<?php

session_start();

require_once '../config/db.php';

require_once 'inc/functions.php';

require_once 'inc/config.php';



// Kullanıcı zaten giriş yapmışsa ana sayfaya yönlendir

if (isset($_SESSION['musteri_id'])) {

    header("Location: index.php");

    exit;

}



$hata = '';

$basarili = '';



if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    $ad = guvenlik($_POST['ad']);
    $soyad = guvenlik($_POST['soyad']);
    $telefon = guvenlik($_POST['telefon']);
    $eposta = guvenlik($_POST['eposta']);
    $sifre = $_POST['sifre'];
    $sifre_tekrar = $_POST['sifre_tekrar'];
    $musteri_turu = guvenlik($_POST['musteri_turu']);
    $adres2 = guvenlik($_POST['adres2']);
    $sehir = guvenlik($_POST['sehir']);
    $ulke = guvenlik($_POST['ulke']);
    $ilce = guvenlik($_POST['ilce']);
    $posta_kodu = guvenlik($_POST['posta_kodu']);
    $faks = guvenlik($_POST['faks']);

    

    // Bireysel müşteri için

    $tc_kimlik_no = $musteri_turu == 'Bireysel' ? guvenlik($_POST['tc_kimlik_no']) : null;

    $dogum_yili = $musteri_turu == 'Bireysel' ? guvenlik($_POST['dogum_yili']) : null;

    

    // Kurumsal müşteri için

    $vergi_dairesi = $musteri_turu == 'Kurumsal' ? guvenlik($_POST['vergi_dairesi']) : null;

    $vergi_no = $musteri_turu == 'Kurumsal' ? guvenlik($_POST['vergi_no']) : null;

    

    // Adres bilgisi

    $adres = guvenlik($_POST['adres']);

    

    // Zorunlu alanları kontrol et

    if (empty($ad) || empty($soyad) || empty($telefon) || empty($eposta) || empty($sifre) || empty($sifre_tekrar)) {

        $hata = 'Lütfen zorunlu alanları doldurun.';

    } elseif ($sifre !== $sifre_tekrar) {

        $hata = 'Şifreler eşleşmiyor.';

    } elseif (strlen($sifre) < 8) {

        $hata = 'Şifre en az 8 karakter uzunluğunda olmalıdır.';

    } else {

        try {

            // Mükerrer kayıt kontrolü

            $kontrolSorgusu = $db->prepare("SELECT * FROM musteriler WHERE 

                telefon = ? OR 

                eposta = ? OR 

                (tc_kimlik_no = ? AND tc_kimlik_no IS NOT NULL) OR 

                (vergi_no = ? AND vergi_no IS NOT NULL)");

            

            $kontrolSorgusu->execute([$telefon, $eposta, $tc_kimlik_no, $vergi_no]);

            

            if ($kontrolSorgusu->rowCount() > 0) {

                $mevcut = $kontrolSorgusu->fetch(PDO::FETCH_ASSOC);

                $hata = 'Bu bilgilere sahip bir müşteri zaten mevcut:<br>';

                

                if ($mevcut['telefon'] == $telefon) {

                    $hata .= '- Bu telefon numarası kullanılıyor<br>';

                }

                if ($mevcut['eposta'] == $eposta) {

                    $hata .= '- Bu e-posta adresi kullanılıyor<br>';

                }

                if ($mevcut['tc_kimlik_no'] == $tc_kimlik_no && $tc_kimlik_no) {

                    $hata .= '- Bu T.C. Kimlik numarası kullanılıyor<br>';

                }

                if ($mevcut['vergi_no'] == $vergi_no && $vergi_no) {

                    $hata .= '- Bu vergi numarası kullanılıyor<br>';

                }

            } else {

                // Aktivasyon kodu oluştur

                $aktivasyon_kodu = aktivasyonKoduOlustur();

                

                // Şifreyi hashle

                $sifre_hash = password_hash($sifre, PASSWORD_DEFAULT);

                

                // Müşteriyi ekle

                $sorgu = $db->prepare("INSERT INTO musteriler 
                    (ad, soyad, telefon, eposta, sifre, musteri_turu, tc_kimlik_no, dogum_yili, 
                     vergi_dairesi, vergi_no, adres, adres2, sehir, ulke, ilce, posta_kodu, faks, aktivasyon_kodu) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

                $sonuc = $sorgu->execute([
                    $ad, $soyad, $telefon, $eposta, $sifre_hash, $musteri_turu,
                    $tc_kimlik_no, $dogum_yili, $vergi_dairesi, $vergi_no, $adres,
                    $adres2, $sehir, $ulke, $ilce, $posta_kodu, $faks,
                    $aktivasyon_kodu
                ]);

                

                if ($sonuc) {

                    // Aktivasyon e-postası gönder

                    require_once '../inc/phpmailer/PHPMailer.php';

                    require_once '../inc/phpmailer/SMTP.php';

                    require_once '../inc/phpmailer/Exception.php';

                    

                    $mail = new PHPMailer\PHPMailer\PHPMailer(true);

                    

                    try {

                        // Server ayarları

                        $mail->isSMTP();

                        $mail->Host = 'mail.torossogutma.com.tr';

                        $mail->SMTPAuth = true;

                        $mail->Username = 'cem@torossogutma.com.tr';

                        $mail->Password = 'Ts147258-+';

                        $mail->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;

                        $mail->Port = 587;

                        $mail->CharSet = 'UTF-8';

                        

                        // Gönderici ve alıcı

                        $mail->setFrom('cem@torossogutma.com.tr', 'Epifiz Web Ajans');

                        $mail->addAddress($eposta);

                        

                        // İçerik

                        $mail->isHTML(true);

                        $mail->Subject = "Hesabınızı Aktifleştirin";

                        

                        // Aktivasyon linki

                        $aktivasyon_link = SITE_URL . "/site/aktivasyon.php?kod=" . $aktivasyon_kodu;

                        

                        $mail->Body = "

                            <h2>Hoş Geldiniz {$ad} {$soyad},</h2>

                            <p>Hesabınızı aktifleştirmek için aşağıdaki linke tıklayın:</p>

                            <p>

                                <a href='{$aktivasyon_link}' 

                                   style='background: #0d6efd; color: #fff; padding: 12px 25px; text-decoration: none; border-radius: 4px;'>

                                    Hesabımı Aktifleştir

                                </a>

                            </p>

                            <p>Ya da bu linki tarayıcınıza kopyalayın:</p>

                            <p>{$aktivasyon_link}</p>

                            <hr>

                            <p><small>Bu e-posta otomatik olarak gönderilmiştir. Lütfen yanıtlamayınız.</small></p>

                        ";

                        

                        $mail->send();

                        $basarili = 'Kayıt işleminiz başarıyla tamamlandı. Lütfen e-posta adresinizi kontrol edin ve hesabınızı aktifleştirin.';

                    } catch (Exception $e) {

                        $hata = 'E-posta gönderilemedi: ' . $mail->ErrorInfo;

                    }

                }

            }

        } catch (PDOException $e) {

            $hata = 'Bir hata oluştu: ' . $e->getMessage();

        }

    }

}

?>

<!DOCTYPE html>

<html lang="tr">

<head>

    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Kayıt Ol - <?php echo $site_ayarlar['site_baslik']; ?></title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">

    <link href="assets/css/style.css" rel="stylesheet">

    <style>

        body {

            background-color: #f8f9fa;

            padding: 40px 0;

        }

        .register-container {

            max-width: 800px;

            margin: 0 auto;

        }

    </style>

</head>

<body>

    <div class="container">

        <div class="register-container">

            <div class="text-center mb-4">

                <a href="index.php" class="text-decoration-none">

                    <i class="bi bi-globe display-4 text-primary"></i>

                    <h4 class="mt-2"><?php echo $site_ayarlar['site_baslik']; ?></h4>

                </a>

            </div>

            

            <div class="card shadow">

                <div class="card-header bg-primary text-white">

                    <h5 class="card-title mb-0">

                        <i class="bi bi-person-plus me-2"></i>

                        Yeni Hesap Oluştur

                    </h5>

                </div>

                <div class="card-body p-4">

                    <?php if ($hata): ?>

                        <div class="alert alert-danger">

                            <i class="bi bi-exclamation-triangle-fill me-2"></i>

                            <?php echo $hata; ?>

                        </div>

                    <?php endif; ?>

                    

                    <?php if ($basarili): ?>

                        <div class="alert alert-success">

                            <i class="bi bi-check-circle-fill me-2"></i>

                            <?php echo $basarili; ?>

                        </div>

                    <?php endif; ?>

                    

                    <form method="POST" action="" id="kayitForm">

                        <!-- Müşteri Türü -->

                        <div class="row mb-4">

                            <div class="col-12">

                                <label class="form-label">Müşteri Türü *</label>

                                <div class="btn-group w-100" role="group">

                                    <input type="radio" class="btn-check" name="musteri_turu" id="bireysel" 

                                           value="Bireysel" checked>

                                    <label class="btn btn-outline-primary" for="bireysel">

                                        <i class="bi bi-person me-2"></i>

                                        Bireysel

                                    </label>

                                    

                                    <input type="radio" class="btn-check" name="musteri_turu" id="kurumsal" 

                                           value="Kurumsal">

                                    <label class="btn btn-outline-primary" for="kurumsal">

                                        <i class="bi bi-building me-2"></i>

                                        Kurumsal

                                    </label>

                                </div>

                            </div>

                        </div>

                        

                        <!-- Temel Bilgiler -->
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="ad" class="form-label">Ad *</label>
                                <input type="text" class="form-control" id="ad" name="ad" 
                                       value="<?php echo isset($ad) ? htmlspecialchars($ad) : ''; ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label for="soyad" class="form-label">Soyad *</label>
                                <input type="text" class="form-control" id="soyad" name="soyad" 
                                       value="<?php echo isset($soyad) ? htmlspecialchars($soyad) : ''; ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label for="telefon" class="form-label">Telefon *</label>
                                <input type="tel" class="form-control" id="telefon" name="telefon" 
                                       value="<?php echo isset($telefon) ? htmlspecialchars($telefon) : ''; ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label for="eposta" class="form-label">E-posta *</label>
                                <input type="email" class="form-control" id="eposta" name="eposta" 
                                       value="<?php echo isset($eposta) ? htmlspecialchars($eposta) : ''; ?>" required>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Ülke *</label>
                                <input type="text" class="form-control" name="ulke" value="Türkiye" required>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Şehir *</label>
                                <input type="text" class="form-control" name="sehir" required>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">İlçe *</label>
                                <input type="text" class="form-control" name="ilce" required>
                            </div>
                             <!-- Gizli alanlar -->
                            <input type="hidden" name="posta_kodu" value="0">
                            <input type="hidden" name="faks" value="0">
                            <input type="hidden" name="adres2" value="0">
                            <div class="col-md-6">
                                <label for="sifre" class="form-label">Şifre *</label>
                                <div class="input-group">
                                    <input type="password" class="form-control" id="sifre" name="sifre" 
                                           minlength="8" required>
                                    <button class="btn btn-outline-secondary" type="button" id="sifreGoster"
                                            data-bs-toggle="tooltip" title="Şifreyi Göster/Gizle">
                                        <i class="bi bi-eye"></i>
                                    </button>
                                    <button class="btn btn-outline-secondary" type="button" id="rastgeleSifre"
                                            data-bs-toggle="tooltip" title="Rastgele Şifre Oluştur">
                                        <i class="bi bi-shuffle"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label for="sifre_tekrar" class="form-label">Şifre Tekrar *</label>
                                <div class="input-group">
                                    <input type="password" class="form-control" id="sifre_tekrar" name="sifre_tekrar" 
                                           minlength="8" required>
                                    <button class="btn btn-outline-secondary" type="button" id="sifreTekrarGoster"
                                            data-bs-toggle="tooltip" title="Şifreyi Göster/Gizle">
                                        <i class="bi bi-eye"></i>
                                    </button>
                                </div>
                            </div>
                        </div>

                        

                        <hr class="my-4">

                        

                        <!-- Bireysel Müşteri Bilgileri -->

                        <div class="row g-3 bireysel-alan">

                            <div class="col-md-6">

                                <label for="tc_kimlik_no" class="form-label">T.C. Kimlik No</label>

                                <input type="text" class="form-control" id="tc_kimlik_no" name="tc_kimlik_no" 

                                       maxlength="11" value="<?php echo isset($tc_kimlik_no) ? htmlspecialchars($tc_kimlik_no) : ''; ?>">

                            </div>

                            

                            <div class="col-md-6">

                                <label for="dogum_yili" class="form-label">Doğum Yılı</label>

                                <input type="number" class="form-control" id="dogum_yili" name="dogum_yili" 

                                       min="1900" max="<?php echo date('Y'); ?>" 

                                       value="<?php echo isset($dogum_yili) ? htmlspecialchars($dogum_yili) : ''; ?>">

                            </div>

                        </div>

                        

                        <!-- Kurumsal Müşteri Bilgileri -->

                        <div class="row g-3 kurumsal-alan" style="display: none;">

                            <div class="col-md-6">

                                <label for="vergi_dairesi" class="form-label">Vergi Dairesi</label>

                                <input type="text" class="form-control" id="vergi_dairesi" name="vergi_dairesi" 

                                       value="<?php echo isset($vergi_dairesi) ? htmlspecialchars($vergi_dairesi) : ''; ?>">

                            </div>

                            

                            <div class="col-md-6">

                                <label for="vergi_no" class="form-label">Vergi No</label>

                                <input type="text" class="form-control" id="vergi_no" name="vergi_no" 

                                       maxlength="10" value="<?php echo isset($vergi_no) ? htmlspecialchars($vergi_no) : ''; ?>">

                            </div>

                        </div>

                        

                        <hr class="my-4">

                        

                        <!-- Adres Bilgisi -->

                        <div class="row g-3">

                            <div class="col-12">

                                <label for="adres" class="form-label">Adres</label>

                                <textarea class="form-control" id="adres" name="adres" rows="3"><?php echo isset($adres) ? htmlspecialchars($adres) : ''; ?></textarea>

                            </div>

                        </div>

                        

                        <hr class="my-4">

                        

                        <div class="row">

                            <div class="col-12">

                                <div class="form-check mb-3">

                                    <input class="form-check-input" type="checkbox" id="sozlesme" required>

                                    <label class="form-check-label" for="sozlesme">

                                        <a href="#" class="text-decoration-none" data-bs-toggle="modal" data-bs-target="#sozlesmeModal">

                                            Üyelik sözleşmesini

                                        </a> 

                                        okudum ve kabul ediyorum.

                                    </label>

                                </div>

                                

                                <button type="submit" class="btn btn-primary">

                                    <i class="bi bi-person-plus me-2"></i>

                                    Hesap Oluştur

                                </button>

                                

                                <a href="giris.php" class="btn btn-link text-decoration-none">

                                    <i class="bi bi-box-arrow-in-right me-2"></i>

                                    Zaten hesabınız var mı? Giriş yapın

                                </a>

                            </div>

                        </div>

                    </form>

                </div>

            </div>

        </div>

    </div>

    

    <!-- Sözleşme Modal -->

    <div class="modal fade" id="sozlesmeModal" tabindex="-1">

        <div class="modal-dialog modal-lg">

            <div class="modal-content">

                <div class="modal-header">

                    <h5 class="modal-title">Üyelik Sözleşmesi</h5>

                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>

                </div>

                <div class="modal-body">

                    <h6>1. Genel Hükümler</h6>

                    <p>Bu sözleşme, sitemiz üzerinden sunulan hizmetlerin kullanım şartlarını belirler...</p>

                    

                    <h6>2. Üyelik</h6>

                    <p>Sitemize üye olabilmek için 18 yaşını doldurmuş olmak ve gerçek bilgiler vermek zorunludur...</p>

                    

                    <h6>3. Gizlilik</h6>

                    <p>Kişisel verileriniz 6698 sayılı KVKK kapsamında korunmaktadır...</p>

                </div>

                <div class="modal-footer">

                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>

                </div>

            </div>

        </div>

    </div>



    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>

    document.addEventListener('DOMContentLoaded', function() {

        // Tooltips'i aktifleştir

        const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');

        const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));

        

        // Müşteri türüne göre form alanlarını göster/gizle

        const musteriTuru = document.getElementsByName('musteri_turu');

        const bireyselAlanlar = document.querySelector('.bireysel-alan');

        const kurumsalAlanlar = document.querySelector('.kurumsal-alan');

        

        function alanlarıGuncelle() {

            const seciliTur = document.querySelector('input[name="musteri_turu"]:checked').value;

            if (seciliTur === 'Bireysel') {

                bireyselAlanlar.style.display = 'flex';

                kurumsalAlanlar.style.display = 'none';

            } else {

                bireyselAlanlar.style.display = 'none';

                kurumsalAlanlar.style.display = 'flex';

            }

        }

        

        musteriTuru.forEach(radio => radio.addEventListener('change', alanlarıGuncelle));

        alanlarıGuncelle();

        

        // Şifre göster/gizle fonksiyonu

        function sifreGosterGizle(input, button) {

            const tip = input.type === 'password' ? 'text' : 'password';

            input.type = tip;

            const icon = button.querySelector('i');

            icon.className = tip === 'password' ? 'bi bi-eye' : 'bi bi-eye-slash';

            

            // Tooltip metnini güncelle

            const tooltip = bootstrap.Tooltip.getInstance(button);

            if (tooltip) {

                tooltip.setContent({ '.tooltip-inner': tip === 'password' ? 'Şifreyi Göster' : 'Şifreyi Gizle' });

            }

        }

        

        // Şifre için göster/gizle

        const sifreInput = document.getElementById('sifre');

        const sifreGoster = document.getElementById('sifreGoster');

        sifreGoster.addEventListener('click', () => sifreGosterGizle(sifreInput, sifreGoster));

        

        // Şifre tekrar için göster/gizle

        const sifreTekrarInput = document.getElementById('sifre_tekrar');

        const sifreTekrarGoster = document.getElementById('sifreTekrarGoster');

        sifreTekrarGoster.addEventListener('click', () => sifreGosterGizle(sifreTekrarInput, sifreTekrarGoster));

        

        // Rastgele şifre oluştur

        const rastgeleSifre = document.getElementById('rastgeleSifre');

        rastgeleSifre.addEventListener('click', function() {

            const karakterler = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*';

            let sifre = '';

            for (let i = 0; i < 12; i++) {

                sifre += karakterler.charAt(Math.floor(Math.random() * karakterler.length));

            }

            

            // Her iki şifre alanını da güncelle ve göster

            sifreInput.type = 'text';

            sifreTekrarInput.type = 'text';

            sifreInput.value = sifre;

            sifreTekrarInput.value = sifre;

            

            // Göster/gizle butonlarını güncelle

            sifreGoster.querySelector('i').className = 'bi bi-eye-slash';

            sifreTekrarGoster.querySelector('i').className = 'bi bi-eye-slash';

            

            // Tooltipleri güncelle

            const sifreGosterTooltip = bootstrap.Tooltip.getInstance(sifreGoster);

            const sifreTekrarGosterTooltip = bootstrap.Tooltip.getInstance(sifreTekrarGoster);

            if (sifreGosterTooltip) sifreGosterTooltip.setContent({ '.tooltip-inner': 'Şifreyi Gizle' });

            if (sifreTekrarGosterTooltip) sifreTekrarGosterTooltip.setContent({ '.tooltip-inner': 'Şifreyi Gizle' });

        });

        

        // Form validasyonu

        const form = document.getElementById('kayitForm');

        form.addEventListener('submit', function(event) {

            let hata = false;

            const telefon = document.getElementById('telefon').value;

            const eposta = document.getElementById('eposta').value;

            const tcKimlikNo = document.getElementById('tc_kimlik_no');

            const vergiNo = document.getElementById('vergi_no');

            const sifre = document.getElementById('sifre').value;

            const sifreTekrar = document.getElementById('sifre_tekrar').value;

            

            // Telefon formatı kontrolü

            if (!/^[0-9]{10,11}$/.test(telefon.replace(/[^0-9]/g, ''))) {

                alert('Lütfen geçerli bir telefon numarası girin.');

                hata = true;

            }

            

            // E-posta formatı kontrolü

            if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(eposta)) {

                alert('Lütfen geçerli bir e-posta adresi girin.');

                hata = true;

            }

            

            // Şifre kontrolü

            if (sifre !== sifreTekrar) {

                alert('Şifreler eşleşmiyor.');

                hata = true;

            }

            

            // TC Kimlik No kontrolü (Bireysel müşteri için)

            if (document.getElementById('bireysel').checked && tcKimlikNo.value) {

                if (!/^[0-9]{11}$/.test(tcKimlikNo.value)) {

                    alert('TC Kimlik No 11 haneli olmalıdır.');

                    hata = true;

                }

            }

            

            // Vergi No kontrolü (Kurumsal müşteri için)

            if (document.getElementById('kurumsal').checked && vergiNo.value) {

                if (!/^[0-9]{10}$/.test(vergiNo.value)) {

                    alert('Vergi No 10 haneli olmalıdır.');

                    hata = true;

                }

            }

            

            if (hata) {

                event.preventDefault();

            }

        });

    });

    </script>

</body>

</html>