<?php

session_start();

require_once '../config/db.php';

require_once 'inc/functions.php';

require_once 'inc/config.php';



$hata = '';

$basarili = '';



if (isset($_GET['kod'])) {

    $aktivasyon_kodu = $_GET['kod'];

    

    try {

        // Aktivasyon kodunu kontrol et

        $sorgu = $db->prepare("SELECT * FROM musteriler WHERE aktivasyon_kodu = ? AND durum = 'Beklemede'");

        $sorgu->execute([$aktivasyon_kodu]);

        $musteri = $sorgu->fetch(PDO::FETCH_ASSOC);

        

        if ($musteri) {

            // Hesabı aktifleştir

            $sorgu = $db->prepare("UPDATE musteriler SET 

                durum = 'Aktif',

                aktivasyon_tarihi = NOW(),

                aktivasyon_kodu = NULL 

                WHERE id = ?");

            

            if ($sorgu->execute([$musteri['id']])) {

                $basarili = 'Hesabınız başarıyla aktifleştirildi. Şimdi giriş yapabilirsiniz.';

            } else {

                $hata = 'Hesap aktifleştirilemedi. Lütfen daha sonra tekrar deneyin.';

            }

        } else {

            $hata = 'Geçersiz aktivasyon kodu veya hesap zaten aktif.';

        }

    } catch (PDOException $e) {

        $hata = 'Bir hata oluştu: ' . $e->getMessage();

    }

} else {

    $hata = 'Aktivasyon kodu bulunamadı.';

}

?>

<!DOCTYPE html>

<html lang="tr">

<head>

    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Hesap Aktivasyonu - <?php echo $site_ayarlar['site_baslik']; ?></title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">

    <link href="assets/css/style.css" rel="stylesheet">

    <style>

        body {

            background-color: #f8f9fa;

        }

        .activation-container {

            max-width: 500px;

            margin: 100px auto;

        }

    </style>

</head>

<body>

    <div class="container">

        <div class="activation-container">

            <div class="text-center mb-4">

                <a href="index.php" class="text-decoration-none">

                    <i class="bi bi-globe display-4 text-primary"></i>

                    <h4 class="mt-2"><?php echo $site_ayarlar['site_baslik']; ?></h4>

                </a>

            </div>

            

            <div class="card shadow">

                <div class="card-header bg-primary text-white">

                    <h5 class="card-title mb-0">

                        <i class="bi bi-check-circle me-2"></i>

                        Hesap Aktivasyonu

                    </h5>

                </div>

                <div class="card-body p-4">

                    <?php if ($hata): ?>

                        <div class="alert alert-danger">

                            <i class="bi bi-exclamation-triangle-fill me-2"></i>

                            <?php echo $hata; ?>

                        </div>

                    <?php endif; ?>

                    

                    <?php if ($basarili): ?>

                        <div class="alert alert-success">

                            <i class="bi bi-check-circle-fill me-2"></i>

                            <?php echo $basarili; ?>

                        </div>

                    <?php endif; ?>

                    

                    <div class="text-center mt-3">

                        <a href="giris.php" class="btn btn-primary">

                            <i class="bi bi-box-arrow-in-right me-2"></i>

                            Giriş Yap

                        </a>

                        <a href="index.php" class="btn btn-secondary">

                            <i class="bi bi-house me-2"></i>

                            Ana Sayfa

                        </a>

                    </div>

                </div>

            </div>

        </div>

    </div>



    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>

</html>