<?php
ob_start(); // Çıktı tamponlamasını başlat
oturumKontrol();

if (!isset($_GET['islem']) || !isset($_GET['user']) || !isset($_GET['server'])) {
    header("Location: index.php?sayfa=hosting/liste");
    exit;
}

$islem = $_GET['islem'];
$username = $_GET['user'];
$server_name = $_GET['server'];

// Sunucu bilgilerini al
$sorgu = $db->prepare("SELECT * FROM sunucular WHERE sunucu_adi = ?");
$sorgu->execute([$server_name]);
$sunucu = $sorgu->fetch(PDO::FETCH_ASSOC);

if (!$sunucu) {
    header("Location: index.php?sayfa=hosting/liste&mesaj=sunucu_bulunamadi");
    exit;
}

function callWHMAPI($server, $function, $params = array()) {
    $url = "https://{$server['ip_adresi']}:2087/json-api/" . $function;
    
    $header = array(
        "Authorization: WHM {$server['kullanici_adi']}:{$server['token']}"
    );
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($params));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    
    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        return array('error' => $error);
    }
    
    return json_decode($response, true);
}

$mesaj = '';

switch ($islem) {
    case 'askiya_al':
        $response = callWHMAPI($sunucu, 'suspendacct', array(
            'user' => $username,
            'reason' => 'Yönetici tarafından askıya alındı'
        ));
        
        if (isset($response['error'])) {
            $mesaj = 'hata_askiya_alma';
        } else {
            $mesaj = 'askiya_alindi';
        }
        break;
        
    case 'aktif_et':
        $response = callWHMAPI($sunucu, 'unsuspendacct', array(
            'user' => $username
        ));
        
        if (isset($response['error'])) {
            $mesaj = 'hata_aktif_etme';
        } else {
            $mesaj = 'aktif_edildi';
        }
        break;
}

ob_end_clean(); // Çıktı tamponunu temizle
header("Location: index.php?sayfa=hosting/liste&mesaj=" . $mesaj);
exit;
?>