<?php
ob_start();
oturumKontrol();

if (!isset($_GET['id'])) {
    header("Location: index.php?sayfa=fatura/liste");
    exit;
}

$fatura_id = $_GET['id'];

try {
    // Önce faturanın var olduğunu ve iptal edilebilir durumda olduğunu kontrol et
    $sorgu = $db->prepare("SELECT * FROM faturalar WHERE id = ? AND odeme_durumu != 'İptal'");
    $sorgu->execute([$fatura_id]);
    $fatura = $sorgu->fetch(PDO::FETCH_ASSOC);
    
    if (!$fatura) {
        header("Location: index.php?sayfa=fatura/liste&mesaj=hata");
        exit;
    }
    
    // Faturayı iptal et
    $sorgu = $db->prepare("UPDATE faturalar SET odeme_durumu = 'İptal' WHERE id = ?");
    $sonuc = $sorgu->execute([$fatura_id]);
    
    if ($sonuc) {
        header("Location: index.php?sayfa=fatura/liste&mesaj=iptal_edildi");
    } else {
        header("Location: index.php?sayfa=fatura/liste&mesaj=hata");
    }
} catch (PDOException $e) {
    error_log("Fatura iptal hatası: " . $e->getMessage());
    header("Location: index.php?sayfa=fatura/liste&mesaj=hata");
}

exit;
?>