<?php
ob_start();
oturumKontrol();

if (!isset($_GET['id'])) {
    header("Location: index.php?sayfa=fatura/liste");
    exit;
}

$fatura_id = $_GET['id'];

// Müşteri listesini getir
$sorgu = $db->query("SELECT * FROM musteriler ORDER BY ad, soyad");
$musteriler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Domain listesini getir
$sorgu = $db->query("SELECT * FROM domain_kayitlar WHERE durum = 'Aktif' ORDER BY domain");
$domainler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Hosting listesini getir
$sorgu = $db->query("
    SELECT h.*, s.sunucu_adi 
    FROM hosting_hesaplari h 
    LEFT JOIN sunucular s ON h.sunucu_id = s.id 
    WHERE h.durum = 'Aktif' 
    ORDER BY h.domain
");
$hosting_hesaplari = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Fatura bilgilerini getir
$sorgu = $db->prepare("
    SELECT f.*, m.ad as musteri_ad, m.soyad as musteri_soyad, m.musteri_turu
    FROM faturalar f
    LEFT JOIN musteriler m ON f.musteri_id = m.id
    WHERE f.id = ?
");
$sorgu->execute([$fatura_id]);
$fatura = $sorgu->fetch(PDO::FETCH_ASSOC);

if (!$fatura) {
    header("Location: index.php?sayfa=fatura/liste");
    exit;
}

// Fatura kalemlerini getir
$sorgu = $db->prepare("SELECT * FROM fatura_kalemleri WHERE fatura_id = ?");
$sorgu->execute([$fatura_id]);
$kalemler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $hata = '';
    
    try {
        // Form verilerini al
        $musteri_id = (int)$_POST['musteri_id'];
        $fatura_tarihi = $_POST['fatura_tarihi'];
        $son_odeme_tarihi = $_POST['son_odeme_tarihi'];
        
        $db->beginTransaction();
        
        // Fatura başlığını güncelle
        $sorgu = $db->prepare("UPDATE faturalar SET 
            musteri_id = ?,
            fatura_tarihi = ?,
            son_odeme_tarihi = ?
            WHERE id = ?");
        
        $sorgu->execute([
            $musteri_id,
            $fatura_tarihi,
            $son_odeme_tarihi,
            $fatura_id
        ]);
        
        // Mevcut kalemleri sil
        $sorgu = $db->prepare("DELETE FROM fatura_kalemleri WHERE fatura_id = ?");
        $sorgu->execute([$fatura_id]);
        
        // Yeni kalemleri ekle
        $ara_toplam = 0;
        
        foreach ($_POST['kalemler'] as $kalem) {
            $kalem_id = generateUUID();
            $hizmet_turu = $kalem['hizmet_turu'];
            $hizmet_id = !empty($kalem['hizmet_id']) ? $kalem['hizmet_id'] : null;
            $aciklama = $kalem['aciklama'];
            $birim = $kalem['birim'];
            $miktar = (float)$kalem['miktar'];
            $birim_fiyat = (float)$kalem['birim_fiyat'];
            $toplam = $miktar * $birim_fiyat;
            
            $sorgu = $db->prepare("INSERT INTO fatura_kalemleri 
                (id, fatura_id, hizmet_id, hizmet_turu, aciklama, birim, miktar, birim_fiyat, toplam) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            
            $sorgu->execute([
                $kalem_id,
                $fatura_id,
                $hizmet_id,
                $hizmet_turu,
                $aciklama,
                $birim,
                $miktar,
                $birim_fiyat,
                $toplam
            ]);
            
            $ara_toplam += $toplam;
        }
        
        // KDV hesapla ve faturayı güncelle
        $kdv_oran = 20.00; // %20 KDV
        $kdv_tutar = $ara_toplam * ($kdv_oran / 100);
        $genel_toplam = $ara_toplam + $kdv_tutar;
        
        $sorgu = $db->prepare("UPDATE faturalar SET 
            ara_toplam = ?, 
            kdv_oran = ?, 
            kdv_tutar = ?, 
            genel_toplam = ? 
            WHERE id = ?");
        
        $sorgu->execute([
            $ara_toplam,
            $kdv_oran,
            $kdv_tutar,
            $genel_toplam,
            $fatura_id
        ]);
        
        $db->commit();
        
        // Başarılı mesajı ile yönlendir
        header("Location: index.php?sayfa=fatura/liste&mesaj=guncellendi");
        exit;
        
    } catch (PDOException $e) {
        $db->rollBack();
        $hata = 'Fatura güncellenirken bir hata oluştu: ' . $e->getMessage();
    }
}

// UUID oluşturma fonksiyonu
function generateUUID() {
    return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        mt_rand(0, 0xffff), mt_rand(0, 0xffff),
        mt_rand(0, 0xffff),
        mt_rand(0, 0x0fff) | 0x4000,
        mt_rand(0, 0x3fff) | 0x8000,
        mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
    );
}
?>

<!-- Bootstrap ve İkonlar -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">

<!-- Flatpickr CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/themes/material_blue.css">

<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=fatura/liste">Faturalar</a></li>
        <li class="breadcrumb-item active">Fatura Düzenle</li>
    </ol>
</nav>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-receipt me-2"></i>
            Fatura Düzenle
            <small class="text-muted">(<?php echo htmlspecialchars($fatura['fatura_no']); ?>)</small>
        </h5>
    </div>
    <div class="card-body">
        <?php if (isset($hata) && $hata): ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                <?php echo $hata; ?>
            </div>
        <?php endif; ?>
        
        <form method="POST" action="" id="faturaForm">
            <!-- Fatura Başlık Bilgileri -->
            <div class="row g-3 mb-4">
                <div class="col-md-4">
                    <label for="musteri_id" class="form-label">Müşteri *</label>
                    <select class="form-select select2" id="musteri_id" name="musteri_id" required>
                        <option value="">Müşteri Seçin</option>
                        <?php foreach ($musteriler as $musteri): ?>
                        <option value="<?php echo $musteri['id']; ?>" 
                                <?php echo $musteri['id'] == $fatura['musteri_id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($musteri['ad'] . ' ' . $musteri['soyad']); ?>
                            (<?php echo $musteri['musteri_turu']; ?>)
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="col-md-4">
                    <label for="fatura_tarihi" class="form-label">Fatura Tarihi *</label>
                    <input type="text" class="form-control flatpickr" id="fatura_tarihi" name="fatura_tarihi" 
                           value="<?php echo $fatura['fatura_tarihi']; ?>" required>
                </div>
                
                <div class="col-md-4">
                    <label for="son_odeme_tarihi" class="form-label">Son Ödeme Tarihi *</label>
                    <input type="text" class="form-control flatpickr" id="son_odeme_tarihi" name="son_odeme_tarihi" 
                           value="<?php echo $fatura['son_odeme_tarihi']; ?>" required>
                </div>
            </div>
            
            <!-- Fatura Kalemleri -->
            <div class="table-responsive mb-4">
                <table class="table table-bordered" id="kalemlerTable">
                    <thead>
                        <tr>
                            <th style="width: 15%;">Hizmet Türü</th>
                            <th style="width: 20%;">Hizmet</th>
                            <th>Açıklama</th>
                            <th style="width: 10%;">Birim</th>
                            <th style="width: 10%;">Miktar</th>
                            <th style="width: 15%;">Birim Fiyat</th>
                            <th style="width: 15%;">Toplam</th>
                            <th style="width: 5%;"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($kalemler as $index => $kalem): ?>
                        <tr>
                            <td>
                                <select class="form-select hizmet-turu" name="kalemler[<?php echo $index; ?>][hizmet_turu]" required>
                                    <option value="">Seçin</option>
                                    <option value="Domain" <?php echo $kalem['hizmet_turu'] == 'Domain' ? 'selected' : ''; ?>>Domain</option>
                                    <option value="Hosting" <?php echo $kalem['hizmet_turu'] == 'Hosting' ? 'selected' : ''; ?>>Hosting</option>
                                    <option value="Manuel" <?php echo $kalem['hizmet_turu'] == 'Manuel' ? 'selected' : ''; ?>>Manuel</option>
                                </select>
                            </td>
                            <td>
                                <select class="form-select hizmet-select" name="kalemler[<?php echo $index; ?>][hizmet_id]" 
                                        <?php echo $kalem['hizmet_turu'] == 'Manuel' ? 'disabled' : ''; ?>>
                                    <option value="">Hizmet Seçin</option>
                                    <?php if ($kalem['hizmet_turu'] == 'Domain'): ?>
                                        <?php foreach ($domainler as $domain): ?>
                                        <option value="<?php echo $domain['id']; ?>" 
                                                <?php echo $domain['id'] == $kalem['hizmet_id'] ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($domain['domain']); ?>
                                        </option>
                                        <?php endforeach; ?>
                                    <?php elseif ($kalem['hizmet_turu'] == 'Hosting'): ?>
                                        <?php foreach ($hosting_hesaplari as $hosting): ?>
                                        <option value="<?php echo $hosting['id']; ?>" 
                                                <?php echo $hosting['id'] == $kalem['hizmet_id'] ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($hosting['domain'] . ' (' . $hosting['sunucu_adi'] . ')'); ?>
                                        </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </td>
                            <td>
                                <input type="text" class="form-control aciklama" name="kalemler[<?php echo $index; ?>][aciklama]" 
                                       value="<?php echo htmlspecialchars($kalem['aciklama']); ?>" required>
                            </td>
                            <td>
                                <input type="text" class="form-control birim" name="kalemler[<?php echo $index; ?>][birim]" 
                                       value="<?php echo htmlspecialchars($kalem['birim']); ?>" required>
                            </td>
                            <td>
                                <input type="number" class="form-control miktar" name="kalemler[<?php echo $index; ?>][miktar]" 
                                       value="<?php echo $kalem['miktar']; ?>" min="1" step="1" required>
                            </td>
                            <td>
                                <div class="input-group">
                                    <input type="number" class="form-control birim-fiyat" name="kalemler[<?php echo $index; ?>][birim_fiyat]" 
                                           value="<?php echo $kalem['birim_fiyat']; ?>" min="0" step="0.01" required>
                                    <span class="input-group-text">₺</span>
                                </div>
                            </td>
                            <td>
                                <div class="input-group">
                                    <input type="text" class="form-control toplam" value="<?php echo $kalem['toplam']; ?>" readonly>
                                    <span class="input-group-text">₺</span>
                                </div>
                            </td>
                            <td class="text-center">
                                <button type="button" class="btn btn-danger btn-sm kalem-sil">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="8">
                                <button type="button" class="btn btn-success btn-sm" id="kalemEkle">
                                    <i class="bi bi-plus-circle me-2"></i>
                                    Yeni Kalem Ekle
                                </button>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6" class="text-end"><strong>Ara Toplam:</strong></td>
                            <td colspan="2">
                                <div class="input-group">
                                    <input type="text" class="form-control" id="araToplam" 
                                           value="<?php echo number_format($fatura['ara_toplam'], 2, '.', ''); ?>" readonly>
                                    <span class="input-group-text">₺</span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6" class="text-end"><strong>KDV (%20):</strong></td>
                            <td colspan="2">
                                <div class="input-group">
                                    <input type="text" class="form-control" id="kdvTutar" 
                                           value="<?php echo number_format($fatura['kdv_tutar'], 2, '.', ''); ?>" readonly>
                                    <span class="input-group-text">₺</span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6" class="text-end"><strong>Genel Toplam:</strong></td>
                            <td colspan="2">
                                <div class="input-group">
                                    <input type="text" class="form-control" id="genelToplam" 
                                           value="<?php echo number_format($fatura['genel_toplam'], 2, '.', ''); ?>" readonly>
                                    <span class="input-group-text">₺</span>
                                </div>
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            
            <div class="row">
                <div class="col-12">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>
                        Değişiklikleri Kaydet
                    </button>
                    <a href="index.php?sayfa=fatura/liste" class="btn btn-secondary">
                        <i class="bi bi-x-circle me-2"></i>
                        İptal
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- jQuery, Flatpickr ve Select2 JS -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/tr.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
// Domain ve Hosting listelerini JavaScript değişkenlerine aktar
const domainler = <?php echo json_encode($domainler); ?>;
const hostingler = <?php echo json_encode($hosting_hesaplari); ?>;

$(document).ready(function() {
    // Select2 başlat
    $('.select2').select2({
        theme: 'bootstrap-5',
        width: '100%'
    });
    
    // Flatpickr başlat
    flatpickr(".flatpickr", {
        locale: "tr",
        dateFormat: "Y-m-d",
        allowInput: true
    });
    
    // Yeni kalem ekleme
    let kalemSayisi = <?php echo count($kalemler); ?>;
    
    $('#kalemEkle').click(function() {
        const yeniSatir = `
            <tr>
                <td>
                    <select class="form-select hizmet-turu" name="kalemler[${kalemSayisi}][hizmet_turu]" required>
                        <option value="">Seçin</option>
                        <option value="Domain">Domain</option>
                        <option value="Hosting">Hosting</option>
                        <option value="Manuel">Manuel</option>
                    </select>
                </td>
                <td>
                    <select class="form-select hizmet-select" name="kalemler[${kalemSayisi}][hizmet_id]" disabled>
                        <option value="">Önce Tür Seçin</option>
                    </select>
                </td>
                <td>
                    <input type="text" class="form-control aciklama" name="kalemler[${kalemSayisi}][aciklama]" required>
                </td>
                <td>
                    <input type="text" class="form-control birim" name="kalemler[${kalemSayisi}][birim]" value="Yıl" required>
                </td>
                <td>
                    <input type="number" class="form-control miktar" name="kalemler[${kalemSayisi}][miktar]" 
                           value="1" min="1" step="1" required>
                </td>
                <td>
                    <div class="input-group">
                        <input type="number" class="form-control birim-fiyat" name="kalemler[${kalemSayisi}][birim_fiyat]" 
                               value="0.00" min="0" step="0.01" required>
                        <span class="input-group-text">₺</span>
                    </div>
                </td>
                <td>
                    <div class="input-group">
                        <input type="text" class="form-control toplam" value="0.00" readonly>
                        <span class="input-group-text">₺</span>
                    </div>
                </td>
                <td class="text-center">
                    <button type="button" class="btn btn-danger btn-sm kalem-sil">
                        <i class="bi bi-trash"></i>
                    </button>
                </td>
            </tr>
        `;
        
        $('#kalemlerTable tbody').append(yeniSatir);
        kalemSayisi++;
        
        // Yeni satırdaki select2'leri başlat
        $('#kalemlerTable tbody tr:last-child select').select2({
            theme: 'bootstrap-5',
            width: '100%'
        });
    });
    
    // Kalem silme
    $(document).on('click', '.kalem-sil', function() {
        const satirSayisi = $('#kalemlerTable tbody tr').length;
        if (satirSayisi > 1) {
            $(this).closest('tr').remove();
            toplamHesapla();
        }
    });
    
    // Hizmet türü değiştiğinde
    $(document).on('change', '.hizmet-turu', function() {
        const hizmetSelect = $(this).closest('tr').find('.hizmet-select');
        const aciklamaInput = $(this).closest('tr').find('.aciklama');
        const birimFiyatInput = $(this).closest('tr').find('.birim-fiyat');
        
        hizmetSelect.empty().prop('disabled', true);
        aciklamaInput.val('');
        birimFiyatInput.val('0.00');
        
        if (this.value === 'Domain') {
            hizmetSelect.prop('disabled', false).append('<option value="">Domain Seçin</option>');
            domainler.forEach(function(domain) {
                hizmetSelect.append(`<option value="${domain.id}">${domain.domain}</option>`);
            });
        } else if (this.value === 'Hosting') {
            hizmetSelect.prop('disabled', false).append('<option value="">Hosting Seçin</option>');
            hostingler.forEach(function(hosting) {
                hizmetSelect.append(`<option value="${hosting.id}">${hosting.domain} (${hosting.sunucu_adi})</option>`);
            });
        } else if (this.value === 'Manuel') {
            aciklamaInput.prop('readonly', false);
        }
    });
    
    // Hizmet seçildiğinde
    $(document).on('change', '.hizmet-select', function() {
        const tr = $(this).closest('tr');
        const hizmetTuru = tr.find('.hizmet-turu').val();
        const aciklamaInput = tr.find('.aciklama');
        const birimFiyatInput = tr.find('.birim-fiyat');
        
        if (this.value) {
            if (hizmetTuru === 'Domain') {
                const domain = domainler.find(d => d.id == this.value);
                if (domain) {
                    aciklamaInput.val(`${domain.domain} Domain Yenileme`);
                }
            } else if (hizmetTuru === 'Hosting') {
                const hosting = hostingler.find(h => h.id == this.value);
                if (hosting) {
                    aciklamaInput.val(`${hosting.domain} Hosting Yenileme (${hosting.paket})`);
                }
            }
        }
    });
    
    // Miktar veya birim fiyat değiştiğinde
    $(document).on('input', '.miktar, .birim-fiyat', function() {
        const tr = $(this).closest('tr');
        const miktar = parseFloat(tr.find('.miktar').val()) || 0;
        const birimFiyat = parseFloat(tr.find('.birim-fiyat').val()) || 0;
        const toplam = miktar * birimFiyat;
        
        tr.find('.toplam').val(toplam.toFixed(2));
        toplamHesapla();
    });
    
    // Toplam hesaplama fonksiyonu
    function toplamHesapla() {
        let araToplam = 0;
        
        $('.toplam').each(function() {
            araToplam += parseFloat($(this).val()) || 0;
        });
        
        const kdvTutar = araToplam * 0.20;
        const genelToplam = araToplam + kdvTutar;
        
        $('#araToplam').val(araToplam.toFixed(2));
        $('#kdvTutar').val(kdvTutar.toFixed(2));
        $('#genelToplam').val(genelToplam.toFixed(2));
    }
    
    // Form gönderilmeden önce kontrol
    $('#faturaForm').on('submit', function(e) {
        let hata = false;
        
        // En az bir kalem olmalı
        if ($('#kalemlerTable tbody tr').length < 1) {
            alert('En az bir fatura kalemi eklemelisiniz.');
            hata = true;
        }
        
        // Genel toplam 0 olamaz
        if (parseFloat($('#genelToplam').val()) <= 0) {
            alert('Fatura tutarı 0₺ olamaz.');
            hata = true;
        }
        
        if (hata) {
            e.preventDefault();
        }
    });
});
</script>

<?php ob_end_flush(); ?>