<?php
ob_start();
oturumKontrol(); // Oturum kontrolü

// Müşteri listesini al
$sorgu = $db->query("SELECT * FROM musteriler ORDER BY ad, soyad");
$musteriler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// URL üzerinden domain parametresini al
if (!isset($_GET['domain'])) {
    echo "Domain parametresi eksik.";
    exit;
}

$domainName = $_GET['domain'];

// Domain kaydını, domain_kayitlar tablosundan sorgula
$sorgu = $db->prepare("SELECT * FROM domain_kayitlar WHERE domain = ?");
$sorgu->execute([$domainName]);
$domainRecord = $sorgu->fetch(PDO::FETCH_ASSOC);

if (!$domainRecord) {
    echo "Belirtilen domain kaydı bulunamadı.";
    exit;
}

// Form gönderildiğinde güncelleme işlemini gerçekleştir
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_domain'])) {
    $new_musteri_id = $_POST['musteri_id'];
    try {
        $update = $db->prepare("UPDATE domain_kayitlar SET musteri_id = ? WHERE domain = ?");
        $update->execute([$new_musteri_id, $domainName]);
        $basarili = 1;
        $hatali = 0;
        header("Location: index.php?sayfa=aktarim/domain_aktar&domain=" . urlencode($domainName) . "&mesaj=update_completed&basarili=" . $basarili . "&hatali=" . $hatali);
        exit;
    } catch (PDOException $e) {
        error_log("Domain Update Error: " . $e->getMessage());
        $basarili = 0;
        $hatali = 1;
        header("Location: index.php?sayfa=aktarim/domain_aktar&domain=" . urlencode($domainName) . "&mesaj=update_failed&basarili=" . $basarili . "&hatali=" . $hatali);
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Domain Sahip Güncelleme</title>
    <!-- CSS Kütüphaneleri -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
</head>
<body>
    <!-- Breadcrumb -->
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
            <li class="breadcrumb-item"><a href="index.php?sayfa=domain">Domain Hesapları</a></li>
            <li class="breadcrumb-item active" aria-current="page">Sahip Değiştir</li>
        </ol>
    </nav>
    
    <?php if (isset($_GET['mesaj']) && $_GET['mesaj'] == 'update_completed'): ?>
    <div class="alert alert-success alert-dismissible fade show">
        <i class="bi bi-check-circle-fill me-2"></i>
        Domain sahibi başarıyla güncellendi.
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php elseif (isset($_GET['mesaj']) && $_GET['mesaj'] == 'update_failed'): ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <i class="bi bi-exclamation-triangle-fill me-2"></i>
        Domain sahibi güncellenirken bir hata oluştu.
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php endif; ?>
    
    <div class="card">
        <div class="card-header">
            <h5 class="card-title mb-0">
                <i class="bi bi-globe me-2"></i>
                Domain Sahip Güncelleme - <?php echo htmlspecialchars($domainName); ?>
            </h5>
        </div>
        <div class="card-body">
            <form method="POST" action="">
                <input type="hidden" name="update_domain" value="1">
                <div class="mb-3">
                    <label for="musteri_id" class="form-label">Yeni Müşteri Seçin</label>
                    <select name="musteri_id" id="musteri_id" class="form-select select2">
                        <option value="">Müşteri Seçin</option>
                        <?php foreach ($musteriler as $musteri): ?>
                        <option value="<?php echo $musteri['id']; ?>" <?php echo ($domainRecord['musteri_id'] == $musteri['id']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($musteri['ad'] . ' ' . $musteri['soyad']); ?> (<?php echo $musteri['musteri_turu']; ?>)
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-arrow-repeat me-2"></i>
                    Domain Sahibini Güncelle
                </button>
            </form>
        </div>
    </div>
    
    <!-- jQuery ve Select2 JS -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
    $(document).ready(function() {
        $('.select2').select2({
            theme: 'bootstrap-5',
            width: '100%'
        });
    });
    </script>
</body>
</html>
<?php ob_end_flush(); ?>
