<?php

require_once '../config/db.php';

    $post = $_POST;
	

    ####################### DÜZENLEMESİ ZORUNLU ALANLAR #######################
    #
    ## API Entegrasyon Bilgileri - Mağaza paneline giriş yaparak BİLGİ sayfasından alabilirsiniz.
    $merchant_key = 'ZoDMTAjHPUp3NNMD';
    $merchant_salt = 's8QswoE3bctohMM6';
    ###########################################################################

    ####### Bu kısımda herhangi bir değişiklik yapmanıza gerek yoktur. #######
    #
    ## İşlem kontrolü için bir flag dosyası kullanalım
    $merchant_oid = $_POST['merchant_oid'] ?? '';
    $flag_dir = dirname(__FILE__) . '/flags';
    if (!file_exists($flag_dir)) {
        mkdir($flag_dir, 0755, true);
    }
    $flag_file = $flag_dir . '/paytr_' . $merchant_oid . '.flag';

    // Kullanıcı tarayıcısından gelen istek mi kontrol et
    if (empty($_POST) && isset($_GET['show_result'])) {
        ?>
        <!DOCTYPE html>
        <html lang="tr">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Ödeme Başarılı - Epifiz Ajans</title>
            <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
            <style>
                body {
                    background-color: #f8f9fa;
                    height: 100vh;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                }
                .success-card {
                    background: white;
                    border-radius: 15px;
                    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
                    padding: 2rem;
                    text-align: center;
                    max-width: 400px;
                    width: 90%;
                }
                .success-icon {
                    color: #28a745;
                    font-size: 4rem;
                    margin-bottom: 1rem;
                }
                .redirect-text {
                    font-size: 0.9rem;
                    color: #6c757d;
                    margin-top: 1rem;
                }
                @keyframes checkmark {
                    0% { transform: scale(0); opacity: 0; }
                    100% { transform: scale(1); opacity: 1; }
                }
                .animate-check {
                    animation: checkmark 0.5s ease-in-out forwards;
                }
            </style>
        </head>
        <body>
            <div class="success-card">
                <div class="success-icon animate-check">
                    ✓
                </div>
                <h3 class="mb-3">Ödeme Başarılı!</h3>
                <p class="mb-4">Ödemeniz başarıyla gerçekleştirildi. Teşekkür ederiz.</p>
                <a href="https://www.epifizajans.com/yonetim/site" class="btn btn-primary mb-3">Ana Sayfaya Dön</a>
                <div class="redirect-text">
                    <span id="countdown">5</span> saniye içinde ana sayfaya yönlendirileceksiniz.
                </div>
            </div>

            <script>
                let timeLeft = 5;
                const countdownElement = document.getElementById('countdown');
                
                const countdown = setInterval(() => {
                    timeLeft--;
                    countdownElement.textContent = timeLeft;
                    
                    if (timeLeft <= 0) {
                        clearInterval(countdown);
                        window.top.location.href = 'https://www.epifizajans.com/yonetim/site';
                    }
                }, 1000);
            </script>
        </body>
        </html>
        <?php
        exit;
    }

    // PayTR'den gelen POST verilerini kontrol et
    if (empty($_POST)) {
        // Son işlenen merchant_oid'yi bul
        $files = glob($flag_dir . '/paytr_*.flag');
        if (!empty($files)) {
            $latest_file = end($files);
            if (time() - filemtime($latest_file) < 60) {
                echo "OK";
                exit;
            }
        }
        error_log("PayTR Error: Empty POST data received");
        die('PAYTR notification failed: no data received');
    }

    // Eğer bu işlem zaten tamamlanmışsa
    if (file_exists($flag_file) && (time() - filemtime($flag_file) < 300)) {
        echo "OK";
        exit;
    }

    // Gerekli alanların varlığını kontrol et
    $required_fields = ['merchant_oid', 'status', 'total_amount', 'hash'];
    foreach ($required_fields as $field) {
        if (!isset($_POST[$field])) {
            error_log("PayTR Error: Missing required field: " . $field);
            die('PAYTR notification failed: missing required field - ' . $field);
        }
    }

    ## POST değerleri ile hash oluştur.
		
    $hash = base64_encode( hash_hmac('sha256', $post['merchant_oid'].$merchant_salt.$post['status'].$post['total_amount'], $merchant_key, true) );
	
    // Debug için gelen değerleri logla
    error_log("PayTR Callback Data: " . json_encode($_POST));
    error_log("Generated Hash: " . $hash);
    error_log("Received Hash: " . $post['hash']);

    // Hash string'ini de logla
    $hashStr = $post['merchant_oid'].$merchant_salt.$post['status'].$post['total_amount'];
    error_log("Hash String: " . $hashStr);

    #
    ## Oluşturulan hash'i, paytr'dan gelen post içindeki hash ile karşılaştır (isteğin paytr'dan geldiğine ve değişmediğine emin olmak için)
    ## Bu işlemi yapmazsanız maddi zarara uğramanız olasıdır.
    if( $hash != $post['hash'] ) {
        error_log("Hash Mismatch - merchant_key: " . $merchant_key);
        die('PAYTR notification failed: bad hash');
    }
    ###########################################################################

   // merchant_oid ile ödemeyi bul
    $sorgu = $db->prepare("SELECT o.*, f.genel_toplam 
                          FROM online_odemeler o 
                          LEFT JOIN faturalar f ON o.fatura_id = f.id 
                          WHERE o.merchant_oid = ? AND o.payment_provider = 'PayTR'");
    $sorgu->execute([$_POST['merchant_oid']]);
    $odeme = $sorgu->fetch(PDO::FETCH_ASSOC);
    
    if (!$odeme) {
        error_log("PayTR payment not found: " . $_POST['merchant_oid']);
        die('PAYTR notification failed: payment not found');
    }

    
    // Ödeme durumunu kontrol et
    if ($odeme['durum'] == 'Ödendi') {
        error_log("PayTR payment already processed: " . $_POST['merchant_oid']);
        echo "OK";
        exit;
    }

    // İşlem başarılı ise
    if ($post['status'] == 'success') {
        $db->beginTransaction();
        
        try {
            // Ödeme kaydını güncelle
            $sorgu = $db->prepare("UPDATE online_odemeler SET 
                durum = 'Ödendi',
                response_code = ?,
                response_message = ?,
                metadata = ?,
                updated_at = CURRENT_TIMESTAMP
                WHERE id = ?");
            
            $metadata = json_encode([
                'payment_type' => $_POST['payment_type'] ?? null,
                'payment_amount' => $_POST['payment_amount'] ?? null,
                'currency' => $_POST['currency'] ?? null,
                'installment_count' => $_POST['installment_count'] ?? null,
                'test_mode' => $_POST['test_mode'] ?? null
            ]);
            
            $sorgu->execute([
                $_POST['status'],
                'Ödeme başarıyla tamamlandı',
                $metadata,
                $odeme['id']
            ]);
            
            // Fatura ödemesi ekle
            $odeme_id = uniqid();
            $sorgu = $db->prepare("INSERT INTO fatura_odemeleri 
                (id, fatura_id, odeme_tarihi, tutar, odeme_yontemi, aciklama) 
                VALUES (?, ?, CURDATE(), ?, 'Kredi Kartı', 'PayTR Online Ödeme')");
            
            $sorgu->execute([
                $odeme_id,
                $odeme['fatura_id'],
                $odeme['tutar']
            ]);
            
            // Fatura durumunu güncelle
            $sorgu = $db->prepare("SELECT SUM(tutar) as toplam_odeme FROM fatura_odemeleri WHERE fatura_id = ?");
            $sorgu->execute([$odeme['fatura_id']]);
            $toplam_odeme = $sorgu->fetchColumn();
            
            $odeme_durumu = $toplam_odeme >= $odeme['genel_toplam'] ? 'Ödendi' : 'Kısmi Ödendi';
            
            $sorgu = $db->prepare("UPDATE faturalar SET odeme_durumu = ? WHERE id = ?");
            $sorgu->execute([$odeme_durumu, $odeme['fatura_id']]);
            
            // Log kaydı
            $sorgu = $db->prepare("INSERT INTO online_odeme_log 
                (odeme_id, islem_tipi, islem_sonucu) 
                VALUES (?, 'Başarılı', ?)");
            $sorgu->execute([$odeme['id'], json_encode($_POST)]);
            
            $db->commit();
            
            // İşlem başarılı ise flag dosyası oluştur
            file_put_contents($flag_file, json_encode([
                'timestamp' => time(),
                'merchant_oid' => $merchant_oid,
                'status' => $post['status']
            ]));
            
            // Eski flag dosyalarını temizle (1 saat önceki)
            $old_files = glob($flag_dir . '/paytr_*.flag');
            foreach ($old_files as $file) {
                if (time() - filemtime($file) > 3600) {
                    unlink($file);
                }
            }
            
            // HTML çıktısı
            ?>
            <!DOCTYPE html>
            <html lang="tr">
            <head>
                <meta charset="UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <title>Ödeme Başarılı - Epifiz Ajans</title>
                <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
                <style>
                    body {
                        background-color: #f8f9fa;
                        height: 100vh;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                    }
                    .success-card {
                        background: white;
                        border-radius: 15px;
                        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
                        padding: 2rem;
                        text-align: center;
                        max-width: 400px;
                        width: 90%;
                    }
                    .success-icon {
                        color: #28a745;
                        font-size: 4rem;
                        margin-bottom: 1rem;
                    }
                    .redirect-text {
                        font-size: 0.9rem;
                        color: #6c757d;
                        margin-top: 1rem;
                    }
                    @keyframes checkmark {
                        0% { transform: scale(0); opacity: 0; }
                        100% { transform: scale(1); opacity: 1; }
                    }
                    .animate-check {
                        animation: checkmark 0.5s ease-in-out forwards;
                    }
                </style>
            </head>
            <body>
                <div class="success-card">
                    <div class="success-icon animate-check">
                        ✓
                    </div>
                    <h3 class="mb-3">Ödeme Başarılı!</h3>
                    <p class="mb-4">Ödemeniz başarıyla gerçekleştirildi. Teşekkür ederiz.</p>
                    <a href="https://www.epifizajans.com/yonetim/site" class="btn btn-primary mb-3">Ana Sayfaya Dön</a>
                    <div class="redirect-text">
                        <span id="countdown">5</span> saniye içinde ana sayfaya yönlendirileceksiniz.
                    </div>
                </div>

                <script>
                    // Geri sayım ve otomatik yönlendirme
                    let timeLeft = 5;
                    const countdownElement = document.getElementById('countdown');
                    
                    const countdown = setInterval(() => {
                        timeLeft--;
                        countdownElement.textContent = timeLeft;
                        
                        if (timeLeft <= 0) {
                            clearInterval(countdown);
                            window.location.href = 'https://www.epifizajans.com/yonetim/site';
                        }
                    }, 1000);
                </script>
            </body>
            </html>
            <?php
            exit;
            
        } catch (Exception $e) {
            $db->rollBack();
            error_log("PayTR success transaction error: " . $e->getMessage());
            
            // Hata logu
            $sorgu = $db->prepare("INSERT INTO online_odeme_log 
                (odeme_id, islem_tipi, islem_sonucu) 
                VALUES (?, 'Hata', ?)");
            $sorgu->execute([$odeme['id'], $e->getMessage()]);
            
            die('PAYTR notification failed: ' . $e->getMessage());
        }
    } else {
        // İşlem başarısızsa
        $sorgu = $db->prepare("UPDATE online_odemeler SET 
            durum = 'İptal',
            response_code = ?,
            response_message = ?,
            metadata = ?,
            updated_at = CURRENT_TIMESTAMP
            WHERE id = ?");
        
        $metadata = json_encode([
            'failed_reason_code' => $_POST['failed_reason_code'] ?? null,
            'failed_reason_msg' => $_POST['failed_reason_msg'] ?? null,
            'test_mode' => $_POST['test_mode'] ?? null
        ]);
        
        $sorgu->execute([
            $_POST['status'],
            $_POST['failed_reason_msg'] ?? 'Ödeme başarısız',
            $metadata,
            $odeme['id']
        ]);
        
        // Log kaydı
        $sorgu = $db->prepare("INSERT INTO online_odeme_log 
            (odeme_id, islem_tipi, islem_sonucu) 
            VALUES (?, 'Başarısız', ?)");
        $sorgu->execute([$odeme['id'], json_encode($_POST)]);
        
        echo "OK";
        exit;
    }
?>