<?php
ob_start();
oturumKontrol(); // Oturum kontrolü fonksiyonunuz

// DomainNameAPI kütüphanesini dahil ediyoruz
require_once 'DomainNameAPI_PHPLibrary.php';

// API ayarlarını al (sadece domain için)
$sorgu = $db->query("SELECT * FROM api_ayarlar WHERE servis = 'domainnameapi' LIMIT 1");
$api_ayarlar = $sorgu->fetch(PDO::FETCH_ASSOC);

// Müşteri listesini al
$sorgu = $db->query("SELECT * FROM musteriler ORDER BY ad, soyad");
$musteriler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Domain listesini getir
function getDomainList($db, $api_ayarlar) {
    try {
        $api = new DomainNameApi\DomainNameAPI_PHPLibrary(
            $api_ayarlar['username'],
            $api_ayarlar['password']
        );
        
        $response = $api->GetList();
        if ($response['result'] == 'OK') {
            $domains = [];
            foreach ($response['data']['Domains'] as $domain) {
                $details = $api->GetDetails($domain['DomainName']);
                if ($details['result'] == 'OK') {
                    $domain['Details'] = $details['data'];
                    
                    // Mevcut kaydı kontrol et
                    $sorgu = $db->prepare("SELECT musteri_id FROM domain_kayitlar WHERE domain = ?");
                    $sorgu->execute([$domain['DomainName']]);
                    $kayit = $sorgu->fetch(PDO::FETCH_ASSOC);
                    
                    if ($kayit) {
                        $domain['musteri_id'] = $kayit['musteri_id'];
                    }
                }
                $domains[] = $domain;
            }
            return $domains;
        }
    } catch (Exception $e) {
        error_log("Domain List Error: " . $e->getMessage());
    }
    return [];
}

// Form gönderildiğinde domain senkronizasyon işlemleri
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $basarili = 0;
    $hatali = 0;
    
    if (isset($_POST['sync_domains'])) {
        $domain_matches = $_POST['domain_matches'] ?? [];
        
        foreach ($domain_matches as $domain_data) {
            list($domain, $musteri_id) = explode('|', $domain_data);
            
            if (isset($_POST['domain_info']) && isset($_POST['domain_info'][$domain])) {
                $domain_info = json_decode(base64_decode($_POST['domain_info'][$domain]), true);
                
                if (!empty($musteri_id) && $domain_info) {
                    try {
                        // Mevcut kaydı kontrol et
                        $check = $db->prepare("SELECT id FROM domain_kayitlar WHERE domain = ?");
                        $check->execute([$domain]);
                        
                        if ($check->rowCount() > 0) {
                            // Kayıt varsa güncelle
                            $update = $db->prepare("UPDATE domain_kayitlar SET 
                                musteri_id = ?, 
                                kayit_tarihi = ?, 
                                bitis_tarihi = ?, 
                                durum = ? 
                                WHERE domain = ?");
                            
                            $update->execute([
                                $musteri_id,
                                date('Y-m-d', strtotime($domain_info['Details']['Dates']['Start'])),
                                date('Y-m-d', strtotime($domain_info['Details']['Dates']['Expiration'])),
                                $domain_info['Status'] == 'Active' ? 'Aktif' : 'Transfer',
                                $domain
                            ]);
                        } else {
                            // Kayıt yoksa ekle
                            $insert = $db->prepare("INSERT INTO domain_kayitlar 
                                (musteri_id, domain, kayit_tarihi, bitis_tarihi, durum) 
                                VALUES (?, ?, ?, ?, ?)");
                            
                            $insert->execute([
                                $musteri_id,
                                $domain,
                                date('Y-m-d', strtotime($domain_info['Details']['Dates']['Start'])),
                                date('Y-m-d', strtotime($domain_info['Details']['Dates']['Expiration'])),
                                $domain_info['Status'] == 'Active' ? 'Aktif' : 'Transfer'
                            ]);
                        }
                        
                        // Log kaydı ekle
                        $log = $db->prepare("INSERT INTO domain_sync_log 
                            (domain, musteri_id, status) 
                            VALUES (?, ?, 'success')");
                        $log->execute([$domain, $musteri_id]);
                        
                        $basarili++;
                    } catch (PDOException $e) {
                        error_log("Domain Sync Error: " . $e->getMessage());
                        
                        // Hata logunu kaydet
                        $log = $db->prepare("INSERT INTO domain_sync_log 
                            (domain, musteri_id, status, error_message) 
                            VALUES (?, ?, 'failed', ?)");
                        $log->execute([$domain, $musteri_id, $e->getMessage()]);
                        
                        $hatali++;
                    }
                }
            }
        }
        
        header("Location: index.php?sayfa=sync/sync_domains&mesaj=sync_completed&basarili=" . $basarili . "&hatali=" . $hatali);
        exit;
    }
}

// Domain listesi
$domains = getDomainList($db, $api_ayarlar);

// Sadece sahipsiz (henüz müşteriye atanmamış) domainleri filtrele
$domains = array_filter($domains, function($domain) {
    return !isset($domain['musteri_id']) || empty($domain['musteri_id']);
});
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Domain Senkronizasyonu</title>
    <!-- CSS kütüphaneleri (Bootstrap Icons, DataTables, Select2 vs.) -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
</head>
<body>
    <!-- Breadcrumb -->
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
            <li class="breadcrumb-item active">Domain Senkronizasyonu</li>
        </ol>
    </nav>
    
    <?php if (isset($_GET['mesaj']) && $_GET['mesaj'] == 'sync_completed'): ?>
    <div class="alert alert-success alert-dismissible fade show">
        <i class="bi bi-check-circle-fill me-2"></i>
        Senkronizasyon işlemi tamamlandı.<br>
        <strong><?php echo $_GET['basarili']; ?></strong> kayıt başarıyla aktarıldı.
        <?php if ($_GET['hatali'] > 0): ?>
            <br><strong><?php echo $_GET['hatali']; ?></strong> kayıt aktarılamadı.
        <?php endif; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php endif; ?>
    
    <!-- Domain Senkronizasyonu Kartı -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="card-title mb-0">
                <i class="bi bi-globe me-2"></i>
                Domain Senkronizasyonu
            </h5>
        </div>
        <div class="card-body">
            <form method="POST" action="">
                <input type="hidden" name="sync_domains" value="1">
                
                <div class="table-responsive">
                    <table id="domainTable" class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>Domain</th>
                                <th>Kayıt Tarihi</th>
                                <th>Bitiş Tarihi</th>
                                <th>Durum</th>
                                <th>Müşteri</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($domains as $domain): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($domain['DomainName']); ?></td>
                                <td><?php echo date('d.m.Y', strtotime($domain['Details']['Dates']['Start'])); ?></td>
                                <td><?php echo date('d.m.Y', strtotime($domain['Details']['Dates']['Expiration'])); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo $domain['Status'] == 'Active' ? 'success' : 'warning'; ?>">
                                        <?php echo $domain['Status']; ?>
                                    </span>
                                </td>
                                <td>
                                    <select name="domain_matches[]" class="form-select form-select-sm select2">
                                        <option value="">Müşteri Seçin</option>
                                        <?php foreach ($musteriler as $musteri): ?>
                                        <option value="<?php echo $domain['DomainName'] . '|' . $musteri['id']; ?>">
                                            <?php echo htmlspecialchars($musteri['ad'] . ' ' . $musteri['soyad']); ?>
                                            (<?php echo $musteri['musteri_turu']; ?>)
                                        </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <input type="hidden" name="domain_info[<?php echo $domain['DomainName']; ?>]" 
                                           value="<?php echo base64_encode(json_encode($domain)); ?>">
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-arrow-repeat me-2"></i>
                    Domain Aktarımını Başlat
                </button>
            </form>
        </div>
    </div>
    
    <!-- jQuery, DataTables ve Select2 JS -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    
    <script>
    $(document).ready(function() {
        // Select2 başlat
        $('.select2').select2({
            theme: 'bootstrap-5',
            width: '100%'
        });
        
        // DataTables başlat
        $('#domainTable').DataTable({
            language: {
                url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/tr.json'
            },
            pageLength: 10,
            lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Tümü"]],
            order: [[0, 'asc']],
            responsive: true,
            dom: "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
                 "<'row'<'col-sm-12'tr>>" +
                 "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            initComplete: function() {
                $('.dataTables_filter input')
                    .attr('placeholder', 'Ara...')
                    .addClass('form-control-sm');
                $('.dataTables_length select').addClass('form-select-sm');
            }
        });
    });
    </script>
</body>
</html>
<?php ob_end_flush(); ?>
