<?php
ob_start();
oturumKontrol();

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: index.php?sayfa=musteriler/liste");
    exit;
}

$musteri_id = (int)$_GET['id'];

// Get customer information
try {
    $sorgu = $db->prepare("SELECT * FROM musteriler WHERE id = ?");
    $sorgu->execute([$musteri_id]);
    $musteri = $sorgu->fetch(PDO::FETCH_ASSOC);
    
    if (!$musteri) {
        header("Location: index.php?sayfa=musteriler/liste");
        exit;
    }
    
    // Get hosting accounts
    $sorgu = $db->prepare("
        SELECT h.*, s.sunucu_adi, s.ip_adresi 
        FROM hosting_hesaplari h 
        LEFT JOIN sunucular s ON h.sunucu_id = s.id 
        WHERE h.musteri_id = ? 
        ORDER BY h.created_at DESC
    ");
    $sorgu->execute([$musteri_id]);
    $hosting_hesaplari = $sorgu->fetchAll(PDO::FETCH_ASSOC);
    
    // Get domains
    $sorgu = $db->prepare("
        SELECT d.*, df.yenileme_fiyat
        FROM domain_kayitlar d
        LEFT JOIN domain_fiyatlar df ON df.uzanti = SUBSTRING_INDEX(d.domain, '.', -2)
        WHERE d.musteri_id = ?
        ORDER BY d.kayit_tarihi DESC
    ");
    $sorgu->execute([$musteri_id]);
    $domainler = $sorgu->fetchAll(PDO::FETCH_ASSOC);
    
    // Calculate total debt
    $sorgu = $db->prepare("
        SELECT SUM(fiyat) as toplam_borc 
        FROM hosting_hesaplari 
        WHERE musteri_id = ? AND durum = 'Aktif' AND sonraki_odeme <= CURDATE()
    ");
    $sorgu->execute([$musteri_id]);
    $borc = $sorgu->fetch(PDO::FETCH_ASSOC);
    $toplam_borc = $borc['toplam_borc'] ?? 0;
    
} catch (PDOException $e) {
    die("Veritabanı hatası: " . $e->getMessage());
}

// Toplam borç hesaplama sorgusunu güncelle
try {
    // Ödenmemiş faturaların toplamını hesapla
    $sorgu = $db->prepare("
        SELECT SUM(genel_toplam) as toplam_borc 
        FROM faturalar 
        WHERE musteri_id = ? 
        AND odeme_durumu = 'Ödenmedi'
    ");
    $sorgu->execute([$musteri_id]);
    $borc = $sorgu->fetch(PDO::FETCH_ASSOC);
    $toplam_borc = $borc['toplam_borc'] ?? 0;

    // Kısmi ödenmiş faturaların kalan borç toplamını da ekle
    $sorgu = $db->prepare("
        SELECT SUM(genel_toplam) as kismi_borc 
        FROM faturalar 
        WHERE musteri_id = ? 
        AND odeme_durumu = 'Kısmi Ödendi'
    ");
    $sorgu->execute([$musteri_id]);
    $kismi_borc = $sorgu->fetch(PDO::FETCH_ASSOC);
    $toplam_borc += $kismi_borc['kismi_borc'] ?? 0;

} catch (PDOException $e) {
    die("Veritabanı hatası: " . $e->getMessage());
}

?>

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=musteriler/liste">Müşteriler</a></li>
        <li class="breadcrumb-item active">Müşteri Detayı</li>
    </ol>
</nav>

<div class="row">
    <!-- Customer Information -->
    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="bi bi-person-vcard me-2"></i>
                    Müşteri Bilgileri
                </h5>
                <a href="index.php?sayfa=musteriler/duzenle&id=<?php echo $musteri_id; ?>" 
                   class="btn btn-warning btn-sm">
                    <i class="bi bi-pencil me-1"></i>
                    Düzenle
                </a>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <h6 class="fw-bold">
                        <?php echo htmlspecialchars($musteri['ad'] . ' ' . $musteri['soyad']); ?>
                    </h6>
                    <span class="badge <?php echo $musteri['musteri_turu'] == 'Bireysel' ? 'bg-primary' : 'bg-success'; ?>">
                        <i class="bi <?php echo $musteri['musteri_turu'] == 'Bireysel' ? 'bi-person' : 'bi-building'; ?> me-1"></i>
                        <?php echo $musteri['musteri_turu']; ?>
                    </span>
                </div>
                
                <div class="mb-3">
                    <small class="text-muted d-block">İletişim Bilgileri</small>
                    <div class="d-flex align-items-center mb-1">
                        <i class="bi bi-telephone me-2"></i>
                        <a href="tel:<?php echo htmlspecialchars($musteri['telefon']); ?>" class="text-decoration-none">
                            <?php echo htmlspecialchars($musteri['telefon']); ?>
                        </a>
                    </div>
                    <div class="d-flex align-items-center">
                        <i class="bi bi-envelope me-2"></i>
                        <a href="mailto:<?php echo htmlspecialchars($musteri['eposta']); ?>" class="text-decoration-none">
                            <?php echo htmlspecialchars($musteri['eposta']); ?>
                        </a>
                    </div>
                </div>
                
                <?php if ($musteri['adres']): ?>
                <div class="mb-3">
                    <small class="text-muted d-block">Adres</small>
                    <div class="d-flex align-items-start">
                        <i class="bi bi-geo-alt me-2 mt-1"></i>
                        <span><?php echo nl2br(htmlspecialchars($musteri['adres'])); ?></span>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if ($musteri['musteri_turu'] == 'Bireysel'): ?>
                    <?php if ($musteri['tc_kimlik_no']): ?>
                    <div class="mb-2">
                        <small class="text-muted d-block">T.C. Kimlik No</small>
                        <div class="d-flex align-items-center">
                            <i class="bi bi-person-badge me-2"></i>
                            <?php echo htmlspecialchars($musteri['tc_kimlik_no']); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ($musteri['dogum_yili']): ?>
                    <div class="mb-2">
                        <small class="text-muted d-block">Doğum Yılı</small>
                        <div class="d-flex align-items-center">
                            <i class="bi bi-calendar me-2"></i>
                            <?php echo htmlspecialchars($musteri['dogum_yili']); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                <?php else: ?>
                    <?php if ($musteri['vergi_dairesi']): ?>
                    <div class="mb-2">
                        <small class="text-muted d-block">Vergi Dairesi</small>
                        <div class="d-flex align-items-center">
                            <i class="bi bi-building me-2"></i>
                            <?php echo htmlspecialchars($musteri['vergi_dairesi']); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ($musteri['vergi_no']): ?>
                    <div class="mb-2">
                        <small class="text-muted d-block">Vergi No</small>
                        <div class="d-flex align-items-center">
                            <i class="bi bi-upc me-2"></i>
                            <?php echo htmlspecialchars($musteri['vergi_no']); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                <?php endif; ?>
                
                <div class="mt-3">
                    <small class="text-muted d-block">Kayıt Tarihi</small>
                    <div class="d-flex align-items-center">
                        <i class="bi bi-clock-history me-2"></i>
                        <?php echo date('d.m.Y H:i', strtotime($musteri['created_at'])); ?>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Financial Status -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-cash-stack me-2"></i>
                    Finansal Durum
                </h5>
            </div>
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div>Toplam Borç</div>
                    <h3 class="mb-0 <?php echo $toplam_borc > 0 ? 'text-danger' : 'text-success'; ?>">
                        <?php echo number_format($toplam_borc, 2, ',', '.'); ?> ₺
                    </h3>
                </div>
                
                <?php if ($toplam_borc > 0): ?>
                    <div class="alert alert-warning mb-0">
                        <i class="bi bi-exclamation-triangle-fill me-2"></i>
                        <?php 
                        $sorgu = $db->prepare("SELECT COUNT(*) as fatura_sayisi FROM faturalar WHERE musteri_id = ? AND (odeme_durumu = 'Ödenmedi' OR odeme_durumu = 'Kısmi Ödendi')");
                        $sorgu->execute([$musteri_id]);
                        $fatura_sayisi = $sorgu->fetch(PDO::FETCH_ASSOC)['fatura_sayisi'];
                        echo $fatura_sayisi . ' adet ödenmemiş veya kısmi ödenmiş fatura bulunmaktadır.';
                        ?>
                    </div>
                <?php else: ?>
                    <div class="alert alert-success mb-0">
                        <i class="bi bi-check-circle-fill me-2"></i>
                        Tüm ödemeler güncel.
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Services -->
    <div class="col-md-8">
        <!-- Hosting Accounts -->
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="bi bi-hdd-rack me-2"></i>
                    Hosting Hesapları
                </h5>
                <a href="index.php?sayfa=hosting/ekle&musteri_id=<?php echo $musteri_id; ?>" 
                   class="btn btn-primary btn-sm">
                    <i class="bi bi-plus-circle me-1"></i>
                    Yeni Hosting Hesabı
                </a>
            </div>
            <div class="card-body">
                <?php if (empty($hosting_hesaplari)): ?>
                    <div class="alert alert-info mb-0">
                        <i class="bi bi-info-circle me-2"></i>
                        Henüz hosting hesabı bulunmamaktadır.
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Domain</th>
                                    <th>Sunucu</th>
                                    <th>Paket</th>
                                    <th>Durum</th>
                                    <th>Sonraki Ödeme</th>
                                    <th>İşlemler</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($hosting_hesaplari as $hesap): ?>
                                <tr>
                                    <td>
                                        <a href="http://<?php echo htmlspecialchars($hesap['domain']); ?>" 
                                           target="_blank" class="text-decoration-none">
                                            <?php echo htmlspecialchars($hesap['domain']); ?>
                                            <i class="bi bi-box-arrow-up-right ms-1"></i>
                                        </a>
                                    </td>
                                    <td>
                                        <span class="d-block"><?php echo htmlspecialchars($hesap['sunucu_adi']); ?></span>
                                        <small class="text-muted"><?php echo htmlspecialchars($hesap['ip_adresi']); ?></small>
                                    </td>
                                    <td><?php echo htmlspecialchars($hesap['paket']); ?></td>
                                    <td>
                                        <?php
                                        $durum_class = '';
                                        $durum_icon = '';
                                        switch($hesap['durum']) {
                                            case 'Aktif':
                                                $durum_class = 'bg-success';
                                                $durum_icon = 'bi-check-circle';
                                                break;
                                            case 'Askıda':
                                                $durum_class = 'bg-warning';
                                                $durum_icon = 'bi-pause-circle';
                                                break;
                                            case 'İptal':
                                                $durum_class = 'bg-danger';
                                                $durum_icon = 'bi-x-circle';
                                                break;
                                        }
                                        ?>
                                        <span class="badge <?php echo $durum_class; ?>">
                                            <i class="bi <?php echo $durum_icon; ?> me-1"></i>
                                            <?php echo $hesap['durum']; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if ($hesap['sonraki_odeme']): ?>
                                            <?php
                                            $tarih = new DateTime($hesap['sonraki_odeme']);
                                            $bugun = new DateTime();
                                            $fark = $bugun->diff($tarih);
                                            $gecmis = $tarih < $bugun;
                                            ?>
                                            <span class="<?php echo $gecmis ? 'text-danger' : 'text-success'; ?>">
                                                <?php echo date('d.m.Y', strtotime($hesap['sonraki_odeme'])); ?>
                                                <small class="d-block text-muted">
                                                    <?php
                                                    if ($gecmis) {
                                                        echo $fark->days . ' gün gecikmiş';
                                                    } else {
                                                        echo $fark->days . ' gün kaldı';
                                                    }
                                                    ?>
                                                </small>
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">Ücretsiz</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-sm btn-primary dropdown-toggle" 
                                                    data-bs-toggle="dropdown">
                                                <i class="bi bi-gear me-1"></i>
                                                İşlemler
                                            </button>
                                            <ul class="dropdown-menu">
                                                <li>
                                                    <a class="dropdown-item" href="index.php?sayfa=hosting/eposta_listesi&user=<?php echo urlencode($hesap['kullanici_adi']); ?>&server=<?php echo urlencode($hesap['sunucu_adi']); ?>">
                                                        <i class="bi bi-envelope me-2"></i>
                                                        E-Posta Hesapları
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="index.php?sayfa=hosting/paket_degistir&user=<?php echo urlencode($hesap['kullanici_adi']); ?>&server=<?php echo urlencode($hesap['sunucu_adi']); ?>">
                                                        <i class="bi bi-box me-2"></i>
                                                        Paket Değiştir
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="index.php?sayfa=hosting/sifre_degistir&user=<?php echo urlencode($hesap['kullanici_adi']); ?>&server=<?php echo urlencode($hesap['sunucu_adi']); ?>">
                                                        <i class="bi bi-key me-2"></i>
                                                        Şifre Değiştir
                                                    </a>
                                                </li>
                                                <?php if ($hesap['durum'] == 'Aktif'): ?>
                                                <li><hr class="dropdown-divider"></li>
                                                <li>
                                                    <a class="dropdown-item text-warning" href="index.php?sayfa=hosting/islemler&islem=askiya_al&user=<?php echo urlencode($hesap['kullanici_adi']); ?>&server=<?php echo urlencode($hesap['sunucu_adi']); ?>">
                                                        <i class="bi bi-pause-circle me-2"></i>
                                                        Askıya Al
                                                    </a>
                                                </li>
                                                <?php else: ?>
                                                <li>
                                                    <a class="dropdown-item text-success" href="index.php?sayfa=hosting/islemler&islem=aktif_et&user=<?php echo urlencode($hesap['kullanici_adi']); ?>&server=<?php echo urlencode($hesap['sunucu_adi']); ?>">
                                                        <i class="bi bi-play-circle me-2"></i>
                                                        Aktifleştir
                                                    </a>
                                                </li>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Domains -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="bi bi-globe me-2"></i>
                    Domainler
                </h5>
                <a href="index.php?sayfa=domain/ekle&musteri_id=<?php echo $musteri_id; ?>" 
                   class="btn btn-primary btn-sm">
                    <i class="bi bi-plus-circle me-1"></i>
                    Yeni Domain
                </a>
            </div>
            <div class="card-body">
                <?php if (empty($domainler)): ?>
                    <div class="alert alert-info mb-0">
                        <i class="bi bi-info-circle me-2"></i>
                        Henüz domain kaydı bulunmamaktadır.
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Domain</th>
                                    <th>Kayıt Tarihi</th>
                                    <th>Bitiş Tarihi</th>
                                    <th>Yenileme Ücreti</th>
                                    <th>Durum</th>
                                    <th>İşlemler</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($domainler as $domain): ?>
                                <tr>
                                    <td>
                                        <a href="http://<?php echo htmlspecialchars($domain['domain']); ?>" 
                                           target="_blank" class="text-decoration-none">
                                            <?php echo htmlspecialchars($domain['domain']); ?>
                                            <i class="bi bi-box-arrow-up-right ms-1"></i>
                                        </a>
                                    </td>
                                    <td><?php echo date('d.m.Y', strtotime($domain['kayit_tarihi'])); ?></td>
                                    <td>
                                        <?php
                                        $bitis_tarihi = new DateTime($domain['bitis_tarihi']);
                                        $bugun = new DateTime();
                                        $fark = $bugun->diff($bitis_tarihi);
                                        $gecmis = $bitis_tarihi < $bugun;
                                        ?>
                                        <span class="<?php echo $gecmis ? 'text-danger' : 'text-success'; ?>">
                                            <?php echo date('d.m.Y', strtotime($domain['bitis_tarihi'])); ?>
                                            <small class="d-block text-muted">
                                                <?php
                                                if ($gecmis) {
                                                    echo $fark->days . ' gün gecikmiş';
                                                } else {
                                                    echo $fark->days . ' gün kaldı';
                                                }
                                                ?>
                                            </small>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if ($domain['yenileme_fiyat']): ?>
                                            <?php echo number_format($domain['yenileme_fiyat'], 2, ',', '.'); ?> ₺
                                        <?php else: ?>
                                            <span class="text-muted">Belirlenmemiş</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php
                                        $durum_class = '';
                                        $durum_icon = '';
                                        switch($domain['durum']) {
                                            case 'Aktif':
                                                $durum_class = 'bg-success';
                                                $durum_icon = 'bi-check-circle';
                                                break;
                                            case 'Transfer':
                                                $durum_class = 'bg-warning';
                                                $durum_icon = 'bi-arrow-left-right';
                                                break;
                                            case 'İptal':
                                                $durum_class = 'bg-danger';
                                                $durum_icon = 'bi-x-circle';
                                                break;
                                        }
                                        ?>
                                        <span class="badge <?php echo $durum_class; ?>">
                                            <i class="bi <?php echo $durum_icon; ?> me-1"></i>
                                            <?php echo $domain['durum']; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-sm btn-primary dropdown-toggle" 
                                                    data-bs-toggle="dropdown">
                                                <i class="bi bi-gear me-1"></i>
                                                İşlemler
                                            </button>
                                            <ul class="dropdown-menu">
                                                <li>
                                                    <a class="dropdown-item" href="index.php?sayfa=domain/nameserver&domain=<?php echo urlencode($domain['domain']); ?>">
                                                        <i class="bi bi-hdd-network me-2"></i>
                                                        Nameserver Ayarları
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="index.php?sayfa=domain/contact&domain=<?php echo urlencode($domain['domain']); ?>">
                                                        <i class="bi bi-person me-2"></i>
                                                        İletişim Bilgileri
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="index.php?sayfa=domain/transfer&domain=<?php echo urlencode($domain['domain']); ?>">
                                                        <i class="bi bi-arrow-left-right me-2"></i>
                                                        Transfer İşlemleri
                                                    </a>
                                                </li>
                                                <?php if ($domain['durum'] == 'Aktif'): ?>
                                                <li><hr class="dropdown-divider"></li>
                                                <li>
                                                    <a class="dropdown-item" href="index.php?sayfa=domain/yenile&domain=<?php echo urlencode($domain['domain']); ?>">
                                                        <i class="bi bi-arrow-clockwise me-2"></i>
                                                        Yenile
                                                    </a>
                                                </li>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php ob_end_flush(); ?>