<?php
oturumKontrol();

if (!isset($_GET['user']) || !isset($_GET['server'])) {
    header("Location: index.php?sayfa=hosting/liste");
    exit;
}

$username = $_GET['user'];
$server_name = $_GET['server'];

// Sunucu bilgilerini al
$sorgu = $db->prepare("SELECT * FROM sunucular WHERE sunucu_adi = ?");
$sorgu->execute([$server_name]);
$sunucu = $sorgu->fetch(PDO::FETCH_ASSOC);

if (!$sunucu) {
    header("Location: index.php?sayfa=hosting/liste&mesaj=sunucu_bulunamadi");
    exit;
}

// WHM API'den paketleri çek
function getPaketler($sunucu) {
    $url = "https://{$sunucu['ip_adresi']}:2087/json-api/listpkgs";
    
    $header = array(
        "Authorization: WHM {$sunucu['kullanici_adi']}:{$sunucu['token']}"
    );
    
    error_log("WHM API Request URL (listpkgs): " . $url);
    error_log("WHM API Headers (listpkgs): " . print_r($header, true));
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    
    $response = curl_exec($ch);
    $info = curl_getinfo($ch);
    $error = curl_error($ch);
    
    error_log("WHM API Response (listpkgs): " . $response);
    error_log("WHM API HTTP Code (listpkgs): " . $info['http_code']);
    if ($error) {
        error_log("WHM API Error (listpkgs): " . $error);
    }
    
    curl_close($ch);
    
    if ($error) {
        return array('error' => $error);
    }
    
    return json_decode($response, true);
}

// Mevcut hesap bilgilerini çek
function getHesapBilgileri($sunucu, $username) {
    $url = "https://{$sunucu['ip_adresi']}:2087/json-api/accountsummary";
    
    $header = array(
        "Authorization: WHM {$sunucu['kullanici_adi']}:{$sunucu['token']}"
    );
    
    $params = array(
        'user' => $username
    );
    
    error_log("WHM API Request URL (accountsummary): " . $url . "?" . http_build_query($params));
    error_log("WHM API Headers (accountsummary): " . print_r($header, true));
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($params));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    
    $response = curl_exec($ch);
    $info = curl_getinfo($ch);
    $error = curl_error($ch);
    
    error_log("WHM API Response (accountsummary): " . $response);
    error_log("WHM API HTTP Code (accountsummary): " . $info['http_code']);
    if ($error) {
        error_log("WHM API Error (accountsummary): " . $error);
    }
    
    curl_close($ch);
    
    return json_decode($response, true);
}

$paketler = getPaketler($sunucu);
$hesapBilgileri = getHesapBilgileri($sunucu, $username);

$hata = '';
$basarili = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $yeni_paket = $_POST['yeni_paket'];
    
    if (empty($yeni_paket)) {
        $hata = 'Lütfen bir paket seçin.';
    } else {
        // WHM API'yi çağır
        $url = "https://{$sunucu['ip_adresi']}:2087/json-api/changepackage";
        
        $header = array(
            "Authorization: WHM {$sunucu['kullanici_adi']}:{$sunucu['token']}"
        );
        
        $params = array(
            'user' => $username,
            'pkg' => $yeni_paket
        );
        
        error_log("WHM API Request URL (changepackage): " . $url . "?" . http_build_query($params));
        error_log("WHM API Headers (changepackage): " . print_r($header, true));
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($params));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        
        $response = curl_exec($ch);
        $info = curl_getinfo($ch);
        $error = curl_error($ch);
        
        error_log("WHM API Response (changepackage): " . $response);
        error_log("WHM API HTTP Code (changepackage): " . $info['http_code']);
        if ($error) {
            error_log("WHM API Error (changepackage): " . $error);
        }
        
        curl_close($ch);
        
        if ($error) {
            $hata = 'API hatası: ' . $error;
        } else {
            $result = json_decode($response, true);
            // Yanıt formatını doğru şekilde kontrol et
            if (isset($result['result']) && is_array($result['result']) && 
                isset($result['result'][0]['status']) && $result['result'][0]['status'] == 1) {
                $basarili = 'Paket başarıyla değiştirildi: ' . $result['result'][0]['statusmsg'];
                
                // Kısa bir beklemeden sonra sayfayı yenile
                header("Refresh: 2; url=" . $_SERVER['REQUEST_URI']);
            } else {
                $hata = 'Paket değiştirilemedi: ' . 
                    (isset($result['result'][0]['statusmsg']) ? $result['result'][0]['statusmsg'] : 'Bilinmeyen hata');
            }
        }
    }
}

?>

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=hosting/liste">Hosting Hesapları</a></li>
        <li class="breadcrumb-item active" aria-current="page">Paket Değiştir</li>
    </ol>
</nav>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">
            Hosting Paketi Değiştir
            <small class="text-muted">(<?php echo htmlspecialchars($username); ?>)</small>
        </h5>
    </div>
    <div class="card-body">
        <?php if ($hata): ?>
            <div class="alert alert-danger"><?php echo $hata; ?></div>
        <?php endif; ?>
        
        <?php if ($basarili): ?>
            <div class="alert alert-success"><?php echo $basarili; ?></div>
        <?php endif; ?>
        
        <?php if (isset($hesapBilgileri['acct'][0])): ?>
        <div class="alert alert-info">
            <h6>Mevcut Paket Bilgileri:</h6>
            <p class="mb-0">
                Paket: <strong><?php echo htmlspecialchars($hesapBilgileri['acct'][0]['plan']); ?></strong><br>
                Disk Alanı: <?php 
                    $disk_limit = $hesapBilgileri['acct'][0]['disklimit'];
                    echo $disk_limit === "unlimited" ? "Sınırsız" : round(intval($disk_limit) / 1024, 2) . " GB";
                ?><br>
                Bant Genişliği: <?php 
                    $bw_limit = $hesapBilgileri['acct'][0]['bandwidth'] ?? "unlimited";
                    echo $bw_limit === "unlimited" ? "Sınırsız" : round(intval($bw_limit) / 1024, 2) . " GB";
                ?>
            </p>
        </div>
        <?php endif; ?>
        
        <form method="POST" action="" class="row g-3">
            <div class="col-md-12">
                <label for="yeni_paket" class="form-label">Yeni Paket</label>
                <select class="form-select" id="yeni_paket" name="yeni_paket" required>
                    <option value="">Paket Seçin</option>
                    <?php 
                    if (isset($paketler['package']) && is_array($paketler['package'])) {
                        foreach ($paketler['package'] as $paket) {
                            if (empty($paket['name']) || $paket['name'] == 'default') continue;
                            
                            $disk = isset($paket['QUOTA']) ? ($paket['QUOTA'] == "unlimited" ? "Sınırsız" : round($paket['QUOTA'] / 1024, 2) . " GB") : "N/A";
                            $bw = isset($paket['BWLIMIT']) ? ($paket['BWLIMIT'] == "unlimited" ? "Sınırsız" : round($paket['BWLIMIT'] / 1024, 2) . " GB") : "N/A";
                            
                            echo '<option value="' . htmlspecialchars($paket['name']) . '">' . 
                                 htmlspecialchars($paket['name']) . ' - ' .
                                 'Disk: ' . $disk . ', ' .
                                 'Bant Genişliği: ' . $bw .
                                 '</option>';
                        }
                    } else {
                        error_log("Paket listesi alınamadı veya boş: " . print_r($paketler, true));
                    }
                    ?>
                </select>
            </div>
            
            <div class="col-12">
                <button type="submit" class="btn btn-primary">Paketi Değiştir</button>
                <a href="index.php?sayfa=hosting/liste" class="btn btn-secondary">İptal</a>
            </div>
        </form>
    </div>
</div>