<?php
require_once '../../../config/db.php';

if (!isset($_GET['sunucu_id'])) {
    die(json_encode(['error' => 'Sunucu ID gerekli']));
}

$sunucu_id = (int)$_GET['sunucu_id'];

try {
    // Sunucu bilgilerini al
    $sorgu = $db->prepare("SELECT * FROM sunucular WHERE id = ?");
    $sorgu->execute([$sunucu_id]);
    $sunucu = $sorgu->fetch(PDO::FETCH_ASSOC);
    
    if (!$sunucu) {
        die(json_encode(['error' => 'Sunucu bulunamadı']));
    }
    
    // Debug: Sunucu bilgilerini logla
    error_log("Sunucu bilgileri: " . print_r($sunucu, true));
    
    // WHM API'yi çağır
    $url = "https://{$sunucu['ip_adresi']}:2087/json-api/listpkgs";
    
    $header = array(
        "Authorization: WHM {$sunucu['kullanici_adi']}:{$sunucu['token']}"
    );
    
    // Debug: API çağrı bilgilerini logla
    error_log("WHM API URL: " . $url);
    error_log("WHM API Headers: " . print_r($header, true));
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    
    // Debug: API yanıtını ve hata bilgilerini logla
    error_log("WHM API HTTP Code: " . $httpCode);
    error_log("WHM API Response: " . $response);
    if ($error) {
        error_log("WHM API Error: " . $error);
    }
    
    curl_close($ch);
    
    if ($error) {
        die(json_encode(['error' => $error]));
    }
    
    $result = json_decode($response, true);
    
    // Debug: JSON decode sonucunu logla
    error_log("Decoded Response: " . print_r($result, true));
    
    // Sadece gerekli bilgileri gönder
    $packages = [];
    if (isset($result['package']) && is_array($result['package'])) {
        foreach ($result['package'] as $pkg) {
            if (!empty($pkg['name']) && $pkg['name'] != 'default') {
                $packages[] = [
                    'name' => $pkg['name'],
                    'quota' => $pkg['QUOTA'],
                    'bwlimit' => $pkg['BWLIMIT']
                ];
            }
        }
    }
    
    // Debug: Son paket listesini logla
    error_log("Final Packages: " . print_r($packages, true));
    
    header('Content-Type: application/json');
    echo json_encode(['packages' => $packages]);
    
} catch (Exception $e) {
    error_log("Exception: " . $e->getMessage());
    die(json_encode(['error' => $e->getMessage()]));
}
?>