<?php
oturumKontrol();

require_once 'DomainNameAPI_PHPLibrary.php';

// API bağlantısı için ayarları al
$sorgu = $db->query("SELECT * FROM api_ayarlar WHERE servis = 'domainnameapi' LIMIT 1");
$api_ayarlar = $sorgu->fetch(PDO::FETCH_ASSOC);

if (!$api_ayarlar) {
    die("DomainNameAPI ayarları bulunamadı!");
}

try {
    // API bağlantısını oluştur
    $api = new DomainNameApi\DomainNameAPI_PHPLibrary(
        $api_ayarlar['username'],
        $api_ayarlar['password']
    );
    
    // Domain listesini çek
    $response = $api->GetList();
    
    if ($response['result'] == 'OK') {
        $domainler = $response['data']['Domains'];
    } else {
        $hata = $response['error']['Message'];
    }
    
} catch (Exception $e) {
    $hata = "API Hatası: " . $e->getMessage();
}

// Mesaj parametresini kontrol et
$mesaj = isset($_GET['mesaj']) ? $_GET['mesaj'] : '';
$mesajMetni = '';
$mesajTuru = '';

switch($mesaj) {
    case 'basarili':
        $mesajMetni = 'Domain başarıyla eklendi.';
        $mesajTuru = 'success';
        break;
    case 'guncellendi':
        $mesajMetni = 'Domain bilgileri güncellendi.';
        $mesajTuru = 'success';
        break;
    case 'silindi':
        $mesajMetni = 'Domain başarıyla silindi.';
        $mesajTuru = 'success';
        break;
    case 'hata':
        $mesajMetni = 'Bir hata oluştu. Lütfen tekrar deneyin.';
        $mesajTuru = 'danger';
        break;
}
?>

<!-- Bootstrap Icons ve DataTables CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item">Domain Hesapları</li>
        <li class="breadcrumb-item active" aria-current="page">Domain Listesi</li>
    </ol>
</nav>

<!-- Mesaj Gösterimi -->
<?php if ($mesajMetni): ?>
<div class="alert alert-<?php echo $mesajTuru; ?> alert-dismissible fade show" role="alert">
    <i class="bi bi-info-circle me-2"></i>
    <?php echo $mesajMetni; ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat"></button>
</div>
<?php endif; ?>

<?php if (isset($hata)): ?>
<div class="alert alert-danger">
    <i class="bi bi-exclamation-triangle-fill me-2"></i>
    <?php echo $hata; ?>
</div>
<?php endif; ?>

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0">
            <i class="bi bi-globe me-2"></i>
            Domain Listesi
        </h5>
        <a href="index.php?sayfa=domain/ekle" class="btn btn-primary btn-sm">
            <i class="bi bi-plus-circle me-2"></i>
            Yeni Domain
        </a>
    </div>
    <div class="card-body">
        <?php if (!empty($domainler)): ?>
        <div class="table-responsive">
            <table id="domainTable" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>Domain Adı</th>
                        <th>Durum</th>
                        <th>Başlangıç Tarihi</th>
                        <th>Bitiş Tarihi</th>
                        <th>Kalan Gün</th>
                        <th>İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($domainler as $domain): ?>
                    <tr>
                        <td>
                            <a href="http://<?php echo htmlspecialchars($domain['DomainName']); ?>" 
                               target="_blank" class="text-decoration-none">
                                <?php echo htmlspecialchars($domain['DomainName']); ?>
                                <i class="bi bi-box-arrow-up-right ms-1"></i>
                            </a>
                        </td>
                        <td>
                            <?php
                            $durum_class = '';
                            $durum_icon = '';
                            switch($domain['Status']) {
                                case 'Active':
                                    $durum_class = 'bg-success';
                                    $durum_icon = 'bi-check-circle';
                                    break;
                                case 'Expired':
                                    $durum_class = 'bg-danger';
                                    $durum_icon = 'bi-x-circle';
                                    break;
                                case 'Pending':
                                    $durum_class = 'bg-warning';
                                    $durum_icon = 'bi-clock';
                                    break;
                                default:
                                    $durum_class = 'bg-secondary';
                                    $durum_icon = 'bi-question-circle';
                            }
                            ?>
                            <span class="badge <?php echo $durum_class; ?>">
                                <i class="bi <?php echo $durum_icon; ?> me-1"></i>
                                <?php echo $domain['Status']; ?>
                            </span>
                        </td>
                        <td><?php echo date('d.m.Y', strtotime($domain['Dates']['Start'])); ?></td>
                        <td>
                            <?php 
                            $bitis_tarihi = strtotime($domain['Dates']['Expiration']);
                            $bugun = time();
                            $kalan_gun = ceil(($bitis_tarihi - $bugun) / (60 * 60 * 24));
                            echo date('d.m.Y', $bitis_tarihi); 
                            ?>
                        </td>
                        <td>
                            <span class="badge <?php echo $kalan_gun <= 30 ? 'bg-danger' : 'bg-success'; ?>">
                                <?php echo $kalan_gun; ?> gün
                            </span>
                        </td>
                        <td>
                            <div class="btn-group">
                                <button type="button" class="btn btn-sm btn-primary dropdown-toggle" 
                                        data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="bi bi-gear me-1"></i>
                                    İşlemler
                                </button>
                                <ul class="dropdown-menu">
                                    <li>
                                        <a class="dropdown-item" href="index.php?sayfa=domain/nameserver&domain=<?php echo urlencode($domain['DomainName']); ?>">
                                            <i class="bi bi-hdd-network me-2"></i>
                                            Nameserver Ayarları
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="index.php?sayfa=domain/contact&domain=<?php echo urlencode($domain['DomainName']); ?>">
                                            <i class="bi bi-person me-2"></i>
                                            İletişim Bilgileri
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="index.php?sayfa=domain/transfer&domain=<?php echo urlencode($domain['DomainName']); ?>">
                                            <i class="bi bi-arrow-left-right me-2"></i>
                                            Transfer İşlemleri
                                        </a>
                                    </li>
                                    <?php if ($domain['Status'] == 'Active'): ?>
                                    <li>
                                        <a class="dropdown-item" href="index.php?sayfa=domain/renew&domain=<?php echo urlencode($domain['DomainName']); ?>">
                                            <i class="bi bi-arrow-clockwise me-2"></i>
                                            Yenile
                                        </a>
                                    </li>
                                    <?php endif; ?>
                                    <!-- Yeni Sahip Değiştir İşlemi -->
                                    <li>
                                        <a class="dropdown-item" href="index.php?sayfa=aktarim/domain_aktar&domain=<?php echo urlencode($domain['DomainName']); ?>"
                                           data-bs-toggle="tooltip" title="Sahip Değiştir">
                                            <i class="bi bi-person-lines-fill me-2"></i>
                                            Sahip Değiştir
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <div class="alert alert-info mb-0">
            <i class="bi bi-info-circle me-2"></i>
            Henüz kayıtlı domain bulunmamaktadır.
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- jQuery ve DataTables JS -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>

<script>
$(document).ready(function() {
    $('#domainTable').DataTable({
        language: {
            url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/tr.json'
        },
        pageLength: 10,
        order: [[3, 'asc']], // Bitiş tarihine göre sırala
        responsive: true
    });
});
</script>