<?php
session_start();
require_once 'config/db.php';

// Ödeme ID kontrolü
if (!isset($_GET['id'])) {
    header("Location: index.php");
    exit;
}

$odeme_id = $_GET['id'];

// Ödeme kaydını kontrol et
$sorgu = $db->prepare("
    SELECT o.*, f.fatura_no, f.genel_toplam, m.ad, m.soyad, m.eposta, m.telefon, m.adres 
    FROM online_odemeler o
    LEFT JOIN faturalar f ON o.fatura_id = f.id
    LEFT JOIN musteriler m ON f.musteri_id = m.id
    WHERE o.id = ? AND o.durum = 'Bekliyor'
");
$sorgu->execute([$odeme_id]);
$odeme = $sorgu->fetch(PDO::FETCH_ASSOC);

if (!$odeme) {
    die("Geçersiz ödeme kaydı veya ödeme zaten tamamlanmış.");
}

// PayTR için gerekli bilgiler
$merchant_id = '124157';
$merchant_key = 'ZoDMTAjHPUp3NNMD';
$merchant_salt = 's8QswoE3bctohMM6';

// Müşteri IP adresi
$user_ip = $_SERVER['HTTP_CLIENT_IP'] ?? $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'];

// merchant_oid olarak odeme_id'yi kullan
// $merchant_oid = preg_replace('/[^a-zA-Z0-9]/', '', $odeme_id . uniqid());
$merchant_oid = preg_replace('/[^a-zA-Z0-9]/', '', $odeme_id); // UUID'deki "-" karakterlerini kaldır

error_log("Generated merchant_oid: " . $merchant_oid);
error_log("User IP sent: " . $user_ip);

try {
    // merchant_oid'yi güncelle
    $sorgu = $db->prepare("UPDATE online_odemeler SET 
        merchant_oid = ?, 
        payment_provider = 'PayTR',
        updated_at = CURRENT_TIMESTAMP 
        WHERE id = ?");
    $sorgu->execute([$merchant_oid, $odeme_id]);
    
    // Log kaydı
    $sorgu = $db->prepare("INSERT INTO online_odeme_log (odeme_id, islem_tipi, islem_sonucu) VALUES (?, 'Başlatıldı', ?)");
    $sorgu->execute([$odeme_id, json_encode([
        'merchant_oid' => $merchant_oid,
        'payment_amount' => $odeme['tutar'] * 100,
        'user_ip' => $user_ip
    ])]);
} catch (PDOException $e) {
    error_log("Ödeme başlatma hatası: " . $e->getMessage());
    die("Ödeme başlatılamadı: Sistem hatası");
}

$email = $odeme['eposta'];
$payment_amount = $odeme['tutar'] * 100; // TL to kuruş
$currency = "TL";
$test_mode = 0;
// $merchant_ok_url = "https://www.epifizajans.com/yonetim/callback/paytr_success.php";
$merchant_ok_url = "https://www.epifizajans.com/yonetim/callback/paytr_success.php?show_result=1&oid=" . $merchant_oid;
$merchant_fail_url = "https://www.epifizajans.com/yonetim/callback/paytr_fail.php";

// Sepet bilgisi
$user_basket = base64_encode(json_encode([
    ["Fatura #" . $odeme['fatura_no'], $odeme['tutar'], 1]
]));

// Diğer parametreler
$user_name = $odeme['ad'] . ' ' . $odeme['soyad'];
$user_address = $odeme['adres'] ?: "Adres belirtilmemiş";
$user_phone = $odeme['telefon'];
$timeout_limit = "30";
$debug_on = 1;
$no_installment = 0;
$max_installment = 0;

// Token için hash oluştur
$hash_str = $merchant_id . $user_ip . $merchant_oid . $email . $payment_amount . $user_basket . $no_installment . $max_installment . $currency . $test_mode;
$paytr_token = base64_encode(hash_hmac('sha256', $hash_str . $merchant_salt, $merchant_key, true));

error_log("Generated hash_str for PayTR: " . $hash_str);
error_log("Generated PayTR Token: " . $paytr_token);

// API'ye gönderilecek veriler
$post_vals = [
    'merchant_id' => $merchant_id,
    'user_ip' => $user_ip,
    'merchant_oid' => $merchant_oid,
    'email' => $email,
    'payment_amount' => $payment_amount,
    'paytr_token' => $paytr_token,
    'user_basket' => $user_basket,
    'debug_on' => $debug_on,
    'no_installment' => $no_installment,
    'max_installment' => $max_installment,
    'user_name' => $user_name,
    'user_address' => $user_address,
    'user_phone' => $user_phone,
    'merchant_ok_url' => $merchant_ok_url,
    'merchant_fail_url' => $merchant_fail_url,
    'timeout_limit' => $timeout_limit,
    'currency' => $currency,
    'test_mode' => $test_mode,
    'lang' => 'tr'
];

// Debug için
error_log("PayTR Request Parameters: " . json_encode($post_vals));

// Token al
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://www.paytr.com/odeme/api/get-token");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $post_vals);
curl_setopt($ch, CURLOPT_FRESH_CONNECT, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 20);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

$result = curl_exec($ch);

if (curl_errno($ch)) {
    error_log("PayTR CURL Error: " . curl_error($ch));
    die("Ödeme sistemi bağlantı hatası: " . curl_error($ch));
}

curl_close($ch);

$result = json_decode($result, true);
error_log("PayTR API Response: " . print_r($result, true));

if ($result['status'] == 'success') {
    $token = $result['token'];
} else {
    error_log("PayTR Token Error: " . $result['reason']);
    die("Ödeme formu oluşturulamadı: " . $result['reason']);
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Online Ödeme - Fatura #<?php echo $odeme['fatura_no']; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .payment-container {
            max-width:1000px;
            width: 100%;
            padding: 20px;
        }
    </style>
</head>
<body>
    <div class="payment-container">
        <div class="card shadow">
            <div class="card-body">
                <div class="logo text-center mb-4">
                    <h4>Epifiz Web Ajans</h4>
                </div>
                
                <h5 class="card-title text-center mb-4">
                    Fatura #<?php echo $odeme['fatura_no']; ?> Ödemesi
                </h5>
                
                <div class="alert alert-info mb-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <span>Ödenecek Tutar:</span>
                        <strong><?php echo number_format($odeme['tutar'], 2, ',', '.'); ?> ₺</strong>
                    </div>
                </div>
                
                <!-- PayTR iframe -->
                <div id="payment-form">
                    <script src="https://www.paytr.com/js/iframeResizer.min.js"></script>
                    <iframe src="https://www.paytr.com/odeme/guvenli/<?php echo $token; ?>" 
                            id="paytriframe" 
                            frameborder="0" 
                            scrolling="no" 
                            style="width: 100%;"></iframe>
                    <script>iFrameResize({},'#paytriframe');</script>
                </div>
            </div>
        </div>
    </div>
</body>
</html>