<?php

musteriGirisKontrol();



// Get hosting accounts

$sorgu = $db->prepare("

    SELECT h.*, s.sunucu_adi, s.ip_adresi 

    FROM hosting_hesaplari h 

    LEFT JOIN sunucular s ON h.sunucu_id = s.id 

    WHERE h.musteri_id = ? 

    ORDER BY h.created_at DESC

");

$sorgu->execute([$_SESSION['musteri_id']]);

$hosting_hesaplari = $sorgu->fetchAll(PDO::FETCH_ASSOC);



// Get domains

$sorgu = $db->prepare("

    SELECT * FROM domain_kayitlar 

    WHERE musteri_id = ? 

    ORDER BY kayit_tarihi DESC

");

$sorgu->execute([$_SESSION['musteri_id']]);

$domainler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

?>



<!-- Page Title -->

<div class="d-flex justify-content-between align-items-center mb-4">

    <h1 class="h3 mb-0">

        <i class="bi bi-hdd-rack me-2"></i>

        Hizmetlerim

    </h1>

    <div>

        <a href="index.php?sayfa=domain/kayit" class="btn btn-primary">

            <i class="bi bi-globe me-2"></i>

            Domain Kaydet

        </a>

        <a href="index.php?sayfa=hosting/satin-al" class="btn btn-success">

            <i class="bi bi-hdd me-2"></i>

            Hosting Satın Al

        </a>

    </div>

</div>



<!-- Hosting Accounts -->

<div class="card mb-4">

    <div class="card-header">

        <h5 class="card-title mb-0">

            <i class="bi bi-hdd-rack me-2"></i>

            Hosting Hesaplarım

        </h5>

    </div>

    <div class="card-body">

        <?php if (empty($hosting_hesaplari)): ?>

            <div class="alert alert-info mb-0">

                <i class="bi bi-info-circle me-2"></i>

                Henüz hosting hesabınız bulunmamaktadır.

                <a href="index.php?sayfa=hosting/satin-al" class="alert-link">

                    Hemen bir hosting paketi satın alın

                </a>.

            </div>

        <?php else: ?>

            <div class="table-responsive">

                <table class="table table-hover">

                    <thead>

                        <tr>

                            <th>Domain</th>

                            <th>Paket</th>

                            <th>Sunucu</th>

                            <th>Durum</th>

                            <th>Sonraki Ödeme</th>

                            <th>İşlemler</th>

                        </tr>

                    </thead>

                    <tbody>

                        <?php foreach ($hosting_hesaplari as $hesap): ?>

                        <tr>

                            <td>

                                <a href="http://<?php echo htmlspecialchars($hesap['domain']); ?>" 

                                   target="_blank" class="text-decoration-none">

                                    <?php echo htmlspecialchars($hesap['domain']); ?>

                                    <i class="bi bi-box-arrow-up-right ms-1"></i>

                                </a>

                            </td>

                            <td><?php echo htmlspecialchars($hesap['paket']); ?></td>

                            <td>

                                <span class="d-block"><?php echo htmlspecialchars($hesap['sunucu_adi']); ?></span>

                                <small class="text-muted"><?php echo htmlspecialchars($hesap['ip_adresi']); ?></small>

                            </td>

                            <td>

                                <?php

                                $durum_class = '';

                                $durum_icon = '';

                                switch($hesap['durum']) {

                                    case 'Aktif':

                                        $durum_class = 'bg-success';

                                        $durum_icon = 'bi-check-circle';

                                        break;

                                    case 'Askıda':

                                        $durum_class = 'bg-warning';

                                        $durum_icon = 'bi-pause-circle';

                                        break;

                                    case 'İptal':

                                        $durum_class = 'bg-danger';

                                        $durum_icon = 'bi-x-circle';

                                        break;

                                }

                                ?>

                                <span class="badge <?php echo $durum_class; ?>">

                                    <i class="bi <?php echo $durum_icon; ?> me-1"></i>

                                    <?php echo $hesap['durum']; ?>

                                </span>

                            </td>

                            <td>

                                <?php if ($hesap['sonraki_odeme']): ?>

                                    <?php

                                    $tarih = new DateTime($hesap['sonraki_odeme']);

                                    $bugun = new DateTime();

                                    $fark = $bugun->diff($tarih);

                                    $gecmis = $tarih < $bugun;

                                    ?>

                                    <span class="<?php echo $gecmis ? 'text-danger' : 'text-success'; ?>">

                                        <?php echo date('d.m.Y', strtotime($hesap['sonraki_odeme'])); ?>

                                        <small class="d-block text-muted">

                                            <?php

                                            if ($gecmis) {

                                                echo $fark->days . ' gün gecikmiş';

                                            } else {

                                                echo $fark->days . ' gün kaldı';

                                            }

                                            ?>

                                        </small>

                                    </span>

                                <?php else: ?>

                                    <span class="badge bg-secondary">Ücretsiz</span>

                                <?php endif; ?>

                            </td>

                            <td>

                                <div class="btn-group">

                                    <button type="button" class="btn btn-sm btn-primary dropdown-toggle" 

                                            data-bs-toggle="dropdown">

                                        <i class="bi bi-gear me-1"></i>

                                        İşlemler

                                    </button>

                                    <ul class="dropdown-menu">

                                        <li>

                                            <a class="dropdown-item" href="index.php?sayfa=hosting/cpanel&id=<?php echo $hesap['id']; ?>"

                                               target="_blank">

                                                <i class="bi bi-speedometer2 me-2"></i>

                                                cPanel'e Git

                                            </a>

                                        </li>

                                        <li>

                                            <a class="dropdown-item" href="index.php?sayfa=hosting/eposta&id=<?php echo $hesap['id']; ?>">

                                                <i class="bi bi-envelope me-2"></i>

                                                E-Posta Hesapları

                                            </a>

                                        </li>

                                        <li>

                                            <a class="dropdown-item" href="index.php?sayfa=hosting/sifre&id=<?php echo $hesap['id']; ?>">

                                                <i class="bi bi-key me-2"></i>

                                                Şifre Değiştir

                                            </a>

                                        </li>

                                        <?php if ($hesap['sonraki_odeme']): ?>

                                        <li><hr class="dropdown-divider"></li>

                                        <li>

                                            <a class="dropdown-item" href="index.php?sayfa=hosting/yenile&id=<?php echo $hesap['id']; ?>">

                                                <i class="bi bi-arrow-clockwise me-2"></i>

                                                Yenile

                                            </a>

                                        </li>

                                        <?php endif; ?>

                                    </ul>

                                </div>

                            </td>

                        </tr>

                        <?php endforeach; ?>

                    </tbody>

                </table>

            </div>

        <?php endif; ?>

    </div>

</div>



<!-- Domains -->

<div class="card">

    <div class="card-header">

        <h5 class="card-title mb-0">

            <i class="bi bi-globe me-2"></i>

            Domainlerim

        </h5>

    </div>

    <div class="card-body">

        <?php if (empty($domainler)): ?>

            <div class="alert alert-info mb-0">

                <i class="bi bi-info-circle me-2"></i>

                Henüz domain kaydınız bulunmamaktadır.

                <a href="index.php?sayfa=domain/kayit" class="alert-link">

                    Hemen bir domain kaydedin

                </a>.

            </div>

        <?php else: ?>

            <div class="table-responsive">

                <table class="table table-hover">

                    <thead>

                        <tr>

                            <th>Domain</th>

                            <th>Kayıt Tarihi</th>

                            <th>Bitiş Tarihi</th>

                            <th>Durum</th>

                            <th>İşlemler</th>

                        </tr>

                    </thead>

                    <tbody>

                        <?php foreach ($domainler as $domain): ?>

                        <tr>

                            <td>

                                <a href="http://<?php echo htmlspecialchars($domain['domain']); ?>" 

                                   target="_blank" class="text-decoration-none">

                                    <?php echo htmlspecialchars($domain['domain']); ?>

                                    <i class="bi bi-box-arrow-up-right ms-1"></i>

                                </a>

                            </td>

                            <td><?php echo date('d.m.Y', strtotime($domain['kayit_tarihi'])); ?></td>

                            <td>

                                <?php

                                $bitis_tarihi = new DateTime($domain['bitis_tarihi']);

                                $bugun = new DateTime();

                                $fark = $bugun->diff($bitis_tarihi);

                                $gecmis = $bitis_tarihi < $bugun;

                                ?>

                                <span class="<?php echo $gecmis ? 'text-danger' : 'text-success'; ?>">

                                    <?php echo date('d.m.Y', strtotime($domain['bitis_tarihi'])); ?>

                                    <small class="d-block text-muted">

                                        <?php

                                        if ($gecmis) {

                                            echo $fark->days . ' gün gecikmiş';

                                        } else {

                                            echo $fark->days . ' gün kaldı';

                                        }

                                        ?>

                                    </small>

                                </span>

                            </td>

                            <td>

                                <?php

                                $durum_class = '';

                                $durum_icon = '';

                                switch($domain['durum']) {

                                    case 'Aktif':

                                        $durum_class = 'bg-success';

                                        $durum_icon = 'bi-check-circle';

                                        break;

                                    case 'Transfer':

                                        $durum_class = 'bg-warning';

                                        $durum_icon = 'bi-arrow-left-right';

                                        break;

                                    case 'İptal':

                                        $durum_class = 'bg-danger';

                                        $durum_icon = 'bi-x-circle';

                                        break;

                                }

                                ?>

                                <span class="badge <?php echo $durum_class; ?>">

                                    <i class="bi <?php echo $durum_icon; ?> me-1"></i>

                                    <?php echo $domain['durum']; ?>

                                </span>

                            </td>

                            <td>

                                <div class="btn-group">

                                    <button type="button" class="btn btn-sm btn-primary dropdown-toggle" 

                                            data-bs-toggle="dropdown">

                                        <i class="bi bi-gear me-1"></i>

                                        İşlemler

                                    </button>

                                    <ul class="dropdown-menu">

                                        <li>

                                            <a class="dropdown-item" href="index.php?sayfa=domain/nameserver&id=<?php echo $domain['id']; ?>">

                                                <i class="bi bi-hdd-network me-2"></i>

                                                Nameserver Ayarları

                                            </a>

                                        </li>

                                        <li>

                                            <a class="dropdown-item" href="index.php?sayfa=domain/yonlendirme&id=<?php echo $domain['id']; ?>">

                                                <i class="bi bi-arrow-right me-2"></i>

                                                Yönlendirme

                                            </a>

                                        </li>

                                        <li>

                                            <a class="dropdown-item" href="index.php?sayfa=domain/dns&id=<?php echo $domain['id']; ?>">

                                                <i class="bi bi-diagram-3 me-2"></i>

                                                DNS Yönetimi

                                            </a>

                                        </li>

                                        <?php if ($domain['durum'] == 'Aktif'): ?>

                                        <li><hr class="dropdown-divider"></li>

                                        <li>

                                            <a class="dropdown-item" href="index.php?sayfa=domain/yenile&id=<?php echo $domain['id']; ?>">

                                                <i class="bi bi-arrow-clockwise me-2"></i>

                                                Yenile

                                            </a>

                                        </li>

                                        <?php endif; ?>

                                    </ul>

                                </div>

                            </td>

                        </tr>

                        <?php endforeach; ?>

                    </tbody>

                </table>

            </div>

        <?php endif; ?>

    </div>

</div>