<?php



musteriGirisKontrol();



$musteri_id = $_SESSION['musteri_id'];



// Faturaları çek

$faturalar = $db->prepare("

    SELECT DISTINCT

        f.*,

        GROUP_CONCAT(fk.hizmet_turu) as hizmet_turleri,

        GROUP_CONCAT(

            CASE 

                WHEN fk.hizmet_turu = 'Domain' THEN CONCAT(d.domain, ' (', DATE_FORMAT(d.kayit_tarihi, '%d.%m.%Y'), ' - ', DATE_FORMAT(d.bitis_tarihi, '%d.%m.%Y'), ')')

                WHEN fk.hizmet_turu = 'Hosting' THEN CONCAT(h.domain, ' (', DATE_FORMAT(h.created_at, '%d.%m.%Y'), ' - ', DATE_FORMAT(h.sonraki_odeme, '%d.%m.%Y'), ')')

                ELSE CONCAT(fk.aciklama, ' (', DATE_FORMAT(f.fatura_tarihi, '%d.%m.%Y'), ' - ', DATE_FORMAT(f.son_odeme_tarihi, '%d.%m.%Y'), ')')

            END

            SEPARATOR '<br>'

        ) as hizmet_detaylari

    FROM faturalar f

    LEFT JOIN fatura_kalemleri fk ON f.id = fk.fatura_id

    LEFT JOIN domain_kayitlar d ON (fk.hizmet_id = d.id AND fk.hizmet_turu = 'Domain')

    LEFT JOIN hosting_hesaplari h ON (fk.hizmet_id = h.id AND fk.hizmet_turu = 'Hosting')

    WHERE f.musteri_id = ?

    GROUP BY f.id

    ORDER BY f.fatura_tarihi DESC

");

$faturalar->execute([$musteri_id]);

$faturalar = $faturalar->fetchAll(PDO::FETCH_ASSOC);

?>

    <div class="container-fluid">

        <div class="row">

            <div class="col-12">

                <div class="card">

                    <div class="card-header">

                        <h5 class="card-title mb-0">Faturalarım</h5>

                    </div>

                    <div class="card-body">

                        <div class="table-responsive">

                            <table class="table table-striped">

                                <thead>

                                    <tr>

                                        <th>Fatura No</th>

                                        <th>Hizmet</th>

                                        <th>Tutar</th>

                                        <th>Tarih</th>

                                        <th>Durum</th>

                                        <th>İşlemler</th>

                                    </tr>

                                </thead>

                                <tbody>

                                    <?php foreach ($faturalar as $fatura): ?>

                                    <tr>

                                        <td><?php echo $fatura['fatura_no']; ?></td>

                                        <td><?php echo $fatura['hizmet_detaylari']; ?></td>

                                        <td><?php echo number_format($fatura['genel_toplam'], 2, ',', '.'); ?> ₺</td>

                                        <td><?php echo date('d.m.Y', strtotime($fatura['fatura_tarihi'])); ?></td>

                                        <td>

                                            <?php if ($fatura['odeme_durumu'] == 'Ödendi'): ?>

                                                <span class="badge bg-success">Ödendi</span>

                                            <?php elseif ($fatura['odeme_durumu'] == 'Kısmi Ödendi'): ?>

                                                <span class="badge bg-warning">Kısmi Ödendi</span>

                                            <?php elseif ($fatura['odeme_durumu'] == 'İptal'): ?>

                                                <span class="badge bg-danger">İptal</span>

                                            <?php else: ?>

                                                <span class="badge bg-warning">Ödenmedi</span>

                                            <?php endif; ?>

                                        </td>

                                        <td>

                                            <a href="index.php?sayfa=fatura_detay&id=<?php echo $fatura['id']; ?>" class="btn btn-info btn-sm">

                                                <i class="bi bi-eye"></i>

                                            </a>

                                            <?php if ($fatura['odeme_durumu'] == 'Ödenmedi'): ?>

                                                <a href="index.php?sayfa=odeme&id=<?php echo $fatura['id']; ?>" class="btn btn-success btn-sm">

                                                    <i class="bi bi-credit-card"></i>

                                                </a>

                                            <?php endif; ?>

                                        </td>

                                    </tr>

                                    <?php endforeach; ?>

                                    

                                    <?php if (empty($faturalar)): ?>

                                    <tr>

                                        <td colspan="6" class="text-center">Henüz faturanız bulunmuyor.</td>

                                    </tr>

                                    <?php endif; ?>

                                </tbody>

                            </table>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>