<!-- Bootstrap Icons ve DataTables CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">

<?php
ob_start();
oturumKontrol();

// Log dosyasını oku
function logOku() {
    $log_dosyasi = __DIR__ . '/../../cron/fatura_log.txt';
    if (file_exists($log_dosyasi)) {
        return file_get_contents($log_dosyasi);
    }
    return '';
}

// Log dosyasını temizle
if (isset($_POST['log_temizle'])) {
    $log_dosyasi = __DIR__ . '/../../cron/fatura_log.txt';
    file_put_contents($log_dosyasi, '');
    header("Location: index.php?sayfa=sync/cron&mesaj=log_temizlendi");
    exit;
}

// Cron işlemini çalıştır
if (isset($_POST['cron_calistir'])) {
    require_once __DIR__ . '/../../cron/fatura_olustur.php';
    header("Location: index.php?sayfa=sync/cron&mesaj=cron_calisti");
    exit;
}

// Log içeriğini al
$log_icerigi = logOku();

// Mesaj parametresini kontrol et
$mesaj = isset($_GET['mesaj']) ? $_GET['mesaj'] : '';
$mesajMetni = '';
$mesajTuru = '';

switch($mesaj) {
    case 'cron_calisti':
        $mesajMetni = 'Cron işlemi başarıyla çalıştırıldı.';
        $mesajTuru = 'success';
        break;
    case 'log_temizlendi':
        $mesajMetni = 'Log kayıtları temizlendi.';
        $mesajTuru = 'success';
        break;
}
?>

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item">Senkronizasyon</li>
        <li class="breadcrumb-item active">Cron İşlemleri</li>
    </ol>
</nav>

<!-- Mesaj Gösterimi -->
<?php if ($mesajMetni): ?>
<div class="alert alert-<?php echo $mesajTuru; ?> alert-dismissible fade show" role="alert">
    <i class="bi bi-info-circle me-2"></i>
    <?php echo $mesajMetni; ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<div class="row">
    <!-- Cron Kontrol Paneli -->
    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-clock-history me-2"></i>
                    Cron Kontrol Paneli
                </h5>
            </div>
            <div class="card-body">
                <div class="alert alert-info">
                    <i class="bi bi-info-circle me-2"></i>
                    Bu panel, cron işlemlerini manuel olarak test etmenizi sağlar.
                </div>
                
                <form method="POST" action="" class="mb-3">
                    <button type="submit" name="cron_calistir" class="btn btn-primary w-100">
                        <i class="bi bi-play-circle me-2"></i>
                        Otomatik Fatura Oluşturmayı Çalıştır
                    </button>
                </form>
                
                <form method="POST" action="">
                    <button type="submit" name="log_temizle" class="btn btn-danger w-100">
                        <i class="bi bi-trash me-2"></i>
                        Log Kayıtlarını Temizle
                    </button>
                </form>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-info-circle me-2"></i>
                    Bilgi
                </h5>
            </div>
            <div class="card-body">
                <h6>Cron İşlemi Ne Yapar?</h6>
                <ul class="mb-0">
                    <li>Vadesi gelen hosting hesaplarını kontrol eder</li>
                    <li>Süresi dolmak üzere olan domainleri kontrol eder</li>
                    <li>Otomatik fatura oluşturur</li>
                    <li>Faturaları e-posta ile gönderir</li>
                    <li>Online ödeme kaydı oluşturur</li>
                </ul>
            </div>
        </div>
    </div>
    
    <!-- Log Kayıtları -->
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-journal-text me-2"></i>
                    Log Kayıtları
                </h5>
            </div>
            <div class="card-body">
                <?php if (empty($log_icerigi)): ?>
                    <div class="alert alert-info mb-0">
                        <i class="bi bi-info-circle me-2"></i>
                        Henüz log kaydı bulunmamaktadır.
                    </div>
                <?php else: ?>
                    <pre class="mb-0" style="max-height: 500px; overflow-y: auto;"><?php echo htmlspecialchars($log_icerigi); ?></pre>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php ob_end_flush(); ?>