<?php
ob_start(); // Çıktı tamponlamasını başlat
oturumKontrol();

if (!isset($_GET['user']) || !isset($_GET['server'])) {
    header("Location: index.php?sayfa=hosting/liste");
    exit;
}

$username = $_GET['user'];
$server_name = $_GET['server'];

// Sunucu bilgilerini al
$sorgu = $db->prepare("SELECT * FROM sunucular WHERE sunucu_adi = ?");
$sorgu->execute([$server_name]);
$sunucu = $sorgu->fetch(PDO::FETCH_ASSOC);

if (!$sunucu) {
    header("Location: index.php?sayfa=hosting/liste&mesaj=sunucu_bulunamadi");
    exit;
}

$hata = '';
$basarili = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $yeni_sifre = $_POST['yeni_sifre'];
    $sifre_tekrar = $_POST['sifre_tekrar'];
    
    if (empty($yeni_sifre) || empty($sifre_tekrar)) {
        $hata = 'Lütfen tüm alanları doldurun.';
    } elseif ($yeni_sifre !== $sifre_tekrar) {
        $hata = 'Şifreler eşleşmiyor.';
    } elseif (strlen($yeni_sifre) < 8) {
        $hata = 'Şifre en az 8 karakter uzunluğunda olmalıdır.';
    } else {
        // WHM API'yi çağır
        $url = "https://{$sunucu['ip_adresi']}:2087/json-api/passwd";
        
        $header = array(
            "Authorization: WHM {$sunucu['kullanici_adi']}:{$sunucu['token']}"
        );
        
        // API parametrelerini güncelle - 'pass' parametresini ekle
        $params = array(
            'user' => $username,
            'pass' => $yeni_sifre  // 'password' yerine 'pass' kullan
        );
        
        error_log("WHM API Request URL (passwd): " . $url);
        error_log("WHM API Headers (passwd): " . print_r($header, true));
        error_log("WHM API Params (passwd): " . print_r($params, true));
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($params));  // GET metodu kullan
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        
        $response = curl_exec($ch);
        $info = curl_getinfo($ch);
        $error = curl_error($ch);
        
        error_log("WHM API Response (passwd): " . $response);
        error_log("WHM API HTTP Code (passwd): " . $info['http_code']);
        if ($error) {
            error_log("WHM API Error (passwd): " . $error);
        }
        
        curl_close($ch);
        
        if ($error) {
            $hata = 'API Bağlantı Hatası: ' . $error;
        } else {
            $result = json_decode($response, true);
            
            // Başarı durumunu kontrol et
            if ($info['http_code'] == 200 && isset($result['passwd'][0]['status']) && $result['passwd'][0]['status'] == 1) {
                $basarili = 'Şifre başarıyla değiştirildi.';
            } else {
                $error_message = '';
                if (isset($result['passwd'][0]['statusmsg'])) {
                    $error_message = $result['passwd'][0]['statusmsg'];
                } else {
                    $error_message = 'Bilinmeyen hata';
                }
                
                $hata = 'Şifre değiştirilemedi: ' . $error_message;
                error_log("WHM API Error Response: " . print_r($result, true));
            }
        }
    }
}
?>

<!-- Bootstrap Icons CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=hosting/liste">Hosting Hesapları</a></li>
        <li class="breadcrumb-item active" aria-current="page">Şifre Değiştir</li>
    </ol>
</nav>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-key me-2"></i>
            Hosting Hesabı Şifre Değiştir
            <small class="text-muted">(<?php echo htmlspecialchars($username); ?>)</small>
        </h5>
    </div>
    <div class="card-body">
        <?php if ($hata): ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                <?php echo $hata; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($basarili): ?>
            <div class="alert alert-success">
                <i class="bi bi-check-circle-fill me-2"></i>
                <?php echo $basarili; ?>
                <hr>
                <p class="mb-0">
                    <i class="bi bi-key-fill me-2"></i>
                    Yeni şifre: <strong><?php echo htmlspecialchars($yeni_sifre); ?></strong>
                    <br>
                    <small class="text-muted">
                        <i class="bi bi-info-circle me-2"></i>
                        Lütfen bu şifreyi güvenli bir yere kaydedin.
                    </small>
                </p>
            </div>
        <?php endif; ?>
        
        <form method="POST" action="" class="row g-3">
            <div class="col-md-6">
                <label for="yeni_sifre" class="form-label">
                    <i class="bi bi-lock-fill me-2"></i>
                    Yeni Şifre
                </label>
                <div class="input-group">
                    <span class="input-group-text">
                        <i class="bi bi-shield-lock"></i>
                    </span>
                    <input type="password" class="form-control" id="yeni_sifre" name="yeni_sifre" 
                           minlength="8" required>
                    <button class="btn btn-outline-secondary" type="button" id="sifreGoster"
                            data-bs-toggle="tooltip" title="Şifreyi Göster/Gizle">
                        <i class="bi bi-eye-fill"></i>
                    </button>
                    <button class="btn btn-outline-secondary" type="button" id="rastgeleSifre"
                            data-bs-toggle="tooltip" title="Rastgele Şifre Oluştur">
                        <i class="bi bi-shuffle"></i>
                    </button>
                </div>
                <small class="text-muted">
                    <i class="bi bi-info-circle me-1"></i>
                    En az 8 karakter uzunluğunda olmalıdır.
                </small>
            </div>
            
            <div class="col-md-6">
                <label for="sifre_tekrar" class="form-label">
                    <i class="bi bi-lock-fill me-2"></i>
                    Şifre Tekrar
                </label>
                <div class="input-group">
                    <span class="input-group-text">
                        <i class="bi bi-shield-lock"></i>
                    </span>
                    <input type="password" class="form-control" id="sifre_tekrar" name="sifre_tekrar" 
                           minlength="8" required>
                    <button class="btn btn-outline-secondary" type="button" id="sifreTekrarGoster"
                            data-bs-toggle="tooltip" title="Şifreyi Göster/Gizle">
                        <i class="bi bi-eye-fill"></i>
                    </button>
                </div>
            </div>
            
            <div class="col-12">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-lg me-2"></i>
                    Şifreyi Değiştir
                </button>
                <a href="index.php?sayfa=hosting/liste" class="btn btn-secondary">
                    <i class="bi bi-x-lg me-2"></i>
                    İptal
                </a>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tooltips'i aktifleştir
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
    
    // Şifre göster/gizle fonksiyonu
    function sifreGosterGizle(input, button) {
        const tip = input.type === 'password' ? 'text' : 'password';
        input.type = tip;
        const icon = button.querySelector('i');
        icon.className = tip === 'password' ? 'bi bi-eye-fill' : 'bi bi-eye-slash-fill';
        
        // Tooltip metnini güncelle
        const tooltip = bootstrap.Tooltip.getInstance(button);
        if (tooltip) {
            tooltip.setContent({ '.tooltip-inner': tip === 'password' ? 'Şifreyi Göster' : 'Şifreyi Gizle' });
        }
    }
    
    // Yeni şifre için göster/gizle
    const yeniSifreInput = document.getElementById('yeni_sifre');
    const sifreGoster = document.getElementById('sifreGoster');
    sifreGoster.addEventListener('click', () => sifreGosterGizle(yeniSifreInput, sifreGoster));
    
    // Şifre tekrar için göster/gizle
    const sifreTekrarInput = document.getElementById('sifre_tekrar');
    const sifreTekrarGoster = document.getElementById('sifreTekrarGoster');
    sifreTekrarGoster.addEventListener('click', () => sifreGosterGizle(sifreTekrarInput, sifreTekrarGoster));
    
    // Rastgele şifre oluştur
    const rastgeleSifre = document.getElementById('rastgeleSifre');
    rastgeleSifre.addEventListener('click', function() {
        const karakterler = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*';
        let sifre = '';
        for (let i = 0; i < 12; i++) {
            sifre += karakterler.charAt(Math.floor(Math.random() * karakterler.length));
        }
        
        // Her iki şifre alanını da güncelle ve göster
        yeniSifreInput.type = 'text';
        sifreTekrarInput.type = 'text';
        yeniSifreInput.value = sifre;
        sifreTekrarInput.value = sifre;
        
        // Göster/gizle butonlarını güncelle
        sifreGoster.querySelector('i').className = 'bi bi-eye-slash-fill';
        sifreTekrarGoster.querySelector('i').className = 'bi bi-eye-slash-fill';
        
        // Tooltipleri güncelle
        const sifreGosterTooltip = bootstrap.Tooltip.getInstance(sifreGoster);
        const sifreTekrarGosterTooltip = bootstrap.Tooltip.getInstance(sifreTekrarGoster);
        if (sifreGosterTooltip) sifreGosterTooltip.setContent({ '.tooltip-inner': 'Şifreyi Gizle' });
        if (sifreTekrarGosterTooltip) sifreTekrarGosterTooltip.setContent({ '.tooltip-inner': 'Şifreyi Gizle' });
    });
});
</script>
<?php
ob_end_flush(); // Çıktı tamponlamasını sonlandır
?>