<?php

// Security function

function guvenlik($data) {

    $data = trim($data);

    $data = stripslashes($data);

    $data = htmlspecialchars($data);

    return $data;

}



// Check if user is logged in

function musteriGirisKontrol() {

    if (!isset($_SESSION['musteri_id'])) {

        header("Location: giris.php");

        exit;

    }

}



// Format file size

function formatBoyut($bytes) {

    if ($bytes >= 1073741824) {

        return number_format($bytes / 1073741824, 2) . ' GB';

    } elseif ($bytes >= 1048576) {

        return number_format($bytes / 1048576, 2) . ' MB';

    } elseif ($bytes >= 1024) {

        return number_format($bytes / 1024, 2) . ' KB';

    }

    return $bytes . ' B';

}



// Generate random password

function randomSifre($length = 12) {

    $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*';

    $password = '';

    for ($i = 0; $i < $length; $i++) {

        $password .= $chars[rand(0, strlen($chars) - 1)];

    }

    return $password;

}



// Generate activation code

function aktivasyonKoduOlustur() {

    return bin2hex(random_bytes(32));

}

?>