<?php
ob_start(); // Çıktı tamponlamasını başlat
oturumKontrol();

if (!isset($_GET['user']) || !isset($_GET['server'])) {
    header("Location: index.php?sayfa=hosting/liste");
    exit;
}

$username = $_GET['user'];
$server_name = $_GET['server'];

// Sunucu bilgilerini al
$sorgu = $db->prepare("SELECT * FROM sunucular WHERE sunucu_adi = ?");
$sorgu->execute([$server_name]);
$sunucu = $sorgu->fetch(PDO::FETCH_ASSOC);

if (!$sunucu) {
    header("Location: index.php?sayfa=hosting/liste&mesaj=sunucu_bulunamadi");
    exit;
}

// E-posta hesaplarını çek
function getEpostaHesaplari($sunucu, $username) {
    $url = "https://{$sunucu['ip_adresi']}:2087/json-api/cpanel";
    
    $header = array(
        "Authorization: WHM {$sunucu['kullanici_adi']}:{$sunucu['token']}"
    );
    
    $params = array(
        'cpanel_jsonapi_version' => 2,
        'cpanel_jsonapi_module' => 'Email',
        'cpanel_jsonapi_func' => 'listpops',
        'user' => $username
    );
    
    error_log("WHM API Request URL (listpops): " . $url . "?" . http_build_query($params));
    error_log("WHM API Headers (listpops): " . print_r($header, true));
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($params));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    
    $response = curl_exec($ch);
    $info = curl_getinfo($ch);
    $error = curl_error($ch);
    
    error_log("WHM API Response (listpops): " . $response);
    error_log("WHM API HTTP Code (listpops): " . $info['http_code']);
    if ($error) {
        error_log("WHM API Error (listpops): " . $error);
    }
    
    curl_close($ch);
    
    $result = json_decode($response, true);
    
    // API yanıtını kontrol et ve gerekli alanları varsayılan değerlerle doldur
    if (isset($result['cpanelresult']['data']) && is_array($result['cpanelresult']['data'])) {
        foreach ($result['cpanelresult']['data'] as &$account) {
            // Eksik alanlar için varsayılan değerler ata
            $account['diskquota'] = isset($account['diskquota']) ? $account['diskquota'] : 0;
            $account['diskused'] = isset($account['diskused']) ? $account['diskused'] : 0;
            $account['email'] = isset($account['email']) ? $account['email'] : '';
        }
    }
    
    return $result;
}

// Hesap bilgilerini çek (domain için)
function getHesapBilgileri($sunucu, $username) {
    $url = "https://{$sunucu['ip_adresi']}:2087/json-api/accountsummary";
    
    $header = array(
        "Authorization: WHM {$sunucu['kullanici_adi']}:{$sunucu['token']}"
    );
    
    $params = array(
        'user' => $username
    );
    
    error_log("WHM API Request URL (accountsummary): " . $url . "?" . http_build_query($params));
    error_log("WHM API Headers (accountsummary): " . print_r($header, true));
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($params));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    
    $response = curl_exec($ch);
    $info = curl_getinfo($ch);
    $error = curl_error($ch);
    
    error_log("WHM API Response (accountsummary): " . $response);
    error_log("WHM API HTTP Code (accountsummary): " . $info['http_code']);
    if ($error) {
        error_log("WHM API Error (accountsummary): " . $error);
    }
    
    curl_close($ch);
    
    return json_decode($response, true);
}

$hesapBilgileri = getHesapBilgileri($sunucu, $username);
$domain = isset($hesapBilgileri['acct'][0]['domain']) ? $hesapBilgileri['acct'][0]['domain'] : '';

$epostaHesaplari = getEpostaHesaplari($sunucu, $username);

// E-posta hesabı silme işlemi
if (isset($_POST['sil']) && isset($_POST['email'])) {
    $email = $_POST['email'];
    
    $url = "https://{$sunucu['ip_adresi']}:2087/json-api/cpanel";
    
    $header = array(
        "Authorization: WHM {$sunucu['kullanici_adi']}:{$sunucu['token']}"
    );
    
    $params = array(
        'cpanel_jsonapi_version' => 2,
        'cpanel_jsonapi_module' => 'Email',
        'cpanel_jsonapi_func' => 'delpop',
        'user' => $username,
        'domain' => $domain,
        'email' => $email
    );
    
    error_log("WHM API Request URL (delpop): " . $url . "?" . http_build_query($params));
    error_log("WHM API Headers (delpop): " . print_r($header, true));
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($params));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    
    $response = curl_exec($ch);
    $info = curl_getinfo($ch);
    $error = curl_error($ch);
    
    error_log("WHM API Response (delpop): " . $response);
    error_log("WHM API HTTP Code (delpop): " . $info['http_code']);
    if ($error) {
        error_log("WHM API Error (delpop): " . $error);
    }
    
    curl_close($ch);
    
    // Sayfayı yenile
    header("Location: index.php?sayfa=hosting/eposta_listesi&user=" . urlencode($username) . "&server=" . urlencode($server_name) . "&mesaj=silindi");
    exit;
}

// E-posta şifre değiştirme işlemi
if (isset($_POST['sifre_degistir']) && isset($_POST['email']) && isset($_POST['yeni_sifre'])) {
    $email = $_POST['email'];
    $yeni_sifre = $_POST['yeni_sifre'];
    
    $url = "https://{$sunucu['ip_adresi']}:2087/json-api/cpanel";
    
    $header = array(
        "Authorization: WHM {$sunucu['kullanici_adi']}:{$sunucu['token']}"
    );
    
    $params = array(
        'cpanel_jsonapi_version' => 2,
        'cpanel_jsonapi_module' => 'Email',
        'cpanel_jsonapi_func' => 'passwdpop',
        'user' => $username,
        'domain' => $domain,
        'email' => $email,
        'password' => $yeni_sifre
    );
    
    error_log("WHM API Request URL (passwdpop): " . $url . "?" . http_build_query($params));
    error_log("WHM API Headers (passwdpop): " . print_r($header, true));
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($params));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    
    $response = curl_exec($ch);
    $info = curl_getinfo($ch);
    $error = curl_error($ch);
    
    error_log("WHM API Response (passwdpop): " . $response);
    error_log("WHM API HTTP Code (passwdpop): " . $info['http_code']);
    if ($error) {
        error_log("WHM API Error (passwdpop): " . $error);
    }
    
    curl_close($ch);
    
    // Sayfayı yenile
    header("Location: index.php?sayfa=hosting/eposta_listesi&user=" . urlencode($username) . "&server=" . urlencode($server_name) . "&mesaj=sifre_degistirildi");
    exit;
}

$mesaj = isset($_GET['mesaj']) ? $_GET['mesaj'] : '';
?>

<!-- Bootstrap ve DataTables CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=hosting/liste">Hosting Hesapları</a></li>
        <li class="breadcrumb-item active" aria-current="page">E-Posta Hesapları</li>
    </ol>
</nav>

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0">
            <i class="bi bi-envelope me-2"></i>
            E-Posta Hesapları
            <small class="text-muted">(<?php echo htmlspecialchars($username); ?>)</small>
        </h5>
        <a href="index.php?sayfa=hosting/eposta_ekle&user=<?php echo urlencode($username); ?>&server=<?php echo urlencode($server_name); ?>" 
           class="btn btn-primary btn-sm">
            <i class="bi bi-envelope-plus me-2"></i>
            Yeni E-Posta Hesabı
        </a>
    </div>
    <div class="card-body">
        <?php if ($mesaj == 'silindi'): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <i class="bi bi-check-circle-fill me-2"></i>
                E-posta hesabı başarıyla silindi.
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php elseif ($mesaj == 'sifre_degistirildi'): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <i class="bi bi-check-circle-fill me-2"></i>
                E-posta şifresi başarıyla değiştirildi.
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        
        <table id="epostaTable" class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th>E-Posta Adresi</th>
                    <th>Kota</th>
                    <th>Kullanılan Alan</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                if (isset($epostaHesaplari['cpanelresult']['data']) && !empty($epostaHesaplari['cpanelresult']['data'])) {
                    foreach ($epostaHesaplari['cpanelresult']['data'] as $hesap) {
                        // E-posta adresini doğru şekilde oluştur
                        // Eğer e-posta zaten @ içeriyorsa domain ekleme
                        $email = strpos($hesap['email'], '@') !== false ? 
                                $hesap['email'] : 
                                $hesap['email'] . '@' . $domain;
                        
                        $kota = isset($hesap['diskquota']) ? ($hesap['diskquota'] == 0 ? 'Sınırsız' : $hesap['diskquota'] . ' MB') : 'Belirlenmemiş';
                        $kullanilan = isset($hesap['diskused']) ? round($hesap['diskused'], 2) . ' MB' : '0 MB';
                ?>
                <tr>
                    <td><?php echo htmlspecialchars($email); ?></td>
                    <td><?php echo $kota; ?></td>
                    <td><?php echo $kullanilan; ?></td>
                    <td>
                        <div class="btn-group">
                            <button type="button" class="btn btn-warning btn-sm" 
                                    onclick="sifreDegistirModal('<?php echo htmlspecialchars($hesap['email']); ?>')"
                                    data-bs-toggle="tooltip" title="Şifre Değiştir">
                                <i class="bi bi-key me-1"></i> Şifre Değiştir
                            </button>
                            <button type="button" class="btn btn-danger btn-sm ms-1" 
                                    onclick="epostaSil('<?php echo htmlspecialchars($hesap['email']); ?>')"
                                    data-bs-toggle="tooltip" title="Hesabı Sil">
                                <i class="bi bi-trash me-1"></i> Sil
                            </button>
                        </div>
                    </td>
                </tr>
                <?php 
                    }
                }
                ?>
            </tbody>
        </table>
        
        <!-- Silme Formu -->
        <form id="silForm" method="POST" style="display: none;">
            <input type="hidden" name="sil" value="1">
            <input type="hidden" name="email" id="silEmail">
        </form>
        
        <!-- Şifre Değiştirme Modal -->
        <div class="modal fade" id="sifreDegistirModal" tabindex="-1" aria-labelledby="sifreDegistirModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="sifreDegistirModalLabel">
                            <i class="bi bi-key me-2"></i>
                            E-Posta Şifresini Değiştir
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
                    </div>
                    <form method="POST" id="sifreDegistirForm">
                        <div class="modal-body">
                            <input type="hidden" name="sifre_degistir" value="1">
                            <input type="hidden" name="email" id="sifreEmail">
                            
                            <div class="mb-3">
                                <label for="yeni_sifre" class="form-label">
                                    <i class="bi bi-lock-fill me-2"></i>
                                    Yeni Şifre
                                </label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i class="bi bi-shield-lock"></i>
                                    </span>
                                    <input type="password" class="form-control" id="yeni_sifre" name="yeni_sifre" 
                                           minlength="8" required>
                                    <button class="btn btn-outline-secondary" type="button" id="sifreGoster"
                                            data-bs-toggle="tooltip" title="Şifreyi Göster/Gizle">
                                        <i class="bi bi-eye-fill"></i>
                                    </button>
                                    <button class="btn btn-outline-secondary" type="button" id="rastgeleSifre"
                                            data-bs-toggle="tooltip" title="Rastgele Şifre Oluştur">
                                        <i class="bi bi-shuffle"></i>
                                    </button>
                                </div>
                                <small class="text-muted">
                                    <i class="bi bi-info-circle me-1"></i>
                                    En az 8 karakter uzunluğunda olmalıdır.
                                </small>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                <i class="bi bi-x-lg me-2"></i>
                                İptal
                            </button>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check-lg me-2"></i>
                                Şifreyi Değiştir
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Gerekli JavaScript dosyaları -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // DataTables
    $('#epostaTable').DataTable({
        language: {
            "emptyTable": "Tabloda herhangi bir veri mevcut değil",
            "info": "_TOTAL_ kayıttan _START_ - _END_ arasındaki kayıtlar gösteriliyor",
            "infoEmpty": "Kayıt yok",
            "infoFiltered": "(_MAX_ kayıt içerisinden bulunan)",
            "infoThousands": ".",
            "lengthMenu": "Sayfada _MENU_ kayıt göster",
            "loadingRecords": "Yükleniyor...",
            "processing": "İşleniyor...",
            "search": "Ara:",
            "zeroRecords": "Eşleşen kayıt bulunamadı",
            "paginate": {
                "first": "İlk",
                "last": "Son",
                "next": "Sonraki",
                "previous": "Önceki"
            },
            "aria": {
                "sortAscending": ": artan sütun sıralamasını aktifleştir",
                "sortDescending": ": azalan sütun sıralamasını aktifleştir"
            },
            "select": {
                "rows": {
                    "_": "%d kayıt seçildi",
                    "1": "1 kayıt seçildi"
                }
            }
        },
        pageLength: 10,
        order: [[0, 'asc']]
    });
    
    // Tooltips'i aktifleştir
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
    
    // Şifre göster/gizle ve rastgele şifre oluşturma
    const sifreInput = document.getElementById('yeni_sifre');
    const sifreGoster = document.getElementById('sifreGoster');
    const rastgeleSifre = document.getElementById('rastgeleSifre');
    
    if (sifreGoster) {
        sifreGoster.addEventListener('click', function() {
            const tip = sifreInput.type === 'password' ? 'text' : 'password';
            sifreInput.type = tip;
            const icon = this.querySelector('i');
            icon.className = tip === 'password' ? 'bi bi-eye-fill' : 'bi bi-eye-slash-fill';
        });
    }
    
    if (rastgeleSifre) {
        rastgeleSifre.addEventListener('click', function() {
            const karakterler = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*';
            let sifre = '';
            for (let i = 0; i < 12; i++) {
                sifre += karakterler.charAt(Math.floor(Math.random() * karakterler.length));
            }
            sifreInput.type = 'text';
            sifreInput.value = sifre;
            sifreGoster.querySelector('i').className = 'bi bi-eye-slash-fill';
        });
    }
});

// Şifre değiştirme modalını aç
function sifreDegistirModal(email) {
    const sifreEmail = document.getElementById('sifreEmail');
    const modal = new bootstrap.Modal(document.getElementById('sifreDegistirModal'));
    
    if (sifreEmail) {
        sifreEmail.value = email;
        modal.show();
    }
}

// E-posta hesabını sil
function epostaSil(email) {
    if (confirm(email + ' e-posta hesabını silmek istediğinizden emin misiniz?')) {
        const silEmail = document.getElementById('silEmail');
        const silForm = document.getElementById('silForm');
        
        if (silEmail && silForm) {
            silEmail.value = email;
            silForm.submit();
        }
    }
}
</script>
<?php
ob_end_flush(); // Çıktı tamponlamasını sonlandır
?>