<?php
ob_start();
oturumKontrol();

// UUID oluşturma fonksiyonu
function generateUUID() {
    return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        mt_rand(0, 0xffff), mt_rand(0, 0xffff),
        mt_rand(0, 0xffff),
        mt_rand(0, 0x0fff) | 0x4000,
        mt_rand(0, 0x3fff) | 0x8000,
        mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
    );
}

// Müşteri listesini getir
$sorgu = $db->query("SELECT * FROM musteriler ORDER BY ad, soyad");
$musteriler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Domain listesini getir
$sorgu = $db->query("SELECT d.*, m.ad, m.soyad FROM domain_kayitlar d 
                     LEFT JOIN musteriler m ON d.musteri_id = m.id 
                     WHERE d.durum = 'Aktif'
                     ORDER BY d.domain");
$domainler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Hosting listesini getir
$sorgu = $db->query("SELECT h.*, m.ad, m.soyad, s.sunucu_adi 
                     FROM hosting_hesaplari h 
                     LEFT JOIN musteriler m ON h.musteri_id = m.id 
                     LEFT JOIN sunucular s ON h.sunucu_id = s.id
                     WHERE h.durum = 'Aktif'
                     ORDER BY h.domain");
$hostingler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Form gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $hata = '';
    
    try {
        // Form verilerini al
        $musteri_id = (int)$_POST['musteri_id'];
        $fatura_tarihi = $_POST['fatura_tarihi'];
        $son_odeme_tarihi = $_POST['son_odeme_tarihi'];
        
        // Fatura numarası oluştur (YIL-XXXX formatında)
        $yil = date('Y');
        
        // Sayacı kontrol et veya oluştur
        $sayac_sorgu = $db->prepare("INSERT INTO fatura_sayac (yil, son_numara) 
                                    VALUES (?, 0) 
                                    ON DUPLICATE KEY UPDATE son_numara = son_numara + 1");
        $sayac_sorgu->execute([$yil]);
        
        // Son numarayı al
        $sorgu = $db->prepare("SELECT son_numara FROM fatura_sayac WHERE yil = ?");
        $sorgu->execute([$yil]);
        $son_numara = $sorgu->fetchColumn();
        
        // Fatura numarasını formatla
        $fatura_no = sprintf("%s-%04d", $yil, $son_numara);
        
        // Fatura başlığını ekle
        $db->beginTransaction();
        
        $fatura_id = generateUUID();
        
        $sorgu = $db->prepare("INSERT INTO faturalar 
            (id, musteri_id, fatura_no, fatura_tarihi, son_odeme_tarihi) 
            VALUES (?, ?, ?, ?, ?)");
        
        $sorgu->execute([
            $fatura_id,
            $musteri_id,
            $fatura_no,
            $fatura_tarihi,
            $son_odeme_tarihi
        ]);
        
        // Fatura kalemlerini ekle
        $ara_toplam = 0;
        
        foreach ($_POST['kalemler'] as $kalem) {
            $kalem_id = generateUUID();
            $hizmet_turu = $kalem['hizmet_turu'];
            $hizmet_id = !empty($kalem['hizmet_id']) ? $kalem['hizmet_id'] : null;
            $aciklama = $kalem['aciklama'];
            $birim = $kalem['birim'];
            $miktar = (float)$kalem['miktar'];
            $birim_fiyat = (float)$kalem['birim_fiyat'];
            $toplam = $miktar * $birim_fiyat;
            
            $sorgu = $db->prepare("INSERT INTO fatura_kalemleri 
                (id, fatura_id, hizmet_id, hizmet_turu, aciklama, birim, miktar, birim_fiyat, toplam) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            
            $sorgu->execute([
                $kalem_id,
                $fatura_id,
                $hizmet_id,
                $hizmet_turu,
                $aciklama,
                $birim,
                $miktar,
                $birim_fiyat,
                $toplam
            ]);
            
            $ara_toplam += $toplam;
        }
        
        // KDV hesapla ve faturayı güncelle
        $kdv_oran = 20.00; // %20 KDV
        $kdv_tutar = $ara_toplam * ($kdv_oran / 100);
        $genel_toplam = $ara_toplam + $kdv_tutar;
        
        $sorgu = $db->prepare("UPDATE faturalar SET 
            ara_toplam = ?, 
            kdv_oran = ?, 
            kdv_tutar = ?, 
            genel_toplam = ? 
            WHERE id = ?");
        
        $sorgu->execute([
            $ara_toplam,
            $kdv_oran,
            $kdv_tutar,
            $genel_toplam,
            $fatura_id
        ]);
        
        $db->commit();
        
        // Yeni fatura oluşturulduğunda otomatik gönderim sayfasına yönlendir
        header("Location: index.php?sayfa=fatura/gonder&id=" . $fatura_id . "&yeni=1");
        exit;
        
    } catch (PDOException $e) {
        $db->rollBack();
        $hata = 'Fatura oluşturulurken bir hata oluştu: ' . $e->getMessage();
    }
}
?>

<!-- Flatpickr CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/themes/material_blue.css">

<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=fatura/liste">Faturalar</a></li>
        <li class="breadcrumb-item active">Yeni Fatura</li>
    </ol>
</nav>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-receipt me-2"></i>
            Yeni Fatura Oluştur
        </h5>
    </div>
    <div class="card-body">
        <?php if (isset($hata) && $hata): ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                <?php echo $hata; ?>
            </div>
        <?php endif; ?>
        
        <form method="POST" action="" id="faturaForm">
            <!-- Fatura Başlık Bilgileri -->
            <div class="row g-3 mb-4">
                <div class="col-md-4">
                    <label for="musteri_id" class="form-label">Müşteri *</label>
                    <select class="form-select select2" id="musteri_id" name="musteri_id" required>
                        <option value="">Müşteri Seçin</option>
                        <?php foreach ($musteriler as $musteri): ?>
                        <option value="<?php echo $musteri['id']; ?>">
                            <?php echo htmlspecialchars($musteri['ad'] . ' ' . $musteri['soyad']); ?>
                            (<?php echo $musteri['musteri_turu']; ?>)
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="col-md-4">
                    <label for="fatura_tarihi" class="form-label">Fatura Tarihi *</label>
                    <input type="text" class="form-control flatpickr" id="fatura_tarihi" name="fatura_tarihi" 
                           value="<?php echo date('Y-m-d'); ?>" required>
                </div>
                
                <div class="col-md-4">
                    <label for="son_odeme_tarihi" class="form-label">Son Ödeme Tarihi *</label>
                    <input type="text" class="form-control flatpickr" id="son_odeme_tarihi" name="son_odeme_tarihi" 
                           value="<?php echo date('Y-m-d', strtotime('+7 days')); ?>" required>
                </div>
            </div>
            
            <!-- Fatura Kalemleri -->
            <div class="table-responsive mb-4">
                <table class="table table-bordered" id="kalemlerTable">
                    <thead>
                        <tr>
                            <th style="width: 15%;">Hizmet Türü</th>
                            <th style="width: 20%;">Hizmet</th>
                            <th>Açıklama</th>
                            <th style="width: 10%;">Birim</th>
                            <th style="width: 10%;">Miktar</th>
                            <th style="width: 15%;">Birim Fiyat</th>
                            <th style="width: 15%;">Toplam</th>
                            <th style="width: 5%;"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>
                                <select class="form-select hizmet-turu" name="kalemler[0][hizmet_turu]" required>
                                    <option value="">Seçin</option>
                                    <option value="Domain">Domain</option>
                                    <option value="Hosting">Hosting</option>
                                    <option value="Manuel">Manuel</option>
                                </select>
                            </td>
                            <td>
                                <select class="form-select hizmet-select" name="kalemler[0][hizmet_id]" disabled>
                                    <option value="">Önce Tür Seçin</option>
                                </select>
                            </td>
                            <td>
                                <input type="text" class="form-control aciklama" name="kalemler[0][aciklama]" required>
                            </td>
                            <td>
                                <input type="text" class="form-control birim" name="kalemler[0][birim]" value="Yıl" required>
                            </td>
                            <td>
                                <input type="number" class="form-control miktar" name="kalemler[0][miktar]" 
                                       value="1" min="1" step="1" required>
                            </td>
                            <td>
                                <div class="input-group">
                                    <input type="number" class="form-control birim-fiyat" name="kalemler[0][birim_fiyat]" 
                                           value="0.00" min="0" step="0.01" required>
                                    <span class="input-group-text">₺</span>
                                </div>
                            </td>
                            <td>
                                <div class="input-group">
                                    <input type="text" class="form-control toplam" value="0.00" readonly>
                                    <span class="input-group-text">₺</span>
                                </div>
                            </td>
                            <td class="text-center">
                                <button type="button" class="btn btn-danger btn-sm kalem-sil">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </td>
                        </tr>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="8">
                                <button type="button" class="btn btn-success btn-sm" id="kalemEkle">
                                    <i class="bi bi-plus-circle me-2"></i>
                                    Yeni Kalem Ekle
                                </button>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6" class="text-end"><strong>Ara Toplam:</strong></td>
                            <td colspan="2">
                                <div class="input-group">
                                    <input type="text" class="form-control" id="araToplam" value="0.00" readonly>
                                    <span class="input-group-text">₺</span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6" class="text-end"><strong>KDV (%20):</strong></td>
                            <td colspan="2">
                                <div class="input-group">
                                    <input type="text" class="form-control" id="kdvTutar" value="0.00" readonly>
                                    <span class="input-group-text">₺</span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6" class="text-end"><strong>Genel Toplam:</strong></td>
                            <td colspan="2">
                                <div class="input-group">
                                    <input type="text" class="form-control" id="genelToplam" value="0.00" readonly>
                                    <span class="input-group-text">₺</span>
                                </div>
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            
            <div class="row">
                <div class="col-12">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>
                        Faturayı Oluştur
                    </button>
                    <a href="index.php?sayfa=fatura/liste" class="btn btn-secondary">
                        <i class="bi bi-x-circle me-2"></i>
                        İptal
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- jQuery, Flatpickr ve Select2 JS -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/tr.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
// Domain ve Hosting listelerini JavaScript değişkenlerine aktar
const domainler = <?php echo json_encode($domainler); ?>;
const hostingler = <?php echo json_encode($hostingler); ?>;

$(document).ready(function() {
    // Select2 başlat
    $('.select2').select2({
        theme: 'bootstrap-5',
        width: '100%'
    });
    
    // Flatpickr başlat
    flatpickr(".flatpickr", {
        locale: "tr",
        dateFormat: "Y-m-d",
        allowInput: true
    });
    
    // Yeni kalem ekleme
    let kalemSayisi = 0;
    
    $('#kalemEkle').click(function() {
        kalemSayisi++;
        const yeniSatir = $('#kalemlerTable tbody tr:first').clone();
        
        // Form elemanlarının name ve id'lerini güncelle
        yeniSatir.find('select, input').each(function() {
            const name = $(this).attr('name');
            if (name) {
                $(this).attr('name', name.replace('[0]', '[' + kalemSayisi + ']'));
            }
        });
        
        // Değerleri sıfırla
        yeniSatir.find('select').val('');
        yeniSatir.find('input[type="text"]').val('');
        yeniSatir.find('input[type="number"]').val('0');
        yeniSatir.find('.toplam').val('0.00');
        
        // Hizmet seçimini devre dışı bırak
        yeniSatir.find('.hizmet-select').prop('disabled', true);
        
        $('#kalemlerTable tbody').append(yeniSatir);
        
        // Select2'yi yeni satırda başlat
        yeniSatir.find('select').select2({
            theme: 'bootstrap-5',
            width: '100%'
        });
    });
    
    // Kalem silme
    $(document).on('click', '.kalem-sil', function() {
        const satirSayisi = $('#kalemlerTable tbody tr').length;
        if (satirSayisi > 1) {
            $(this).closest('tr').remove();
            toplamHesapla();
        }
    });
    
    // Hizmet türü değiştiğinde
    $(document).on('change', '.hizmet-turu', function() {
        const hizmetSelect = $(this).closest('tr').find('.hizmet-select');
        const aciklamaInput = $(this).closest('tr').find('.aciklama');
        const birimFiyatInput = $(this).closest('tr').find('.birim-fiyat');
        const seciliMusteri = $('#musteri_id').val(); // Seçili müşteri ID'sini al
        
        hizmetSelect.empty().prop('disabled', true);
        aciklamaInput.val('');
        birimFiyatInput.val('0.00');
        
        // Eğer müşteri seçili değilse uyarı ver
        if (!seciliMusteri) {
            alert('Lütfen önce müşteri seçiniz!');
            $(this).val(''); // Hizmet türü seçimini temizle
            return;
        }
        
        if (this.value === 'Domain') {
            // Sadece seçili müşteriye ait domainleri filtrele
            const musteriDomainleri = domainler.filter(d => d.musteri_id == seciliMusteri);
            
            if (musteriDomainleri.length === 0) {
                alert('Seçili müşteriye ait domain kaydı bulunamadı!');
                $(this).val('');
                return;
            }
            
            hizmetSelect.prop('disabled', false)
                .append('<option value="">Domain Seçin</option>');
                
            musteriDomainleri.forEach(function(domain) {
                hizmetSelect.append(`<option value="${domain.id}">${domain.domain}</option>`);
            });
            
        } else if (this.value === 'Hosting') {
            // Sadece seçili müşteriye ait hostingleri filtrele
            const musteriHostingleri = hostingler.filter(h => h.musteri_id == seciliMusteri);
            
            if (musteriHostingleri.length === 0) {
                alert('Seçili müşteriye ait hosting kaydı bulunamadı!');
                $(this).val('');
                return;
            }
            
            hizmetSelect.prop('disabled', false)
                .append('<option value="">Hosting Seçin</option>');
                
            musteriHostingleri.forEach(function(hosting) {
                hizmetSelect.append(`<option value="${hosting.id}">${hosting.domain} - ${hosting.paket}</option>`);
            });
            
        } else if (this.value === 'Manuel') {
            aciklamaInput.prop('readonly', false);
        }
    });
    
    // Müşteri değiştiğinde tüm hizmet seçimlerini sıfırla
    $('#musteri_id').on('change', function() {
        $('#kalemlerTable tbody tr').each(function() {
            $(this).find('.hizmet-turu').val('');
            $(this).find('.hizmet-select').empty().prop('disabled', true);
            $(this).find('.aciklama').val('').prop('readonly', true);
            $(this).find('.birim-fiyat').val('0.00');
            $(this).find('.miktar').val('1');
            $(this).find('.toplam').val('0.00');
        });
        toplamHesapla();
    });
    
    // Hizmet seçildiğinde
    $(document).on('change', '.hizmet-select', function() {
        const tr = $(this).closest('tr');
        const hizmetTuru = tr.find('.hizmet-turu').val();
        const aciklamaInput = tr.find('.aciklama');
        const birimFiyatInput = tr.find('.birim-fiyat');
        
        if (this.value) {
            if (hizmetTuru === 'Domain') {
                const domain = domainler.find(d => d.id == this.value);
                if (domain) {
                    aciklamaInput.val(`${domain.domain} Domain Yenileme`);
                }
            } else if (hizmetTuru === 'Hosting') {
                const hosting = hostingler.find(h => h.id == this.value);
                if (hosting) {
                    aciklamaInput.val(`${hosting.domain} Hosting Yenileme`);
                }
            }
        }
    });
    
    // Miktar veya birim fiyat değiştiğinde
    $(document).on('input', '.miktar, .birim-fiyat', function() {
        const tr = $(this).closest('tr');
        const miktar = parseFloat(tr.find('.miktar').val()) || 0;
        const birimFiyat = parseFloat(tr.find('.birim-fiyat').val()) || 0;
        const toplam = miktar * birimFiyat;
        
        tr.find('.toplam').val(toplam.toFixed(2));
        toplamHesapla();
    });
    
    // Toplam hesaplama fonksiyonu
    function toplamHesapla() {
        let araToplam = 0;
        
        $('.toplam').each(function() {
            araToplam += parseFloat($(this).val()) || 0;
        });
        
        const kdvTutar = araToplam * 0.20;
        const genelToplam = araToplam + kdvTutar;
        
        $('#araToplam').val(araToplam.toFixed(2));
        $('#kdvTutar').val(kdvTutar.toFixed(2));
        $('#genelToplam').val(genelToplam.toFixed(2));
    }
    
    // Form gönderilmeden önce kontrol
    $('#faturaForm').on('submit', function(e) {
        let hata = false;
        
        // En az bir kalem olmalı
        if ($('#kalemlerTable tbody tr').length < 1) {
            alert('En az bir fatura kalemi eklemelisiniz.');
            hata = true;
        }
        
        // Genel toplam 0 olamaz
        if (parseFloat($('#genelToplam').val()) <= 0) {
            alert('Fatura tutarı 0₺ olamaz.');
            hata = true;
        }
        
        if (hata) {
            e.preventDefault();
        }
    });
});
</script>

<?php ob_end_flush(); ?>