<?php
ob_start();
oturumKontrol();

require_once 'DomainNameAPI_PHPLibrary.php';

// API bağlantısı için ayarları al
$sorgu = $db->query("SELECT * FROM api_ayarlar WHERE servis = 'domainnameapi' LIMIT 1");
$api_ayarlar = $sorgu->fetch(PDO::FETCH_ASSOC);

if (!$api_ayarlar) {
    die("DomainNameAPI ayarları bulunamadı!");
}

if (!isset($_GET['domain'])) {
    header("Location: index.php?sayfa=domain/liste");
    exit;
}

$domain = $_GET['domain'];
$hata = '';
$basarili = '';
$mevcut_nameserverlar = [];

try {
    $api = new DomainNameApi\DomainNameAPI_PHPLibrary(
        $api_ayarlar['username'],
        $api_ayarlar['password']
    );

    // Mevcut nameserver'ları getir
    $response = $api->GetDetails($domain); // GetDomainInfo yerine GetDetails kullanılıyor
    
    if ($response['result'] == 'OK') {
        if (isset($response['data']['NameServers']) && is_array($response['data']['NameServers'])) {
            $mevcut_nameserverlar = $response['data']['NameServers'];
        }
    } else {
        $hata = "Domain bilgileri alınamadı: " . $response['error']['Message'];
    }
    
    // Nameserver güncelleme işlemi
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $nameservers = array_filter($_POST['nameservers']); // Boş olanları temizle
        
        if (empty($nameservers)) {
            $hata = "En az bir nameserver girmelisiniz.";
        } else {
            $response = $api->ModifyNameServer($domain, $nameservers); // ModifyNameServer kullanılıyor
            
            if ($response['result'] == 'OK') {
                $basarili = "Nameserver ayarları başarıyla güncellendi.";
                $mevcut_nameserverlar = $nameservers; // Listeyi güncelle
            } else {
                $hata = "Nameserver ayarları güncellenirken hata oluştu: " . $response['error']['Message'];
            }
        }
    }
    
} catch (Exception $e) {
    $hata = "API Hatası: " . $e->getMessage();
}

?>

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=domain/liste">Domain Listesi</a></li>
        <li class="breadcrumb-item active" aria-current="page">Nameserver Ayarları</li>
    </ol>
</nav>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-hdd-network me-2"></i>
            Nameserver Ayarları
            <small class="text-muted">(<?php echo htmlspecialchars($domain); ?>)</small>
        </h5>
    </div>
    <div class="card-body">
        <?php if ($hata): ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                <?php echo $hata; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($basarili): ?>
            <div class="alert alert-success">
                <i class="bi bi-check-circle-fill me-2"></i>
                <?php echo $basarili; ?>
            </div>
        <?php endif; ?>
        
        <form method="POST" action="" id="nameserverForm">
            <div class="row g-3">
                <div class="col-12">
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle-fill me-2"></i>
                        <strong>Önemli:</strong> Nameserver değişikliği yaptıktan sonra DNS kayıtlarının yayılması 24-48 saat sürebilir.
                    </div>
                </div>
                
                <!-- Nameserver Giriş Alanları -->
                <div class="col-12">
                    <div class="row" id="nameserverContainer">
                        <?php 
                        // En az 2, en fazla 4 nameserver alanı göster
                        $ns_count = max(2, count($mevcut_nameserverlar));
                        for ($i = 0; $i < $ns_count; $i++): 
                        ?>
                        <div class="col-md-6 mb-3">
                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="bi bi-hdd-network"></i>
                                </span>
                                <input type="text" class="form-control" 
                                       name="nameservers[]" 
                                       placeholder="ns<?php echo ($i + 1); ?>.example.com"
                                       value="<?php echo isset($mevcut_nameserverlar[$i]) ? htmlspecialchars($mevcut_nameserverlar[$i]) : ''; ?>"
                                       <?php echo $i < 2 ? 'required' : ''; ?>>
                                <?php if ($i >= 2): ?>
                                <button type="button" class="btn btn-outline-danger" onclick="removeNameserver(this)">
                                    <i class="bi bi-trash"></i>
                                </button>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endfor; ?>
                    </div>
                    
                    <?php if (count($mevcut_nameserverlar) < 4): ?>
                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="addNameserver()">
                        <i class="bi bi-plus-circle me-2"></i>
                        Nameserver Ekle
                    </button>
                    <?php endif; ?>
                </div>
                
                <!-- Hazır Nameserver Şablonları -->
                <div class="col-12">
                    <label class="form-label">Hazır Nameserver Şablonları</label>
                    <div class="row g-2">
                        <div class="col-auto">
                            <button type="button" class="btn btn-outline-secondary btn-sm" 
                                    onclick="setTemplate('cloudflare')">
                                <i class="bi bi-cloud me-2"></i>
                                Cloudflare
                            </button>
                        </div>
                        <div class="col-auto">
                            <button type="button" class="btn btn-outline-secondary btn-sm" 
                                    onclick="setTemplate('google')">
                                <i class="bi bi-google me-2"></i>
                                Google Cloud
                            </button>
                        </div>
                        <div class="col-auto">
                            <button type="button" class="btn btn-outline-secondary btn-sm" 
                                    onclick="setTemplate('aws')">
                                <i class="bi bi-cloud me-2"></i>
                                Amazon Route 53
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="col-12">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>
                        Nameserver'ları Güncelle
                    </button>
                    <a href="index.php?sayfa=domain/liste" class="btn btn-secondary">
                        <i class="bi bi-x-circle me-2"></i>
                        İptal
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
// Nameserver şablonları
const templates = {
    cloudflare: [
        'ns1.cloudflare.com',
        'ns2.cloudflare.com'
    ],
    google: [
        'ns-cloud-a1.googledomains.com',
        'ns-cloud-a2.googledomains.com',
        'ns-cloud-a3.googledomains.com',
        'ns-cloud-a4.googledomains.com'
    ],
    aws: [
        'ns-1.awsdns-00.com',
        'ns-2.awsdns-00.org',
        'ns-3.awsdns-00.co.uk',
        'ns-4.awsdns-00.net'
    ]
};

// Şablon uygula
function setTemplate(provider) {
    const inputs = document.querySelectorAll('input[name="nameservers[]"]');
    const template = templates[provider];
    
    // Önce mevcut alanları temizle
    inputs.forEach((input, index) => {
        if (index < template.length) {
            input.value = template[index];
        } else {
            input.closest('.col-md-6').remove();
        }
    });
    
    // Eğer şablonda daha fazla nameserver varsa ekle
    if (template.length > inputs.length) {
        for (let i = inputs.length; i < template.length; i++) {
            addNameserver(template[i]);
        }
    }
}

// Yeni nameserver alanı ekle
function addNameserver(value = '') {
    const container = document.getElementById('nameserverContainer');
    const count = container.children.length;
    
    if (count >= 4) {
        alert('En fazla 4 nameserver ekleyebilirsiniz.');
        return;
    }
    
    const div = document.createElement('div');
    div.className = 'col-md-6 mb-3';
    div.innerHTML = `
        <div class="input-group">
            <span class="input-group-text">
                <i class="bi bi-hdd-network"></i>
            </span>
            <input type="text" class="form-control" 
                   name="nameservers[]" 
                   placeholder="ns${count + 1}.example.com"
                   value="${value}">
            <button type="button" class="btn btn-outline-danger" onclick="removeNameserver(this)">
                <i class="bi bi-trash"></i>
            </button>
        </div>
    `;
    
    container.appendChild(div);
    
    // "Nameserver Ekle" butonunu kontrol et
    const addButton = document.querySelector('button[onclick="addNameserver()"]');
    if (container.children.length >= 4) {
        addButton.style.display = 'none';
    }
}

// Nameserver alanını kaldır
function removeNameserver(button) {
    const container = document.getElementById('nameserverContainer');
    button.closest('.col-md-6').remove();
    
    // "Nameserver Ekle" butonunu göster
    const addButton = document.querySelector('button[onclick="addNameserver()"]');
    if (container.children.length < 4) {
        addButton.style.display = '';
    }
}

// Form gönderilmeden önce kontrol
document.getElementById('nameserverForm').addEventListener('submit', function(e) {
    const inputs = document.querySelectorAll('input[name="nameservers[]"]');
    let validCount = 0;
    
    inputs.forEach(input => {
        if (input.value.trim()) {
            validCount++;
        }
    });
    
    if (validCount < 2) {
        e.preventDefault();
        alert('En az 2 nameserver girmelisiniz.');
    }
});
</script>
<?php ob_end_flush(); ?>