<?php
ob_start();
oturumKontrol();

require_once 'DomainNameAPI_PHPLibrary.php';

// API bağlantısı için ayarları al
$sorgu = $db->query("SELECT * FROM api_ayarlar WHERE servis = 'domainnameapi' LIMIT 1");
$api_ayarlar = $sorgu->fetch(PDO::FETCH_ASSOC);

if (!$api_ayarlar) {
    die("DomainNameAPI ayarları bulunamadı!");
}

// Müşteri listesini getir
$sorgu = $db->query("SELECT * FROM musteriler ORDER BY ad, soyad");
$musteriler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

$hata = '';
$sonuc = [];

// Domain sorgulama
if (isset($_POST['domain_sorgula'])) {
    $domain = trim($_POST['domain']);
    $uzantilar = $_POST['uzantilar'];
    
    try {
        $domainAPI = new DomainNameApi\DomainNameAPI_PHPLibrary(
            $api_ayarlar['username'],
            $api_ayarlar['password']
        );
        
        // Domain adını parçala (örn: example.com -> [example, com])
        $domain_parts = explode('.', $domain);
        if (count($domain_parts) > 1) {
            $domain_name = $domain_parts[0];
            $uzantilar = ['.' . implode('.', array_slice($domain_parts, 1))];
        } else {
            $domain_name = $domain;
        }
        
        // Domainleri sorgula
        $response = $domainAPI->CheckAvailability(
            [$domain_name],  // Domain adları
            $uzantilar,      // Uzantılar
            1,               // Kayıt süresi (yıl)
            'create'         // İşlem türü
        );
        
        if (is_array($response)) {
            $sonuc = $response;
        } else {
            $hata = "Domain sorgulanamadı!";
        }
        
    } catch (Exception $e) {
        $hata = "API Hatası: " . $e->getMessage();
    }
}

// Domain transferi başlat
if (isset($_POST['domain_transfer'])) {
    $musteri_id = $_POST['musteri_id'];
    $domain = $_POST['domain'];
    $epp_code = $_POST['epp_code'];
    
    // Müşteri bilgilerini al
    $sorgu = $db->prepare("SELECT * FROM musteriler WHERE id = ?");
    $sorgu->execute([$musteri_id]);
    $musteri = $sorgu->fetch(PDO::FETCH_ASSOC);
    
    if (!$musteri) {
        $hata = "Müşteri bulunamadı!";
    } else {
        try {
            $domainAPI = new DomainNameApi\DomainNameAPI_PHPLibrary(
                $api_ayarlar['username'],
                $api_ayarlar['password']
            );
            
            // İletişim bilgilerini hazırla
            $contacts = [
                "Administrative" => [
                    "FirstName" => $musteri['ad'],
                    "LastName" => $musteri['soyad'],
                    "Company" => $musteri['musteri_turu'] == 'Kurumsal' ? $musteri['vergi_dairesi'] : '',
                    "EMail" => $musteri['eposta'],
                    "AddressLine1" => $musteri['adres'],
                    "City" => "Istanbul",
                    "Country" => "TR",
                    "Phone" => $musteri['telefon'],
                    "PhoneCountryCode" => "90",
                    "Type" => "Contact"
                ]
            ];
            
            // Diğer contact türleri için aynı bilgileri kullan
            $contacts["Technical"] = $contacts["Administrative"];
            $contacts["Billing"] = $contacts["Administrative"];
            $contacts["Registrant"] = $contacts["Administrative"];
            
            // Transfer işlemini başlat
            $response = $domainAPI->TransferDomain(
                $domain,
                $epp_code,
                $contacts
            );
            
            if ($response['result'] == 'OK') {
                // Transfer başarılı, veritabanına ekle
                $sorgu = $db->prepare("INSERT INTO domain_kayitlar (musteri_id, domain, kayit_tarihi, bitis_tarihi, durum) VALUES (?, ?, CURDATE(), DATE_ADD(CURDATE(), INTERVAL 1 YEAR), 'Transfer')");
                $sonuc = $sorgu->execute([
                    $musteri_id,
                    $domain
                ]);
                
                if ($sonuc) {
                    header("Location: index.php?sayfa=domain/liste&mesaj=transfer_basladi");
                    exit;
                }
            } else {
                $hata = "Domain transferi başlatılamadı: " . $response['error']['Message'];
            }
            
        } catch (Exception $e) {
            $hata = "API Hatası: " . $e->getMessage();
        }
    }
}

// Kütüphaneyi dahil et
require_once(__DIR__ . "/DomainNameAPI_PHPLibrary.php");

// Namespace'i kullan
use DomainNameApi\DomainNameAPI_PHPLibrary;

// API bağlantısı için ayarları al
$sorgu = $db->query("SELECT * FROM api_ayarlar WHERE servis = 'domainnameapi' LIMIT 1");
$api_ayarlar = $sorgu->fetch(PDO::FETCH_ASSOC);

if (!$api_ayarlar) {
    die("DomainNameAPI ayarları bulunamadı!");
}

try {
    // API bağlantısı
    $domainAPI = new DomainNameAPI_PHPLibrary(
        $api_ayarlar['username'],
        $api_ayarlar['password']
    );

    // Popüler TLD'leri tanımla (noktasız)
    $popularTlds = array('com', 'net', 'org', 'com.tr', 'net.tr', 'org.tr', 'info', 'biz', 'xyz');

    // Tüm TLD listesini çek
    $tld_response = $domainAPI->GetTldList();
    $allTlds = array();

    // API yanıtını kontrol et ve TLD'leri çıkar
    if ($tld_response['result'] == 'OK') {
        foreach ($tld_response['data'] as $tld_data) {
            $tld = $tld_data['tld'];
            // Başında nokta varsa kaldır
            $tld = ltrim($tld, '.');
            $allTlds[] = $tld;
        }
    }

    // TLD'leri sırala
    $sortedTlds = array();

    // Önce popüler TLD'leri ekle
    foreach ($popularTlds as $tld) {
        if (in_array($tld, $allTlds)) {
            $sortedTlds[] = $tld;
        }
    }

    // Sonra diğer TLD'leri ekle (alfabetik sıralı)
    $otherTlds = array_diff($allTlds, $popularTlds);
    sort($otherTlds);
    $sortedTlds = array_merge($sortedTlds, $otherTlds);


} catch (Exception $e) {
    echo '<option value="">API Hatası: ' . htmlspecialchars($e->getMessage()) . '</option>';
}
?>

<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=domain/liste">Domain Listesi</a></li>
        <li class="breadcrumb-item active" aria-current="page">Yeni Domain</li>
    </ol>
</nav>

<?php if ($hata): ?>
<div class="alert alert-danger">
    <i class="bi bi-exclamation-triangle-fill me-2"></i>
    <?php echo $hata; ?>
</div>
<?php endif; ?>

<!-- Domain Sorgulama -->
<div class="card mb-4">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-search me-2"></i>
            Domain Sorgula
        </h5>
    </div>
    <div class="card-body">
        <form method="post" action="" id="sorgulaForm">
            <input type="hidden" name="domain_sorgula" value="1">
            
            <div class="row g-3">
                <div class="col-md-6">
                    <label for="domain" class="form-label">Domain Adı</label>
                    <input type="text" class="form-control" id="domain" name="domain" 
                           value="<?php echo isset($_POST['domain']) ? htmlspecialchars($_POST['domain']) : ''; ?>"
                           placeholder="example.com" required>
                </div>
                
                <div class="col-md-6">
                    <label for="uzantilar" class="form-label">Uzantılar</label>
                    <select class="form-select select2" id="uzantilar" name="uzantilar[]" multiple>
                        <?php foreach ($sortedTlds as $tld): ?>
                        <option value="<?php echo $tld; ?>" 
                                <?php echo (isset($_POST['uzantilar']) && in_array($tld, $_POST['uzantilar'])) ? 'selected' : ''; ?>>
                            <?php echo $tld; ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="col-12">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-search me-2"></i>
                        Sorgula
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<?php if (!empty($sonuc)): ?>
<!-- Sonuçlar -->
<div class="card mb-4">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-list-check me-2"></i>
            Sonuçlar
        </h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Domain</th>
                        <th>Durum</th>
                        <th>Fiyat</th>
                        <th>İşlem</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($sonuc as $domain): ?>
                <tr>
                    <td>
                        <div class="d-flex align-items-center">
                            <span><?php echo htmlspecialchars($domain['DomainName']); ?></span>
                            <span class="text-primary ms-1">.<?php echo htmlspecialchars($domain['TLD']); ?></span>
                        </div>
                    </td>
                    <td>
                        <?php if ($domain['Status'] == 'available'): ?>
                            <span class="badge bg-success">Müsait</span>
                        <?php else: ?>
                            <span class="badge bg-danger">Kayıtlı</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if ($domain['Status'] == 'available'): ?>
                            <?php echo number_format($domain['Price'], 2); ?> 
                            <?php echo $domain['Currency']; ?>
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if ($domain['Status'] == 'available'): ?>
                            <button type="button" class="btn btn-success btn-sm"
                                    onclick="domainSec('<?php echo htmlspecialchars($domain['DomainName'] . '.' . $domain['TLD']); ?>')">
                                <i class="bi bi-check-circle me-1"></i>
                                Satın Al
                            </button>
                        <?php else: ?>
                            <button type="button" class="btn btn-warning btn-sm"
                                    onclick="transferBaslat('<?php echo htmlspecialchars($domain['DomainName'] . '.' . $domain['TLD']); ?>')">
                                <i class="bi bi-arrow-left-right me-1"></i>
                                Transfer Et
                            </button>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Domain Kayıt Formu -->
<div class="card" id="kayitForm" style="display: none;">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-globe me-2"></i>
            Domain Kaydı
        </h5>
    </div>
    <div class="card-body">
        <form method="post" action="">
            <input type="hidden" name="domain_kaydet" value="1">
            <input type="hidden" name="domain" id="secilen_domain">
            
            <div class="row g-3">
                <div class="col-md-6">
                    <label for="musteri_id" class="form-label">Müşteri</label>
                    <select class="form-select select2" id="musteri_id" name="musteri_id" required>
                        <option value="">Müşteri Seçin</option>
                        <?php foreach ($musteriler as $musteri): ?>
                        <option value="<?php echo $musteri['id']; ?>">
                            <?php echo htmlspecialchars($musteri['ad'] . ' ' . $musteri['soyad']); ?>
                            (<?php echo $musteri['musteri_turu']; ?>)
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="col-md-6">
                    <label for="period" class="form-label">Kayıt Süresi</label>
                    <select class="form-select" id="period" name="period" required>
                        <?php for ($i = 1; $i <= 10; $i++): ?>
                        <option value="<?php echo $i; ?>"><?php echo $i; ?> Yıl</option>
                        <?php endfor; ?>
                    </select>
                </div>
                
                <div class="col-12">
                    <label class="form-label">Nameserverlar</label>
                    <div class="row g-2">
                        <?php for ($i = 1; $i <= 4; $i++): ?>
                        <div class="col-md-6">
                            <input type="text" class="form-control" name="nameservers[]" 
                                   placeholder="ns<?php echo $i; ?>.example.com">
                        </div>
                        <?php endfor; ?>
                    </div>
                    <small class="text-muted">
                        Boş bırakılırsa varsayılan nameserverlar kullanılacaktır.
                    </small>
                </div>
                
                <div class="col-12">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>
                        Kaydı Tamamla
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Domain Transfer Formu -->
<div class="card" id="transferForm" style="display: none;">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-arrow-left-right me-2"></i>
            Domain Transfer
        </h5>
    </div>
    <div class="card-body">
        <form method="post" action="">
            <input type="hidden" name="domain_transfer" value="1">
            <input type="hidden" name="domain" id="transfer_domain">
            
            <div class="row g-3">
                <div class="col-md-12">
                    <label for="transfer_musteri_id" class="form-label">Müşteri</label>
                    <select class="form-select select2" id="transfer_musteri_id" name="musteri_id" required>
                        <option value="">Müşteri Seçin</option>
                        <?php foreach ($musteriler as $musteri): ?>
                        <option value="<?php echo $musteri['id']; ?>">
                            <?php echo htmlspecialchars($musteri['ad'] . ' ' . $musteri['soyad']); ?>
                            (<?php echo $musteri['musteri_turu']; ?>)
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="col-md-12">
                    <label for="epp_code" class="form-label">EPP (Transfer) Kodu</label>
                    <input type="text" class="form-control" id="epp_code" name="epp_code" required>
                    <small class="text-muted">
                        Domain'in transfer kodunu girin. Bu kodu mevcut domain sağlayıcınızdan alabilirsiniz.
                    </small>
                </div>
                
                <div class="col-12">
                    <button type="submit" class="btn btn-warning">
                        <i class="bi bi-arrow-left-right me-2"></i>
                        Transfer İşlemini Başlat
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
<?php endif; ?>

<!-- jQuery ve Select2 JS -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    // Select2
    $('.select2').select2({
        theme: 'bootstrap-5'
    });
    
    // Varsayılan uzantıları seç
    if ($('#uzantilar').val() === null) {
        $('#uzantilar').val(['.com', '.net', '.org']).trigger('change');
    }
});

function domainSec(domain) {
    $('#secilen_domain').val(domain);
    $('#transferForm').slideUp();
    $('#kayitForm').slideDown();
    $('html, body').animate({
        scrollTop: $('#kayitForm').offset().top - 20
    }, 500);
}

function transferBaslat(domain) {
    $('#transfer_domain').val(domain);
    $('#kayitForm').slideUp();
    $('#transferForm').slideDown();
    $('html, body').animate({
        scrollTop: $('#transferForm').offset().top - 20
    }, 500);
}
</script>
<?php ob_end_flush(); ?>