<?php

session_start();

require_once '../config/db.php';

require_once 'inc/functions.php';

require_once 'inc/config.php';



// Get requested page

$sayfa = isset($_GET['sayfa']) ? $_GET['sayfa'] : 'anasayfa';

$dosya = 'sayfalar/' . $sayfa . '.php';



// Get site settings

$site_ayarlar = [

    'site_baslik' => 'Epifiz Web Ajans',

    'site_aciklama' => 'Hosting ve Domain Hizmetleri'

];

?>

<!DOCTYPE html>

<html lang="tr">

<head>

    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title><?php echo $site_ayarlar['site_baslik']; ?></title>

    

    <!-- Bootstrap CSS -->

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">

    

    <!-- Custom CSS -->

    <link href="assets/css/style.css" rel="stylesheet">

</head>

<body>

    <!-- Header -->

    <?php include 'inc/header.php'; ?>

    

    <!-- Main Content -->

    <main class="flex-shrink-0">

        <div class="container py-4">

            <?php

            if (file_exists($dosya)) {

                include $dosya;

            } else {

                include 'sayfalar/404.php';

            }

            ?>

        </div>

    </main>

    

    <!-- Footer -->

    <?php include 'inc/footer.php'; ?>

    

    <!-- Bootstrap JS -->

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    

    <!-- Custom JS -->

    <script src="assets/js/main.js"></script>

</body>

</html>