<?php

require_once 'config/db.php';



ini_set('display_errors', 1);

ini_set('display_startup_errors', 1);

error_reporting(E_ALL);



// Ödeme ID kontrolü

if (!isset($_GET['id'])) {

    die("Geçersiz işlem.");

}



$odeme_id = $_GET['id'];



// Ödeme kaydını kontrol et

$sorgu = $db->prepare("

    SELECT o.*, f.fatura_no, f.genel_toplam, m.ad, m.soyad, m.eposta, m.telefon 

    FROM online_odemeler o

    LEFT JOIN faturalar f ON o.fatura_id = f.id

    LEFT JOIN musteriler m ON f.musteri_id = m.id

    WHERE o.id = ? AND o.durum = 'Bekliyor'

");

$sorgu->execute([$odeme_id]);

$odeme = $sorgu->fetch(PDO::FETCH_ASSOC);



if (!$odeme) {

    die("Geçersiz ödeme kaydı veya ödeme zaten tamamlanmış.");

}



// Shopier için gerekli bilgiler

$shopier_api_key = 'a9f63a5a29b5cfa25106f487ec97d92b'; // Shopier Mağaza API Key

$shopier_secret_key = '86c529d8c7dee05198fbf2b0a14d7708'; // Shopier Mağaza Secret Key



// Ödeme bilgileri

$order_id = $odeme['id'];

$user_name = $odeme['ad'] . ' ' . $odeme['soyad'];

$user_email = $odeme['eposta'];

$user_phone = $odeme['telefon'];

$payment_amount = $odeme['genel_toplam']; // TL cinsinden



// Geri dönüş URL'leri

$success_url = "https://www.epifizajans.com/yonetim/callback/shopier_success.php";

$fail_url = "https://www.epifizajans.com/yonetim/callback/shopier_fail.php";



// Shopier hash oluşturma

$hash_str = $shopier_api_key . $order_id . $user_email . $payment_amount;

$hash = base64_encode(hash_hmac('sha256', $hash_str, $shopier_secret_key, true));



// Shopier ödeme formuna yönlendirme

$form_url = "https://www.shopier.com/ShowProduct/api_pay4.php";



?>

<!DOCTYPE html>

<html lang="tr">

<head>

    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Ödeme Yönlendirme</title>

</head>

<body>

    <form id="shopier_form" action="<?php echo $form_url; ?>" method="post">

        <input type="hidden" name="API_key" value="<?php echo $shopier_api_key; ?>">

        <input type="hidden" name="website_index" value="1">

        <input type="hidden" name="product_name" value="Fatura Ödemesi">

        <input type="hidden" name="product_type" value="1">

        <input type="hidden" name="merchant_oid" value="<?php echo $order_id; ?>">

        <input type="hidden" name="buyer_name" value="<?php echo $user_name; ?>">

        <input type="hidden" name="buyer_email" value="<?php echo $user_email; ?>">

        <input type="hidden" name="buyer_phone" value="<?php echo $user_phone; ?>">

        <input type="hidden" name="buyer_address" value="Adres belirtilmemiş">

        <input type="hidden" name="total_order_value" value="<?php echo $payment_amount; ?>">

        <input type="hidden" name="return_ok_url" value="<?php echo $success_url; ?>">

        <input type="hidden" name="return_fail_url" value="<?php echo $fail_url; ?>">

        <input type="hidden" name="hash" value="<?php echo $hash; ?>">

    </form>

    <script>

        document.getElementById('shopier_form').submit();

    </script>

</body>

</html>

