<?php
ob_start();
oturumKontrol();

$hata = '';
$basarili = '';

// TLD ekleme/güncelleme işlemi
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['tld_ekle'])) {
        $uzanti = guvenlik($_POST['uzanti']);
        $kayit_fiyat = (float)$_POST['kayit_fiyat'];
        $yenileme_fiyat = (float)$_POST['yenileme_fiyat'];
        $transfer_fiyat = (float)$_POST['transfer_fiyat'];
        $min_sure = (int)$_POST['min_sure'];
        $max_sure = (int)$_POST['max_sure'];
        
        if (empty($uzanti)) {
            $hata = 'Uzantı alanı boş bırakılamaz.';
        } else {
            try {
                // Uzantı kontrolü
                $sorgu = $db->prepare("SELECT id FROM domain_fiyatlar WHERE uzanti = ?");
                $sorgu->execute([$uzanti]);
                
                if ($sorgu->rowCount() > 0) {
                    $hata = 'Bu uzantı zaten mevcut.';
                } else {
                    $sorgu = $db->prepare("INSERT INTO domain_fiyatlar 
                        (uzanti, kayit_fiyat, yenileme_fiyat, transfer_fiyat, min_sure, max_sure) 
                        VALUES (?, ?, ?, ?, ?, ?)");
                    
                    $sonuc = $sorgu->execute([
                        $uzanti,
                        $kayit_fiyat,
                        $yenileme_fiyat,
                        $transfer_fiyat,
                        $min_sure,
                        $max_sure
                    ]);
                    
                    if ($sonuc) {
                        $basarili = 'Yeni TLD başarıyla eklendi.';
                    }
                }
            } catch (PDOException $e) {
                $hata = 'Veritabanı hatası: ' . $e->getMessage();
            }
        }
    }
    
    // Fiyat güncelleme
    if (isset($_POST['fiyat_guncelle'])) {
        try {
            $db->beginTransaction();
            
            foreach ($_POST['fiyatlar'] as $id => $fiyat) {
                $sorgu = $db->prepare("UPDATE domain_fiyatlar SET 
                    kayit_fiyat = ?,
                    yenileme_fiyat = ?,
                    transfer_fiyat = ?,
                    min_sure = ?,
                    max_sure = ?,
                    durum = ?
                    WHERE id = ?");
                
                $sorgu->execute([
                    (float)$fiyat['kayit'],
                    (float)$fiyat['yenileme'],
                    (float)$fiyat['transfer'],
                    (int)$fiyat['min_sure'],
                    (int)$fiyat['max_sure'],
                    isset($fiyat['durum']) ? 1 : 0,
                    $id
                ]);
            }
            
            $db->commit();
            $basarili = 'Fiyatlar başarıyla güncellendi.';
            
        } catch (PDOException $e) {
            $db->rollBack();
            $hata = 'Veritabanı hatası: ' . $e->getMessage();
        }
    }
}

// TLD listesini getir
$sorgu = $db->query("SELECT * FROM domain_fiyatlar ORDER BY uzanti");
$tldler = $sorgu->fetchAll(PDO::FETCH_ASSOC);
?>

<!-- Bootstrap Icons ve DataTables CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item">Fiyatlar</li>
        <li class="breadcrumb-item active">Domain Fiyatları</li>
    </ol>
</nav>

<?php if ($hata): ?>
    <div class="alert alert-danger">
        <i class="bi bi-exclamation-triangle-fill me-2"></i>
        <?php echo $hata; ?>
    </div>
<?php endif; ?>

<?php if ($basarili): ?>
    <div class="alert alert-success">
        <i class="bi bi-check-circle-fill me-2"></i>
        <?php echo $basarili; ?>
    </div>
<?php endif; ?>

<div class="row">
    <!-- Yeni TLD Ekleme -->
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-plus-circle me-2"></i>
                    Yeni TLD Ekle
                </h5>
            </div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="tld_ekle" value="1">
                    
                    <div class="mb-3">
                        <label for="uzanti" class="form-label">Uzantı *</label>
                        <div class="input-group">
                            <span class="input-group-text">.</span>
                            <input type="text" class="form-control" id="uzanti" name="uzanti" 
                                   placeholder="com" required>
                        </div>
                        <small class="text-muted">Örnek: com, net, org, com.tr</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="kayit_fiyat" class="form-label">Kayıt Fiyatı *</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="kayit_fiyat" name="kayit_fiyat" 
                                   step="0.01" min="0" value="0.00" required>
                            <span class="input-group-text">₺</span>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="yenileme_fiyat" class="form-label">Yenileme Fiyatı *</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="yenileme_fiyat" name="yenileme_fiyat" 
                                   step="0.01" min="0" value="0.00" required>
                            <span class="input-group-text">₺</span>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="transfer_fiyat" class="form-label">Transfer Fiyatı *</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="transfer_fiyat" name="transfer_fiyat" 
                                   step="0.01" min="0" value="0.00" required>
                            <span class="input-group-text">₺</span>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="min_sure" class="form-label">Min. Süre (Yıl)</label>
                                <input type="number" class="form-control" id="min_sure" name="min_sure" 
                                       min="1" max="10" value="1" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="max_sure" class="form-label">Max. Süre (Yıl)</label>
                                <input type="number" class="form-control" id="max_sure" name="max_sure" 
                                       min="1" max="10" value="10" required>
                            </div>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-plus-circle me-2"></i>
                        TLD Ekle
                    </button>
                </form>
            </div>
        </div>
    </div>
    
    <!-- TLD Listesi -->
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-globe me-2"></i>
                    TLD Listesi ve Fiyatlar
                </h5>
            </div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="fiyat_guncelle" value="1">
                    
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Uzantı</th>
                                    <th>Kayıt</th>
                                    <th>Yenileme</th>
                                    <th>Transfer</th>
                                    <th>Min-Max Süre</th>
                                    <th>Durum</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($tldler as $tld): ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <i class="bi bi-globe me-2"></i>
                                            .<?php echo htmlspecialchars($tld['uzanti']); ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input-group-sm">
                                            <input type="number" class="form-control" 
                                                   name="fiyatlar[<?php echo $tld['id']; ?>][kayit]" 
                                                   value="<?php echo $tld['kayit_fiyat']; ?>" 
                                                   step="0.01" min="0" required>
                                            <span class="input-group-text">₺</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input-group-sm">
                                            <input type="number" class="form-control" 
                                                   name="fiyatlar[<?php echo $tld['id']; ?>][yenileme]" 
                                                   value="<?php echo $tld['yenileme_fiyat']; ?>" 
                                                   step="0.01" min="0" required>
                                            <span class="input-group-text">₺</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input-group-sm">
                                            <input type="number" class="form-control" 
                                                   name="fiyatlar[<?php echo $tld['id']; ?>][transfer]" 
                                                   value="<?php echo $tld['transfer_fiyat']; ?>" 
                                                   step="0.01" min="0" required>
                                            <span class="input-group-text">₺</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input-group-sm">
                                            <input type="number" class="form-control" 
                                                   name="fiyatlar[<?php echo $tld['id']; ?>][min_sure]" 
                                                   value="<?php echo $tld['min_sure']; ?>" 
                                                   min="1" max="10" required>
                                            <span class="input-group-text">-</span>
                                            <input type="number" class="form-control" 
                                                   name="fiyatlar[<?php echo $tld['id']; ?>][max_sure]" 
                                                   value="<?php echo $tld['max_sure']; ?>" 
                                                   min="1" max="10" required>
                                            <span class="input-group-text">Yıl</span>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="form-check form-switch d-flex justify-content-center">
                                            <input class="form-check-input" type="checkbox" 
                                                   name="fiyatlar[<?php echo $tld['id']; ?>][durum]" 
                                                   <?php echo $tld['durum'] ? 'checked' : ''; ?>>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>
                        Fiyatları Güncelle
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php ob_end_flush(); ?>