<?php
ob_start();
oturumKontrol();

require_once 'DomainNameAPI_PHPLibrary.php';

// API bağlantısı için ayarları al
$sorgu = $db->query("SELECT * FROM api_ayarlar WHERE servis = 'domainnameapi' LIMIT 1");
$api_ayarlar = $sorgu->fetch(PDO::FETCH_ASSOC);

if (!$api_ayarlar) {
    die("DomainNameAPI ayarları bulunamadı!");
}

if (!isset($_GET['domain'])) {
    header("Location: index.php?sayfa=domain/liste");
    exit;
}

$domain = $_GET['domain'];
$hata = '';
$basarili = '';
$contact_info = [];

try {
    $api = new DomainNameApi\DomainNameAPI_PHPLibrary(
        $api_ayarlar['username'],
        $api_ayarlar['password']
    );
    
    // Debug: API kimlik bilgilerini logla (hassas bilgileri maskeleyerek)
    error_log("API Username: " . substr($api_ayarlar['username'], 0, 3) . '***');
    error_log("Domain: " . $domain);
    
    // Mevcut iletişim bilgilerini getir
    $response = $api->GetContacts($domain);
    
    // Debug: API yanıtını logla
    error_log("GetContacts API Response: " . print_r($response, true));
    
    if ($response['result'] == 'OK') {
        $contact_info = $response['data'];
        error_log("Contact Info: " . print_r($contact_info, true));
    } else {
        $hata = "İletişim bilgileri alınamadı: " . $response['error']['Message'];
        error_log("API Error: " . $hata);
        
        // Domain detaylarını almayı dene
        $details_response = $api->GetDetails($domain);
        error_log("GetDetails API Response: " . print_r($details_response, true));
        
        if ($details_response['result'] == 'OK' && isset($details_response['data']['Contacts'])) {
            $contact_info = $details_response['data']['Contacts'];
            error_log("Contact Info from Details: " . print_r($contact_info, true));
        }
    }
    
    // İletişim bilgilerini güncelle
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $contacts = [];
    $contact_types = ['Registrant', 'Administrative', 'Technical', 'Billing'];

    foreach ($contact_types as $type) {
        $contacts[$type] = [
            "ID"             => $_POST[$type . '_Id'] ?? "",
            "FirstName"      => $_POST[$type . '_FirstName'],
            "LastName"       => $_POST[$type . '_LastName'],
            "Company"        => $_POST[$type . '_Company'],
            "EMail"          => $_POST[$type . '_EMail'],
            "AddressLine1"   => $_POST[$type . '_AddressLine1'],
            "AddressLine2"   => $_POST[$type . '_AddressLine2'] ?? "",
            "City"           => $_POST[$type . '_City'],
            "Country"        => $_POST[$type . '_Country'],
            "ZipCode"        => $_POST[$type . '_ZipCode'] ?? "",
            "Phone"          => $_POST[$type . '_Phone'],
            "PhoneCountryCode" => $_POST[$type . '_PhoneCountryCode'],
            "Fax"            => $_POST[$type . '_Fax'] ?? "",
            "FaxCountryCode" => $_POST[$type . '_FaxCountryCode'] ?? "",
        ];
    }

    // Gönderilen veriyi loglayın
    error_log("Gönderilen Contacts Verisi: " . print_r($contacts, true));

    // Veriyi API'ye gönder
    $response = $api->SaveContacts($domain, $contacts);

    if ($response['result'] == 'OK') {
        $basarili = "İletişim bilgileri başarıyla güncellendi.";
    } else {
        $hata = "İletişim bilgileri güncellenirken hata oluştu: " . $response['error']['Message'];
    }
}

    
} catch (Exception $e) {
    $hata = "API Hatası: " . $e->getMessage();
    error_log("Exception: " . $e->getMessage());
}

// Ülke listesi
$ulkeler = [
    'TR' => 'Türkiye',
    'US' => 'Amerika Birleşik Devletleri',
    'GB' => 'Birleşik Krallık',
    'DE' => 'Almanya',
    'FR' => 'Fransa',
    // Diğer ülkeler eklenebilir
];

?>

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=domain/liste">Domain Listesi</a></li>
        <li class="breadcrumb-item active" aria-current="page">İletişim Bilgileri</li>
    </ol>
</nav>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-person-vcard me-2"></i>
            Domain İletişim Bilgileri
            <small class="text-muted">(<?php echo htmlspecialchars($domain); ?>)</small>
        </h5>
    </div>
    <div class="card-body">
        <?php if ($hata): ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                <?php echo $hata; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($basarili): ?>
            <div class="alert alert-success">
                <i class="bi bi-check-circle-fill me-2"></i>
                <?php echo $basarili; ?>
            </div>
        <?php endif; ?>
        
        <?php if (empty($contact_info)): ?>
            <div class="alert alert-warning">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                Domain için iletişim bilgileri alınamadı. Lütfen API ayarlarınızı kontrol edin.
            </div>
        <?php endif; ?>
        
        <form method="POST" action="" id="contactForm">
            <!-- Contact Tabs -->
            <ul class="nav nav-tabs mb-3" id="contactTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#registrant" type="button">
                        <i class="bi bi-person me-2"></i>
                        Domain Sahibi
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#administrative" type="button">
                        <i class="bi bi-person-badge me-2"></i>
                        İdari İletişim
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#technical" type="button">
                        <i class="bi bi-gear me-2"></i>
                        Teknik İletişim
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#billing" type="button">
                        <i class="bi bi-credit-card me-2"></i>
                        Fatura İletişim
                    </button>
                </li>
            </ul>
            
            <!-- Tab Content -->
            <div class="tab-content" id="contactTabsContent">
                <?php
                $contact_types = [
                    'Registrant' => ['title' => 'Domain Sahibi', 'icon' => 'person'],
                    'Administrative' => ['title' => 'İdari İletişim', 'icon' => 'person-badge'],
                    'Technical' => ['title' => 'Teknik İletişim', 'icon' => 'gear'],
                    'Billing' => ['title' => 'Fatura İletişim', 'icon' => 'credit-card']
                ]; 

                foreach ($contact_types as $type => $info):
                    $contact = isset($contact_info['contacts'][$type]) ? $contact_info['contacts'][$type] : [];
                ?>
                <div class="tab-pane fade<?php echo $type === 'Registrant' ? ' show active' : ''; ?>" id="<?php echo strtolower($type); ?>" role="tabpanel">
                    <div class="row g-3">
                        <!-- Gizli ID Alanı -->
                        <input type="hidden" name="<?php echo $type; ?>_Id" value="<?php echo htmlspecialchars($contact['ID'] ?? ''); ?>">

                        <div class="col-md-6">
                            <label class="form-label">Ad</label>
                            <input type="text" class="form-control" name="<?php echo $type; ?>_FirstName" 
                                   value="<?php echo htmlspecialchars($contact['FirstName'] ?? ''); ?>" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Soyad</label>
                            <input type="text" class="form-control" name="<?php echo $type; ?>_LastName" 
                                   value="<?php echo htmlspecialchars($contact['LastName'] ?? ''); ?>" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Firma</label>
                            <input type="text" class="form-control" name="<?php echo $type; ?>_Company" 
                                   value="<?php echo htmlspecialchars($contact['Company'] ?? ''); ?>">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">E-posta</label>
                            <input type="email" class="form-control" name="<?php echo $type; ?>_EMail" 
                                   value="<?php echo htmlspecialchars($contact['EMail'] ?? ''); ?>" required>
                        </div>
                        <div class="col-12">
                            <label class="form-label">Adres</label>
                            <input type="text" class="form-control" name="<?php echo $type; ?>_AddressLine1" 
                                   value="<?php echo htmlspecialchars($contact['Address']['Line1'] ?? ''); ?>" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Şehir</label>
                            <input type="text" class="form-control" name="<?php echo $type; ?>_City" 
                                   value="<?php echo htmlspecialchars($contact['Address']['City'] ?? ''); ?>" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Ülke</label>
                            <select class="form-select" name="<?php echo $type; ?>_Country" required>
                                <?php foreach ($ulkeler as $kod => $ulke): ?>
                                <option value="<?php echo $kod; ?>" <?php echo (isset($contact['Address']['Country']) && $contact['Address']['Country'] === $kod) ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($ulke); ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Posta Kodu (ZipCode)</label>
                            <input type="text" class="form-control" name="<?php echo $type; ?>_ZipCode" 
                                   value="<?php echo htmlspecialchars($contact['Address']['ZipCode'] ?? ''); ?>">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Fax</label>
                            <input type="text" class="form-control" name="<?php echo $type; ?>_Fax" 
                                   value="<?php echo htmlspecialchars($contact['Phone']['Fax']['Number'] ?? ''); ?>">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Fax Ülke Kodu</label>
                            <input type="text" class="form-control" name="<?php echo $type; ?>_FaxCountryCode" 
                                   value="<?php echo htmlspecialchars($contact['Phone']['Fax']['CountryCode'] ?? ''); ?>">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Eyalet/İl (State)</label>
                            <input type="text" class="form-control" name="<?php echo $type; ?>_State" 
                                   value="<?php echo htmlspecialchars($contact['Address']['State'] ?? ''); ?>">
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Telefon Ülke Kodu</label>
                            <input type="text" class="form-control" name="<?php echo $type; ?>_PhoneCountryCode" 
                                   value="<?php echo htmlspecialchars($contact['Phone']['Phone']['CountryCode'] ?? ''); ?>" required>
                        </div>
                        <div class="col-md-8">
                            <label class="form-label">Telefon</label>
                            <input type="tel" class="form-control" name="<?php echo $type; ?>_Phone" 
                                   value="<?php echo htmlspecialchars($contact['Phone']['Phone']['Number'] ?? ''); ?>" required>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>

            
            <div class="mt-4">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-circle me-2"></i>
                    Bilgileri Güncelle
                </button>
                <a href="index.php?sayfa=domain/liste" class="btn btn-secondary">
                    <i class="bi bi-x-circle me-2"></i>
                    İptal
                </a>
            </div>
            <?php error_log("POST Verisi: " . print_r($_POST, true)); ?>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Form doğrulama
    const form = document.getElementById('contactForm');
    
    form.addEventListener('submit', function(e) {
        const inputs = form.querySelectorAll('input[required], select[required]');
        let valid = true;
        
        inputs.forEach(input => {
            if (!input.value.trim()) {
                valid = false;
                input.classList.add('is-invalid');
            } else {
                input.classList.remove('is-invalid');
            }
            
            // E-posta kontrolü
            if (input.type === 'email' && input.value) {
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                if (!emailRegex.test(input.value)) {
                    valid = false;
                    input.classList.add('is-invalid');
                }
            }
            
            // Telefon kontrolü
            if (input.type === 'tel' && input.value) {
                const phoneRegex = /^[0-9]{10}$/;
                if (!phoneRegex.test(input.value)) {
                    valid = false;
                    input.classList.add('is-invalid');
                }
            }
        });
        
        if (!valid) {
            e.preventDefault();
            alert('Lütfen tüm zorunlu alanları doğru şekilde doldurun.');
        }
    });
    
    // Aynı bilgileri kopyalama fonksiyonu
    const copyButtons = document.querySelectorAll('[data-copy-from]');
    copyButtons.forEach(button => {
        button.addEventListener('click', function() {
            const sourceType = this.dataset.copyFrom;
            const targetType = this.dataset.copyTo;
            
            const fields = ['FirstName', 'LastName', 'Company', 'EMail', 'AddressLine1', 'City', 'Country', 'Phone', 'PhoneCountryCode'];
            
            fields.forEach(field => {
                const sourceInput = document.querySelector(`[name="${sourceType}_${field}"]`);
                const targetInput = document.querySelector(`[name="${targetType}_${field}"]`);
                
                if (sourceInput && targetInput) {
                    targetInput.value = sourceInput.value;
                }
            });
        });
    });
});
</script>
<?php ob_end_flush(); ?>