<?php

session_start();

require_once 'config/db.php';

require_once 'includes/functions.php';



ob_start(); // Ana dosyada da çıktı tamponlaması başlat

?>

<!DOCTYPE html>

<html lang="tr">

<head>

    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Hosting Yönetim Paneli</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <link href="assets/css/style.css" rel="stylesheet">

    <!-- Bootstrap Icons ve DataTables CSS -->

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">

</head>

<body>

    <div class="wrapper">

        <!-- Sidebar -->

        <?php include 'includes/sidebar.php'; ?>



        <div class="main-content">

            <!-- Üst Menü -->

            <?php include 'includes/header.php'; ?>



            <!-- Ana İçerik -->

            <div class="container-fluid mt-4">

                <?php

                $sayfa = isset($_GET['sayfa']) ? $_GET['sayfa'] : 'dashboard';

                $dosya = 'sayfalar/' . $sayfa . '.php';

                

                if (file_exists($dosya)) {

                    include $dosya;

                } else {

                    include 'sayfalar/404.php';

                }

                ?>

            </div>

        </div>

    </div>



    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script src="assets/js/main.js"></script>

</body>

</html>

<?php

ob_end_flush(); // Ana dosyada çıktı tamponlamasını sonlandır

?>