<?php

$musteri_id = $_SESSION['musteri_id'];
$fatura_id = $_GET['id'] ?? 0;

// Ana fatura bilgilerini çek
$fatura_sorgu = $db->prepare("
    SELECT 
        f.*,
        CONCAT(m.ad, ' ', m.soyad) as musteri_adi,
        m.tc_kimlik_no,
        m.vergi_dairesi,
        m.vergi_no,
        m.adres
    FROM faturalar f
    LEFT JOIN musteriler m ON f.musteri_id = m.id
    WHERE f.id = ? AND f.musteri_id = ?
");

$fatura_sorgu->execute([$fatura_id, $musteri_id]);
$fatura = $fatura_sorgu->fetch(PDO::FETCH_ASSOC);

if (!$fatura) {
    header('Location: index.php?sayfa=faturalarim');
    exit;
}

// Fatura kalemlerini ayrıca çek
$kalemler_sorgu = $db->prepare("
    SELECT 
        fk.*,
        CASE 
            WHEN fk.hizmet_turu = 'Domain' THEN CONCAT(d.domain, ' Domain Yenileme')
            WHEN fk.hizmet_turu = 'Hosting' THEN CONCAT(h.domain, ' Hosting Yenileme (', h.paket, ')')
            ELSE fk.aciklama
        END as hizmet_adi
    FROM fatura_kalemleri fk
    LEFT JOIN domain_kayitlar d ON (fk.hizmet_id = d.id AND fk.hizmet_turu = 'Domain')
    LEFT JOIN hosting_hesaplari h ON (fk.hizmet_id = h.id AND fk.hizmet_turu = 'Hosting')
    WHERE fk.fatura_id = ?
");

$kalemler_sorgu->execute([$_GET['id']]);
$kalemler = $kalemler_sorgu->fetchAll(PDO::FETCH_ASSOC);

// Online ödeme kaydını kontrol et
$odeme_sorgu = $db->prepare("SELECT id FROM online_odemeler WHERE fatura_id = ? ORDER BY created_at DESC LIMIT 1");
$odeme_sorgu->execute([$_GET['id']]);
$odeme = $odeme_sorgu->fetch(PDO::FETCH_ASSOC);

// Eğer online ödeme kaydı yoksa yeni oluştur
if (!$odeme) {
    $online_odeme_id = generateUUID();
    $sorgu = $db->prepare("INSERT INTO online_odemeler (id, fatura_id, tutar) VALUES (?, ?, ?)");
    $sorgu->execute([$online_odeme_id, $_GET['id'], $fatura['genel_toplam']]);
} else {
    $online_odeme_id = $odeme['id'];
}

// Ödeme linkini oluştur
$odeme_link = SITE_URL . "/odeme.php?id=" . $online_odeme_id;

?>

    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">Fatura Detayı</h5>
                        <div>
                            <a href="index.php?sayfa=faturalarim" class="btn btn-secondary btn-sm">
                                <i class="bi bi-arrow-left"></i> Geri
                            </a>
                            <?php if ($fatura['odeme_durumu'] == 'Ödenmedi'): ?>
                            <a href="<?php echo $odeme_link; ?>" class="btn btn-success btn-sm">
                                <i class="bi bi-credit-card"></i> Ödeme Yap
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- Fatura Durumu -->
                        <div class="mb-4">
                            <h6 class="fw-bold">Fatura Durumu</h6>
                            <?php
                            switch($fatura['odeme_durumu']) {
                                case 'Ödendi':
                                    echo '<span class="badge bg-success">Ödendi</span>';
                                    break;
                                case 'Kısmi Ödendi':
                                    echo '<span class="badge bg-warning">Kısmi Ödendi</span>';
                                    break;
                                case 'İptal':
                                    echo '<span class="badge bg-danger">İptal</span>';
                                    break;
                                default:
                                    echo '<span class="badge bg-warning">Ödenmedi</span>';
                            }
                            ?>
                        </div>

                        <!-- Fatura Bilgileri -->
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <h6 class="fw-bold">Fatura Bilgileri</h6>
                                <table class="table table-sm">
                                    <tr>
                                        <td class="fw-bold">Fatura No:</td>
                                        <td><?php echo $fatura['fatura_no']; ?></td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold">Fatura Tarihi:</td>
                                        <td><?php echo date('d.m.Y', strtotime($fatura['fatura_tarihi'])); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold">Son Ödeme Tarihi:</td>
                                        <td><?php echo date('d.m.Y', strtotime($fatura['son_odeme_tarihi'])); ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>

                        <!-- Fatura Detayları -->
                        <div class="mb-4">
                            <h6 class="fw-bold">Fatura Detayı</h6>
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Açıklama</th>
                                        <th>Birim</th>
                                        <th>Miktar</th>
                                        <th>Birim Fiyat</th>
                                        <th class="text-end">Toplam</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($kalemler as $kalem): ?>
                                    <tr>
                                        <td><?php echo $kalem['hizmet_adi']; ?></td>
                                        <td><?php echo $kalem['birim']; ?></td>
                                        <td><?php echo $kalem['miktar']; ?></td>
                                        <td><?php echo number_format($kalem['birim_fiyat'], 2, ',', '.'); ?> ₺</td>
                                        <td class="text-end"><?php echo number_format($kalem['toplam'], 2, ',', '.'); ?> ₺</td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="4" class="text-end fw-bold">Ara Toplam:</td>
                                        <td class="text-end"><?php echo number_format($fatura['ara_toplam'], 2, ',', '.'); ?> ₺</td>
                                    </tr>
                                    <tr>
                                        <td colspan="4" class="text-end fw-bold">KDV (<?php echo $fatura['kdv_oran']; ?>%):</td>
                                        <td class="text-end"><?php echo number_format($fatura['kdv_tutar'], 2, ',', '.'); ?> ₺</td>
                                    </tr>
                                    <tr>
                                        <td colspan="4" class="text-end fw-bold">Genel Toplam:</td>
                                        <td class="text-end fw-bold"><?php echo number_format($fatura['genel_toplam'], 2, ',', '.'); ?> ₺</td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>