<?php

session_start();

require_once '../config/db.php';

require_once 'inc/functions.php';

require_once 'inc/config.php';



// Kullanıcı zaten giriş yapmışsa ana sayfaya yönlendir

if (isset($_SESSION['musteri_id'])) {

    header("Location: index.php");

    exit;

}



$hata = '';



if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    $eposta = guvenlik($_POST['eposta']);

    $sifre = $_POST['sifre'];

    

    if (empty($eposta) || empty($sifre)) {

        $hata = 'Lütfen tüm alanları doldurun.';

    } else {

        $sorgu = $db->prepare("SELECT * FROM musteriler WHERE eposta = ? AND durum = 'Aktif'");

        $sorgu->execute([$eposta]);

        $musteri = $sorgu->fetch(PDO::FETCH_ASSOC);

        

        if ($musteri && password_verify($sifre, $musteri['sifre'])) {

            $_SESSION['musteri_id'] = $musteri['id'];

            $_SESSION['musteri_ad'] = $musteri['ad'];

            $_SESSION['musteri_soyad'] = $musteri['soyad'];

            

            // Son giriş bilgilerini güncelle

            $sorgu = $db->prepare("UPDATE musteriler SET 

                son_giris = NOW(), 

                son_giris_ip = ? 

                WHERE id = ?");

            $sorgu->execute([$_SERVER['REMOTE_ADDR'], $musteri['id']]);

            

            header("Location: index.php");

            exit;

        } else {

            $hata = 'E-posta adresi veya şifre hatalı.';

        }

    }

}

?>

<!DOCTYPE html>

<html lang="tr">

<head>

    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Giriş Yap - <?php echo $site_ayarlar['site_baslik']; ?></title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">

    <link href="assets/css/style.css" rel="stylesheet">

    <style>

        body {

            background-color: #f8f9fa;

        }

        .login-container {

            max-width: 400px;

            margin: 100px auto;

        }

    </style>

</head>

<body>

    <div class="container">

        <div class="login-container">

            <div class="text-center mb-4">

                <a href="index.php" class="text-decoration-none">

                    <i class="bi bi-globe display-4 text-primary"></i>

                    <h4 class="mt-2"><?php echo $site_ayarlar['site_baslik']; ?></h4>

                </a>

            </div>

            

            <div class="card shadow">

                <div class="card-header bg-primary text-white">

                    <h5 class="card-title mb-0">

                        <i class="bi bi-box-arrow-in-right me-2"></i>

                        Giriş Yap

                    </h5>

                </div>

                <div class="card-body p-4">

                    <?php if ($hata): ?>

                        <div class="alert alert-danger">

                            <i class="bi bi-exclamation-triangle-fill me-2"></i>

                            <?php echo $hata; ?>

                        </div>

                    <?php endif; ?>

                    

                    <form method="POST" action="">

                        <div class="mb-3">

                            <label for="eposta" class="form-label">

                                <i class="bi bi-envelope me-2"></i>

                                E-posta Adresi

                            </label>

                            <input type="email" class="form-control" id="eposta" name="eposta" 

                                   value="<?php echo isset($eposta) ? htmlspecialchars($eposta) : ''; ?>" required>

                        </div>

                        

                        <div class="mb-4">

                            <label for="sifre" class="form-label">

                                <i class="bi bi-lock me-2"></i>

                                Şifre

                            </label>

                            <div class="input-group">

                                <input type="password" class="form-control" id="sifre" name="sifre" required>

                                <button class="btn btn-outline-secondary" type="button" id="sifreGoster"

                                        data-bs-toggle="tooltip" title="Şifreyi Göster/Gizle">

                                    <i class="bi bi-eye"></i>

                                </button>

                            </div>

                        </div>

                        

                        <div class="d-grid mb-3">

                            <button type="submit" class="btn btn-primary">

                                <i class="bi bi-box-arrow-in-right me-2"></i>

                                Giriş Yap

                            </button>

                        </div>

                        

                        <div class="text-center">

                            <a href="sifremi-unuttum.php" class="text-decoration-none">

                                <i class="bi bi-key me-1"></i>

                                Şifremi Unuttum

                            </a>

                        </div>

                    </form>

                </div>

                <div class="card-footer text-center bg-light">

                    <p class="mb-0">

                        Hesabınız yok mu? 

                        <a href="kayit.php" class="text-decoration-none">

                            <i class="bi bi-person-plus me-1"></i>

                            Kayıt Ol

                        </a>

                    </p>

                </div>

            </div>

        </div>

    </div>



    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>

    document.addEventListener('DOMContentLoaded', function() {

        // Tooltips'i aktifleştir

        const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');

        const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));

        

        // Şifre göster/gizle

        const sifreInput = document.getElementById('sifre');

        const sifreGoster = document.getElementById('sifreGoster');

        

        sifreGoster.addEventListener('click', function() {

            const tip = sifreInput.type === 'password' ? 'text' : 'password';

            sifreInput.type = tip;

            const icon = this.querySelector('i');

            icon.className = tip === 'password' ? 'bi bi-eye' : 'bi bi-eye-slash';

            

            // Tooltip metnini güncelle

            const tooltip = bootstrap.Tooltip.getInstance(sifreGoster);

            if (tooltip) {

                tooltip.setContent({ '.tooltip-inner': tip === 'password' ? 'Şifreyi Göster' : 'Şifreyi Gizle' });

            }

        });

    });

    </script>

</body>

</html>