<?php
oturumKontrol();

// Sunucu durumunu kontrol eden fonksiyon
function sunucuDurumKontrol($ip, $port = 80, $timeout = 2) {
    $fp = @fsockopen($ip, $port, $errno, $errstr, $timeout);
    if ($fp) {
        fclose($fp);
        return true;
    }
    return false;
}

// Sunucu listesini çek
$sorgu = $db->query("SELECT * FROM sunucular ORDER BY created_at DESC");
$sunucular = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Mesaj parametresini kontrol et
$mesaj = isset($_GET['mesaj']) ? $_GET['mesaj'] : '';
$mesajMetni = '';
$mesajTuru = '';

switch($mesaj) {
    case 'basarili':
        $mesajMetni = 'Yeni sunucu başarıyla eklendi.';
        $mesajTuru = 'success';
        break;
    case 'guncellendi':
        $mesajMetni = 'Sunucu bilgileri güncellendi.';
        $mesajTuru = 'success';
        break;
    case 'silindi':
        $mesajMetni = 'Sunucu başarıyla silindi.';
        $mesajTuru = 'success';
        break;
    case 'hata':
        $mesajMetni = 'Bir hata oluştu. Lütfen tekrar deneyin.';
        $mesajTuru = 'danger';
        break;
}
?>

<!-- Bootstrap Icons -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item active" aria-current="page">Sunucular</li>
    </ol>
</nav>

<!-- Mesaj Gösterimi -->
<?php if ($mesajMetni): ?>
<div class="alert alert-<?php echo $mesajTuru; ?> alert-dismissible fade show" role="alert">
    <?php echo $mesajMetni; ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat"></button>
</div>
<?php endif; ?>

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0">Sunucu Listesi</h5>
        <a href="index.php?sayfa=sunucular/ekle" class="btn btn-primary btn-sm">
            <i class="bi bi-plus-circle"></i> Yeni Sunucu
        </a>
    </div>
    <div class="card-body">
        <table id="sunucuTable" class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th>Durum</th>
                    <th>Sunucu Adı</th>
                    <th>IP Adresi</th>
                    <th>Kullanıcı Adı</th>
                    <th>Oluşturulma Tarihi</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($sunucular as $sunucu): 
                    $durum = sunucuDurumKontrol($sunucu['ip_adresi']);
                ?>
                <tr>
                    <td class="text-center">
                        <?php if ($durum): ?>
                            Online <i class="bi bi-check-circle-fill text-success" title="Sunucu Aktif"></i>
                        <?php else: ?>
                            Offline <i class="bi bi-x-circle-fill text-danger" title="Sunucu Erişilemez"></i>
                        <?php endif; ?>
                    </td>
                    <td><?php echo htmlspecialchars($sunucu['sunucu_adi']); ?></td>
                    <td><?php echo htmlspecialchars($sunucu['ip_adresi']); ?></td>
                    <td><?php echo htmlspecialchars($sunucu['kullanici_adi']); ?></td>
                    <td><?php echo date('d.m.Y H:i', strtotime($sunucu['created_at'])); ?></td>
                    <td>
                        <a href="index.php?sayfa=sunucular/duzenle&id=<?php echo $sunucu['id']; ?>" 
                           class="btn btn-warning btn-sm">
                            <i class="bi bi-pencil"></i> Düzenle
                        </a>
                        <button type="button" 
                                class="btn btn-danger btn-sm" 
                                onclick="sunucuSil(<?php echo $sunucu['id']; ?>)">
                            <i class="bi bi-trash"></i> Sil
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#sunucuTable').DataTable({
        language: {
            url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/tr.json'
        },
        pageLength: 10,
        order: [[1, 'asc']] // Sunucu adına göre sırala
    });
});

function sunucuSil(id) {
    if (confirm('Bu sunucuyu silmek istediğinizden emin misiniz?')) {
        window.location.href = 'index.php?sayfa=sunucular/sil&id=' + id;
    }
}
</script>