<?php
oturumKontrol();

// Form gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $hata = '';
    
    // Form verilerini al ve güvenli hale getir
    $sunucu_adi = guvenlik($_POST['sunucu_adi']);
    $ip_adresi = guvenlik($_POST['ip_adresi']);
    $kullanici_adi = guvenlik($_POST['kullanici_adi']);
    $sifre = $_POST['sifre']; // Şifreyi hash'leyeceğimiz için güvenlik() fonksiyonunu kullanmıyoruz
    $token = guvenlik($_POST['token']);
    
    // Zorunlu alanları kontrol et
    if (empty($sunucu_adi) || empty($ip_adresi) || empty($kullanici_adi) || empty($sifre) || empty($token)) {
        $hata = 'Lütfen tüm alanları doldurun.';
    } else {
        try {
            // IP adresi kontrolü
            if (!filter_var($ip_adresi, FILTER_VALIDATE_IP)) {
                $hata = 'Geçersiz IP adresi formatı.';
            } else {
                // Mükerrer sunucu kontrolü
                $kontrolSorgusu = $db->prepare("SELECT * FROM sunucular WHERE ip_adresi = ?");
                $kontrolSorgusu->execute([$ip_adresi]);
                
                if ($kontrolSorgusu->rowCount() > 0) {
                    $hata = 'Bu IP adresine sahip bir sunucu zaten mevcut.';
                } else {
                    // Şifreyi güvenli bir şekilde hashle
                    $sifre_hash = password_hash($sifre, PASSWORD_DEFAULT);
                    
                    $sorgu = $db->prepare("INSERT INTO sunucular (sunucu_adi, ip_adresi, kullanici_adi, sifre, token) VALUES (?, ?, ?, ?, ?)");
                    $sonuc = $sorgu->execute([$sunucu_adi, $ip_adresi, $kullanici_adi, $sifre_hash, $token]);
                    
                    if ($sonuc) {
                        header("Location: index.php?sayfa=sunucular/liste&mesaj=basarili");
                        exit;
                    }
                }
            }
        } catch (PDOException $e) {
            $hata = 'Bir hata oluştu: ' . $e->getMessage();
        }
    }
}
?>

<!-- Bootstrap Icons CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item">Sunucular</li>
        <li class="breadcrumb-item active" aria-current="page">Yeni Sunucu</li>
    </ol>
</nav>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-hdd-rack me-2"></i>
            Yeni Sunucu Ekle
        </h5>
    </div>
    <div class="card-body">
        <?php if (isset($hata) && $hata): ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                <?php echo $hata; ?>
            </div>
        <?php endif; ?>
        
        <form method="POST" action="" class="row g-3">
            <div class="col-md-6">
                <label for="sunucu_adi" class="form-label">
                    <i class="bi bi-server me-2"></i>
                    Sunucu Adı *
                </label>
                <input type="text" class="form-control" id="sunucu_adi" name="sunucu_adi" 
                       value="<?php echo isset($sunucu_adi) ? htmlspecialchars($sunucu_adi) : ''; ?>" required>
            </div>
            
            <div class="col-md-6">
                <label for="ip_adresi" class="form-label">
                    <i class="bi bi-globe me-2"></i>
                    IP Adresi *
                </label>
                <input type="text" class="form-control" id="ip_adresi" name="ip_adresi" 
                       value="<?php echo isset($ip_adresi) ? htmlspecialchars($ip_adresi) : ''; ?>" 
                       placeholder="örn: 192.168.1.1" required>
            </div>
            
            <div class="col-md-6">
                <label for="kullanici_adi" class="form-label">
                    <i class="bi bi-person me-2"></i>
                    Kullanıcı Adı *
                </label>
                <input type="text" class="form-control" id="kullanici_adi" name="kullanici_adi" 
                       value="<?php echo isset($kullanici_adi) ? htmlspecialchars($kullanici_adi) : ''; ?>" required>
            </div>
            
            <div class="col-md-6">
                <label for="sifre" class="form-label">
                    <i class="bi bi-key me-2"></i>
                    Şifre *
                </label>
                <div class="input-group">
                    <input type="password" class="form-control" id="sifre" name="sifre" required>
                    <button class="btn btn-outline-secondary" type="button" id="sifreGoster"
                            data-bs-toggle="tooltip" title="Şifreyi Göster/Gizle">
                        <i class="bi bi-eye"></i>
                    </button>
                    <button class="btn btn-outline-secondary" type="button" id="rastgeleSifre"
                            data-bs-toggle="tooltip" title="Rastgele Şifre Oluştur">
                        <i class="bi bi-shuffle"></i>
                    </button>
                </div>
            </div>

            <div class="col-md-12">
                <label for="token" class="form-label">
                    <i class="bi bi-shield-lock me-2"></i>
                    WHM/cPanel API Token *
                </label>
                <input type="text" class="form-control" id="token" name="token" 
                       value="<?php echo isset($token) ? htmlspecialchars($token) : ''; ?>" required>
                <small class="text-muted">
                    <i class="bi bi-info-circle me-2"></i>
                    WHM API token'ını buraya girin
                </small>
            </div>
            
            <div class="col-12">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-plus-circle me-2"></i>
                    Sunucu Ekle
                </button>
                <a href="index.php?sayfa=sunucular/liste" class="btn btn-secondary">
                    <i class="bi bi-x-circle me-2"></i>
                    İptal
                </a>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tooltips'i aktifleştir
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
    
    // Şifre göster/gizle
    const sifreInput = document.getElementById('sifre');
    const sifreGoster = document.getElementById('sifreGoster');
    
    sifreGoster.addEventListener('click', function() {
        const tip = sifreInput.type === 'password' ? 'text' : 'password';
        sifreInput.type = tip;
        const icon = this.querySelector('i');
        icon.className = tip === 'password' ? 'bi bi-eye' : 'bi bi-eye-slash';
    });
    
    // Rastgele şifre oluştur
    const rastgeleSifre = document.getElementById('rastgeleSifre');
    rastgeleSifre.addEventListener('click', function() {
        const karakterler = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*';
        let sifre = '';
        for (let i = 0; i < 12; i++) {
            sifre += karakterler.charAt(Math.floor(Math.random() * karakterler.length));
        }
        sifreInput.type = 'text';
        sifreInput.value = sifre;
        sifreGoster.querySelector('i').className = 'bi bi-eye-slash';
    });
});
</script>