<?php
ob_start(); // Çıktı tamponlamasını başlat
oturumKontrol();

// Sunucu ID kontrolü
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: index.php?sayfa=sunucular/liste");
    exit;
}

$sunucu_id = (int)$_GET['id'];

// Form gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $hata = '';
    
    // Form verilerini al ve güvenli hale getir
    $sunucu_adi = guvenlik($_POST['sunucu_adi']);
    $ip_adresi = guvenlik($_POST['ip_adresi']);
    $kullanici_adi = guvenlik($_POST['kullanici_adi']);
    $sifre = $_POST['sifre']; // Boş olabilir, sadece değiştirilmek istenirse dolu gelir
    $token = guvenlik($_POST['token']);
    
    // Zorunlu alanları kontrol et
    if (empty($sunucu_adi) || empty($ip_adresi) || empty($kullanici_adi) || empty($token)) {
        $hata = 'Lütfen zorunlu alanları doldurun.';
    } else {
        try {
            // IP adresi kontrolü
            if (!filter_var($ip_adresi, FILTER_VALIDATE_IP)) {
                $hata = 'Geçersiz IP adresi formatı.';
            } else {
                // Mükerrer IP kontrolü (kendi IP'si hariç)
                $kontrolSorgusu = $db->prepare("SELECT * FROM sunucular WHERE ip_adresi = ? AND id != ?");
                $kontrolSorgusu->execute([$ip_adresi, $sunucu_id]);
                
                if ($kontrolSorgusu->rowCount() > 0) {
                    $hata = 'Bu IP adresine sahip başka bir sunucu mevcut.';
                } else {
                    // Şifre değiştirilmek isteniyorsa
                    if (!empty($sifre)) {
                        $sifre_hash = password_hash($sifre, PASSWORD_DEFAULT);
                        $sorgu = $db->prepare("UPDATE sunucular SET sunucu_adi = ?, ip_adresi = ?, kullanici_adi = ?, sifre = ?, token = ? WHERE id = ?");
                        $sonuc = $sorgu->execute([$sunucu_adi, $ip_adresi, $kullanici_adi, $sifre_hash, $token, $sunucu_id]);
                    } else {
                        // Şifre değiştirilmek istenmiyorsa
                        $sorgu = $db->prepare("UPDATE sunucular SET sunucu_adi = ?, ip_adresi = ?, kullanici_adi = ?, token = ? WHERE id = ?");
                        $sonuc = $sorgu->execute([$sunucu_adi, $ip_adresi, $kullanici_adi, $token, $sunucu_id]);
                    }
                    
                    if ($sonuc) {
                        header("Location: index.php?sayfa=sunucular/liste&mesaj=guncellendi");
                        exit;
                    }
                }
            }
        } catch (PDOException $e) {
            $hata = 'Bir hata oluştu: ' . $e->getMessage();
        }
    }
}

// Sunucu bilgilerini getir
try {
    $sorgu = $db->prepare("SELECT * FROM sunucular WHERE id = ?");
    $sorgu->execute([$sunucu_id]);
    $sunucu = $sorgu->fetch(PDO::FETCH_ASSOC);
    
    if (!$sunucu) {
        header("Location: index.php?sayfa=sunucular/liste");
        exit;
    }
} catch (PDOException $e) {
    die("Veritabanı hatası: " . $e->getMessage());
}
?>

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item">Sunucular</li>
        <li class="breadcrumb-item active" aria-current="page">Sunucu Düzenle</li>
    </ol>
</nav>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">Sunucu Düzenle</h5>
    </div>
    <div class="card-body">
        <?php if (isset($hata) && $hata): ?>
            <div class="alert alert-danger"><?php echo $hata; ?></div>
        <?php endif; ?>
        
        <form method="POST" action="" class="row g-3">
            <div class="col-md-6">
                <label for="sunucu_adi" class="form-label">Sunucu Adı *</label>
                <input type="text" class="form-control" id="sunucu_adi" name="sunucu_adi" 
                       value="<?php echo htmlspecialchars($sunucu['sunucu_adi']); ?>" required>
            </div>
            
            <div class="col-md-6">
                <label for="ip_adresi" class="form-label">IP Adresi *</label>
                <input type="text" class="form-control" id="ip_adresi" name="ip_adresi" 
                       value="<?php echo htmlspecialchars($sunucu['ip_adresi']); ?>" 
                       placeholder="örn: 192.168.1.1" required>
            </div>
            
            <div class="col-md-6">
                <label for="kullanici_adi" class="form-label">Kullanıcı Adı *</label>
                <input type="text" class="form-control" id="kullanici_adi" name="kullanici_adi" 
                       value="<?php echo htmlspecialchars($sunucu['kullanici_adi']); ?>" required>
            </div>
            
            <div class="col-md-6">
                <label for="sifre" class="form-label">Şifre</label>
                <input type="password" class="form-control" id="sifre" name="sifre" 
                       placeholder="Değiştirmek istemiyorsanız boş bırakın">
                <small class="text-muted">Sadece değiştirmek istiyorsanız doldurun</small>
            </div>

            <div class="col-md-12">
                <label for="token" class="form-label">WHM/cPanel API Token *</label>
                <input type="text" class="form-control" id="token" name="token" 
                       value="<?php echo htmlspecialchars($sunucu['token']); ?>" required>
                <small class="text-muted">WHM API token'ını buraya girin</small>
            </div>
            
            <div class="col-12">
                <button type="submit" class="btn btn-primary">Değişiklikleri Kaydet</button>
                <a href="index.php?sayfa=sunucular/liste" class="btn btn-secondary">İptal</a>
            </div>
        </form>
    </div>
</div>
<?php
ob_end_flush(); // Çıktı tamponlamasını sonlandır ve içeriği gönder
?>