<?php
oturumKontrol();

// Müşteri listesini çek
$sorgu = $db->query("
    SELECT 
        m.*,
        COUNT(DISTINCT h.id) as hosting_sayisi,
        COUNT(DISTINCT d.id) as domain_sayisi,
        SUM(CASE WHEN h.sonraki_odeme <= CURDATE() AND h.durum = 'Aktif' THEN h.fiyat ELSE 0 END) as toplam_borc
    FROM musteriler m
    LEFT JOIN hosting_hesaplari h ON m.id = h.musteri_id
    LEFT JOIN domain_kayitlar d ON m.id = d.musteri_id
    GROUP BY m.id
    ORDER BY m.created_at DESC
");
$musteriler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Mesaj parametresini kontrol et
$mesaj = isset($_GET['mesaj']) ? $_GET['mesaj'] : '';
$mesajMetni = '';
$mesajTuru = '';

switch($mesaj) {
    case 'basarili':
        $mesajMetni = 'Yeni müşteri başarıyla eklendi.';
        $mesajTuru = 'success';
        break;
    case 'guncellendi':
        $mesajMetni = 'Müşteri bilgileri güncellendi.';
        $mesajTuru = 'success';
        break;
    case 'silindi':
        $mesajMetni = 'Müşteri başarıyla silindi.';
        $mesajTuru = 'success';
        break;
    case 'hata':
        $mesajMetni = 'Bir hata oluştu. Lütfen tekrar deneyin.';
        $mesajTuru = 'danger';
        break;
}
?>

<!-- Bootstrap Icons ve DataTables CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">

<!-- jQuery ve DataTables JS -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item">Müşteriler</li>
        <li class="breadcrumb-item active" aria-current="page">Müşteri Listesi</li>
    </ol>
</nav>

<!-- Mesaj Gösterimi -->
<?php if ($mesajMetni): ?>
<div class="alert alert-<?php echo $mesajTuru; ?> alert-dismissible fade show" role="alert">
    <i class="bi bi-info-circle me-2"></i>
    <?php echo $mesajMetni; ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat"></button>
</div>
<?php endif; ?>

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0">
            <i class="bi bi-people me-2"></i>
            Müşteri Listesi
        </h5>
        <a href="index.php?sayfa=musteriler/ekle" class="btn btn-primary btn-sm">
            <i class="bi bi-person-plus me-2"></i>
            Yeni Müşteri
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table id="musteriTable" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>Ad Soyad</th>
                        <th>E-posta</th>
                        <th>Müşteri Türü</th>
                        <th>Hosting</th>
                        <th>Domain</th>
                        <th>Borç Durumu</th>
                        <th>Kayıt Tarihi</th>
                        <th style="min-width: 200px;">İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($musteriler as $musteri): ?>
                    <tr>
                        <td>
                            <a href="index.php?sayfa=musteriler/detay&id=<?php echo $musteri['id']; ?>" 
                               class="text-decoration-none">
                                <?php echo htmlspecialchars($musteri['ad'] . ' ' . $musteri['soyad']); ?>
                            </a>
                        </td>
                        <td>
                            <a href="mailto:<?php echo htmlspecialchars($musteri['eposta']); ?>" 
                               class="text-decoration-none">
                                <?php echo htmlspecialchars($musteri['eposta']); ?>
                            </a>
                        </td>
                        <td>
                            <?php if ($musteri['musteri_turu'] == 'Bireysel'): ?>
                                <span class="badge bg-primary">
                                    <i class="bi bi-person me-1"></i>
                                    Bireysel
                                </span>
                            <?php else: ?>
                                <span class="badge bg-success">
                                    <i class="bi bi-building me-1"></i>
                                    Kurumsal
                                </span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($musteri['hosting_sayisi'] > 0): ?>
                                <span class="badge bg-info">
                                    <i class="bi bi-hdd-rack me-1"></i>
                                    <?php echo $musteri['hosting_sayisi']; ?> Hesap
                                </span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Yok</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($musteri['domain_sayisi'] > 0): ?>
                                <span class="badge bg-info">
                                    <i class="bi bi-globe me-1"></i>
                                    <?php echo $musteri['domain_sayisi']; ?> Domain
                                </span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Yok</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($musteri['toplam_borc'] > 0): ?>
                                <span class="text-danger fw-bold">
                                    <?php echo number_format($musteri['toplam_borc'], 2, ',', '.'); ?> ₺
                                </span>
                            <?php else: ?>
                                <span class="text-success">
                                    <i class="bi bi-check-circle-fill me-1"></i>
                                    Borç Yok
                                </span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo date('d.m.Y H:i', strtotime($musteri['created_at'])); ?></td>
                        <td>
                            <div class="btn-group">
                                <a href="index.php?sayfa=musteriler/detay&id=<?php echo $musteri['id']; ?>" 
                                   class="btn btn-primary btn-sm"
                                   data-bs-toggle="tooltip" title="Detaylar">
                                    <i class="bi bi-eye me-1"></i>
                                    Detaylar
                                </a>
                                <a href="index.php?sayfa=musteriler/duzenle&id=<?php echo $musteri['id']; ?>" 
                                   class="btn btn-warning btn-sm ms-1"
                                   data-bs-toggle="tooltip" title="Düzenle">
                                    <i class="bi bi-pencil me-1"></i>
                                    Düzenle
                                </a>
                                <button type="button" class="btn btn-danger btn-sm ms-1" 
                                        onclick="musteriSil(<?php echo $musteri['id']; ?>)"
                                        data-bs-toggle="tooltip" title="Sil">
                                    <i class="bi bi-trash me-1"></i>
                                    Sil
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<script>
$(document).ready(function() {
    // Tooltips'i aktifleştir
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
    
    // DataTables'ı başlat
    $('#musteriTable').DataTable({
        language: {
            url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/tr.json'
        },
        pageLength: 25,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Tümü"]],
        order: [[0, 'asc']],
        responsive: true,
        dom: "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
             "<'row'<'col-sm-12'tr>>" +
             "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        initComplete: function() {
            // Arama kutusuna placeholder ekle
            $('.dataTables_filter input')
                .attr('placeholder', 'Ara...')
                .addClass('form-control-sm');
            
            // Sayfa başına gösterim seçeneğini özelleştir
            $('.dataTables_length select').addClass('form-select-sm');
        }
    });
});

function musteriSil(id) {
    if (confirm('Bu müşteriyi silmek istediğinizden emin misiniz?')) {
        window.location.href = 'index.php?sayfa=musteriler/sil&id=' + id;
    }
}
</script>