<?php
ob_start(); // Çıktı tamponlamasını başlat
oturumKontrol();

// Müşteri listesini çek
$musteri_sorgu = $db->query("SELECT id, CONCAT(ad, ' ', soyad) as tam_ad FROM musteriler ORDER BY ad, soyad");
$musteriler = $musteri_sorgu->fetchAll(PDO::FETCH_ASSOC);

// Sunucu listesini çek
$sunucu_sorgu = $db->query("SELECT * FROM sunucular ORDER BY sunucu_adi");
$sunucular = $sunucu_sorgu->fetchAll(PDO::FETCH_ASSOC);

$hata = '';
$basarili = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $musteri_id = $_POST['musteri_id'] ?? '';
    $sunucu_id = $_POST['sunucu_id'] ?? '';
    $domain = guvenlik($_POST['domain']);
    $kullanici_adi = guvenlik($_POST['kullanici_adi']);
    $sifre = $_POST['sifre'];
    $sifre_tekrar = $_POST['sifre_tekrar'];
    $eposta = guvenlik($_POST['eposta']);
    $paket = guvenlik($_POST['paket']);
    $fatura_donemi = guvenlik($_POST['fatura_donemi']);
    $fiyat = floatval($_POST['fiyat']);
    $sonraki_odeme = $_POST['sonraki_odeme'];
    
    // Form validasyonu
    if (empty($musteri_id) || empty($sunucu_id) || empty($domain) || empty($kullanici_adi) || 
        empty($sifre) || empty($eposta) || empty($paket) || empty($fatura_donemi)) {
        $hata = 'Lütfen tüm zorunlu alanları doldurun.';
    } elseif ($sifre !== $sifre_tekrar) {
        $hata = 'Şifreler eşleşmiyor.';
    } elseif (strlen($sifre) < 8) {
        $hata = 'Şifre en az 8 karakter uzunluğunda olmalıdır.';
    } else {
        try {
            // Sunucu bilgilerini al
            $sunucu_sorgu = $db->prepare("SELECT * FROM sunucular WHERE id = ?");
            $sunucu_sorgu->execute([$sunucu_id]);
            $sunucu = $sunucu_sorgu->fetch(PDO::FETCH_ASSOC);
            
            if (!$sunucu) {
                $hata = 'Geçersiz sunucu seçimi.';
            } else {
                // WHM API'yi çağır
                $url = "https://{$sunucu['ip_adresi']}:2087/json-api/createacct";
                
                $header = array(
                    "Authorization: WHM {$sunucu['kullanici_adi']}:{$sunucu['token']}"
                );
                
                $params = array(
                    'username' => $kullanici_adi,
                    'domain' => $domain,
                    'password' => $sifre,
                    'plan' => $paket,
                    'contactemail' => $eposta
                );
                
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($params));
                curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
                
                $response = curl_exec($ch);
                $error = curl_error($ch);
                curl_close($ch);
                
                if ($error) {
                    $hata = 'API hatası: ' . $error;
                } else {
                    $result = json_decode($response, true);
                    
                    if (isset($result['result']) && $result['result'][0]['status'] == 1) {
                        // Veritabanına kaydet
                        $sorgu = $db->prepare("INSERT INTO hosting_hesaplari 
                            (musteri_id, sunucu_id, domain, kullanici_adi, sifre, eposta, 
                             paket, fatura_donemi, fiyat, sonraki_odeme) 
                            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                        
                        $sonuc = $sorgu->execute([
                            $musteri_id, $sunucu_id, $domain, $kullanici_adi,
                            password_hash($sifre, PASSWORD_DEFAULT), $eposta,
                            $paket, $fatura_donemi, $fiyat,
                            date('Y-m-d', strtotime(str_replace('/', '-', $sonraki_odeme)))
                        ]);
                        
                        if ($sonuc) {
                            header("Location: index.php?sayfa=hosting/liste&mesaj=basarili");
                            exit;
                        }
                    } else {
                        $hata = 'Hosting hesabı oluşturulamadı: ' . 
                            ($result['result'][0]['statusmsg'] ?? 'Bilinmeyen hata');
                    }
                }
            }
        } catch (PDOException $e) {
            $hata = 'Veritabanı hatası: ' . $e->getMessage();
        }
    }
}
?>

<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />

<!-- Bootstrap Icons CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

<!-- Flatpickr CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/themes/material_blue.css">

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=hosting/liste">Hosting Hesapları</a></li>
        <li class="breadcrumb-item active" aria-current="page">Yeni Hesap</li>
    </ol>
</nav>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-hdd-rack me-2"></i>
            Yeni Hosting Hesabı
        </h5>
    </div>
    <div class="card-body">
        <?php if ($hata): ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                <?php echo $hata; ?>
            </div>
        <?php endif; ?>
        
        <form method="POST" action="" class="row g-3">
            <!-- Müşteri Seçimi -->
            <div class="col-md-6">
                <label for="musteri_id" class="form-label">
                    <i class="bi bi-person me-2"></i>
                    Müşteri *
                </label>
                <select class="form-select select2" id="musteri_id" name="musteri_id" required>
                    <option value="">Müşteri Seçin</option>
                    <?php foreach ($musteriler as $musteri): ?>
                        <option value="<?php echo $musteri['id']; ?>">
                            <?php echo htmlspecialchars($musteri['tam_ad']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <!-- Sunucu Seçimi -->
            <div class="col-md-6">
                <label for="sunucu_id" class="form-label">
                    <i class="bi bi-server me-2"></i>
                    Sunucu *
                </label>
                <select class="form-select select2" id="sunucu_id" name="sunucu_id" required>
                    <option value="">Sunucu Seçin</option>
                    <?php foreach ($sunucular as $sunucu): ?>
                        <option value="<?php echo $sunucu['id']; ?>">
                            <?php echo htmlspecialchars($sunucu['sunucu_adi']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <!-- Domain -->
            <div class="col-md-12">
                <label for="domain" class="form-label">
                    <i class="bi bi-globe me-2"></i>
                    Etki Alanı *
                </label>
                <input type="text" class="form-control" id="domain" name="domain" required
                       placeholder="ornek: epifizajans.com">
            </div>
            
            <!-- Kullanıcı Adı -->
            <div class="col-md-6">
                <label for="kullanici_adi" class="form-label">
                    <i class="bi bi-person-badge me-2"></i>
                    Kullanıcı Adı *
                </label>
                <input type="text" class="form-control" id="kullanici_adi" name="kullanici_adi" required>
            </div>
            
            <!-- E-posta -->
            <div class="col-md-6">
                <label for="eposta" class="form-label">
                    <i class="bi bi-envelope me-2"></i>
                    E-posta *
                </label>
                <input type="email" class="form-control" id="eposta" name="eposta" required>
            </div>
            
            <!-- Şifre -->
            <div class="col-md-6">
                <label for="sifre" class="form-label">
                    <i class="bi bi-key me-2"></i>
                    Şifre *
                </label>
                <div class="input-group">
                    <input type="password" class="form-control" id="sifre" name="sifre" required>
                    <button class="btn btn-outline-secondary" type="button" id="sifreGoster"
                            data-bs-toggle="tooltip" title="Şifreyi Göster/Gizle">
                        <i class="bi bi-eye"></i>
                    </button>
                    <button class="btn btn-outline-secondary" type="button" id="rastgeleSifre"
                            data-bs-toggle="tooltip" title="Rastgele Şifre Oluştur">
                        <i class="bi bi-shuffle"></i>
                    </button>
                </div>
            </div>
            
            <!-- Şifre Tekrar -->
            <div class="col-md-6">
                <label for="sifre_tekrar" class="form-label">
                    <i class="bi bi-key-fill me-2"></i>
                    Şifre Tekrar *
                </label>
                <div class="input-group">
                    <input type="password" class="form-control" id="sifre_tekrar" name="sifre_tekrar" required>
                    <button class="btn btn-outline-secondary" type="button" id="sifreTekrarGoster"
                            data-bs-toggle="tooltip" title="Şifreyi Göster/Gizle">
                        <i class="bi bi-eye"></i>
                    </button>
                </div>
            </div>
            
            <!-- Paket Seçimi -->
            <div class="col-md-6">
                <label for="paket" class="form-label">
                    <i class="bi bi-box me-2"></i>
                    Hosting Paketi *
                </label>
                <select class="form-select select2" id="paket" name="paket" required>
                    <option value="">Paket Seçin</option>
                    <!-- Paketler AJAX ile yüklenecek -->
                </select>
            </div>
            
            <!-- Fatura Dönemi -->
            <div class="col-md-6">
                <label for="fatura_donemi" class="form-label">
                    <i class="bi bi-calendar-check me-2"></i>
                    Fatura Dönemi *
                </label>
                <select class="form-select" id="fatura_donemi" name="fatura_donemi" required>
                    <option value="">Seçin</option>
                    <option value="1 Yıllık">1 Yıllık</option>
                    <option value="5 Yıllık">5 Yıllık</option>
                    <option value="Ücretsiz">Ücretsiz</option>
                </select>
            </div>
            
            <!-- Fiyat -->
            <div class="col-md-6">
                <label for="fiyat" class="form-label">
                    <i class="bi bi-currency-dollar me-2"></i>
                    Fiyat
                </label>
                <div class="input-group">
                    <input type="number" class="form-control" id="fiyat" name="fiyat" 
                           step="0.01" min="0" value="0">
                    <span class="input-group-text">₺</span>
                </div>
            </div>
            
            <!-- Sonraki Ödeme -->
            <div class="col-md-6">
                <label for="sonraki_odeme" class="form-label">
                    <i class="bi bi-calendar-date me-2"></i>
                    Sonraki Ödeme Tarihi
                </label>
                <input type="text" class="form-control flatpickr" id="sonraki_odeme" 
                       name="sonraki_odeme" placeholder="GG/AA/YYYY">
            </div>
            
            <div class="col-12">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-plus-circle me-2"></i>
                    Hesap Oluştur
                </button>
                <a href="index.php?sayfa=hosting/liste" class="btn btn-secondary">
                    <i class="bi bi-x-circle me-2"></i>
                    İptal
                </a>
            </div>
        </form>
    </div>
</div>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<!-- Flatpickr JS -->
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/tr.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Select2 başlat
    $('.select2').select2({
        theme: 'bootstrap-5',
        width: '100%'
    });
    
    // Flatpickr başlat
    flatpickr(".flatpickr", {
        dateFormat: "d/m/Y",
        locale: "tr",
        allowInput: true
    });
    
    // Tooltips'i aktifleştir
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
    
    // Şifre göster/gizle fonksiyonu
    function sifreGosterGizle(input, button) {
        const tip = input.type === 'password' ? 'text' : 'password';
        input.type = tip;
        const icon = button.querySelector('i');
        icon.className = tip === 'password' ? 'bi bi-eye' : 'bi bi-eye-slash';
    }
    
    // Şifre göster/gizle
    const sifreInput = document.getElementById('sifre');
    const sifreGoster = document.getElementById('sifreGoster');
    sifreGoster.addEventListener('click', () => sifreGosterGizle(sifreInput, sifreGoster));
    
    // Şifre tekrar göster/gizle
    const sifreTekrarInput = document.getElementById('sifre_tekrar');
    const sifreTekrarGoster = document.getElementById('sifreTekrarGoster');
    sifreTekrarGoster.addEventListener('click', () => sifreGosterGizle(sifreTekrarInput, sifreTekrarGoster));
    
    // Rastgele şifre oluştur
    const rastgeleSifre = document.getElementById('rastgeleSifre');
    rastgeleSifre.addEventListener('click', function() {
        const karakterler = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*';
        let sifre = '';
        for (let i = 0; i < 12; i++) {
            sifre += karakterler.charAt(Math.floor(Math.random() * karakterler.length));
        }
        sifreInput.type = 'text';
        sifreTekrarInput.type = 'text';
        sifreInput.value = sifre;
        sifreTekrarInput.value = sifre;
        sifreGoster.querySelector('i').className = 'bi bi-eye-slash';
        sifreTekrarGoster.querySelector('i').className = 'bi bi-eye-slash';
    });
    
    // Sunucu değiştiğinde paketleri yükle
    $('#sunucu_id').on('change', function() {
        const sunucu_id = $(this).val();
        if (sunucu_id) {
            // Sunucu bilgilerini al
            $.get('sayfalar/hosting/ajax/get_paketler.php', { sunucu_id: sunucu_id }, function(data) {
                const paketSelect = $('#paket');
                paketSelect.empty().append('<option value="">Paket Seçin</option>');
                
                if (data.packages) {
                    data.packages.forEach(function(paket) {
                        paketSelect.append(new Option(paket.name, paket.name));
                    });
                }
                
                paketSelect.trigger('change');
            });
        }
    });
    
    // Domain değiştiğinde kullanıcı adı öner
    $('#domain').on('input', function() {
        const domain = $(this).val().split('.')[0];
        if (domain) {
            $('#kullanici_adi').val(domain.toLowerCase().replace(/[^a-z0-9]/g, '').substring(0, 8));
        }
    });
    
    // Fatura dönemi değiştiğinde sonraki ödeme tarihini güncelle
    $('#fatura_donemi').on('change', function() {
        const today = new Date();
        let nextPayment = new Date();
        
        switch($(this).val()) {
            case '1 Yıllık':
                nextPayment.setFullYear(today.getFullYear() + 1);
                break;
            case '5 Yıllık':
                nextPayment.setFullYear(today.getFullYear() + 5);
                break;
            default:
                nextPayment = null;
                break;
        }
        
        if (nextPayment) {
            const fp = document.querySelector("#sonraki_odeme")._flatpickr;
            fp.setDate(nextPayment);
        }
    });
});
</script>
<?php
ob_end_flush(); // Çıktı tamponlamasını sonlandır
?>