<?php
oturumKontrol();

// Fatura listesini çek
$sorgu = $db->query("
    SELECT 
        f.*,
        m.ad as musteri_ad,
        m.soyad as musteri_soyad,
        m.musteri_turu,
        COALESCE(SUM(o.tutar), 0) as odenen_tutar
    FROM faturalar f
    LEFT JOIN musteriler m ON f.musteri_id = m.id
    LEFT JOIN fatura_odemeleri o ON f.id = o.fatura_id
    GROUP BY f.id
    ORDER BY f.created_at DESC
");
$faturalar = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Mesaj parametresini kontrol et
$mesaj = isset($_GET['mesaj']) ? $_GET['mesaj'] : '';
$mesajMetni = '';
$mesajTuru = '';

switch($mesaj) {
    case 'basarili':
        $mesajMetni = 'Yeni fatura başarıyla oluşturuldu.';
        $mesajTuru = 'success';
        break;
    case 'guncellendi':
        $mesajMetni = 'Fatura başarıyla güncellendi.';
        $mesajTuru = 'success';
        break;
    case 'iptal_edildi':
        $mesajMetni = 'Fatura başarıyla iptal edildi.';
        $mesajTuru = 'success';
        break;
    case 'hata':
        $mesajMetni = 'Bir hata oluştu. Lütfen tekrar deneyin.';
        $mesajTuru = 'danger';
        break;
}
?>

<!-- Bootstrap Icons ve DataTables CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item active" aria-current="page">Faturalar</li>
    </ol>
</nav>

<!-- Mesaj Gösterimi -->
<?php if ($mesajMetni): ?>
<div class="alert alert-<?php echo $mesajTuru; ?> alert-dismissible fade show" role="alert">
    <i class="bi bi-info-circle me-2"></i>
    <?php echo $mesajMetni; ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat"></button>
</div>
<?php endif; ?>

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0">
            <i class="bi bi-receipt me-2"></i>
            Fatura Listesi
        </h5>
        <a href="index.php?sayfa=fatura/ekle" class="btn btn-primary btn-sm">
            <i class="bi bi-plus-circle me-2"></i>
            Yeni Fatura
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table id="faturaTable" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>Fatura No</th>
                        <th>Müşteri</th>
                        <th>Fatura Tarihi</th>
                        <th>Son Ödeme</th>
                        <th>Tutar</th>
                        <th>Ödenen</th>
                        <th>Kalan</th>
                        <th>Durum</th>
                        <th style="min-width: 200px;">İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($faturalar as $fatura): 
                        $kalan_tutar = $fatura['genel_toplam'] - $fatura['odenen_tutar'];
                        $gecikme = strtotime($fatura['son_odeme_tarihi']) < time() && $kalan_tutar > 0;
                    ?>
                    <tr>
                        <td>
                            <a href="index.php?sayfa=fatura/goruntule&id=<?php echo $fatura['id']; ?>" 
                               class="text-decoration-none">
                                <?php echo htmlspecialchars($fatura['fatura_no']); ?>
                            </a>
                        </td>
                        <td>
                            <a href="index.php?sayfa=musteriler/detay&id=<?php echo $fatura['musteri_id']; ?>" 
                               class="text-decoration-none">
                                <?php echo htmlspecialchars($fatura['musteri_ad'] . ' ' . $fatura['musteri_soyad']); ?>
                                <span class="badge <?php echo $fatura['musteri_turu'] == 'Bireysel' ? 'bg-primary' : 'bg-success'; ?>">
                                    <i class="bi <?php echo $fatura['musteri_turu'] == 'Bireysel' ? 'bi-person' : 'bi-building'; ?> me-1"></i>
                                    <?php echo $fatura['musteri_turu']; ?>
                                </span>
                            </a>
                        </td>
                        <td><?php echo date('d.m.Y', strtotime($fatura['fatura_tarihi'])); ?></td>
                        <td>
                            <span class="<?php echo $gecikme ? 'text-danger' : ''; ?>">
                                <?php echo date('d.m.Y', strtotime($fatura['son_odeme_tarihi'])); ?>
                                <?php if ($gecikme): ?>
                                    <br>
                                    <small class="text-danger">
                                        <i class="bi bi-exclamation-triangle-fill me-1"></i>
                                        <?php 
                                        $gun_farki = floor((time() - strtotime($fatura['son_odeme_tarihi'])) / (60 * 60 * 24));
                                        echo $gun_farki . ' gün gecikme';
                                        ?>
                                    </small>
                                <?php endif; ?>
                            </span>
                        </td>
                        <td class="text-end">
                            <?php echo number_format($fatura['genel_toplam'], 2, ',', '.'); ?> ₺
                        </td>
                        <td class="text-end">
                            <?php echo number_format($fatura['odenen_tutar'], 2, ',', '.'); ?> ₺
                        </td>
                        <td class="text-end">
                            <span class="<?php echo $kalan_tutar > 0 ? 'text-danger' : 'text-success'; ?> fw-bold">
                                <?php echo number_format($kalan_tutar, 2, ',', '.'); ?> ₺
                            </span>
                        </td>
                        <td>
                            <?php
                            $durum_class = '';
                            $durum_icon = '';
                            switch($fatura['odeme_durumu']) {
                                case 'Ödendi':
                                    $durum_class = 'bg-success';
                                    $durum_icon = 'bi-check-circle';
                                    break;
                                case 'Kısmi Ödendi':
                                    $durum_class = 'bg-warning';
                                    $durum_icon = 'bi-clock';
                                    break;
                                case 'İptal':
                                    $durum_class = 'bg-danger';
                                    $durum_icon = 'bi-x-circle';
                                    break;
                                default:
                                    $durum_class = $gecikme ? 'bg-danger' : 'bg-secondary';
                                    $durum_icon = $gecikme ? 'bi-exclamation-circle' : 'bi-hourglass';
                            }
                            ?>
                            <span class="badge <?php echo $durum_class; ?>">
                                <i class="bi <?php echo $durum_icon; ?> me-1"></i>
                                <?php echo $fatura['odeme_durumu']; ?>
                            </span>
                        </td>
                        <td>
                            <div class="btn-group">
                                <a href="index.php?sayfa=fatura/goruntule&id=<?php echo $fatura['id']; ?>" 
                                   class="btn btn-primary btn-sm"
                                   data-bs-toggle="tooltip" title="Görüntüle">
                                    <i class="bi bi-eye me-1"></i>
                                    Görüntüle
                                </a>
                                <?php if ($fatura['odeme_durumu'] != 'İptal'): ?>
                                    <a href="index.php?sayfa=fatura/duzenle&id=<?php echo $fatura['id']; ?>" 
                                       class="btn btn-warning btn-sm ms-1"
                                       data-bs-toggle="tooltip" title="Düzenle">
                                        <i class="bi bi-pencil me-1"></i>
                                        Düzenle
                                    </a>
                                    <?php if ($kalan_tutar > 0): ?>
                                        <a href="index.php?sayfa=fatura/odeme_al&id=<?php echo $fatura['id']; ?>" 
                                           class="btn btn-success btn-sm ms-1"
                                           data-bs-toggle="tooltip" title="Ödeme Al">
                                            <i class="bi bi-cash me-1"></i>
                                            Ödeme Al
                                        </a>
                                    <?php endif; ?>
                                    <button type="button" class="btn btn-danger btn-sm ms-1" 
                                            onclick="faturaIptal('<?php echo $fatura['id']; ?>')"
                                            data-bs-toggle="tooltip" title="İptal Et">
                                        <i class="bi bi-x-circle me-1"></i>
                                        İptal Et
                                    </button>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- jQuery ve DataTables JS -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>

<script>
$(document).ready(function() {
    // Tooltips'i aktifleştir
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
    
    // DataTables'ı başlat
    $('#faturaTable').DataTable({
        language: {
            url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/tr.json'
        },
        pageLength: 25,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Tümü"]],
        order: [[2, 'desc']], // Fatura tarihine göre sırala
        responsive: true,
        dom: "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
             "<'row'<'col-sm-12'tr>>" +
             "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        initComplete: function() {
            // Arama kutusuna placeholder ekle
            $('.dataTables_filter input')
                .attr('placeholder', 'Ara...')
                .addClass('form-control-sm');
            
            // Sayfa başına gösterim seçeneğini özelleştir
            $('.dataTables_length select').addClass('form-select-sm');
        }
    });
});

function faturaIptal(id) {
    if (confirm('Bu faturayı iptal etmek istediğinizden emin misiniz?')) {
        window.location.href = 'index.php?sayfa=fatura/iptal&id=' + id;
    }
}
</script>