<?php
ob_start();
oturumKontrol();

if (!isset($_GET['id'])) {
    header("Location: index.php?sayfa=fatura/liste");
    exit;
}

$fatura_id = $_GET['id'];

// Fatura bilgilerini getir
$sorgu = $db->prepare("
    SELECT f.*, m.ad as musteri_ad, m.soyad as musteri_soyad, m.musteri_turu,
           m.telefon, m.eposta, m.adres, m.vergi_dairesi, m.vergi_no, m.tc_kimlik_no
    FROM faturalar f
    LEFT JOIN musteriler m ON f.musteri_id = m.id
    WHERE f.id = ?
");
$sorgu->execute([$fatura_id]);
$fatura = $sorgu->fetch(PDO::FETCH_ASSOC);

if (!$fatura) {
    header("Location: index.php?sayfa=fatura/liste");
    exit;
}

// Fatura kalemlerini getir
$sorgu = $db->prepare("SELECT * FROM fatura_kalemleri WHERE fatura_id = ?");
$sorgu->execute([$fatura_id]);
$kalemler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Fatura ödemelerini getir
$sorgu = $db->prepare("SELECT * FROM fatura_odemeleri WHERE fatura_id = ? ORDER BY odeme_tarihi DESC");
$sorgu->execute([$fatura_id]);
$odemeler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Toplam ödenen tutarı hesapla
$toplam_odenen = 0;
foreach ($odemeler as $odeme) {
    $toplam_odenen += $odeme['tutar'];
}

$kalan_tutar = $fatura['genel_toplam'] - $toplam_odenen;
$gecikme = strtotime($fatura['son_odeme_tarihi']) < time() && $kalan_tutar > 0;
?>

<!-- Bootstrap ve İkonlar -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=fatura/liste">Faturalar</a></li>
        <li class="breadcrumb-item active">Fatura Detayı</li>
    </ol>
</nav>

<div class="row">
    <!-- Fatura Bilgileri -->
    <div class="col-md-8">
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="bi bi-receipt me-2"></i>
                    Fatura Detayı
                </h5>
                <div class="btn-group">
                    <a href="javascript:window.print()" class="btn btn-primary btn-sm">
                        <i class="bi bi-printer me-2"></i>
                        Yazdır
                    </a>
                    <?php if ($fatura['odeme_durumu'] != 'İptal'): ?>
                        <a href="index.php?sayfa=fatura/duzenle&id=<?php echo $fatura_id; ?>" 
                           class="btn btn-warning btn-sm ms-1">
                            <i class="bi bi-pencil me-2"></i>
                            Düzenle
                        </a>
                        <!-- Fatura Gönder butonu eklendi -->
                        <a href="index.php?sayfa=fatura/gonder&id=<?php echo $fatura_id; ?>" 
                           class="btn btn-info btn-sm ms-1">
                            <i class="bi bi-envelope me-2"></i>
                            Fatura Gönder
                        </a>
                        <?php if ($kalan_tutar > 0): ?>
                            <a href="index.php?sayfa=fatura/odeme_al&id=<?php echo $fatura_id; ?>" 
                               class="btn btn-success btn-sm ms-1">
                                <i class="bi bi-cash me-2"></i>
                                Ödeme Al
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
            <div class="card-body">
                <!-- Fatura Başlık Bilgileri -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <h6 class="fw-bold mb-3">Fatura Bilgileri</h6>
                        <table class="table table-sm">
                            <tr>
                                <td class="fw-bold">Fatura No:</td>
                                <td><?php echo htmlspecialchars($fatura['fatura_no']); ?></td>
                            </tr>
                            <tr>
                                <td class="fw-bold">Fatura Tarihi:</td>
                                <td><?php echo date('d.m.Y', strtotime($fatura['fatura_tarihi'])); ?></td>
                            </tr>
                            <tr>
                                <td class="fw-bold">Son Ödeme Tarihi:</td>
                                <td>
                                    <span class="<?php echo $gecikme ? 'text-danger' : ''; ?>">
                                        <?php echo date('d.m.Y', strtotime($fatura['son_odeme_tarihi'])); ?>
                                        <?php if ($gecikme): ?>
                                            <br>
                                            <small class="text-danger">
                                                <i class="bi bi-exclamation-triangle-fill me-1"></i>
                                                <?php 
                                                $gun_farki = floor((time() - strtotime($fatura['son_odeme_tarihi'])) / (60 * 60 * 24));
                                                echo $gun_farki . ' gün gecikme';
                                                ?>
                                            </small>
                                        <?php endif; ?>
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold">Durum:</td>
                                <td>
                                    <?php
                                    $durum_class = '';
                                    $durum_icon = '';
                                    switch($fatura['odeme_durumu']) {
                                        case 'Ödendi':
                                            $durum_class = 'bg-success';
                                            $durum_icon = 'bi-check-circle';
                                            break;
                                        case 'Kısmi Ödendi':
                                            $durum_class = 'bg-warning';
                                            $durum_icon = 'bi-clock';
                                            break;
                                        case 'İptal':
                                            $durum_class = 'bg-danger';
                                            $durum_icon = 'bi-x-circle';
                                            break;
                                        default:
                                            $durum_class = $gecikme ? 'bg-danger' : 'bg-secondary';
                                            $durum_icon = $gecikme ? 'bi-exclamation-circle' : 'bi-hourglass';
                                    }
                                    ?>
                                    <span class="badge <?php echo $durum_class; ?>">
                                        <i class="bi <?php echo $durum_icon; ?> me-1"></i>
                                        <?php echo $fatura['odeme_durumu']; ?>
                                    </span>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <h6 class="fw-bold mb-3">Müşteri Bilgileri</h6>
                        <table class="table table-sm">
                            <tr>
                                <td class="fw-bold">Ad Soyad:</td>
                                <td>
                                    <a href="index.php?sayfa=musteriler/detay&id=<?php echo $fatura['musteri_id']; ?>" 
                                       class="text-decoration-none">
                                        <?php echo htmlspecialchars($fatura['musteri_ad'] . ' ' . $fatura['musteri_soyad']); ?>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold">Müşteri Türü:</td>
                                <td>
                                    <span class="badge <?php echo $fatura['musteri_turu'] == 'Bireysel' ? 'bg-primary' : 'bg-success'; ?>">
                                        <i class="bi <?php echo $fatura['musteri_turu'] == 'Bireysel' ? 'bi-person' : 'bi-building'; ?> me-1"></i>
                                        <?php echo $fatura['musteri_turu']; ?>
                                    </span>
                                </td>
                            </tr>
                            <?php if ($fatura['musteri_turu'] == 'Bireysel' && $fatura['tc_kimlik_no']): ?>
                            <tr>
                                <td class="fw-bold">T.C. Kimlik No:</td>
                                <td><?php echo htmlspecialchars($fatura['tc_kimlik_no']); ?></td>
                            </tr>
                            <?php else: ?>
                            <tr>
                                <td class="fw-bold">Vergi Dairesi:</td>
                                <td><?php echo htmlspecialchars($fatura['vergi_dairesi']); ?></td>
                            </tr>
                            <tr>
                                <td class="fw-bold">Vergi No:</td>
                                <td><?php echo htmlspecialchars($fatura['vergi_no']); ?></td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <td class="fw-bold">Telefon:</td>
                                <td>
                                    <a href="tel:<?php echo htmlspecialchars($fatura['telefon']); ?>" 
                                       class="text-decoration-none">
                                        <?php echo htmlspecialchars($fatura['telefon']); ?>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold">E-posta:</td>
                                <td>
                                    <a href="mailto:<?php echo htmlspecialchars($fatura['eposta']); ?>" 
                                       class="text-decoration-none">
                                        <?php echo htmlspecialchars($fatura['eposta']); ?>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold">Adres:</td>
                                <td><?php echo nl2br(htmlspecialchars($fatura['adres'])); ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
                
                <!-- Fatura Kalemleri -->
                <h6 class="fw-bold mb-3">Fatura Kalemleri</h6>
                <div class="table-responsive mb-4">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Hizmet Türü</th>
                                <th>Açıklama</th>
                                <th class="text-end">Birim</th>
                                <th class="text-end">Miktar</th>
                                <th class="text-end">Birim Fiyat</th>
                                <th class="text-end">Toplam</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($kalemler as $kalem): ?>
                            <tr>
                                <td>
                                    <?php
                                    $hizmet_icon = '';
                                    switch($kalem['hizmet_turu']) {
                                        case 'Domain':
                                            $hizmet_icon = 'bi-globe';
                                            break;
                                        case 'Hosting':
                                            $hizmet_icon = 'bi-hdd-rack';
                                            break;
                                        default:
                                            $hizmet_icon = 'bi-gear';
                                    }
                                    ?>
                                    <i class="bi <?php echo $hizmet_icon; ?> me-1"></i>
                                    <?php echo $kalem['hizmet_turu']; ?>
                                </td>
                                <td><?php echo htmlspecialchars($kalem['aciklama']); ?></td>
                                <td class="text-end"><?php echo htmlspecialchars($kalem['birim']); ?></td>
                                <td class="text-end"><?php echo number_format($kalem['miktar'], 2, ',', '.'); ?></td>
                                <td class="text-end"><?php echo number_format($kalem['birim_fiyat'], 2, ',', '.'); ?> ₺</td>
                                <td class="text-end"><?php echo number_format($kalem['toplam'], 2, ',', '.'); ?> ₺</td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="5" class="text-end fw-bold">Ara Toplam:</td>
                                <td class="text-end fw-bold"><?php echo number_format($fatura['ara_toplam'], 2, ',', '.'); ?> ₺</td>
                            </tr>
                            <tr>
                                <td colspan="5" class="text-end fw-bold">KDV (%<?php echo $fatura['kdv_oran']; ?>):</td>
                                <td class="text-end fw-bold"><?php echo number_format($fatura['kdv_tutar'], 2, ',', '.'); ?> ₺</td>
                            </tr>
                            <tr>
                                <td colspan="5" class="text-end fw-bold">Genel Toplam:</td>
                                <td class="text-end fw-bold"><?php echo number_format($fatura['genel_toplam'], 2, ',', '.'); ?> ₺</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Ödeme Bilgileri -->
    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-cash me-2"></i>
                    Ödeme Durumu
                </h5>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-12">
                        <div class="alert <?php echo $kalan_tutar > 0 ? 'alert-warning' : 'alert-success'; ?>">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h6 class="mb-1">Kalan Tutar</h6>
                                    <h3 class="mb-0">
                                        <?php echo number_format($kalan_tutar, 2, ',', '.'); ?> ₺
                                    </h3>
                                </div>
                                <?php if ($kalan_tutar > 0 && $fatura['odeme_durumu'] != 'İptal'): ?>
                                    <a href="index.php?sayfa=fatura/odeme_al&id=<?php echo $fatura_id; ?>" 
                                       class="btn btn-success">
                                        <i class="bi bi-cash me-2"></i>
                                        Ödeme Al
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-6">
                        <div class="border rounded p-3 text-center">
                            <small class="text-muted d-block mb-1">Fatura Tutarı</small>
                            <h5 class="mb-0"><?php echo number_format($fatura['genel_toplam'], 2, ',', '.'); ?> ₺</h5>
                        </div>
                    </div>
                    
                    <div class="col-6">
                        <div class="border rounded p-3 text-center">
                            <small class="text-muted d-block mb-1">Ödenen Tutar</small>
                            <h5 class="mb-0"><?php echo number_format($toplam_odenen, 2, ',', '.'); ?> ₺</h5>
                        </div>
                    </div>
                </div>
                
                <?php if (!empty($odemeler)): ?>
                    <hr>
                    <h6 class="fw-bold mb-3">Ödeme Geçmişi</h6>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Tarih</th>
                                    <th>Tutar</th>
                                    <th>Yöntem</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($odemeler as $odeme): ?>
                                <tr>
                                    <td><?php echo date('d.m.Y', strtotime($odeme['odeme_tarihi'])); ?></td>
                                    <td class="text-end"><?php echo number_format($odeme['tutar'], 2, ',', '.'); ?> ₺</td>
                                    <td>
                                        <?php
                                        $odeme_icon = '';
                                        switch($odeme['odeme_yontemi']) {
                                            case 'Havale':
                                                $odeme_icon = 'bi-bank';
                                                break;
                                            case 'Kredi Kartı':
                                                $odeme_icon = 'bi-credit-card';
                                                break;
                                            default:
                                                $odeme_icon = 'bi-cash';
                                        }
                                        ?>
                                        <i class="bi <?php echo $odeme_icon; ?> me-1"></i>
                                        <?php echo $odeme['odeme_yontemi']; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Yazdırma Stili -->
<style type="text/css" media="print">
    @page {
        size: auto;
        margin: 10mm;
    }
    
    body {
        background: #fff !important;
    }
    
    .no-print {
        display: none !important;
    }
    
    .card {
        border: none !important;
        box-shadow: none !important;
    }
    
    .card-header {
        background: none !important;
        border-bottom: 2px solid #000 !important;
        padding-left: 0 !important;
        padding-right: 0 !important;
    }
    
    .breadcrumb,
    .btn-group,
    .alert {
        display: none !important;
    }
    
    .table {
        border-color: #000 !important;
    }
    
    .table th,
    .table td {
        border-color: #000 !important;
    }
</style>

<?php ob_end_flush(); ?>