<?php
ob_start();
oturumKontrol();

// Get notification settings
$sorgu = $db->query("SELECT * FROM bildirim_ayarlar LIMIT 1");
$bildirim_ayarlar = $sorgu->fetch(PDO::FETCH_ASSOC) ?: [];

// Get invoice notification template
$sorgu = $db->query("SELECT * FROM bildirim_sablon WHERE tur = 'fatura' AND otomatik = 1 LIMIT 1");
$sablon = $sorgu->fetch(PDO::FETCH_ASSOC) ?: [];

if (!isset($_GET['id'])) {
    header("Location: index.php?sayfa=fatura/liste");
    exit;
}

$fatura_id = $_GET['id'];
$hata = '';
$basarili = '';

// Get invoice information
$sorgu = $db->prepare("
    SELECT f.*, m.ad as musteri_ad, m.soyad as musteri_soyad, m.musteri_turu,
           m.telefon, m.eposta, m.adres, m.vergi_dairesi, m.vergi_no, m.tc_kimlik_no
    FROM faturalar f
    LEFT JOIN musteriler m ON f.musteri_id = m.id
    WHERE f.id = ?
");
$sorgu->execute([$fatura_id]);
$fatura = $sorgu->fetch(PDO::FETCH_ASSOC);

if (!$fatura) {
    header("Location: index.php?sayfa=fatura/liste");
    exit;
}

// Get invoice items
$sorgu = $db->prepare("SELECT * FROM fatura_kalemleri WHERE fatura_id = ?");
$sorgu->execute([$fatura_id]);
$kalemler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Helper functions for notification logging
function logBildirim($data) {
    global $db;
    
    $sorgu = $db->prepare("INSERT INTO bildirim_log 
        (tur, alici, baslik, icerik, durum) 
        VALUES (?, ?, ?, ?, 'failed')");
    
    $sorgu->execute([
        $data['tur'],
        $data['alici'],
        $data['baslik'],
        $data['icerik']
    ]);
    
    return $db->lastInsertId();
}

function updateBildirimLog($id, $durum, $hata_mesaji = null) {
    global $db;
    
    $sorgu = $db->prepare("UPDATE bildirim_log SET 
        durum = ?, 
        hata_mesaji = ? 
        WHERE id = ?");
    
    $sorgu->execute([
        $durum ? 'success' : 'failed',
        $hata_mesaji,
        $id
    ]);
}

// UUID generation function
function generateUUID() {
    return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        mt_rand(0, 0xffff), mt_rand(0, 0xffff),
        mt_rand(0, 0xffff),
        mt_rand(0, 0x0fff) | 0x4000,
        mt_rand(0, 0x3fff) | 0x8000,
        mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
    );
}

// Create PDF function
function createPDF($fatura, $kalemler) {
    require_once('inc/tcpdf/tcpdf.php');
    
    // TCPDF configuration
    class MYPDF extends TCPDF {
        public function Header() {
            // Empty header - can be customized
        }
        
        public function Footer() {
            // Footer text
            $this->SetY(-15);
            $this->SetFont('dejavusans', 'I', 8);
            $this->Cell(0, 10, 'Sayfa '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C');
        }
    }
    
    // Create PDF
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    
    // PDF meta data
    $pdf->SetCreator('Hosting Yönetim Sistemi');
    $pdf->SetAuthor('Epifiz Web Ajans - Cem T. Elbaşı');
    $pdf->SetTitle('Fatura #' . $fatura['fatura_no']);
    
    // Default header/footer settings
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(true);
    
    // Font settings
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins(15, 15, 15);
    
    // Page settings
    $pdf->AddPage();
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    
    // Company logo (if exists)
    // $pdf->Image('logo.png', 15, 15, 50);
    
    // Company information
    $pdf->SetFont('dejavusans', 'B', 14);
    $pdf->Cell(0, 10, 'Epifiz Web Ajans - Cem T. Elbaşı', 0, 1, 'L');
    $pdf->SetFont('dejavusans', '', 10);
    $pdf->Cell(0, 6, 'Adres: Yeşilce Mh. Yasin Sok No: 11 Kağıthane / İstanbul', 0, 1, 'L');
    $pdf->Cell(0, 6, 'Tel: +90 5347771169', 0, 1, 'L');
    $pdf->Cell(0, 6, 'E-posta: bilgi@epifizajans.com', 0, 1, 'L');
    
    // Invoice header
    $pdf->Ln(10);
    $pdf->SetFont('dejavusans', 'B', 16);
    $pdf->Cell(0, 10, 'FATURA', 0, 1, 'C');
    $pdf->SetFont('dejavusans', '', 10);
    $pdf->Cell(0, 6, 'Fatura No: ' . $fatura['fatura_no'], 0, 1, 'R');
    $pdf->Cell(0, 6, 'Tarih: ' . date('d.m.Y', strtotime($fatura['fatura_tarihi'])), 0, 1, 'R');
    
    // Customer information
    $pdf->Ln(5);
    $pdf->SetFont('dejavusans', 'B', 12);
    $pdf->Cell(0, 8, 'FATURA ADRESİ', 0, 1, 'L');
    $pdf->SetFont('dejavusans', '', 10);
    $pdf->Cell(0, 6, $fatura['musteri_ad'] . ' ' . $fatura['musteri_soyad'], 0, 1, 'L');
    
    if ($fatura['musteri_turu'] == 'Kurumsal') {
        $pdf->Cell(0, 6, 'Vergi Dairesi: ' . $fatura['vergi_dairesi'], 0, 1, 'L');
        $pdf->Cell(0, 6, 'Vergi No: ' . $fatura['vergi_no'], 0, 1, 'L');
    } else {
        $pdf->Cell(0, 6, 'T.C. Kimlik No: ' . $fatura['tc_kimlik_no'], 0, 1, 'L');
    }
    
    $pdf->MultiCell(0, 6, $fatura['adres'], 0, 'L');
    $pdf->Cell(0, 6, 'Tel: ' . $fatura['telefon'], 0, 1, 'L');
    $pdf->Cell(0, 6, 'E-posta: ' . $fatura['eposta'], 0, 1, 'L');
    
    // Invoice items table
    $pdf->Ln(10);
    $pdf->SetFont('dejavusans', 'B', 10);
    
    // Table headers
    $w = array(60, 25, 25, 30, 35);
    $pdf->SetFillColor(240, 240, 240);
    $pdf->Cell($w[0], 7, 'Açıklama', 1, 0, 'C', true);
    $pdf->Cell($w[1], 7, 'Birim', 1, 0, 'C', true);
    $pdf->Cell($w[2], 7, 'Miktar', 1, 0, 'C', true);
    $pdf->Cell($w[3], 7, 'Birim Fiyat', 1, 0, 'C', true);
    $pdf->Cell($w[4], 7, 'Toplam', 1, 1, 'C', true);
    
    // Table content
    $pdf->SetFont('dejavusans', '', 10);
    $fill = false;
    foreach ($kalemler as $kalem) {
		// Açıklama alanındaki metni yazdırmadan önce yüksekliğini hesaplayın
		$cellHeight = $pdf->getStringHeight($w[0], $kalem['aciklama']);
		
		// Yüksekliği diğer hücreler için de kullanmak üzere hesaplayın
		$rowHeight = max($cellHeight, 6); // 6 varsayılan satır yüksekliği

		// Açıklama hücresi
		$pdf->MultiCell($w[0], $rowHeight, $kalem['aciklama'], 1, 'L', $fill, 0);
		
		// Diğer hücreleri aynı yükseklikle hizalayın
		$pdf->Cell($w[1], $rowHeight, $kalem['birim'], 1, 0, 'C', $fill);
		$pdf->Cell($w[2], $rowHeight, number_format($kalem['miktar'], 2, ',', '.'), 1, 0, 'R', $fill);
		$pdf->Cell($w[3], $rowHeight, number_format($kalem['birim_fiyat'], 2, ',', '.') . ' ₺', 1, 0, 'R', $fill);
		$pdf->Cell($w[4], $rowHeight, number_format($kalem['toplam'], 2, ',', '.') . ' ₺', 1, 1, 'R', $fill);

		$fill = !$fill;
	}
    
    // Totals
    $pdf->SetFont('dejavusans', 'B', 10);
    $pdf->Cell(array_sum($w) - $w[4], 6, 'Ara Toplam:', 1, 0, 'R');
    $pdf->Cell($w[4], 6, number_format($fatura['ara_toplam'], 2, ',', '.') . ' ₺', 1, 1, 'R');
    
    $pdf->Cell(array_sum($w) - $w[4], 6, 'KDV (%' . $fatura['kdv_oran'] . '):', 1, 0, 'R');
    $pdf->Cell($w[4], 6, number_format($fatura['kdv_tutar'], 2, ',', '.') . ' ₺', 1, 1, 'R');
    
    $pdf->SetFillColor(220, 220, 220);
    $pdf->Cell(array_sum($w) - $w[4], 6, 'Genel Toplam:', 1, 0, 'R', true);
    $pdf->Cell($w[4], 6, number_format($fatura['genel_toplam'], 2, ',', '.') . ' ₺', 1, 1, 'R', true);
    
    // Bank information
    $pdf->Ln(10);
    $pdf->SetFont('dejavusans', 'B', 10);
    $pdf->Cell(0, 6, 'Banka Hesap Bilgileri:', 0, 1, 'L');
    $pdf->SetFont('dejavusans', '', 10);
    $pdf->Cell(0, 6, 'Banka: Ziraat Bankası', 0, 1, 'L');
    $pdf->Cell(0, 6, 'IBAN: TR70 0001 0014 8565 2498 5050 01', 0, 1, 'L');
    
    // Final notes
    $pdf->Ln(10);
    $pdf->SetFont('dejavusans', '', 8);
    $pdf->MultiCell(0, 4, 'Not: Banka havalesi ile ödeme yaparsanız dekontu bilgi@epifizajans.com adresine mail ile göndermenizi rica ederiz', 0, 'L');
    
    return $pdf;
}

// Process form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        // Create PDF
        $pdf = createPDF($fatura, $kalemler);
        $pdf_content = $pdf->Output('', 'S');
        
        // Create online payment record
        $online_odeme_id = generateUUID();
        $sorgu = $db->prepare("INSERT INTO online_odemeler (id, fatura_id, tutar) VALUES (?, ?, ?)");
        $sorgu->execute([$online_odeme_id, $fatura_id, $fatura['genel_toplam']]);
        
        // Create online payment link
        $online_odeme_link = SITE_URL . "/odeme.php?id=" . $online_odeme_id;
        
        if ($bildirim_ayarlar && $sablon) {
            // Replace template variables
            $email_content = $sablon['icerik'];
            $sms_content = $sablon['sms_icerik'];
            
            $variables = [
                '{AD}' => $fatura['musteri_ad'],
                '{SOYAD}' => $fatura['musteri_soyad'],
                '{FATURA_NO}' => $fatura['fatura_no'],
                '{TUTAR}' => number_format($fatura['genel_toplam'], 2, ',', '.'),
                '{FATURA_TARIHI}' => date('d.m.Y', strtotime($fatura['fatura_tarihi'])),
                '{SON_ODEME_TARIHI}' => date('d.m.Y', strtotime($fatura['son_odeme_tarihi'])),
                '{ODEME_LINK}' => $online_odeme_link
            ];
            
            foreach ($variables as $key => $value) {
                $email_content = str_replace($key, $value, $email_content);
                $sms_content = str_replace($key, $value, $sms_content);
            }
            
            // Send email
            require_once $_SERVER['DOCUMENT_ROOT'] . '/yonetim/inc/phpmailer/PHPMailer.php';
			require_once $_SERVER['DOCUMENT_ROOT'] . '/yonetim/inc/phpmailer/SMTP.php';
			require_once $_SERVER['DOCUMENT_ROOT'] . '/yonetim/inc/phpmailer/Exception.php';
            
            $mail = new PHPMailer\PHPMailer\PHPMailer(true);
            
            try {
                // Server settings
                $mail->isSMTP();
                $mail->Host = $bildirim_ayarlar['smtp_host'];
                $mail->SMTPAuth = true;
                $mail->Username = $bildirim_ayarlar['smtp_user'];
                $mail->Password = $bildirim_ayarlar['smtp_pass'];
                $mail->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
                $mail->Port = $bildirim_ayarlar['smtp_port'];
                $mail->CharSet = 'UTF-8';
                
                // Sender and recipient
                $mail->setFrom($bildirim_ayarlar['smtp_from'], $bildirim_ayarlar['smtp_from_name']);
                $mail->addAddress($fatura['eposta']);
                
                // Content
                $mail->isHTML(true);
                $mail->Subject = $sablon['baslik'];
                $mail->Body = $email_content;
                
                // Add PDF attachment
                $mail->addStringAttachment($pdf_content, 'fatura.pdf');
                
                // Log before sending
                $log_data = [
                    'tur' => 'email',
                    'alici' => $fatura['eposta'],
                    'baslik' => $sablon['baslik'],
                    'icerik' => $email_content,
                    'durum' => 'pending'
                ];
                
                $log_id = logBildirim($log_data);
                
                // Send email
                $success = $mail->send();
                
                // Update log
                updateBildirimLog($log_id, $success ? 'success' : 'failed', $success ? null : $mail->ErrorInfo);
                
                // Send SMS if enabled
                if ($success && $bildirim_ayarlar['sms_user'] && $bildirim_ayarlar['sms_pass']) {
                    // NetGSM API
                    $url = "https://api.netgsm.com.tr/sms/send/get";
                    $params = array(
                        'usercode' => $bildirim_ayarlar['sms_user'],
                        'password' => $bildirim_ayarlar['sms_pass'],
                        'gsmno' => $fatura['telefon'],
                        'message' => $sms_content,
                        'msgheader' => $bildirim_ayarlar['sms_header'],
                        'dil' => 'TR'
                    );
                    
                    // Log SMS before sending
                    $sms_log_data = [
                        'tur' => 'sms',
                        'alici' => $fatura['telefon'],
                        'baslik' => $bildirim_ayarlar['sms_header'],
                        'icerik' => $sms_content,
                        'durum' => 'pending'
                    ];
                    
                    $sms_log_id = logBildirim($sms_log_data);
                    
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url . '?' . http_build_query($params));
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    
                    $response = curl_exec($ch);
                    $error = curl_error($ch);
                    curl_close($ch);
                    
                    if ($error) {
                        updateBildirimLog($sms_log_id, 'failed', $error);
                    } else {
                        $code = substr($response, 0, 2);
                        $sms_success = $code == '00';
                        updateBildirimLog($sms_log_id, $sms_success ? 'success' : 'failed', $sms_success ? null : 'SMS gönderilemedi: Kod ' . $code);
                    }
                }
                
                $basarili = 'Fatura başarıyla gönderildi.';
                
            } catch (Exception $e) {
                if (isset($log_id)) {
                    updateBildirimLog($log_id, 'failed', $e->getMessage());
                }
                $hata = 'E-posta gönderilemedi: ' . $e->getMessage();
            }
        } else {
            $hata = 'Bildirim ayarları veya şablonu bulunamadı.';
        }
        
    } catch (Exception $e) {
        $hata = "Bir hata oluştu: " . $e->getMessage();
    }
}
?>

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=fatura/liste">Faturalar</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=fatura/goruntule&id=<?php echo $fatura_id; ?>">Fatura Detayı</a></li>
        <li class="breadcrumb-item active">Fatura Gönder</li>
    </ol>
</nav>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-envelope me-2"></i>
            Fatura Gönder
            <small class="text-muted">(<?php echo htmlspecialchars($fatura['fatura_no']); ?>)</small>
        </h5>
    </div>
    <div class="card-body">
        <?php if ($hata): ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                <?php echo $hata; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($basarili): ?>
            <div class="alert alert-success">
                <i class="bi bi-check-circle-fill me-2"></i>
                <?php echo $basarili; ?>
            </div>
        <?php endif; ?>
        
        <div class="row">
            <div class="col-md-6">
                <h6 class="fw-bold mb-3">Fatura Bilgileri</h6>
                <table class="table table-sm">
                    <tr>
                        <td class="fw-bold">Fatura No:</td>
                        <td><?php echo htmlspecialchars($fatura['fatura_no']); ?></td>
                    </tr>
                    <tr>
                        <td class="fw-bold">Fatura Tarihi:</td>
                        <td><?php echo date('d.m.Y', strtotime($fatura['fatura_tarihi'])); ?></td>
                    </tr>
                    <tr>
                        <td class="fw-bold">Tutar:</td>
                        <td><?php echo number_format($fatura['genel_toplam'], 2, ',', '.'); ?> ₺</td>
                    </tr>
                </table>
            </div>
            
            <div class="col-md-6">
                <h6 class="fw-bold mb-3">Müşteri Bilgileri</h6>
                <table class="table table-sm">
                    <tr>
                        <td class="fw-bold">Ad Soyad:</td>
                        <td><?php echo htmlspecialchars($fatura['musteri_ad'] . ' ' . $fatura['musteri_soyad']); ?></td>
                    </tr>
                    <tr>
                        <td class="fw-bold">E-posta:</td>
                        <td><?php echo htmlspecialchars($fatura['eposta']); ?></td>
                    </tr>
                    <tr>
                        <td class="fw-bold">Telefon:</td>
                        <td><?php echo htmlspecialchars($fatura['telefon']); ?></td>
                    </tr>
                </table>
            </div>
        </div>
        
        <hr>
        
        <form method="POST" action="" class="mt-4">
            <div class="alert alert-info">
                <i class="bi bi-info-circle-fill me-2"></i>
                Fatura PDF olarak oluşturulup müşterinin e-posta adresine gönderilecektir.
            </div>
            
            <div class="mt-4">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-envelope me-2"></i>
                    Faturayı Gönder
                </button>
                <a href="index.php?sayfa=fatura/goruntule&id=<?php echo $fatura_id; ?>" class="btn btn-secondary">
                    <i class="bi bi-x-circle me-2"></i>
                    İptal
                </a>
            </div>
        </form>
    </div>
</div>