<?php
ob_start();
oturumKontrol();

// Get total customers count
$musteri_sorgu = $db->query("SELECT 
    COUNT(*) as toplam,
    COUNT(CASE WHEN musteri_turu = 'Bireysel' THEN 1 END) as bireysel,
    COUNT(CASE WHEN musteri_turu = 'Kurumsal' THEN 1 END) as kurumsal,
    COUNT(CASE WHEN created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY) THEN 1 END) as yeni
    FROM musteriler");
$musteri_sayilari = $musteri_sorgu->fetch(PDO::FETCH_ASSOC);

// Get hosting accounts statistics
$hosting_sorgu = $db->query("SELECT 
    COUNT(*) as toplam,
    COUNT(CASE WHEN durum = 'Aktif' THEN 1 END) as aktif,
    COUNT(CASE WHEN durum = 'Askıda' THEN 1 END) as askida,
    SUM(CASE WHEN durum = 'Aktif' AND fatura_donemi != 'Ücretsiz' THEN fiyat ELSE 0 END) as aylik_gelir
    FROM hosting_hesaplari");
$hosting_sayilari = $hosting_sorgu->fetch(PDO::FETCH_ASSOC);

// Get domain statistics
$domain_sorgu = $db->query("SELECT 
    COUNT(*) as toplam,
    COUNT(CASE WHEN durum = 'Aktif' THEN 1 END) as aktif,
    COUNT(CASE WHEN durum = 'Transfer' THEN 1 END) as transfer,
    COUNT(CASE WHEN bitis_tarihi <= DATE_ADD(CURDATE(), INTERVAL 30 DAY) THEN 1 END) as yakinda_bitecek
    FROM domain_kayitlar");
$domain_sayilari = $domain_sorgu->fetch(PDO::FETCH_ASSOC);

// Get invoice statistics
$fatura_sorgu = $db->query("SELECT 
    COUNT(*) as toplam,
    COUNT(CASE WHEN odeme_durumu = 'Ödenmedi' THEN 1 END) as odenmemis,
    COUNT(CASE WHEN odeme_durumu = 'Kısmi Ödendi' THEN 1 END) as kismi_odenen,
    SUM(CASE WHEN odeme_durumu IN ('Ödenmedi', 'Kısmi Ödendi') THEN genel_toplam ELSE 0 END) as toplam_borc,
    SUM(CASE WHEN fatura_tarihi >= DATE_SUB(CURDATE(), INTERVAL 30 DAY) THEN genel_toplam ELSE 0 END) as aylik_ciro
    FROM faturalar 
    WHERE odeme_durumu != 'İptal'");
$fatura_sayilari = $fatura_sorgu->fetch(PDO::FETCH_ASSOC);

// Get recent activities
$aktiviteler_sorgu = $db->query("(
        SELECT 
            'musteri' as tur,
            CONCAT(ad, ' ', soyad) as baslik,
            musteri_turu as detay,
            created_at as tarih
        FROM musteriler 
        ORDER BY created_at DESC 
        LIMIT 5
    ) UNION ALL (
        SELECT 
            'hosting' as tur,
            domain as baslik,
            paket as detay,
            created_at as tarih
        FROM hosting_hesaplari 
        ORDER BY created_at DESC 
        LIMIT 5
    ) UNION ALL (
        SELECT 
            'domain' as tur,
            domain as baslik,
            durum as detay,
            created_at as tarih
        FROM domain_kayitlar 
        ORDER BY created_at DESC 
        LIMIT 5
    ) ORDER BY tarih DESC LIMIT 3");
$aktiviteler = $aktiviteler_sorgu->fetchAll(PDO::FETCH_ASSOC);

// Get upcoming renewals
$yenilemeler_sorgu = $db->query("(
        SELECT 
            'hosting' as tur,
            domain as baslik,
            sonraki_odeme as tarih,
            fiyat as tutar
        FROM hosting_hesaplari 
        WHERE durum = 'Aktif' 
        AND sonraki_odeme IS NOT NULL 
        AND sonraki_odeme <= DATE_ADD(CURDATE(), INTERVAL 30 DAY)
    ) UNION ALL (
        SELECT 
            'domain' as tur,
            domain as baslik,
            bitis_tarihi as tarih,
            0 as tutar
        FROM domain_kayitlar 
        WHERE durum = 'Aktif' 
        AND bitis_tarihi <= DATE_ADD(CURDATE(), INTERVAL 30 DAY)
    ) ORDER BY tarih ASC LIMIT 10");
$yenilemeler = $yenilemeler_sorgu->fetchAll(PDO::FETCH_ASSOC);

// Son 12 aylık gelir trendi için sorgu
$gelir_trendi_sorgu = $db->query("
    SELECT 
        DATE_FORMAT(fatura_tarihi, '%Y-%m') as ay,
        SUM(genel_toplam) as toplam
    FROM faturalar 
    WHERE fatura_tarihi >= DATE_SUB(CURDATE(), INTERVAL 12 MONTH)
    AND odeme_durumu != 'İptal'
    GROUP BY DATE_FORMAT(fatura_tarihi, '%Y-%m')
    ORDER BY ay ASC
");
$gelir_trendi = $gelir_trendi_sorgu->fetchAll(PDO::FETCH_ASSOC);

// Sunucu durumları için sorgu
$sunucu_sorgu = $db->query("
    SELECT s.*, 
           COUNT(h.id) as hosting_sayisi,
           SUM(CASE WHEN h.durum = 'Aktif' THEN 1 ELSE 0 END) as aktif_hosting
    FROM sunucular s
    LEFT JOIN hosting_hesaplari h ON s.id = h.sunucu_id
    GROUP BY s.id
");
$sunucular = $sunucu_sorgu->fetchAll(PDO::FETCH_ASSOC);

// Kritik görevler için sorgu
$gorevler_sorgu = $db->query("
    SELECT 'domain_bitis' as tur, domain as baslik, bitis_tarihi as tarih
    FROM domain_kayitlar
    WHERE durum = 'Aktif' AND bitis_tarihi <= DATE_ADD(CURDATE(), INTERVAL 30 DAY)
    UNION ALL
    SELECT 'hosting_odeme' as tur, domain as baslik, sonraki_odeme as tarih
    FROM hosting_hesaplari
    WHERE durum = 'Aktif' AND sonraki_odeme <= DATE_ADD(CURDATE(), INTERVAL 30 DAY)
    UNION ALL
    SELECT 'geciken_fatura' as tur, fatura_no as baslik, son_odeme_tarihi as tarih
    FROM faturalar
    WHERE odeme_durumu IN ('Ödenmedi', 'Kısmi Ödendi') 
    AND son_odeme_tarihi < CURDATE()
    ORDER BY tarih ASC
    LIMIT 10
");
$kritik_gorevler = $gorevler_sorgu->fetchAll(PDO::FETCH_ASSOC);

// Ödeme yöntemlerine göre dağılım
$odeme_dagilim_sorgu = $db->query("
    SELECT 
        odeme_yontemi,
        COUNT(*) as adet,
        SUM(tutar) as toplam
    FROM fatura_odemeleri
    WHERE created_at >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)
    GROUP BY odeme_yontemi
");
$odeme_dagilimi = $odeme_dagilim_sorgu->fetchAll(PDO::FETCH_ASSOC);

?>

<!-- Page Title -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="bi bi-speedometer2 me-2"></i>
        Kontrol Paneli
    </h1>
    <div class="btn-group">
        <a href="index.php?sayfa=sync/cron" class="btn btn-primary">
            <i class="bi bi-arrow-repeat me-2"></i>
            Otomatik İşlemler
        </a>
        <a href="index.php?sayfa=sync/index" class="btn btn-success">
            <i class="bi bi-cloud-arrow-down me-2"></i>
            Senkronizasyon
        </a>
    </div>
</div>

<!-- Overview Cards -->
<div class="row">
    <!-- Customers Card -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-primary h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Müşteriler</div>
                        <div class="h5 mb-0 font-weight-bold"><?php echo $musteri_sayilari['toplam']; ?></div>
                        <div class="text-muted small mt-2">
                            <?php echo $musteri_sayilari['bireysel']; ?> Bireysel, 
                            <?php echo $musteri_sayilari['kurumsal']; ?> Kurumsal
                        </div>
                    </div>
                    <div class="bg-primary bg-opacity-10 rounded-3 p-3">
                        <i class="bi bi-people text-primary display-6"></i>
                    </div>
                </div>
                <div class="mt-3">
                    <span class="text-success">
                        <i class="bi bi-graph-up"></i>
                        <?php echo $musteri_sayilari['yeni']; ?> yeni müşteri
                    </span>
                    <span class="text-muted">(son 30 gün)</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Hosting Card -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-success h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Hosting Hesapları</div>
                        <div class="h5 mb-0 font-weight-bold"><?php echo $hosting_sayilari['toplam']; ?></div>
                        <div class="text-muted small mt-2">
                            <?php echo $hosting_sayilari['aktif']; ?> Aktif, 
                            <?php echo $hosting_sayilari['askida']; ?> Askıda
                        </div>
                    </div>
                    <div class="bg-success bg-opacity-10 rounded-3 p-3">
                        <i class="bi bi-hdd-rack text-success display-6"></i>
                    </div>
                </div>
                <div class="mt-3">
                    <span class="text-success">
                        <i class="bi bi-currency-dollar"></i>
                        <?php echo number_format($hosting_sayilari['aylik_gelir'] ?? 0, 2, ',', '.'); ?> ₺
                    </span>
                    <span class="text-muted">aylık gelir</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Domains Card -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-info h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Domain Kayıtları</div>
                        <div class="h5 mb-0 font-weight-bold"><?php echo $domain_sayilari['toplam']; ?></div>
                        <div class="text-muted small mt-2">
                            <?php echo $domain_sayilari['aktif']; ?> Aktif, 
                            <?php echo $domain_sayilari['transfer']; ?> Transfer
                        </div>
                    </div>
                    <div class="bg-info bg-opacity-10 rounded-3 p-3">
                        <i class="bi bi-globe text-info display-6"></i>
                    </div>
                </div>
                <div class="mt-3">
                    <span class="text-warning">
                        <i class="bi bi-exclamation-triangle"></i>
                        <?php echo $domain_sayilari['yakinda_bitecek']; ?> domain
                    </span>
                    <span class="text-muted">yakında bitecek</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Invoices Card -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-warning h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Faturalar</div>
                        <div class="h5 mb-0 font-weight-bold"><?php echo $fatura_sayilari['toplam']; ?></div>
                        <div class="text-muted small mt-2">
                            <?php echo $fatura_sayilari['odenmemis']; ?> Ödenmemiş, 
                            <?php echo $fatura_sayilari['kismi_odenen']; ?> Kısmi
                        </div>
                    </div>
                    <div class="bg-warning bg-opacity-10 rounded-3 p-3">
                        <i class="bi bi-receipt text-warning display-6"></i>
                    </div>
                </div>
                <div class="mt-3">
                    <span class="text-danger">
                        <i class="bi bi-cash"></i>
                        <?php echo number_format($fatura_sayilari['toplam_borc'] ?? 0, 2, ',', '.'); ?> ₺
                    </span>
                    <span class="text-muted">toplam borç</span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Content Row -->
<div class="row">
    <!-- Recent Activities -->
    <div class="col-xl-8 col-lg-7">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-activity me-2"></i>
                    Son Aktiviteler
                </h5>
            </div>
            <div class="card-body">
                <div class="timeline">
                    <?php foreach ($aktiviteler as $aktivite): ?>
                    <div class="timeline-item">
                        <?php
                        $icon = '';
                        $color = '';
                        switch($aktivite['tur']) {
                            case 'musteri':
                                $icon = 'bi-person';
                                $color = 'text-primary';
                                break;
                            case 'hosting':
                                $icon = 'bi-hdd';
                                $color = 'text-success';
                                break;
                            case 'domain':
                                $icon = 'bi-globe';
                                $color = 'text-info';
                                break;
                        }
                        ?>
                        <div class="timeline-icon <?php echo $color; ?>">
                            <i class="bi <?php echo $icon; ?>"></i>
                        </div>
                        <div class="timeline-content">
                            <h6 class="mb-1"><?php echo htmlspecialchars($aktivite['baslik']); ?></h6>
                            <p class="mb-0 text-muted">
                                <?php echo htmlspecialchars($aktivite['detay']); ?>
                                <small class="float-end">
                                    <?php echo date('d.m.Y H:i', strtotime($aktivite['tarih'])); ?>
                                </small>
                            </p>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Upcoming Renewals -->
    <div class="col-xl-4 col-lg-5">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-calendar-event me-2"></i>
                    Yaklaşan Yenilemeler
                </h5>
            </div>
            <div class="card-body">
                <?php if (empty($yenilemeler)): ?>
                    <div class="alert alert-info mb-0">
                        <i class="bi bi-info-circle me-2"></i>
                        Yaklaşan yenileme bulunmamaktadır.
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Hizmet</th>
                                    <th>Tarih</th>
                                    <th>Kalan</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($yenilemeler as $yenileme): 
                                    $tarih = new DateTime($yenileme['tarih']);
                                    $bugun = new DateTime();
                                    $fark = $bugun->diff($tarih);
                                    $gecmis = $tarih < $bugun;
                                ?>
                                <tr>
                                    <td>
                                        <i class="bi <?php echo $yenileme['tur'] == 'hosting' ? 'bi-hdd text-success' : 'bi-globe text-info'; ?> me-2"></i>
                                        <?php echo htmlspecialchars($yenileme['baslik']); ?>
                                    </td>
                                    <td><?php echo date('d.m.Y', strtotime($yenileme['tarih'])); ?></td>
                                    <td>
                                        <span class="<?php echo $gecmis ? 'text-danger' : 'text-success'; ?>">
                                            <?php
                                            if ($gecmis) {
                                                echo $fark->days . ' gün gecikmiş';
                                            } else {
                                                echo $fark->days . ' gün kaldı';
                                            }
                                            ?>
                                        </span>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Monthly Revenue Chart -->
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-graph-up me-2"></i>
                    Aylık Ciro
                </h5>
            </div>
            <div class="card-body text-center">
                <h3 class="mb-0">
                    <?php echo number_format($fatura_sayilari['aylik_ciro'] ?? 0, 2, ',', '.'); ?> ₺
                </h3>
                <p class="text-muted">Son 30 günlük toplam</p>
                <hr>
                <div class="row text-center">
                    <div class="col-6">
                        <h5><?php echo number_format($hosting_sayilari['aylik_gelir'] ?? 0, 2, ',', '.'); ?> ₺</h5>
                        <p class="text-muted mb-0">Hosting Gelirleri</p>
                    </div>
                    <div class="col-6">
                        <h5><?php echo number_format($fatura_sayilari['toplam_borc'] ?? 0, 2, ',', '.'); ?> ₺</h5>
                        <p class="text-muted mb-0">Bekleyen Ödemeler</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Sunucu Durumu ve Kritik Görevler -->
<div class="row">
    <!-- Sunucu Durumu -->
    <div class="col-xl-6 col-lg-6">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-hdd-rack me-2"></i>
                    Sunucu Durumu
                </h5>
            </div>
            <div class="card-body">
                <?php foreach ($sunucular as $sunucu): 
                    $uptime = @fsockopen($sunucu['ip_adresi'], 80, $errno, $errstr, 2);
                ?>
                <div class="server-status mb-3">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <div>
                            <h6 class="mb-0"><?php echo htmlspecialchars($sunucu['sunucu_adi']); ?></h6>
                            <small class="text-muted"><?php echo htmlspecialchars($sunucu['ip_adresi']); ?></small>
                        </div>
                        <span class="badge <?php echo $uptime ? 'bg-success' : 'bg-danger'; ?>">
                            <?php echo $uptime ? 'Aktif' : 'Kapalı'; ?>
                        </span>
                    </div>
                    <div class="progress" style="height: 5px;">
                        <div class="progress-bar <?php echo $uptime ? 'bg-success' : 'bg-danger'; ?>" 
                             style="width: <?php echo ($sunucu['aktif_hosting'] / max(1, $sunucu['hosting_sayisi'])) * 100; ?>%">
                        </div>
                    </div>
                    <div class="d-flex justify-content-between mt-1">
                        <small class="text-muted">
                            <?php echo $sunucu['aktif_hosting']; ?> aktif / 
                            <?php echo $sunucu['hosting_sayisi']; ?> toplam hosting
                        </small>
                        <small class="text-muted">
                            <?php echo $uptime ? 'Çalışıyor' : 'Erişilemiyor'; ?>
                        </small>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <!-- Kritik Görevler -->
    <div class="col-xl-6 col-lg-6">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    Kritik Görevler
                </h5>
            </div>
            <div class="card-body">
                <?php if (empty($kritik_gorevler)): ?>
                    <div class="alert alert-success mb-0">
                        <i class="bi bi-check-circle me-2"></i>
                        Kritik görev bulunmamaktadır.
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Görev</th>
                                    <th>Tarih</th>
                                    <th>Durum</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($kritik_gorevler as $gorev): 
                                    $tarih = new DateTime($gorev['tarih']);
                                    $bugun = new DateTime();
                                    $fark = $bugun->diff($tarih);
                                    $gecmis = $tarih < $bugun;
                                ?>
                                <tr>
                                    <td>
                                        <?php
                                        switch($gorev['tur']) {
                                            case 'domain_bitis':
                                                echo '<i class="bi bi-globe text-info me-2"></i>';
                                                echo 'Domain Bitiş: ' . $gorev['baslik'];
                                                break;
                                            case 'hosting_odeme':
                                                echo '<i class="bi bi-hdd text-success me-2"></i>';
                                                echo 'Hosting Ödemesi: ' . $gorev['baslik'];
                                                break;
                                            case 'geciken_fatura':
                                                echo '<i class="bi bi-receipt text-danger me-2"></i>';
                                                echo 'Geciken Fatura: ' . $gorev['baslik'];
                                                break;
                                        }
                                        ?>
                                    </td>
                                    <td><?php echo date('d.m.Y', strtotime($gorev['tarih'])); ?></td>
                                    <td>
                                        <span class="badge <?php echo $gecmis ? 'bg-danger' : 'bg-warning'; ?>">
                                            <?php
                                            if ($gecmis) {
                                                echo $fark->days . ' gün gecikmiş';
                                            } else {
                                                echo $fark->days . ' gün kaldı';
                                            }
                                            ?>
                                        </span>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Chart.js Kütüphanesi -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<style>
/* Timeline Styles */
.timeline {
    position: relative;
    padding: 20px 0;
}

.timeline-item {
    position: relative;
    padding-left: 50px;
    margin-bottom: 20px;
}

.timeline-icon {
    position: absolute;
    left: 0;
    top: 0;
    width: 36px;
    height: 36px;
    border-radius: 50%;
    background: #fff;
    border: 2px solid currentColor;
    display: flex;
    align-items: center;
    justify-content: center;
}

.timeline-content {
    background: #fff;
    border-radius: 4px;
    padding: 15px;
    box-shadow: 0 1px 3px rgba(0,0,0,.1);
}

/* Card Styles */
.card {
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
}

.card .card-header {
    background-color: #f8f9fc;
    border-bottom: 1px solid #e3e6f0;
}

.border-left-primary { border-left: 4px solid var(--bs-primary); }
.border-left-success { border-left: 4px solid var(--bs-success); }
.border-left-info { border-left: 4px solid var(--bs-info); }
.border-left-warning { border-left: 4px solid var(--bs-warning); }

/* Metrik kartları için ek stiller */
.metric-item {
    padding: 15px;
    border-radius: 8px;
    background: rgba(0,0,0,.02);
}

.server-status {
    padding: 15px;
    border-radius: 8px;
    background: rgba(0,0,0,.02);
}

.progress {
    background-color: rgba(0,0,0,.05);
}

</style>


<script>
// Gelir Trendi Grafiği
const gelirTrendiCtx = document.getElementById('gelirTrendiGrafik').getContext('2d');
new Chart(gelirTrendiCtx, {
    type: 'line',
    data: {
        labels: <?php echo json_encode(array_column($gelir_trendi, 'ay')); ?>,
        datasets: [{
            label: 'Aylık Gelir',
            data: <?php echo json_encode(array_column($gelir_trendi, 'toplam')); ?>,
            borderColor: 'rgb(75, 192, 192)',
            tension: 0.1,
            fill: true,
            backgroundColor: 'rgba(75, 192, 192, 0.1)'
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: {
                position: 'top',
            },
            title: {
                display: true,
                text: 'Son 12 Aylık Gelir Trendi'
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return value.toLocaleString('tr-TR', {
                            style: 'currency',
                            currency: 'TRY'
                        });
                    }
                }
            }
        }
    }
});

// Ödeme Dağılımı Grafiği
const odemeDagilimCtx = document.getElementById('odemeDagilimGrafik').getContext('2d');
new Chart(odemeDagilimCtx, {
    type: 'doughnut',
    data: {
        labels: <?php echo json_encode(array_column($odeme_dagilimi, 'odeme_yontemi')); ?>,
        datasets: [{
            data: <?php echo json_encode(array_column($odeme_dagilimi, 'toplam')); ?>,
            backgroundColor: [
                'rgba(255, 99, 132, 0.8)',
                'rgba(54, 162, 235, 0.8)',
                'rgba(255, 206, 86, 0.8)'
            ]
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: {
                position: 'bottom'
            }
        }
    }
});
</script>

<?php ob_end_flush(); ?>