<?php

// Oturum ayarlarını güvenli hale getir

ini_set('session.cookie_httponly', 1);

ini_set('session.use_only_cookies', 1);

ini_set('session.cookie_secure', 1);



session_start();



// Oturum süresini ayarla (60 dakika)

$session_lifetime = 3600; // 60 dakika

if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY'] > $session_lifetime)) {

    session_unset();     // Oturum değişkenlerini temizle

    session_destroy();   // Oturumu sonlandır

    header("Location: giris.php");

    exit;

}

$_SESSION['LAST_ACTIVITY'] = time(); // Son aktivite zamanını güncelle



require_once 'config/db.php';



// Kullanıcı zaten giriş yapmışsa ana sayfaya yönlendir

if (isset($_SESSION['kullanici_id'])) {

    header("Location: index.php");

    exit;

}



$hata = '';



if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    $kullanici_adi = trim($_POST['kullanici_adi']);

    $sifre = $_POST['sifre'];

    

    if (empty($kullanici_adi) || empty($sifre)) {

        $hata = 'Lütfen tüm alanları doldurun.';

    } else {

        $sorgu = $db->prepare("SELECT * FROM yonetici WHERE kullanici_adi = ?");

        $sorgu->execute([$kullanici_adi]);

        $kullanici = $sorgu->fetch(PDO::FETCH_ASSOC);

        

        if ($kullanici && password_verify($sifre, $kullanici['sifre'])) {

            $_SESSION['kullanici_id'] = $kullanici['id'];

            $_SESSION['kullanici_adi'] = $kullanici['kullanici_adi'];

            $_SESSION['ad_soyad'] = $kullanici['ad_soyad'];

            

            header("Location: index.php");

            exit;

        } else {

            $hata = 'Kullanıcı adı veya şifre hatalı.';

        }

    }

}

?>

<!DOCTYPE html>

<html lang="tr">

<head>

    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Yönetici Girişi</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>

        body {

            background-color: #f8f9fa;

        }

        .login-container {

            max-width: 400px;

            margin: 100px auto;

        }

    </style>

</head>

<body>

    <div class="container">

        <div class="login-container">

            <div class="card shadow">

                <div class="card-header text-center bg-primary text-white">

                    <h4 class="mb-0">Yönetici Girişi</h4>

                </div>

                <div class="card-body p-4">

                    <?php if ($hata): ?>

                        <div class="alert alert-danger"><?php echo $hata; ?></div>

                    <?php endif; ?>

                    

                    <form method="POST" action="">

                        <div class="mb-3">

                            <label for="kullanici_adi" class="form-label">Kullanıcı Adı</label>

                            <input type="text" class="form-control" id="kullanici_adi" name="kullanici_adi" required>

                        </div>

                        <div class="mb-4">

                            <label for="sifre" class="form-label">Şifre</label>

                            <input type="password" class="form-control" id="sifre" name="sifre" required>

                        </div>

                        <button type="submit" class="btn btn-primary w-100">Giriş Yap</button>

                    </form>

                </div>

            </div>

        </div>

    </div>



    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>

</html>