<?php

require_once '../config/db.php';



// POST verilerini logla

error_log("NKolay Callback Data: " . json_encode($_POST));



if (empty($_POST)) {

    error_log("NKolay Error: Empty POST data received");

    die('NKolay notification failed: no data received');

}



// Merchant bilgileri

$merchantSecretKey = "_YXMmaRPOK05Gzztl9lds";



// Response kodlarını kontrol et

$responseCode = $_POST['responseCode'] ?? '';

$responseMessage = $_POST['responseMessage'] ?? '';



// İşlem başarılı ise

if ($responseCode === '00') {

    // Başarılı ödeme sayfasını göster

    ?>

    <!DOCTYPE html>

    <html lang="tr">

    <head>

        <meta charset="UTF-8">

        <meta name="viewport" content="width=device-width, initial-scale=1.0">

        <title>Ödeme Başarılı - Epifiz Ajans</title>

        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

        <style>

            body {

                background-color: #f8f9fa;

                height: 100vh;

                display: flex;

                align-items: center;

                justify-content: center;

            }

            .payment-form {

                background: white;

                border-radius: 15px;

                box-shadow: 0 4px 15px rgba(0,0,0,0.1);

                padding: 2rem;

                text-align: center;

                max-width: 400px;

                width: 90%;

            }

        </style>

    </head>

    <body>

        <div class="success-card">

            <div class="success-icon animate-check">✓</div>

            <h3 class="mb-3">Ödeme Başarılı!</h3>

            <p class="mb-4">Ödemeniz başarıyla gerçekleştirildi. Teşekkür ederiz.</p>

            <a href="https://www.epifizajans.com" class="btn btn-primary mb-3">Ana Sayfaya Dön</a>

            <div class="redirect-text">

                <span id="countdown">5</span> saniye içinde ana sayfaya yönlendirileceksiniz.

            </div>

        </div>

        <script>

            let timeLeft = 5;

            const countdownElement = document.getElementById('countdown');

            const countdown = setInterval(() => {

                timeLeft--;

                countdownElement.textContent = timeLeft;

                if (timeLeft <= 0) {

                    clearInterval(countdown);

                    window.top.location.href = 'https://www.epifizajans.com';

                }

            }, 1000);

        </script>

    </body>

    </html>

    <?php

} else {

    // Hata durumunda fail sayfasına yönlendir

    header("Location: nkolay_fail.php?error=" . urlencode($responseMessage));

    exit;

} 