<?php

// Remove session_start() since it's already started in index.php

musteriGirisKontrol();



// Get customer information

$sorgu = $db->prepare("SELECT * FROM musteriler WHERE id = ?");

$sorgu->execute([$_SESSION['musteri_id']]);

$musteri = $sorgu->fetch(PDO::FETCH_ASSOC);



// Get active services count

$sorgu = $db->prepare("

    SELECT 

        COUNT(DISTINCT h.id) as hosting_count,

        COUNT(DISTINCT d.id) as domain_count,

        SUM(CASE WHEN f.odeme_durumu = 'Ödenmedi' THEN f.genel_toplam ELSE 0 END) as toplam_borc

    FROM musteriler m

    LEFT JOIN hosting_hesaplari h ON m.id = h.musteri_id AND h.durum = 'Aktif'

    LEFT JOIN domain_kayitlar d ON m.id = d.musteri_id AND d.durum = 'Aktif'

    LEFT JOIN faturalar f ON m.id = f.musteri_id AND f.odeme_durumu = 'Ödenmedi'

    WHERE m.id = ?

");

$sorgu->execute([$_SESSION['musteri_id']]);

$ozet = $sorgu->fetch(PDO::FETCH_ASSOC);



// Get recent invoices

$sorgu = $db->prepare("

    SELECT * FROM faturalar 

    WHERE musteri_id = ? 

    ORDER BY fatura_tarihi DESC 

    LIMIT 5

");

$sorgu->execute([$_SESSION['musteri_id']]);

$son_faturalar = $sorgu->fetchAll(PDO::FETCH_ASSOC);

?>



<!-- Page Title -->

<div class="d-flex justify-content-between align-items-center mb-4">

    <h1 class="h3 mb-0">

        <i class="bi bi-person-circle me-2"></i>

        Hesabım

    </h1>

</div>



<!-- Overview Cards -->

<div class="row">

    <div class="col-md-4 mb-4">

        <div class="card">

            <div class="card-body">

                <div class="d-flex justify-content-between align-items-center">

                    <div>

                        <h6 class="card-subtitle text-muted">Aktif Hosting</h6>

                        <h2 class="card-title mb-0"><?php echo $ozet['hosting_count']; ?></h2>

                    </div>

                    <div class="bg-primary bg-opacity-10 rounded-3 p-3">

                        <i class="bi bi-hdd-rack text-primary fs-1"></i>

                    </div>

                </div>

            </div>

        </div>

    </div>

    

    <div class="col-md-4 mb-4">

        <div class="card">

            <div class="card-body">

                <div class="d-flex justify-content-between align-items-center">

                    <div>

                        <h6 class="card-subtitle text-muted">Aktif Domain</h6>

                        <h2 class="card-title mb-0"><?php echo $ozet['domain_count']; ?></h2>

                    </div>

                    <div class="bg-success bg-opacity-10 rounded-3 p-3">

                        <i class="bi bi-globe text-success fs-1"></i>

                    </div>

                </div>

            </div>

        </div>

    </div>

    

    <div class="col-md-4 mb-4">

        <div class="card">

            <div class="card-body">

                <div class="d-flex justify-content-between align-items-center">

                    <div>

                        <h6 class="card-subtitle text-muted">Toplam Borç</h6>

                        <h2 class="card-title mb-0">

                            <?php echo number_format($ozet['toplam_borc'], 2, ',', '.'); ?> ₺

                        </h2>

                    </div>

                    <div class="bg-danger bg-opacity-10 rounded-3 p-3">

                        <i class="bi bi-cash text-danger fs-1"></i>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>



<div class="row">

    <!-- Customer Information -->

    <div class="col-md-6 mb-4">

        <div class="card h-100">

            <div class="card-header">

                <h5 class="card-title mb-0">

                    <i class="bi bi-person me-2"></i>

                    Müşteri Bilgileri

                </h5>

            </div>

            <div class="card-body">

                <div class="row g-3">

                    <div class="col-md-6">

                        <label class="form-label text-muted">Ad Soyad</label>

                        <div class="fw-bold">

                            <?php echo htmlspecialchars($musteri['ad'] . ' ' . $musteri['soyad']); ?>

                        </div>

                    </div>

                    

                    <div class="col-md-6">

                        <label class="form-label text-muted">Müşteri Türü</label>

                        <div>

                            <span class="badge <?php echo $musteri['musteri_turu'] == 'Bireysel' ? 'bg-primary' : 'bg-success'; ?>">

                                <i class="bi <?php echo $musteri['musteri_turu'] == 'Bireysel' ? 'bi-person' : 'bi-building'; ?> me-1"></i>

                                <?php echo $musteri['musteri_turu']; ?>

                            </span>

                        </div>

                    </div>

                    

                    <div class="col-md-6">

                        <label class="form-label text-muted">E-posta</label>

                        <div class="fw-bold">

                            <?php echo htmlspecialchars($musteri['eposta']); ?>

                        </div>

                    </div>

                    

                    <div class="col-md-6">

                        <label class="form-label text-muted">Telefon</label>

                        <div class="fw-bold">

                            <?php echo htmlspecialchars($musteri['telefon']); ?>

                        </div>

                    </div>

                    

                    <?php if ($musteri['musteri_turu'] == 'Bireysel'): ?>

                        <?php if ($musteri['tc_kimlik_no']): ?>

                        <div class="col-md-6">

                            <label class="form-label text-muted">T.C. Kimlik No</label>

                            <div class="fw-bold">

                                <?php echo htmlspecialchars($musteri['tc_kimlik_no']); ?>

                            </div>

                        </div>

                        <?php endif; ?>

                        

                        <?php if ($musteri['dogum_yili']): ?>

                        <div class="col-md-6">

                            <label class="form-label text-muted">Doğum Yılı</label>

                            <div class="fw-bold">

                                <?php echo htmlspecialchars($musteri['dogum_yili']); ?>

                            </div>

                        </div>

                        <?php endif; ?>

                    <?php else: ?>

                        <?php if ($musteri['vergi_dairesi']): ?>

                        <div class="col-md-6">

                            <label class="form-label text-muted">Vergi Dairesi</label>

                            <div class="fw-bold">

                                <?php echo htmlspecialchars($musteri['vergi_dairesi']); ?>

                            </div>

                        </div>

                        <?php endif; ?>

                        

                        <?php if ($musteri['vergi_no']): ?>

                        <div class="col-md-6">

                            <label class="form-label text-muted">Vergi No</label>

                            <div class="fw-bold">

                                <?php echo htmlspecialchars($musteri['vergi_no']); ?>

                            </div>

                        </div>

                        <?php endif; ?>

                    <?php endif; ?>

                    

                    <?php if ($musteri['adres']): ?>

                    <div class="col-12">

                        <label class="form-label text-muted">Adres</label>

                        <div class="fw-bold">

                            <?php echo nl2br(htmlspecialchars($musteri['adres'])); ?>

                        </div>

                    </div>

                    <?php endif; ?>

                </div>

                

                <div class="mt-4">

                    <a href="index.php?sayfa=hesabim/duzenle" class="btn btn-primary">

                        <i class="bi bi-pencil me-2"></i>

                        Bilgilerimi Düzenle

                    </a>

                    <a href="index.php?sayfa=hesabim/sifre" class="btn btn-warning">

                        <i class="bi bi-key me-2"></i>

                        Şifremi Değiştir

                    </a>

                </div>

            </div>

        </div>

    </div>

    

    <!-- Recent Invoices -->

    <div class="col-md-6 mb-4">

        <div class="card h-100">

            <div class="card-header d-flex justify-content-between align-items-center">

                <h5 class="card-title mb-0">

                    <i class="bi bi-receipt me-2"></i>

                    Son Faturalar

                </h5>

                <a href="index.php?sayfa=faturalarim" class="btn btn-primary btn-sm">

                    <i class="bi bi-list me-2"></i>

                    Tüm Faturalar

                </a>

            </div>

            <div class="card-body">

                <?php if (empty($son_faturalar)): ?>

                    <div class="alert alert-info mb-0">

                        <i class="bi bi-info-circle me-2"></i>

                        Henüz faturanız bulunmamaktadır.

                    </div>

                <?php else: ?>

                    <div class="table-responsive">

                        <table class="table table-hover">

                            <thead>

                                <tr>

                                    <th>Fatura No</th>

                                    <th>Tarih</th>

                                    <th>Tutar</th>

                                    <th>Durum</th>

                                </tr>

                            </thead>

                            <tbody>

                                <?php foreach ($son_faturalar as $fatura): ?>

                                <tr>

                                    <td>

                                        <a href="index.php?sayfa=faturalarim/goruntule&id=<?php echo $fatura['id']; ?>" 

                                           class="text-decoration-none">

                                            <?php echo $fatura['fatura_no']; ?>

                                        </a>

                                    </td>

                                    <td><?php echo date('d.m.Y', strtotime($fatura['fatura_tarihi'])); ?></td>

                                    <td><?php echo number_format($fatura['genel_toplam'], 2, ',', '.'); ?> ₺</td>

                                    <td>

                                        <?php

                                        $durum_class = '';

                                        $durum_icon = '';

                                        switch($fatura['odeme_durumu']) {

                                            case 'Ödendi':

                                                $durum_class = 'bg-success';

                                                $durum_icon = 'bi-check-circle';

                                                break;

                                            case 'Kısmi Ödendi':

                                                $durum_class = 'bg-warning';

                                                $durum_icon = 'bi-clock';

                                                break;

                                            case 'İptal':

                                                $durum_class = 'bg-danger';

                                                $durum_icon = 'bi-x-circle';

                                                break;

                                            default:

                                                $durum_class = 'bg-secondary';

                                                $durum_icon = 'bi-hourglass';

                                        }

                                        ?>

                                        <span class="badge <?php echo $durum_class; ?>">

                                            <i class="bi <?php echo $durum_icon; ?> me-1"></i>

                                            <?php echo $fatura['odeme_durumu']; ?>

                                        </span>

                                    </td>

                                </tr>

                                <?php endforeach; ?>

                            </tbody>

                        </table>

                    </div>

                <?php endif; ?>

            </div>

        </div>

    </div>

</div>