<?php
ob_start();
oturumKontrol();

require_once 'DomainNameAPI_PHPLibrary.php';

// API bağlantısı için ayarları al
$sorgu = $db->query("SELECT * FROM api_ayarlar WHERE servis = 'domainnameapi' LIMIT 1");
$api_ayarlar = $sorgu->fetch(PDO::FETCH_ASSOC);

// Müşteri listesini getir
$sorgu = $db->query("SELECT * FROM musteriler ORDER BY ad, soyad");
$musteriler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Sunucu listesini getir
$sorgu = $db->query("SELECT * FROM sunucular ORDER BY sunucu_adi");
$sunucular = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Domain listesini getir
function getDomainList($db, $api_ayarlar) {
    try {
        $api = new DomainNameApi\DomainNameAPI_PHPLibrary(
            $api_ayarlar['username'],
            $api_ayarlar['password']
        );
        
        $response = $api->GetList();
        if ($response['result'] == 'OK') {
            $domains = [];
            foreach ($response['data']['Domains'] as $domain) {
                $details = $api->GetDetails($domain['DomainName']);
                if ($details['result'] == 'OK') {
                    $domain['Details'] = $details['data'];
                    
                    // Mevcut kaydı kontrol et
                    $sorgu = $db->prepare("SELECT musteri_id FROM domain_kayitlar WHERE domain = ?");
                    $sorgu->execute([$domain['DomainName']]);
                    $kayit = $sorgu->fetch(PDO::FETCH_ASSOC);
                    
                    if ($kayit) {
                        $domain['musteri_id'] = $kayit['musteri_id'];
                    }
                }
                $domains[] = $domain;
            }
            return $domains;
        }
    } catch (Exception $e) {
        error_log("Domain List Error: " . $e->getMessage());
    }
    return [];
}

// Hosting hesaplarını getir
function getHostingAccounts($db, $server) {
    try {
        $url = "https://{$server['ip_adresi']}:2087/json-api/listaccts";
        
        $header = array(
            "Authorization: WHM {$server['kullanici_adi']}:{$server['token']}"
        );
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        
        $response = curl_exec($ch);
        curl_close($ch);
        
        $result = json_decode($response, true);
        
        if (isset($result['acct'])) {
            foreach ($result['acct'] as &$account) {
                // Hesap detaylarını al
                $url = "https://{$server['ip_adresi']}:2087/json-api/accountsummary";
                $params = array('user' => $account['user']);
                
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($params));
                curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
                
                $details = curl_exec($ch);
                curl_close($ch);
                
                $details = json_decode($details, true);
                
                if (isset($details['acct'][0])) {
                    $account['details'] = $details['acct'][0];
                    $account['email'] = $details['acct'][0]['email'] ?? 'hosting@' . $account['domain'];
                }
                
                // Mevcut kaydı kontrol et
                $sorgu = $db->prepare("SELECT musteri_id FROM hosting_hesaplari WHERE kullanici_adi = ? AND sunucu_id = ?");
                $sorgu->execute([$account['user'], $server['id']]);
                $kayit = $sorgu->fetch(PDO::FETCH_ASSOC);
                
                if ($kayit) {
                    $account['musteri_id'] = $kayit['musteri_id'];
                }
            }
            return $result['acct'];
        }
    } catch (Exception $e) {
        error_log("Hosting List Error: " . $e->getMessage());
    }
    return [];
}

// Senkronizasyon işlemleri
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $basarili = 0;
    $hatali = 0;
    
    // Domain senkronizasyonu için
    if (isset($_POST['sync_domains'])) {
        $domain_matches = $_POST['domain_matches'] ?? [];
        
        foreach ($domain_matches as $domain_data) {
            list($domain, $musteri_id) = explode('|', $domain_data);
            
            if (isset($_POST['domain_info']) && isset($_POST['domain_info'][$domain])) {
                $domain_info = json_decode(base64_decode($_POST['domain_info'][$domain]), true);
                
                if (!empty($musteri_id) && $domain_info) {
                    try {
                        // Önce mevcut kaydı kontrol et
                        $check = $db->prepare("SELECT id FROM domain_kayitlar WHERE domain = ?");
                        $check->execute([$domain]);
                        
                        if ($check->rowCount() > 0) {
                            // Kayıt varsa güncelle
                            $update = $db->prepare("UPDATE domain_kayitlar SET 
                                musteri_id = ?, 
                                kayit_tarihi = ?, 
                                bitis_tarihi = ?, 
                                durum = ? 
                                WHERE domain = ?");
                            
                            $update->execute([
                                $musteri_id,
                                date('Y-m-d', strtotime($domain_info['Details']['Dates']['Start'])),
                                date('Y-m-d', strtotime($domain_info['Details']['Dates']['Expiration'])),
                                $domain_info['Status'] == 'Active' ? 'Aktif' : 'Transfer',
                                $domain
                            ]);
                        } else {
                            // Kayıt yoksa ekle
                            $insert = $db->prepare("INSERT INTO domain_kayitlar 
                                (musteri_id, domain, kayit_tarihi, bitis_tarihi, durum) 
                                VALUES (?, ?, ?, ?, ?)");
                            
                            $insert->execute([
                                $musteri_id,
                                $domain,
                                date('Y-m-d', strtotime($domain_info['Details']['Dates']['Start'])),
                                date('Y-m-d', strtotime($domain_info['Details']['Dates']['Expiration'])),
                                $domain_info['Status'] == 'Active' ? 'Aktif' : 'Transfer'
                            ]);
                        }
                        
                        // Log kaydı ekle
                        $log = $db->prepare("INSERT INTO domain_sync_log 
                            (domain, musteri_id, status) 
                            VALUES (?, ?, 'success')");
                        $log->execute([$domain, $musteri_id]);
                        
                        $basarili++;
                    } catch (PDOException $e) {
                        error_log("Domain Sync Error: " . $e->getMessage());
                        
                        // Hata logunu kaydet
                        $log = $db->prepare("INSERT INTO domain_sync_log 
                            (domain, musteri_id, status, error_message) 
                            VALUES (?, ?, 'failed', ?)");
                        $log->execute([$domain, $musteri_id, $e->getMessage()]);
                        
                        $hatali++;
                    }
                }
            }
        }
    }

    // Hosting senkronizasyonu için
    if (isset($_POST['sync_hosting'])) {
        $hosting_matches = $_POST['hosting_matches'] ?? [];
        
        foreach ($hosting_matches as $hosting_data) {
            list($username, $sunucu_id, $musteri_id) = explode('|', $hosting_data);
            
            if (isset($_POST['hosting_info']) && isset($_POST['hosting_info'][$username])) {
                $hosting_info = json_decode(base64_decode($_POST['hosting_info'][$username]), true);
                
                if (!empty($musteri_id) && $hosting_info) {
                    try {
                        // Önce mevcut kaydı kontrol et
                        $check = $db->prepare("SELECT id FROM hosting_hesaplari WHERE kullanici_adi = ? AND sunucu_id = ?");
                        $check->execute([$username, $sunucu_id]);
                        
                        if ($check->rowCount() > 0) {
                            // Kayıt varsa güncelle
                            $update = $db->prepare("UPDATE hosting_hesaplari SET 
                                musteri_id = ?, 
                                domain = ?, 
                                paket = ?, 
                                durum = ? 
                                WHERE kullanici_adi = ? AND sunucu_id = ?");
                            
                            $update->execute([
                                $musteri_id,
                                $hosting_info['domain'],
                                $hosting_info['plan'],
                                $hosting_info['suspended'] ? 'Askıda' : 'Aktif',
                                $username,
                                $sunucu_id
                            ]);
                        } else {
                            // Varsayılan değerler
                            $sifre = password_hash('ChangeMe2024!', PASSWORD_DEFAULT);
                            $eposta = $hosting_info['email'] ?? 'hosting@' . $hosting_info['domain'];
                            
                            // Kayıt yoksa ekle
                            $insert = $db->prepare("INSERT INTO hosting_hesaplari 
                                (musteri_id, sunucu_id, domain, kullanici_adi, sifre, eposta, paket, 
                                 fatura_donemi, fiyat, durum) 
                                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                            
                            $insert->execute([
                                $musteri_id,
                                $sunucu_id,
                                $hosting_info['domain'],
                                $username,
                                $sifre,
                                $eposta,
                                $hosting_info['plan'],
                                'Ücretsiz',
                                0.00,
                                $hosting_info['suspended'] ? 'Askıda' : 'Aktif'
                            ]);
                        }
                        
                        // Log kaydı ekle
                        $log = $db->prepare("INSERT INTO hosting_sync_log 
                            (username, sunucu_id, musteri_id, status) 
                            VALUES (?, ?, ?, 'success')");
                        $log->execute([$username, $sunucu_id, $musteri_id]);
                        
                        $basarili++;
                    } catch (PDOException $e) {
                        error_log("Hosting Sync Error: " . $e->getMessage());
                        
                        // Hata logunu kaydet
                        $log = $db->prepare("INSERT INTO hosting_sync_log 
                            (username, sunucu_id, musteri_id, status, error_message) 
                            VALUES (?, ?, ?, 'failed', ?)");
                        $log->execute([$username, $sunucu_id, $musteri_id, $e->getMessage()]);
                        
                        $hatali++;
                    }
                }
            }
        }
    }
    
    header("Location: index.php?sayfa=sync/index&mesaj=sync_completed&basarili=" . $basarili . "&hatali=" . $hatali);
    exit;
}

// Domain ve hosting listelerini al
$domains = getDomainList($db, $api_ayarlar);
$hosting_accounts = [];
foreach ($sunucular as $sunucu) {
    $accounts = getHostingAccounts($db, $sunucu);
    foreach ($accounts as $account) {
        $account['sunucu_id'] = $sunucu['id'];
        $account['sunucu_adi'] = $sunucu['sunucu_adi'];
        $hosting_accounts[] = $account;
    }
}
?>

<!-- Bootstrap Icons ve DataTables CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item active">Hizmet Senkronizasyonu</li>
    </ol>
</nav>

<?php if (isset($_GET['mesaj']) && $_GET['mesaj'] == 'sync_completed'): ?>
<div class="alert alert-success alert-dismissible fade show">
    <i class="bi bi-check-circle-fill me-2"></i>
    Senkronizasyon işlemi tamamlandı.<br>
    <strong><?php echo $_GET['basarili']; ?></strong> kayıt başarıyla aktarıldı.
    <?php if ($_GET['hatali'] > 0): ?>
        <br><strong><?php echo $_GET['hatali']; ?></strong> kayıt aktarılamadı.
    <?php endif; ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<!-- Domain Senkronizasyonu -->
<div class="card mb-4">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-globe me-2"></i>
            Domain Senkronizasyonu
        </h5>
    </div>
    <div class="card-body">
        <form method="POST" action="">
            <input type="hidden" name="sync_domains" value="1">
            
            <div class="table-responsive">
                <table id="domainTable" class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th>Domain</th>
                            <th>Kayıt Tarihi</th>
                            <th>Bitiş Tarihi</th>
                            <th>Durum</th>
                            <th>Müşteri</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($domains as $domain): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($domain['DomainName']); ?></td>
                            <td><?php echo date('d.m.Y', strtotime($domain['Details']['Dates']['Start'])); ?></td>
                            <td><?php echo date('d.m.Y', strtotime($domain['Details']['Dates']['Expiration'])); ?></td>
                            <td>
                                <span class="badge bg-<?php echo $domain['Status'] == 'Active' ? 'success' : 'warning'; ?>">
                                    <?php echo $domain['Status']; ?>
                                </span>
                            </td>
                            <td>
                                <select name="domain_matches[]" class="form-select form-select-sm select2">
                                    <option value="">Müşteri Seçin</option>
                                    <?php foreach ($musteriler as $musteri): ?>
                                    <option value="<?php echo $domain['DomainName'] . '|' . $musteri['id']; ?>"
                                            <?php echo (isset($domain['musteri_id']) && $domain['musteri_id'] == $musteri['id']) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($musteri['ad'] . ' ' . $musteri['soyad']); ?>
                                        (<?php echo $musteri['musteri_turu']; ?>)
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                                <input type="hidden" name="domain_info[<?php echo $domain['DomainName']; ?>]" 
                                       value="<?php echo base64_encode(json_encode($domain)); ?>">
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-arrow-repeat me-2"></i>
                Domainleri Aktarımını Başlat
            </button>
        </form>
    </div>
</div>

<!-- Hosting Senkronizasyonu -->
<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-hdd-rack me-2"></i>
            Hosting Senkronizasyonu
        </h5>
    </div>
    <div class="card-body">
        <form method="POST" action="">
            <input type="hidden" name="sync_hosting" value="1">
            
            <div class="table-responsive">
                <table id="hostingTable" class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th>Kullanıcı Adı</th>
                            <th>Domain</th>
                            <th>Sunucu</th>
                            <th>Paket</th>
                            <th>Durum</th>
                            <th>Müşteri</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($hosting_accounts as $account): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($account['user']); ?></td>
                            <td><?php echo htmlspecialchars($account['domain']); ?></td>
                            <td><?php echo htmlspecialchars($account['sunucu_adi']); ?></td>
                            <td><?php echo htmlspecialchars($account['plan']); ?></td>
                            <td>
                                <?php if ($account['suspended']): ?>
                                    <span class="badge bg-warning">
                                        <i class="bi bi-pause-circle me-1"></i>
                                        Askıda
                                    </span>
                                <?php else: ?>
                                    <span class="badge bg-success">
                                        <i class="bi bi-check-circle me-1"></i>
                                        Aktif
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <select name="hosting_matches[]" class="form-select form-select-sm select2">
                                    <option value="">Müşteri Seçin</option>
                                    <?php foreach ($musteriler as $musteri): ?>
                                    <option value="<?php echo $account['user'] . '|' . $account['sunucu_id'] . '|' . $musteri['id']; ?>"
                                            <?php echo (isset($account['musteri_id']) && $account['musteri_id'] == $musteri['id']) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($musteri['ad'] . ' ' . $musteri['soyad']); ?>
                                        (<?php echo $musteri['musteri_turu']; ?>)
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                                <input type="hidden" name="hosting_info[<?php echo $account['user']; ?>]" 
                                       value="<?php echo base64_encode(json_encode($account)); ?>">
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-arrow-repeat me-2"></i>
                Hosting Hesaplarını Aktarımını Başlat
            </button>
        </form>
    </div>
</div>

<!-- jQuery ve DataTables JS -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    // Select2 başlat
    $('.select2').select2({
        theme: 'bootstrap-5',
        width: '100%'
    });
    
    // DataTables başlat
    $('#domainTable, #hostingTable').DataTable({
        language: {
            url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/tr.json'
        },
        pageLength: 10,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Tümü"]],
        order: [[0, 'asc']],
        responsive: true,
        dom: "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
             "<'row'<'col-sm-12'tr>>" +
             "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        initComplete: function() {
            // Arama kutusuna placeholder ekle
            $('.dataTables_filter input')
                .attr('placeholder', 'Ara...')
                .addClass('form-control-sm');
            
            // Sayfa başına gösterim seçeneğini özelleştir
            $('.dataTables_length select').addClass('form-select-sm');
        }
    });
});
</script>

<?php ob_end_flush(); ?>