<?php
oturumKontrol();

// Müşteri ID kontrolü
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: index.php?sayfa=musteriler/liste");
    exit;
}

$musteri_id = (int)$_GET['id'];

try {
    // Önce müşterinin var olduğunu kontrol et
    $kontrol = $db->prepare("SELECT id FROM musteriler WHERE id = ?");
    $kontrol->execute([$musteri_id]);
    
    if ($kontrol->rowCount() === 0) {
        header("Location: index.php?sayfa=musteriler/liste&mesaj=bulunamadi");
        exit;
    }
    
    // Müşteriyi sil
    $sorgu = $db->prepare("DELETE FROM musteriler WHERE id = ?");
    $sonuc = $sorgu->execute([$musteri_id]);
    
    if ($sonuc) {
        header("Location: index.php?sayfa=musteriler/liste&mesaj=silindi");
    } else {
        header("Location: index.php?sayfa=musteriler/liste&mesaj=hata");
    }
} catch (PDOException $e) {
    header("Location: index.php?sayfa=musteriler/liste&mesaj=hata");
}
exit;
?>