<?php
oturumKontrol();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $hata = '';
    
    // Form verilerini al ve güvenli hale getir
    $firma_adi = guvenlik($_POST['firma_adi']);
    $ad = guvenlik($_POST['ad']);
    $soyad = guvenlik($_POST['soyad']);
    $telefon = guvenlik($_POST['telefon']);
    $eposta = guvenlik($_POST['eposta']);
    $sifre = $_POST['sifre']; // Şifreyi hash'leyeceğimiz için guvenlik() fonksiyonunu kullanmıyoruz
    $adres = guvenlik($_POST['adres']);
    $adres2 = guvenlik($_POST['adres2']);
    $sehir = guvenlik($_POST['sehir']);
    $ulke = guvenlik($_POST['ulke']);
    $ilce = guvenlik($_POST['ilce']);
    $posta_kodu = guvenlik($_POST['posta_kodu']);
    $faks = guvenlik($_POST['faks']);
    $musteri_turu = guvenlik($_POST['musteri_turu']);
    
    // Müşteri türüne göre ilgili alanları al
    if ($musteri_turu == 'Bireysel') {
        $tc_kimlik_no = !empty($_POST['tc_kimlik_no']) ? guvenlik($_POST['tc_kimlik_no']) : null;
        $dogum_yili = !empty($_POST['dogum_yili']) ? guvenlik($_POST['dogum_yili']) : null;
        $vergi_dairesi = null;
        $vergi_no = null;
    } else {
        $tc_kimlik_no = null;
        $dogum_yili = null;
        $vergi_dairesi = !empty($_POST['vergi_dairesi']) ? guvenlik($_POST['vergi_dairesi']) : null;
        $vergi_no = !empty($_POST['vergi_no']) ? guvenlik($_POST['vergi_no']) : null;
    }
    
    // Zorunlu alanları kontrol et
    if (empty($ad) || empty($soyad) || empty($telefon) || empty($eposta) || empty($sifre)) {
        $hata = 'Lütfen zorunlu alanları doldurun.';
    } elseif (strlen($sifre) < 8) {
        $hata = 'Şifre en az 8 karakter uzunluğunda olmalıdır.';
    } else {
        try {
            // Mükerrer kayıt kontrolü
            $kontrolSorgusu = $db->prepare("SELECT * FROM musteriler WHERE 
                telefon = ? OR 
                eposta = ? OR 
                (tc_kimlik_no = ? AND tc_kimlik_no IS NOT NULL) OR 
                (vergi_no = ? AND vergi_no IS NOT NULL)");
            
            $kontrolSorgusu->execute([$telefon, $eposta, $tc_kimlik_no, $vergi_no]);
            
            if ($kontrolSorgusu->rowCount() > 0) {
                $mevcut = $kontrolSorgusu->fetch(PDO::FETCH_ASSOC);
                $hata = 'Bu bilgilere sahip bir müşteri zaten mevcut:<br>';
                
                if ($mevcut['telefon'] == $telefon) {
                    $hata .= '- Bu telefon numarası kullanılıyor<br>';
                }
                if ($mevcut['eposta'] == $eposta) {
                    $hata .= '- Bu e-posta adresi kullanılıyor<br>';
                }
                if ($mevcut['tc_kimlik_no'] == $tc_kimlik_no && $tc_kimlik_no) {
                    $hata .= '- Bu T.C. Kimlik numarası kullanılıyor<br>';
                }
                if ($mevcut['vergi_no'] == $vergi_no && $vergi_no) {
                    $hata .= '- Bu vergi numarası kullanılıyor<br>';
                }
            } else {
                // Şifreyi hashle
                $sifre_hash = password_hash($sifre, PASSWORD_DEFAULT);
                
                $sorgu = $db->prepare("INSERT INTO musteriler 
                    (firma_adi, ad, soyad, telefon, eposta, sifre, musteri_turu, tc_kimlik_no, dogum_yili, 
                     vergi_dairesi, vergi_no, adres, adres2, sehir, ulke, ilce, posta_kodu, faks, durum) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'Aktif')");
                
                $sonuc = $sorgu->execute([
                    $firma_adi, $ad, $soyad, $telefon, $eposta, $sifre_hash, $musteri_turu,
                    $tc_kimlik_no, $dogum_yili, $vergi_dairesi, $vergi_no, $adres, $adres2,
                    $sehir, $ulke, $ilce, $posta_kodu, $faks
                ]);
                
                if ($sonuc) {
                    header("Location: index.php?sayfa=musteriler/liste&mesaj=basarili");
                    exit;
                }
            }
        } catch (PDOException $e) {
            $hata = 'Bir hata oluştu: ' . $e->getMessage();
        }
    }
}
?>

<!-- Bootstrap Icons CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item">Müşteriler</li>
        <li class="breadcrumb-item active" aria-current="page">Yeni Müşteri</li>
    </ol>
</nav>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-person-plus me-2"></i>
            Yeni Müşteri Ekle
        </h5>
    </div>
    <div class="card-body">
        <?php if (isset($hata) && $hata): ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                <?php echo $hata; ?>
            </div>
        <?php endif; ?>
        
        <form method="POST" action="" class="row g-3">
            <!-- Temel Bilgiler -->
            <div class="col-md-4">
                <label for="ad" class="form-label">
                    <i class="bi bi-person me-2"></i>
                    Ad *
                </label>
                <input type="text" class="form-control" id="ad" name="ad" 
                       value="<?php echo isset($ad) ? htmlspecialchars($ad) : ''; ?>" required>
            </div>
            
            <div class="col-md-4">
                <label for="soyad" class="form-label">
                    <i class="bi bi-person me-2"></i>
                    Soyad *
                </label>
                <input type="text" class="form-control" id="soyad" name="soyad" 
                       value="<?php echo isset($soyad) ? htmlspecialchars($soyad) : ''; ?>" required>
            </div>
            
            <div class="col-md-4">
                <label for="musteri_turu" class="form-label">
                    <i class="bi bi-person-vcard me-2"></i>
                    Müşteri Türü *
                </label>
                <select class="form-select" id="musteri_turu" name="musteri_turu" required>
                    <option value="">Seçiniz</option>
                    <option value="Bireysel" <?php echo isset($musteri_turu) && $musteri_turu == 'Bireysel' ? 'selected' : ''; ?>>Bireysel</option>
                    <option value="Kurumsal" <?php echo isset($musteri_turu) && $musteri_turu == 'Kurumsal' ? 'selected' : ''; ?>>Kurumsal</option>
                </select>
            </div>
            
            <!-- İletişim Bilgileri -->
            <div class="col-md-6">
                <label for="telefon" class="form-label">
                    <i class="bi bi-telephone me-2"></i>
                    Telefon *
                </label>
                <input type="tel" class="form-control" id="telefon" name="telefon" 
                       value="<?php echo isset($telefon) ? htmlspecialchars($telefon) : ''; ?>" required>
            </div>
            
            <div class="col-md-6">
                <label for="eposta" class="form-label">
                    <i class="bi bi-envelope me-2"></i>
                    E-posta *
                </label>
                <input type="email" class="form-control" id="eposta" name="eposta" 
                       value="<?php echo isset($eposta) ? htmlspecialchars($eposta) : ''; ?>" required>
            </div>

            <div class="col-md-6">
                <label for="sifre" class="form-label">
                    <i class="bi bi-key me-2"></i>
                    Şifre *
                </label>
                <div class="input-group">
                    <input type="password" class="form-control" id="sifre" name="sifre" 
                           minlength="8" required>
                    <button class="btn btn-outline-secondary" type="button" id="sifreGoster"
                            data-bs-toggle="tooltip" title="Şifreyi Göster/Gizle">
                        <i class="bi bi-eye"></i>
                    </button>
                    <button class="btn btn-outline-secondary" type="button" id="rastgeleSifre"
                            data-bs-toggle="tooltip" title="Rastgele Şifre Oluştur">
                        <i class="bi bi-shuffle"></i>
                    </button>
                </div>
                <small class="text-muted">En az 8 karakter uzunluğunda olmalıdır.</small>
            </div>
            <div class="col-md-6">
                <label for="firma_adi" class="form-label">Firma Adı</label>
                <input type="text" class="form-control" id="firma_adi" name="firma_adi">
            </div>
            <div class="col-md-4">
                <label for="ulke" class="form-label">Ülke</label>
                <input type="text" class="form-control" id="ulke" name="ulke" value="Türkiye">
            </div>
            <div class="col-md-4">
                <label for="sehir" class="form-label">Şehir</label>
                <select class="form-select" id="sehir" name="sehir">
                    <option value="">Seçiniz</option>
                    <option value="İstanbul">İstanbul</option>
                    <option value="Ankara">Ankara</option>
                    <option value="İzmir">İzmir</option>
                </select>
            </div>
            <div class="col-md-4">
                <label for="ilce" class="form-label">İlçe</label>
                <input type="text" class="form-control" id="ilce" name="ilce">
            </div>
            <div class="col-md-6">
                <label for="posta_kodu" class="form-label">Posta Kodu</label>
                <input type="text" class="form-control" id="posta_kodu" name="posta_kodu">
            </div>
            <div class="col-md-6">
                <label for="faks" class="form-label">Faks</label>
                <input type="text" class="form-control" id="faks" name="faks" value="0">
            </div>
            
            <!-- Adres -->
            <div class="col-6">
                <label for="adres" class="form-label">
                    <i class="bi bi-geo-alt me-2"></i>
                    Adres
                </label>
                <input type="text" class="form-control" id="adres2" name="adres2">
            </div>
            <div class="col-md-6">
                <label for="adres2" class="form-label">Adres 2</label>
                <input type="text" class="form-control" id="adres2" name="adres2">
            </div>
            <!-- Bireysel Müşteri Bilgileri -->
            <div class="col-md-6 bireysel-alan">
                <label for="tc_kimlik_no" class="form-label">
                    <i class="bi bi-person-badge me-2"></i>
                    T.C. Kimlik No
                </label>
                <input type="text" class="form-control" id="tc_kimlik_no" name="tc_kimlik_no" 
                       maxlength="11" value="<?php echo isset($tc_kimlik_no) ? htmlspecialchars($tc_kimlik_no) : ''; ?>">
            </div>
            
            <div class="col-md-6 bireysel-alan">
                <label for="dogum_yili" class="form-label">
                    <i class="bi bi-calendar me-2"></i>
                    Doğum Yılı
                </label>
                <input type="number" class="form-control" id="dogum_yili" name="dogum_yili" 
                       min="1900" max="<?php echo date('Y'); ?>" 
                       value="<?php echo isset($dogum_yili) ? htmlspecialchars($dogum_yili) : ''; ?>">
            </div>
            
            <!-- Kurumsal Müşteri Bilgileri -->
            <div class="col-md-6 kurumsal-alan">
                <label for="vergi_dairesi" class="form-label">
                    <i class="bi bi-building me-2"></i>
                    Vergi Dairesi
                </label>
                <input type="text" class="form-control" id="vergi_dairesi" name="vergi_dairesi" 
                       value="<?php echo isset($vergi_dairesi) ? htmlspecialchars($vergi_dairesi) : ''; ?>">
            </div>
            
            <div class="col-md-6 kurumsal-alan">
                <label for="vergi_no" class="form-label">
                    <i class="bi bi-upc me-2"></i>
                    Vergi No
                </label>
                <input type="text" class="form-control" id="vergi_no" name="vergi_no" 
                       maxlength="10" value="<?php echo isset($vergi_no) ? htmlspecialchars($vergi_no) : ''; ?>">
            </div>
            
            <div class="col-12">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-lg me-2"></i>
                    Müşteri Ekle
                </button>
                <a href="index.php?sayfa=musteriler/liste" class="btn btn-secondary">
                    <i class="bi bi-x-lg me-2"></i>
                    İptal
                </a>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Müşteri türüne göre form alanlarını göster/gizle
    const musteriTuru = document.getElementById('musteri_turu');
    const bireyselAlanlar = document.querySelectorAll('.bireysel-alan');
    const kurumsalAlanlar = document.querySelectorAll('.kurumsal-alan');
    
    function alanlarıGuncelle() {
        if (musteriTuru.value === 'Bireysel') {
            bireyselAlanlar.forEach(alan => alan.style.display = 'block');
            kurumsalAlanlar.forEach(alan => alan.style.display = 'none');
        } else if (musteriTuru.value === 'Kurumsal') {
            bireyselAlanlar.forEach(alan => alan.style.display = 'none');
            kurumsalAlanlar.forEach(alan => alan.style.display = 'block');
        } else {
            bireyselAlanlar.forEach(alan => alan.style.display = 'none');
            kurumsalAlanlar.forEach(alan => alan.style.display = 'none');
        }
    }
    
    musteriTuru.addEventListener('change', alanlarıGuncelle);
    alanlarıGuncelle(); // Sayfa yüklendiğinde çalıştır
    
    // Form validasyonu
    const form = document.querySelector('form');
    form.addEventListener('submit', function(event) {
        let hata = false;
        const telefon = document.getElementById('telefon').value;
        const eposta = document.getElementById('eposta').value;
        const tcKimlikNo = document.getElementById('tc_kimlik_no');
        const vergiNo = document.getElementById('vergi_no');
        
        // Telefon formatı kontrolü
        if (!/^[0-9]{10,11}$/.test(telefon.replace(/[^0-9]/g, ''))) {
            alert('Lütfen geçerli bir telefon numarası girin.');
            hata = true;
        }
        
        // E-posta formatı kontrolü
        if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(eposta)) {
            alert('Lütfen geçerli bir e-posta adresi girin.');
            hata = true;
        }
        
        // TC Kimlik No kontrolü (Bireysel müşteri için)
        if (musteriTuru.value === 'Bireysel' && tcKimlikNo.value) {
            if (!/^[0-9]{11}$/.test(tcKimlikNo.value)) {
                alert('TC Kimlik No 11 haneli olmalıdır.');
                hata = true;
            }
        }
        
        // Vergi No kontrolü (Kurumsal müşteri için)
        if (musteriTuru.value === 'Kurumsal' && vergiNo.value) {
            if (!/^[0-9]{10}$/.test(vergiNo.value)) {
                alert('Vergi No 10 haneli olmalıdır.');
                hata = true;
            }
        }
        
        if (hata) {
            event.preventDefault();
        }
    });

    // Şifre göster/gizle ve rastgele şifre oluşturma işlevselliği
    const sifreInput = document.getElementById('sifre');
    const sifreGoster = document.getElementById('sifreGoster');
    const rastgeleSifre = document.getElementById('rastgeleSifre');

    sifreGoster.addEventListener('click', function() {
        const type = sifreInput.getAttribute('type') === 'password' ? 'text' : 'password';
        sifreInput.setAttribute('type', type);
        sifreGoster.querySelector('i').classList.toggle('bi-eye');
        sifreGoster.querySelector('i').classList.toggle('bi-eye-slash');
    });

    rastgeleSifre.addEventListener('click', function() {
        const karakterler = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*';
        let sifre = '';
        for (let i = 0; i < 12; i++) {
            sifre += karakterler.charAt(Math.floor(Math.random() * karakterler.length));
        }
        sifreInput.value = sifre;
        sifreInput.setAttribute('type', 'text');
        setTimeout(() => {
            sifreInput.setAttribute('type', 'password');
        }, 3000);
    });
});
</script>