<?php
ob_start();
oturumKontrol();

// Get notification settings
$sorgu = $db->query("SELECT * FROM bildirim_ayarlar LIMIT 1");
$ayarlar = $sorgu->fetch(PDO::FETCH_ASSOC);

// Get notification templates
$sorgu = $db->query("SELECT * FROM bildirim_sablon ORDER BY tur, baslik");
$sablonlar = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Update notification settings
if (isset($_POST['ayarlar_kaydet'])) {
    $smtp_host = guvenlik($_POST['smtp_host']);
    $smtp_port = (int)$_POST['smtp_port'];
    $smtp_user = guvenlik($_POST['smtp_user']);
    $smtp_pass = $_POST['smtp_pass']; // Only if changed
    $smtp_from = guvenlik($_POST['smtp_from']);
    $smtp_from_name = guvenlik($_POST['smtp_from_name']);
    
    $sms_user = guvenlik($_POST['sms_user']);
    $sms_pass = $_POST['sms_pass']; // Only if changed
    $sms_header = guvenlik($_POST['sms_header']);
    
    try {
        if ($ayarlar) {
            $sql = "UPDATE bildirim_ayarlar SET 
                smtp_host = ?, 
                smtp_port = ?, 
                smtp_user = ?, 
                smtp_from = ?,
                smtp_from_name = ?,
                sms_user = ?,
                sms_header = ?";
            
            $params = [
                $smtp_host,
                $smtp_port,
                $smtp_user,
                $smtp_from,
                $smtp_from_name,
                $sms_user,
                $sms_header
            ];
            
            // Add password parameters if changed
            if (!empty($_POST['smtp_pass'])) {
                $sql .= ", smtp_pass = ?";
                $params[] = $_POST['smtp_pass'];
            }
            
            if (!empty($_POST['sms_pass'])) {
                $sql .= ", sms_pass = ?";
                $params[] = $_POST['sms_pass'];
            }
            
            $sql .= " WHERE id = ?";
            $params[] = $ayarlar['id'];
            
            $sorgu = $db->prepare($sql);
            $sonuc = $sorgu->execute($params);
        } else {
            $sorgu = $db->prepare("INSERT INTO bildirim_ayarlar 
                (smtp_host, smtp_port, smtp_user, smtp_pass, smtp_from, smtp_from_name,
                 sms_user, sms_pass, sms_header) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            
            $sonuc = $sorgu->execute([
                $smtp_host,
                $smtp_port,
                $smtp_user,
                $_POST['smtp_pass'],
                $smtp_from,
                $smtp_from_name,
                $sms_user,
                $_POST['sms_pass'],
                $sms_header
            ]);
        }
        
        if ($sonuc) {
            $basarili = 'Bildirim ayarları güncellendi.';
            header("Refresh:2");
        }
    } catch (PDOException $e) {
        $hata = 'Ayarlar güncellenirken hata: ' . $e->getMessage();
    }
}

// Add/Edit notification template
if (isset($_POST['sablon_kaydet'])) {
    $id = isset($_POST['id']) ? $_POST['id'] : null;
    $tur = guvenlik($_POST['tur']);
    $baslik = guvenlik($_POST['baslik']);
    $icerik = $_POST['icerik'];
    $sms_icerik = $_POST['sms_icerik'];
    $otomatik = isset($_POST['otomatik']) ? 1 : 0;
    
    try {
        if ($id) {
            $sorgu = $db->prepare("UPDATE bildirim_sablon SET 
                tur = ?, baslik = ?, icerik = ?, sms_icerik = ?, otomatik = ?
                WHERE id = ?");
            
            $sonuc = $sorgu->execute([
                $tur,
                $baslik,
                $icerik,
                $sms_icerik,
                $otomatik,
                $id
            ]);
        } else {
            $sorgu = $db->prepare("INSERT INTO bildirim_sablon 
                (tur, baslik, icerik, sms_icerik, otomatik) 
                VALUES (?, ?, ?, ?, ?)");
            
            $sonuc = $sorgu->execute([
                $tur,
                $baslik,
                $icerik,
                $sms_icerik,
                $otomatik
            ]);
        }
        
        if ($sonuc) {
            $basarili = 'Bildirim şablonu kaydedildi.';
            header("Refresh:2");
        }
    } catch (PDOException $e) {
        $hata = 'Şablon kaydedilirken hata: ' . $e->getMessage();
    }
}

// Delete notification template
if (isset($_POST['sablon_sil'])) {
    $id = (int)$_POST['id'];
    
    try {
        $sorgu = $db->prepare("DELETE FROM bildirim_sablon WHERE id = ?");
        $sonuc = $sorgu->execute([$id]);
        
        if ($sonuc) {
            $basarili = 'Bildirim şablonu silindi.';
            header("Refresh:2");
        }
    } catch (PDOException $e) {
        $hata = 'Şablon silinirken hata: ' . $e->getMessage();
    }
}

// Test email
if (isset($_POST['test_email'])) {
require_once $_SERVER['DOCUMENT_ROOT'] . '/yonetim/inc/phpmailer/PHPMailer.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/yonetim/inc/phpmailer/SMTP.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/yonetim/inc/phpmailer/Exception.php';
    
    $test_email = $_POST['test_email_address'];
    
    try {
        $mail = new PHPMailer\PHPMailer\PHPMailer(true);
        
        $mail->isSMTP();
        $mail->Host = $ayarlar['smtp_host'];
        $mail->SMTPAuth = true;
        $mail->Username = $ayarlar['smtp_user'];
        $mail->Password = $ayarlar['smtp_pass'];
        $mail->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = $ayarlar['smtp_port'];
        $mail->CharSet = 'UTF-8';
        
        $mail->setFrom($ayarlar['smtp_from'], $ayarlar['smtp_from_name']);
        $mail->addAddress($test_email);
        
        $mail->isHTML(true);
        $mail->Subject = 'Test E-postası';
        $mail->Body = 'Bu bir test e-postasıdır. E-posta ayarlarınız doğru çalışıyor.';
        
        $mail->send();
        $basarili = 'Test e-postası başarıyla gönderildi.';
    } catch (Exception $e) {
        $hata = 'Test e-postası gönderilemedi: ' . $mail->ErrorInfo;
    }
}

// Test SMS
if (isset($_POST['test_sms'])) {
    $test_phone = $_POST['test_phone'];
    
    // NetGSM API
    $username = $ayarlar['sms_user'];
    $password = $ayarlar['sms_pass'];
    $header = $ayarlar['sms_header'];
    $message = 'Bu bir test SMS\'idir.';
    
    $url = "https://api.netgsm.com.tr/sms/send/get";
    $params = array(
        'usercode' => $username,
        'password' => $password,
        'gsmno' => $test_phone,
        'message' => $message,
        'msgheader' => $header,
        'dil' => 'TR'
    );
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url . '?' . http_build_query($params));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        $hata = 'Test SMS gönderilemedi: ' . $error;
    } else {
        // NetGSM response codes
        $codes = array(
            '00' => 'Mesaj gönderim başarılı',
            '01' => 'Mesaj gönderim hatası',
            '02' => 'Kullanıcı adı ya da şifre hatalı',
            '30' => 'Hesap bakiyesi yetersiz'
        );
        
        $code = substr($response, 0, 2);
        if (isset($codes[$code])) {
            if ($code == '00') {
                $basarili = 'Test SMS\'i başarıyla gönderildi.';
            } else {
                $hata = 'Test SMS gönderilemedi: ' . $codes[$code];
            }
        } else {
            $hata = 'Test SMS gönderilemedi: Bilinmeyen hata';
        }
    }
}
?>

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=ayarlar">Ayarlar</a></li>
        <li class="breadcrumb-item active">Bildirim Ayarları</li>
    </ol>
</nav>

<!-- Messages -->
<?php if (isset($hata)): ?>
    <div class="alert alert-danger">
        <i class="bi bi-exclamation-triangle-fill me-2"></i>
        <?php echo $hata; ?>
    </div>
<?php endif; ?>

<?php if (isset($basarili)): ?>
    <div class="alert alert-success">
        <i class="bi bi-check-circle-fill me-2"></i>
        <?php echo $basarili; ?>
    </div>
<?php endif; ?>

<div class="row">
    <!-- Email Settings -->
    <div class="col-md-6 mb-4">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-envelope me-2"></i>
                    E-posta Ayarları
                </h5>
            </div>
            <div class="card-body">
                <form method="POST" action="" class="row g-3">
                    <input type="hidden" name="ayarlar_kaydet" value="1">
                    
                    <div class="col-md-8">
                        <label for="smtp_host" class="form-label">SMTP Sunucu</label>
                        <input type="text" class="form-control" id="smtp_host" name="smtp_host" 
                               value="<?php echo htmlspecialchars($ayarlar['smtp_host'] ?? ''); ?>" required>
                    </div>
                    
                    <div class="col-md-4">
                        <label for="smtp_port" class="form-label">Port</label>
                        <input type="number" class="form-control" id="smtp_port" name="smtp_port" 
                               value="<?php echo $ayarlar['smtp_port'] ?? 587; ?>" required>
                    </div>
                    
                    <div class="col-md-6">
                        <label for="smtp_user" class="form-label">Kullanıcı Adı</label>
                        <input type="text" class="form-control" id="smtp_user" name="smtp_user" 
                               value="<?php echo htmlspecialchars($ayarlar['smtp_user'] ?? ''); ?>" required>
                    </div>
                    
                    <div class="col-md-6">
                        <label for="smtp_pass" class="form-label">Şifre</label>
                        <input type="password" class="form-control" id="smtp_pass" name="smtp_pass" 
                               placeholder="Değiştirmek için doldurun">
                    </div>
                    
                    <div class="col-md-6">
                        <label for="smtp_from" class="form-label">Gönderen E-posta</label>
                        <input type="email" class="form-control" id="smtp_from" name="smtp_from" 
                               value="<?php echo htmlspecialchars($ayarlar['smtp_from'] ?? ''); ?>" required>
                    </div>
                    
                    <div class="col-md-6">
                        <label for="smtp_from_name" class="form-label">Gönderen Adı</label>
                        <input type="text" class="form-control" id="smtp_from_name" name="smtp_from_name" 
                               value="<?php echo htmlspecialchars($ayarlar['smtp_from_name'] ?? ''); ?>" required>
                    </div>
                    
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-2"></i>
                            Ayarları Kaydet
                        </button>
                        
                        <button type="button" class="btn btn-info" data-bs-toggle="modal" data-bs-target="#testEmailModal">
                            <i class="bi bi-envelope-paper me-2"></i>
                            Test E-postası Gönder
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- SMS Settings -->
    <div class="col-md-6 mb-4">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-chat-dots me-2"></i>
                    SMS Ayarları
                </h5>
            </div>
            <div class="card-body">
                <form method="POST" action="" class="row g-3">
                    <input type="hidden" name="ayarlar_kaydet" value="1">
                    
                    <div class="col-md-6">
                        <label for="sms_user" class="form-label">NetGSM Kullanıcı Adı</label>
                        <input type="text" class="form-control" id="sms_user" name="sms_user" 
                               value="<?php echo htmlspecialchars($ayarlar['sms_user'] ?? ''); ?>" required>
                    </div>
                    
                    <div class="col-md-6">
                        <label for="sms_pass" class="form-label">NetGSM Şifre</label>
                        <input type="password" class="form-control" id="sms_pass" name="sms_pass" 
                               placeholder="Değiştirmek için doldurun">
                    </div>
                    
                    <div class="col-md-12">
                        <label for="sms_header" class="form-label">SMS Başlığı</label>
                        <input type="text" class="form-control" id="sms_header" name="sms_header" 
                               value="<?php echo htmlspecialchars($ayarlar['sms_header'] ?? ''); ?>" required>
                        <small class="text-muted">NetGSM'de tanımlı SMS başlığınız</small>
                    </div>
                    
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-2"></i>
                            Ayarları Kaydet
                        </button>
                        
                        <button type="button" class="btn btn-info" data-bs-toggle="modal" data-bs-target="#testSmsModal">
                            <i class="bi bi-chat-dots me-2"></i>
                            Test SMS Gönder
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Notification Templates -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0">
            <i class="bi bi-file-text me-2"></i>
            Bildirim Şablonları
        </h5>
        <button type="button" class="btn btn-primary btn-sm" onclick="sablonDuzenle()">
            <i class="bi bi-plus-circle me-2"></i>
            Yeni Şablon
        </button>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Başlık</th>
                        <th>Tür</th>
                        <th>Otomatik</th>
                        <th>Son Güncelleme</th>
                        <th>İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($sablonlar as $sablon): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($sablon['baslik']); ?></td>
                        <td>
                            <?php
                            $tur_badge = '';
                            switch($sablon['tur']) {
                                case 'fatura':
                                    $tur_badge = 'bg-primary';
                                    $tur_text = 'Fatura';
                                    break;
                                case 'domain':
                                    $tur_badge = 'bg-info';
                                    $tur_text = 'Domain';
                                    break;
                                case 'hosting':
                                    $tur_badge = 'bg-success';
                                    $tur_text = 'Hosting';
                                    break;
                                case 'diger':
                                    $tur_badge = 'bg-secondary';
                                    $tur_text = 'Diğer';
                                    break;
                            }
                            ?>
                            <span class="badge <?php echo $tur_badge; ?>">
                                <?php echo $tur_text; ?>
                            </span>
                        </td>
                        <td>
                            <?php if ($sablon['otomatik']): ?>
                                <span class="badge bg-success">
                                    <i class="bi bi-check-circle me-1"></i>
                                    Evet
                                </span>
                            <?php else: ?>
                                <span class="badge bg-secondary">
                                    <i class="bi bi-x-circle me-1"></i>
                                    Hayır
                                </span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo date('d.m.Y H:i', strtotime($sablon['updated_at'])); ?></td>
                        <td>
                            <div class="btn-group">
                                <button type="button" class="btn btn-warning btn-sm" 
                                        onclick="sablonDuzenle(<?php echo htmlspecialchars(json_encode($sablon)); ?>)">
                                    <i class="bi bi-pencil me-1"></i>
                                    Düzenle
                                </button>
                                <button type="button" class="btn btn-danger btn-sm" 
                                        onclick="sablonSil(<?php echo $sablon['id']; ?>)">
                                    <i class="bi bi-trash me-1"></i>
                                    Sil
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Test Email Modal -->
<div class="modal fade" id="testEmailModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="bi bi-envelope-paper me-2"></i>
                    Test E-postası Gönder
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="">
                <input type="hidden" name="test_email" value="1">
                
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="test_email_address" class="form-label">E-posta Adresi</label>
                        <input type="email" class="form-control" id="test_email_address" name="test_email_address" required>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Gönder</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Test SMS Modal -->
<div class="modal fade" id="testSmsModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="bi bi-chat-dots me-2"></i>
                    Test SMS Gönder
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="">
                <input type="hidden" name="test_sms" value="1">
                
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="test_phone" class="form-label">Telefon Numarası</label>
                        <input type="tel" class="form-control" id="test_phone" name="test_phone" 
                               placeholder="5XXXXXXXXX" required>
                        <small class="text-muted">Başında 0 olmadan 10 haneli olarak girin</small>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Gönder</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Template Modal -->
<div class="modal fade" id="sablonModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="bi bi-file-text me-2"></i>
                    <span id="modalTitle">Yeni Bildirim Şablonu</span>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="">
                <input type="hidden" name="sablon_kaydet" value="1">
                <input type="hidden" name="id" id="sablon_id">
                
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-8">
                            <label for="baslik" class="form-label">Şablon Başlığı</label>
                            <input type="text" class="form-control" id="baslik" name="baslik" required>
                        </div>
                        
                        <div class="col-md-4">
                            <label for="tur" class="form-label">Bildirim Türü</label>
                            <select class="form-select" id="tur" name="tur" required>
                                <option value="fatura">Fatura</option>
                                <option value="domain">Domain</option>
                                <option value="hosting">Hosting</option>
                                <option value="diger">Diğer</option>
                            </select>
                        </div>
                        
                        <div class="col-12">
                            <label for="icerik" class="form-label">E-posta İçeriği</label>
                            <textarea class="form-control" id="icerik" name="icerik" rows="10" required></textarea>
                            <small class="text-muted">HTML kullanabilirsiniz. Değişkenler: {AD}, {SOYAD}, {TUTAR}, {TARIH}, vs.</small>
                        </div>
                        
                        <div class="col-12">
                            <label for="sms_icerik" class="form-label">SMS İçeriği</label>
                            <textarea class="form-control" id="sms_icerik" name="sms_icerik" rows="3" required></textarea>
                            <small class="text-muted">Maksimum 160 karakter. Değişkenler: {AD}, {SOYAD}, {TUTAR}, {TARIH}, vs.</small>
                        </div>
                        
                        <div class="col-12">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="otomatik" name="otomatik">
                                <label class="form-check-label" for="otomatik">
                                    Otomatik Gönder
                                </label>
                            </div>
                            <small class="text-muted">İşaretlenirse, ilgili durumlarda otomatik olarak gönderilir.</small>
                        </div>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Kaydet</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Form -->
<form id="silForm" method="POST" style="display: none;">
    <input type="hidden" name="sablon_sil" value="1">
    <input type="hidden" name="id" id="sil_id">
</form>

<script>
// Template edit function
function sablonDuzenle(sablon = null) {
    const modal = new bootstrap.Modal(document.getElementById('sablonModal'));
    
    if (sablon) {
        document.getElementById('modalTitle').textContent = 'Bildirim Şablonu Düzenle';
        document.getElementById('sablon_id').value = sablon.id;
        document.getElementById('baslik').value = sablon.baslik;
        document.getElementById('tur').value = sablon.tur;
        document.getElementById('icerik').value = sablon.icerik;
        document.getElementById('sms_icerik').value = sablon.sms_icerik;
        document.getElementById('otomatik').checked = sablon.otomatik == 1;
    } else {
        document.getElementById('modalTitle').textContent = 'Yeni Bildirim Şablonu';
        document.getElementById('sablon_id').value = '';
        document.getElementById('baslik').value = '';
        document.getElementById('tur').value = 'fatura';
        document.getElementById('icerik').value = '';
        document.getElementById('sms_icerik').value = '';
        document.getElementById('otomatik').checked = false;
    }
    
    modal.show();
}

// Template delete function
function sablonSil(id) {
    if (confirm('Bu bildirim şablonunu silmek istediğinizden emin misiniz?')) {
        document.getElementById('sil_id').value = id;
        document.getElementById('silForm').submit();
    }
}

// Phone number format validation
document.getElementById('test_phone').addEventListener('input', function(e) {
    let value = e.target.value.replace(/\D/g, '');
    if (value.startsWith('0')) {
        value = value.substring(1);
    }
    if (value.length > 10) {
        value = value.slice(0, 10);
    }
    e.target.value = value;
});

// SMS content character counter
document.getElementById('sms_icerik').addEventListener('input', function(e) {
    const maxLength = 160;
    const currentLength = e.target.value.length;
    
    if (currentLength > maxLength) {
        e.target.value = e.target.value.slice(0, maxLength);
    }
    
    const remainingChars = maxLength - e.target.value.length;
    e.target.nextElementSibling.textContent = `Kalan karakter: ${remainingChars}`;
});
</script>

<?php ob_end_flush(); ?>