<?php
require_once '../config/db.php';

// Gelen verileri logla
error_log("PayTR Fail Callback Data: " . print_r($_POST, true));

// Gerekli alanları kontrol et
if (!isset($_POST['merchant_oid']) || !isset($_POST['status']) || !isset($_POST['total_amount']) || !isset($_POST['hash'])) {
    error_log("PayTR callback: Missing required fields");
    error_log("POST data: " . print_r($_POST, true));
    die('PAYTR notification failed: invalid data');
}

// PayTR'den gelen parametreleri al
$merchant_key = 'ZoDMTAjHPUp3NNMD';
$merchant_salt = 's8QswoE3bctohMM6';

// Hash doğrulama
$hash = base64_encode(hash_hmac('sha256', $_POST['merchant_oid'] . $merchant_salt . $_POST['status'] . $_POST['total_amount'], $merchant_key, true));

if ($hash != $_POST['hash']) {
    error_log("PayTR hash validation failed");
    error_log("Generated hash: " . $hash);
    error_log("Received hash: " . $_POST['hash']);
    die('PAYTR notification failed: bad hash');
}

try {
    // merchant_oid ile ödemeyi bul
    $sorgu = $db->prepare("SELECT * FROM online_odemeler WHERE merchant_oid = ? AND payment_provider = 'PayTR'");
    $sorgu->execute([$_POST['merchant_oid']]);
    $odeme = $sorgu->fetch(PDO::FETCH_ASSOC);
    
    if (!$odeme) {
        error_log("PayTR payment not found: " . $_POST['merchant_oid']);
        die('PAYTR notification failed: payment not found');
    }
    
    // Ödeme kaydını güncelle
    $sorgu = $db->prepare("UPDATE online_odemeler SET 
        durum = 'İptal',
        response_code = ?,
        response_message = ?,
        metadata = ?,
        updated_at = CURRENT_TIMESTAMP
        WHERE id = ?");
    
    $metadata = json_encode([
        'failed_reason_code' => $_POST['failed_reason_code'] ?? null,
        'failed_reason_msg' => $_POST['failed_reason_msg'] ?? null,
        'test_mode' => $_POST['test_mode'] ?? null
    ]);
    
    $sorgu->execute([
        $_POST['status'],
        $_POST['failed_reason_msg'] ?? 'Ödeme başarısız',
        $metadata,
        $odeme['id']
    ]);
    
    // Log kaydı
    $sorgu = $db->prepare("INSERT INTO online_odeme_log 
        (odeme_id, islem_tipi, islem_sonucu) 
        VALUES (?, 'Başarısız', ?)");
    $sorgu->execute([$odeme['id'], json_encode($_POST)]);
    
    echo "OK";
    exit;
    
} catch (Exception $e) {
    error_log("PayTR fail callback error: " . $e->getMessage());
    die('PAYTR notification failed: ' . $e->getMessage());
}
?>