<?php

musteriGirisKontrol();



if (!isset($_GET['id'])) {

    header("Location: index.php?sayfa=hizmetlerim");

    exit;

}



$hosting_id = $_GET['id'];



// Get hosting account details

$sorgu = $db->prepare("

    SELECT h.*, s.sunucu_adi, s.ip_adresi, s.kullanici_adi as sunucu_kullanici, s.token

    FROM hosting_hesaplari h 

    LEFT JOIN sunucular s ON h.sunucu_id = s.id 

    WHERE h.id = ? AND h.musteri_id = ? AND h.durum = 'Aktif'

");

$sorgu->execute([$hosting_id, $_SESSION['musteri_id']]);

$hosting = $sorgu->fetch(PDO::FETCH_ASSOC);



if (!$hosting) {

    header("Location: index.php?sayfa=hizmetlerim");

    exit;

}



$hata = '';

$basarili = '';



// Get email accounts

function getEpostaHesaplari($hosting) {

    $url = "https://{$hosting['ip_adresi']}:2087/json-api/cpanel";

    

    $header = array(

        "Authorization: WHM {$hosting['sunucu_kullanici']}:{$hosting['token']}"

    );

    

    $params = array(

        'cpanel_jsonapi_version' => 2,

        'cpanel_jsonapi_module' => 'Email',

        'cpanel_jsonapi_func' => 'listpops',

        'user' => $hosting['kullanici_adi']

    );

    

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($params));

    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    

    $response = curl_exec($ch);

    curl_close($ch);

    

    return json_decode($response, true);

}



// Create new email account

if (isset($_POST['yeni_eposta'])) {

    $email_user = $_POST['email_user'];

    $sifre = $_POST['sifre'];

    $kota = (int)$_POST['kota'];

    

    if (empty($email_user) || empty($sifre)) {

        $hata = 'Lütfen tüm alanları doldurun.';

    } elseif (strlen($sifre) < 8) {

        $hata = 'Şifre en az 8 karakter uzunluğunda olmalıdır.';

    } else {

        $url = "https://{$hosting['ip_adresi']}:2087/json-api/cpanel";

        

        $header = array(

            "Authorization: WHM {$hosting['sunucu_kullanici']}:{$hosting['token']}"

        );

        

        $params = array(

            'cpanel_jsonapi_version' => 2,

            'cpanel_jsonapi_module' => 'Email',

            'cpanel_jsonapi_func' => 'addpop',

            'user' => $hosting['kullanici_adi'],

            'domain' => $hosting['domain'],

            'email' => $email_user,

            'password' => $sifre,

            'quota' => $kota

        );

        

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($params));

        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        

        $response = curl_exec($ch);

        curl_close($ch);

        

        $result = json_decode($response, true);

        

        if (isset($result['cpanelresult']['data'][0]['result']) && $result['cpanelresult']['data'][0]['result'] == 1) {

            $basarili = 'E-posta hesabı başarıyla oluşturuldu.';

        } else {

            $hata = 'E-posta hesabı oluşturulamadı: ' . ($result['cpanelresult']['data'][0]['reason'] ?? 'Bilinmeyen hata');

        }

    }

}



// Delete email account

if (isset($_POST['sil'])) {

    $email = $_POST['email'];

    

    $url = "https://{$hosting['ip_adresi']}:2087/json-api/cpanel";

    

    $header = array(

        "Authorization: WHM {$hosting['sunucu_kullanici']}:{$hosting['token']}"

    );

    

    $params = array(

        'cpanel_jsonapi_version' => 2,

        'cpanel_jsonapi_module' => 'Email',

        'cpanel_jsonapi_func' => 'delpop',

        'user' => $hosting['kullanici_adi'],

        'domain' => $hosting['domain'],

        'email' => $email

    );

    

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($params));

    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    

    $response = curl_exec($ch);

    curl_close($ch);

    

    $result = json_decode($response, true);

    

    if (isset($result['cpanelresult']['data'][0]['result']) && $result['cpanelresult']['data'][0]['result'] == 1) {

        $basarili = 'E-posta hesabı başarıyla silindi.';

    } else {

        $hata = 'E-posta hesabı silinemedi: ' . ($result['cpanelresult']['data'][0]['reason'] ?? 'Bilinmeyen hata');

    }

}



// Change email password

if (isset($_POST['sifre_degistir'])) {

    $email = $_POST['email'];

    $yeni_sifre = $_POST['yeni_sifre'];

    

    if (empty($yeni_sifre)) {

        $hata = 'Lütfen yeni şifre girin.';

    } elseif (strlen($yeni_sifre) < 8) {

        $hata = 'Şifre en az 8 karakter uzunluğunda olmalıdır.';

    } else {

        $url = "https://{$hosting['ip_adresi']}:2087/json-api/cpanel";

        

        $header = array(

            "Authorization: WHM {$hosting['sunucu_kullanici']}:{$hosting['token']}"

        );

        

        $params = array(

            'cpanel_jsonapi_version' => 2,

            'cpanel_jsonapi_module' => 'Email',

            'cpanel_jsonapi_func' => 'passwdpop',

            'user' => $hosting['kullanici_adi'],

            'domain' => $hosting['domain'],

            'email' => $email,

            'password' => $yeni_sifre

        );

        

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($params));

        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        

        $response = curl_exec($ch);

        curl_close($ch);

        

        $result = json_decode($response, true);

        

        if (isset($result['cpanelresult']['data'][0]['result']) && $result['cpanelresult']['data'][0]['result'] == 1) {

            $basarili = 'E-posta şifresi başarıyla değiştirildi.';

        } else {

            $hata = 'E-posta şifresi değiştirilemedi: ' . ($result['cpanelresult']['data'][0]['reason'] ?? 'Bilinmeyen hata');

        }

    }

}



// Get email accounts list

$epostaHesaplari = getEpostaHesaplari($hosting);

?>



<!-- Page Title -->

<div class="d-flex justify-content-between align-items-center mb-4">

    <h1 class="h3 mb-0">

        <i class="bi bi-envelope me-2"></i>

        E-Posta Hesapları

    </h1>

    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#yeniEpostaModal">

        <i class="bi bi-plus-circle me-2"></i>

        Yeni E-Posta Hesabı

    </button>

</div>



<?php if ($hata): ?>

    <div class="alert alert-danger">

        <i class="bi bi-exclamation-triangle-fill me-2"></i>

        <?php echo $hata; ?>

    </div>

<?php endif; ?>



<?php if ($basarili): ?>

    <div class="alert alert-success">

        <i class="bi bi-check-circle-fill me-2"></i>

        <?php echo $basarili; ?>

    </div>

<?php endif; ?>



<!-- Hosting Info -->

<div class="alert alert-info mb-4">

    <div class="d-flex align-items-center">

        <div class="flex-shrink-0">

            <i class="bi bi-info-circle display-6"></i>

        </div>

        <div class="flex-grow-1 ms-3">

            <h6 class="alert-heading mb-1">Hosting Bilgileri</h6>

            <p class="mb-0">

                Domain: <strong><?php echo htmlspecialchars($hosting['domain']); ?></strong><br>

                Paket: <strong><?php echo htmlspecialchars($hosting['paket']); ?></strong><br>

                Sunucu: <strong><?php echo htmlspecialchars($hosting['sunucu_adi']); ?></strong>

            </p>

        </div>

    </div>

</div>



<!-- Email Accounts Table -->

<div class="card">

    <div class="card-body">

        <?php if (isset($epostaHesaplari['cpanelresult']['data']) && !empty($epostaHesaplari['cpanelresult']['data'])): ?>

            <div class="table-responsive">

                <table class="table table-hover">

                    <thead>

                        <tr>

                            <th>E-Posta Adresi</th>

                            <th>Kota</th>

                            <th>Kullanılan Alan</th>

                            <th>İşlemler</th>

                        </tr>

                    </thead>

                    <tbody>

                        <?php foreach ($epostaHesaplari['cpanelresult']['data'] as $hesap): 

                            $email = strpos($hesap['email'], '@') !== false ? 

                                    $hesap['email'] : 

                                    $hesap['email'] . '@' . $hosting['domain'];

                            

                            $kota = isset($hesap['diskquota']) ? ($hesap['diskquota'] == 0 ? 'Sınırsız' : $hesap['diskquota'] . ' MB') : 'Belirlenmemiş';

                            $kullanilan = isset($hesap['diskused']) ? round($hesap['diskused'], 2) . ' MB' : '0 MB';

                        ?>

                        <tr>

                            <td><?php echo htmlspecialchars($email); ?></td>

                            <td><?php echo $kota; ?></td>

                            <td><?php echo $kullanilan; ?></td>

                            <td>

                                <div class="btn-group">

                                    <button type="button" class="btn btn-warning btn-sm" 

                                            onclick="sifreDegistirModal('<?php echo htmlspecialchars($hesap['email']); ?>')"

                                            data-bs-toggle="tooltip" title="Şifre Değiştir">

                                        <i class="bi bi-key me-1"></i>

                                        Şifre Değiştir

                                    </button>

                                    <button type="button" class="btn btn-danger btn-sm ms-1" 

                                            onclick="epostaSil('<?php echo htmlspecialchars($hesap['email']); ?>')"

                                            data-bs-toggle="tooltip" title="Hesabı Sil">

                                        <i class="bi bi-trash me-1"></i>

                                        Sil

                                    </button>

                                </div>

                            </td>

                        </tr>

                        <?php endforeach; ?>

                    </tbody>

                </table>

            </div>

        <?php else: ?>

            <div class="alert alert-info mb-0">

                <i class="bi bi-info-circle me-2"></i>

                Henüz e-posta hesabı bulunmamaktadır.

            </div>

        <?php endif; ?>

    </div>

</div>



<!-- New Email Modal -->

<div class="modal fade" id="yeniEpostaModal" tabindex="-1">

    <div class="modal-dialog">

        <div class="modal-content">

            <div class="modal-header">

                <h5 class="modal-title">

                    <i class="bi bi-envelope-plus me-2"></i>

                    Yeni E-Posta Hesabı

                </h5>

                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>

            </div>

            <form method="POST" action="">

                <input type="hidden" name="yeni_eposta" value="1">

                

                <div class="modal-body">

                    <div class="mb-3">

                        <label for="email_user" class="form-label">E-Posta Adresi</label>

                        <div class="input-group">

                            <input type="text" class="form-control" id="email_user" name="email_user" required>

                            <span class="input-group-text">@<?php echo htmlspecialchars($hosting['domain']); ?></span>

                        </div>

                    </div>

                    

                    <div class="mb-3">

                        <label for="sifre" class="form-label">Şifre</label>

                        <div class="input-group">

                            <input type="password" class="form-control" id="sifre" name="sifre" 

                                   minlength="8" required>

                            <button class="btn btn-outline-secondary" type="button" id="sifreGoster"

                                    data-bs-toggle="tooltip" title="Şifreyi Göster/Gizle">

                                <i class="bi bi-eye"></i>

                            </button>

                            <button class="btn btn-outline-secondary" type="button" id="rastgeleSifre"

                                    data-bs-toggle="tooltip" title="Rastgele Şifre Oluştur">

                                <i class="bi bi-shuffle"></i>

                            </button>

                        </div>

                        <small class="text-muted">En az 8 karakter uzunluğunda olmalıdır.</small>

                    </div>

                    

                    <div class="mb-3">

                        <label for="kota" class="form-label">Kota (MB)</label>

                        <div class="input-group">

                            <input type="number" class="form-control" id="kota" name="kota" 

                                   value="1024" min="0" required>

                            <span class="input-group-text">MB</span>

                        </div>

                        <small class="text-muted">0 = Sınırsız</small>

                    </div>

                </div>

                

                <div class="modal-footer">

                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>

                    <button type="submit" class="btn btn-primary">Oluştur</button>

                </div>

            </form>

        </div>

    </div>

</div>



<!-- Change Password Modal -->

<div class="modal fade" id="sifreDegistirModal" tabindex="-1">

    <div class="modal-dialog">

        <div class="modal-content">

            <div class="modal-header">

                <h5 class="modal-title">

                    <i class="bi bi-key me-2"></i>

                    E-Posta Şifresini Değiştir

                </h5>

                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>

            </div>

            <form method="POST" action="">

                <input type="hidden" name="sifre_degistir" value="1">

                <input type="hidden" name="email" id="sifreEmail">

                

                <div class="modal-body">

                    <div class="mb-3">

                        <label for="yeni_sifre" class="form-label">Yeni Şifre</label>

                        <div class="input-group">

                            <input type="password" class="form-control" id="yeni_sifre" name="yeni_sifre" 

                                   minlength="8" required>

                            <button class="btn btn-outline-secondary" type="button" id="yeniSifreGoster"

                                    data-bs-toggle="tooltip" title="Şifreyi Göster/Gizle">

                                <i class="bi bi-eye"></i>

                            </button>

                            <button class="btn btn-outline-secondary" type="button" id="yeniRastgeleSifre"

                                    data-bs-toggle="tooltip" title="Rastgele Şifre Oluştur">

                                <i class="bi bi-shuffle"></i>

                            </button>

                        </div>

                        <small class="text-muted">En az 8 karakter uzunluğunda olmalıdır.</small>

                    </div>

                </div>

                

                <div class="modal-footer">

                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>

                    <button type="submit" class="btn btn-primary">Şifreyi Değiştir</button>

                </div>

            </form>

        </div>

    </div>

</div>



<!-- Delete Form -->

<form id="silForm" method="POST" style="display: none;">

    <input type="hidden" name="sil" value="1">

    <input type="hidden" name="email" id="silEmail">

</form>



<script>

document.addEventListener('DOMContentLoaded', function() {

    // Tooltips'i aktifleştir

    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');

    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));

    

    // Şifre göster/gizle fonksiyonu

    function sifreGosterGizle(input, button) {

        const tip = input.type === 'password' ? 'text' : 'password';

        input.type = tip;

        const icon = button.querySelector('i');

        icon.className = tip === 'password' ? 'bi bi-eye' : 'bi bi-eye-slash';

        

        // Tooltip metnini güncelle

        const tooltip = bootstrap.Tooltip.getInstance(button);

        if (tooltip) {

            tooltip.setContent({ '.tooltip-inner': tip === 'password' ? 'Şifreyi Göster' : 'Şifreyi Gizle' });

        }

    }

    

    // Rastgele şifre oluştur fonksiyonu

    function rastgeleSifreOlustur(input, button) {

        const karakterler = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*';

        let sifre = '';

        for (let i = 0; i < 12; i++) {

            sifre += karakterler.charAt(Math.floor(Math.random() * karakterler.length));

        }

        input.type = 'text';

        input.value = sifre;

        button.querySelector('i').className = 'bi bi-eye-slash';

    }

    

    // Yeni hesap için şifre işlemleri

    const sifreInput = document.getElementById('sifre');

    const sifreGoster = document.getElementById('sifreGoster');

    const rastgeleSifre = document.getElementById('rastgeleSifre');

    

    if (sifreGoster) {

        sifreGoster.addEventListener('click', () => sifreGosterGizle(sifreInput, sifreGoster));

    }

    

    if (rastgeleSifre) {

        rastgeleSifre.addEventListener('click', () => rastgeleSifreOlustur(sifreInput, sifreGoster));

    }

    

    // Şifre değiştirme için şifre işlemleri

    const yeniSifreInput = document.getElementById('yeni_sifre');

    const yeniSifreGoster = document.getElementById('yeniSifreGoster');

    const yeniRastgeleSifre = document.getElementById('yeniRastgeleSifre');

    

    if (yeniSifreGoster) {

        yeniSifreGoster.addEventListener('click', () => sifreGosterGizle(yeniSifreInput, yeniSifreGoster));

    }

    

    if (yeniRastgeleSifre) {

        yeniRastgeleSifre.addEventListener('click', () => rastgeleSifreOlustur(yeniSifreInput, yeniSifreGoster));

    }

});



// Şifre değiştirme modalını aç

function sifreDegistirModal(email) {

    const sifreEmail = document.getElementById('sifreEmail');

    const modal = new bootstrap.Modal(document.getElementById('sifreDegistirModal'));

    

    if (sifreEmail) {

        sifreEmail.value = email;

        modal.show();

    }

}



// E-posta hesabını sil

function epostaSil(email) {

    if (confirm(email + ' e-posta hesabını silmek istediğinizden emin misiniz?')) {

        const silEmail = document.getElementById('silEmail');

        const silForm = document.getElementById('silForm');

        

        if (silEmail && silForm) {

            silEmail.value = email;

            silForm.submit();

        }

    }

}

</script>