<?php
oturumKontrol();

// WHM API'den hosting hesaplarını çeken fonksiyon
function getHostingAccounts($server) {
    $url = "https://{$server['ip_adresi']}:2087/json-api/listaccts";
    
    $header = array(
        "Authorization: WHM {$server['kullanici_adi']}:{$server['token']}"
    );
    
    error_log("WHM API Request URL (listaccts): " . $url);
    error_log("WHM API Headers (listaccts): " . print_r($header, true));
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    
    $response = curl_exec($ch);
    $info = curl_getinfo($ch);
    $error = curl_error($ch);
    
    error_log("WHM API Response (listaccts): " . $response);
    error_log("WHM API HTTP Code (listaccts): " . $info['http_code']);
    if ($error) {
        error_log("WHM API Error (listaccts): " . $error);
    }
    
    curl_close($ch);
    
    if ($error) {
        return array('error' => $error);
    }
    
    return json_decode($response, true);
}

// Tüm sunucuları getir
$sunucular = $db->query("SELECT * FROM sunucular ORDER BY sunucu_adi")->fetchAll(PDO::FETCH_ASSOC);

// Her sunucudaki hosting hesaplarını topla
$tumHesaplar = array();
foreach ($sunucular as $sunucu) {
    $hesaplar = getHostingAccounts($sunucu);
    if (!isset($hesaplar['error']) && isset($hesaplar['acct'])) {
        foreach ($hesaplar['acct'] as $hesap) {
            $hesap['sunucu_adi'] = $sunucu['sunucu_adi'];
            $hesap['sunucu_ip'] = $sunucu['ip_adresi'];
            $tumHesaplar[] = $hesap;
        }
    }
}

// Mesaj parametresini kontrol et
$mesaj = isset($_GET['mesaj']) ? $_GET['mesaj'] : '';
$mesajMetni = '';
$mesajTuru = '';

switch($mesaj) {
    case 'basarili':
        $mesajMetni = 'Yeni hosting hesabı başarıyla eklendi.';
        $mesajTuru = 'success';
        break;
    case 'guncellendi':
        $mesajMetni = 'Hosting hesabı güncellendi.';
        $mesajTuru = 'success';
        break;
    case 'silindi':
        $mesajMetni = 'Hosting hesabı başarıyla silindi.';
        $mesajTuru = 'success';
        break;
    case 'hata':
        $mesajMetni = 'Bir hata oluştu. Lütfen tekrar deneyin.';
        $mesajTuru = 'danger';
        break;
}
?>

<!-- Bootstrap Icons ve DataTables CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<!-- DataTables JS -->
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item">Hosting Hesapları</li>
        <li class="breadcrumb-item active" aria-current="page">Hesap Listesi</li>
    </ol>
</nav>

<!-- Mesaj Gösterimi -->
<?php if ($mesajMetni): ?>
<div class="alert alert-<?php echo $mesajTuru; ?> alert-dismissible fade show" role="alert">
    <i class="bi bi-info-circle me-2"></i>
    <?php echo $mesajMetni; ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat"></button>
</div>
<?php endif; ?>

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0">
            <i class="bi bi-hdd-rack me-2"></i>
            Hosting Hesapları
        </h5>
        <a href="index.php?sayfa=hosting/ekle" class="btn btn-primary btn-sm">
            <i class="bi bi-plus-circle me-2"></i>
            Yeni Hesap
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table id="hostingTable" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>Kullanıcı Adı</th>
                        <th>Domain</th>
                        <th>IP Adresi</th>
                        <th>Sunucu</th>
                        <th>Paket</th>
                        <th>Durum</th>
                        <th style="min-width: 200px;">İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($tumHesaplar as $hesap): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($hesap['user']); ?></td>
                        <td><?php echo htmlspecialchars($hesap['domain']); ?></td>
                        <td><?php echo htmlspecialchars($hesap['ip']); ?></td>
                        <td><?php echo htmlspecialchars($hesap['sunucu_adi']); ?></td>
                        <td><?php echo htmlspecialchars($hesap['plan']); ?></td>
                        <td>
                            <?php if ($hesap['suspended'] == 0): ?>
                                <span class="badge bg-success">
                                    <i class="bi bi-check-circle me-1"></i>
                                    Aktif
                                </span>
                            <?php else: ?>
                                <span class="badge bg-danger">
                                    <i class="bi bi-x-circle me-1"></i>
                                    Askıya Alınmış
                                </span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="btn-group">
                                <button type="button" class="btn btn-sm btn-primary dropdown-toggle" 
                                        data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="bi bi-gear me-1"></i>
                                    İşlemler
                                </button>
                                <ul class="dropdown-menu">
                                    <?php if ($hesap['suspended'] == 0): ?>
                                        <li>
                                            <a class="dropdown-item text-danger" href="index.php?sayfa=hosting/islemler&islem=askiya_al&user=<?php echo urlencode($hesap['user']); ?>&server=<?php echo urlencode($hesap['sunucu_adi']); ?>"
                                               data-bs-toggle="tooltip" title="Hesabı Askıya Al">
                                                <i class="bi bi-pause-circle me-2"></i>
                                                Askıya Al
                                            </a>
                                        </li>
                                    <?php else: ?>
                                        <li>
                                            <a class="dropdown-item text-success" href="index.php?sayfa=hosting/islemler&islem=aktif_et&user=<?php echo urlencode($hesap['user']); ?>&server=<?php echo urlencode($hesap['sunucu_adi']); ?>"
                                               data-bs-toggle="tooltip" title="Hesabı Aktifleştir">
                                                <i class="bi bi-play-circle me-2"></i>
                                                Aktifleştir
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    
                                    <li>
                                        <a class="dropdown-item" href="index.php?sayfa=hosting/sifre_degistir&user=<?php echo urlencode($hesap['user']); ?>&server=<?php echo urlencode($hesap['sunucu_adi']); ?>"
                                           data-bs-toggle="tooltip" title="Hesap Şifresini Değiştir">
                                            <i class="bi bi-key me-2"></i>
                                            Şifre Değiştir
                                        </a>
                                    </li>
                                    
                                    <li>
                                        <a class="dropdown-item" href="index.php?sayfa=hosting/paket_degistir&user=<?php echo urlencode($hesap['user']); ?>&server=<?php echo urlencode($hesap['sunucu_adi']); ?>"
                                           data-bs-toggle="tooltip" title="Hosting Paketini Değiştir">
                                            <i class="bi bi-box me-2"></i>
                                            Paket Değiştir
                                        </a>
                                    </li>
                                    
                                    <!-- Yeni Sahip Değiştir İşlemi -->
                                    <li>
                                        <a class="dropdown-item" href="index.php?sayfa=aktarim/hosting_aktar&user=<?php echo urlencode($hesap['user']); ?>&server=<?php echo urlencode($hesap['sunucu_adi']); ?>"
                                           data-bs-toggle="tooltip" title="Sahip Değiştir">
                                            <i class="bi bi-person-lines-fill me-2"></i>
                                            Sahip Değiştir
                                        </a>
                                    </li>
                                    
                                    <li><hr class="dropdown-divider"></li>
                                    
                                    <li>
                                        <a class="dropdown-item" href="index.php?sayfa=hosting/eposta_ekle&user=<?php echo urlencode($hesap['user']); ?>&server=<?php echo urlencode($hesap['sunucu_adi']); ?>"
                                           data-bs-toggle="tooltip" title="Yeni E-Posta Hesabı Oluştur">
                                            <i class="bi bi-envelope-plus me-2"></i>
                                            E-Posta Hesabı Oluştur
                                        </a>
                                    </li>
                                    
                                    <li>
                                        <a class="dropdown-item" href="index.php?sayfa=hosting/eposta_listesi&user=<?php echo urlencode($hesap['user']); ?>&server=<?php echo urlencode($hesap['sunucu_adi']); ?>"
                                           data-bs-toggle="tooltip" title="E-Posta Hesaplarını Yönet">
                                            <i class="bi bi-envelope me-2"></i>
                                            E-Posta Hesapları
                                        </a>
                                    </li>
                                    
                                    <li><hr class="dropdown-divider"></li>
                                    
                                    <li>
                                        <a class="dropdown-item text-danger" href="#" 
                                           onclick="return confirm('Bu hesabı silmek istediğinizden emin misiniz?')"
                                           data-bs-toggle="tooltip" title="Hesabı Sil">
                                            <i class="bi bi-trash me-2"></i>
                                            Sil
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

<script>
$(document).ready(function() {
    // Tooltips'i aktifleştir
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
    
    // DataTables'ı başlat
    $('#hostingTable').DataTable({
        language: {
            url: 'https://cdn.datatables.net/plug-ins/1.13.7/i18n/tr.json'
        },
        pageLength: 10,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Tümü"]],
        order: [[0, 'asc']],
        responsive: true,
        dom: "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
             "<'row'<'col-sm-12'tr>>" +
             "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        initComplete: function() {
            $('.dataTables_filter input')
                .attr('placeholder', 'Ara...')
                .addClass('form-control-sm');
            $('.dataTables_length select').addClass('form-select-sm');
        }
    });
});
</script>
