<?php
ob_start(); // Çıktı tamponlamasını başlat
oturumKontrol();

if (!isset($_GET['user']) || !isset($_GET['server'])) {
    header("Location: index.php?sayfa=hosting/liste");
    exit;
}

$username = $_GET['user'];
$server_name = $_GET['server'];

// Sunucu bilgilerini al
$sorgu = $db->prepare("SELECT * FROM sunucular WHERE sunucu_adi = ?");
$sorgu->execute([$server_name]);
$sunucu = $sorgu->fetch(PDO::FETCH_ASSOC);

if (!$sunucu) {
    header("Location: index.php?sayfa=hosting/liste&mesaj=sunucu_bulunamadi");
    exit;
}

// Hesap bilgilerini çek
function getHesapBilgileri($sunucu, $username) {
    $url = "https://{$sunucu['ip_adresi']}:2087/json-api/accountsummary";
    
    $header = array(
        "Authorization: WHM {$sunucu['kullanici_adi']}:{$sunucu['token']}"
    );
    
    $params = array(
        'user' => $username
    );
    
    error_log("WHM API Request URL (accountsummary): " . $url . "?" . http_build_query($params));
    error_log("WHM API Headers (accountsummary): " . print_r($header, true));
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($params));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    
    $response = curl_exec($ch);
    $info = curl_getinfo($ch);
    $error = curl_error($ch);
    
    error_log("WHM API Response (accountsummary): " . $response);
    error_log("WHM API HTTP Code (accountsummary): " . $info['http_code']);
    if ($error) {
        error_log("WHM API Error (accountsummary): " . $error);
    }
    
    curl_close($ch);
    
    return json_decode($response, true);
}

$hesapBilgileri = getHesapBilgileri($sunucu, $username);
$domain = isset($hesapBilgileri['acct'][0]['domain']) ? $hesapBilgileri['acct'][0]['domain'] : '';

$hata = '';
$basarili = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email_user = $_POST['email_user'];
    $domain = $_POST['domain'];
    $sifre = $_POST['sifre'];
    $kota = (int)$_POST['kota']; // MB cinsinden
    
    if (empty($email_user) || empty($domain) || empty($sifre)) {
        $hata = 'Lütfen tüm alanları doldurun.';
    } elseif (strlen($sifre) < 8) {
        $hata = 'Şifre en az 8 karakter uzunluğunda olmalıdır.';
    } else {
        // WHM API'yi çağır (cPanel uAPI üzerinden)
        $url = "https://{$sunucu['ip_adresi']}:2087/json-api/cpanel";
        
        $header = array(
            "Authorization: WHM {$sunucu['kullanici_adi']}:{$sunucu['token']}"
        );
        
        $params = array(
            'cpanel_jsonapi_version' => 2,
            'cpanel_jsonapi_module' => 'Email',
            'cpanel_jsonapi_func' => 'addpop',
            'user' => $username,
            'domain' => $domain,
            'email' => $email_user,
            'password' => $sifre,
            'quota' => $kota
        );
        
        error_log("WHM API Request URL (addpop): " . $url . "?" . http_build_query($params));
        error_log("WHM API Headers (addpop): " . print_r($header, true));
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($params));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        
        $response = curl_exec($ch);
        $info = curl_getinfo($ch);
        $error = curl_error($ch);
        
        error_log("WHM API Response (addpop): " . $response);
        error_log("WHM API HTTP Code (addpop): " . $info['http_code']);
        if ($error) {
            error_log("WHM API Error (addpop): " . $error);
        }
        
        curl_close($ch);
        
        if ($error) {
            $hata = 'API hatası: ' . $error;
        } else {
            $result = json_decode($response, true);
            if (isset($result['cpanelresult']['data'][0]['result']) && $result['cpanelresult']['data'][0]['result'] == 1) {
                $basarili = 'E-posta hesabı başarıyla oluşturuldu.';
            } else {
                $hata = 'E-posta hesabı oluşturulamadı: ' . ($result['cpanelresult']['data'][0]['reason'] ?? 'Bilinmeyen hata');
            }
        }
    }
}
?>

<!-- Bootstrap Icons CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=hosting/liste">Hosting Hesapları</a></li>
        <li class="breadcrumb-item active" aria-current="page">E-Posta Hesabı Oluştur</li>
    </ol>
</nav>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-envelope-plus me-2"></i>
            E-Posta Hesabı Oluştur
            <small class="text-muted">(<?php echo htmlspecialchars($username); ?>)</small>
        </h5>
    </div>
    <div class="card-body">
        <?php if ($hata): ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                <?php echo $hata; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($basarili): ?>
            <div class="alert alert-success">
                <i class="bi bi-check-circle-fill me-2"></i>
                <?php echo $basarili; ?>
                <hr>
                <p class="mb-0">
                    <i class="bi bi-envelope-fill me-2"></i>
                    E-posta: <strong><?php echo htmlspecialchars($email_user . '@' . $domain); ?></strong><br>
                    <i class="bi bi-key-fill me-2"></i>
                    Şifre: <strong><?php echo htmlspecialchars($sifre); ?></strong>
                    <br>
                    <small class="text-muted">
                        <i class="bi bi-info-circle me-2"></i>
                        Lütfen bu bilgileri güvenli bir yere kaydedin.
                    </small>
                </p>
            </div>
        <?php endif; ?>
        
        <form method="POST" action="" class="row g-3">
            <div class="col-md-6">
                <label for="email_user" class="form-label">
                    <i class="bi bi-at me-2"></i>
                    E-posta Kullanıcı Adı
                </label>
                <div class="input-group">
                    <span class="input-group-text">
                        <i class="bi bi-envelope"></i>
                    </span>
                    <input type="text" class="form-control" id="email_user" name="email_user" required>
                    <span class="input-group-text">@</span>
                    <input type="text" class="form-control" id="domain" name="domain" 
                           value="<?php echo htmlspecialchars($domain); ?>" readonly>
                </div>
                <small class="text-muted">
                    <i class="bi bi-info-circle me-1"></i>
                    Örnek: info, destek, satis vb.
                </small>
            </div>
            
            <div class="col-md-6">
                <label for="sifre" class="form-label">
                    <i class="bi bi-lock-fill me-2"></i>
                    Şifre
                </label>
                <div class="input-group">
                    <span class="input-group-text">
                        <i class="bi bi-shield-lock"></i>
                    </span>
                    <input type="password" class="form-control" id="sifre" name="sifre" 
                           minlength="8" required>
                    <button class="btn btn-outline-secondary" type="button" id="sifreGoster"
                            data-bs-toggle="tooltip" title="Şifreyi Göster/Gizle">
                        <i class="bi bi-eye-fill"></i>
                    </button>
                    <button class="btn btn-outline-secondary" type="button" id="rastgeleSifre"
                            data-bs-toggle="tooltip" title="Rastgele Şifre Oluştur">
                        <i class="bi bi-shuffle"></i>
                    </button>
                </div>
                <small class="text-muted">
                    <i class="bi bi-info-circle me-1"></i>
                    En az 8 karakter uzunluğunda olmalıdır.
                </small>
            </div>
            
            <div class="col-md-6">
                <label for="kota" class="form-label">
                    <i class="bi bi-hdd-fill me-2"></i>
                    Kota (MB)
                </label>
                <div class="input-group">
                    <span class="input-group-text">
                        <i class="bi bi-database"></i>
                    </span>
                    <input type="number" class="form-control" id="kota" name="kota" 
                           value="1024" min="0" step="1" required>
                    <span class="input-group-text">MB</span>
                </div>
                <small class="text-muted">
                    <i class="bi bi-info-circle me-1"></i>
                    0 = Sınırsız
                </small>
            </div>
            
            <div class="col-12">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-plus-circle me-2"></i>
                    E-Posta Hesabı Oluştur
                </button>
                <a href="index.php?sayfa=hosting/liste" class="btn btn-secondary">
                    <i class="bi bi-x-lg me-2"></i>
                    İptal
                </a>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tooltips'i aktifleştir
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
    
    // Şifre göster/gizle fonksiyonu
    const sifreInput = document.getElementById('sifre');
    const sifreGoster = document.getElementById('sifreGoster');
    
    sifreGoster.addEventListener('click', function() {
        const tip = sifreInput.type === 'password' ? 'text' : 'password';
        sifreInput.type = tip;
        const icon = sifreGoster.querySelector('i');
        icon.className = tip === 'password' ? 'bi bi-eye-fill' : 'bi bi-eye-slash-fill';
        
        // Tooltip metnini güncelle
        const tooltip = bootstrap.Tooltip.getInstance(sifreGoster);
        if (tooltip) {
            tooltip.setContent({ '.tooltip-inner': tip === 'password' ? 'Şifreyi Göster' : 'Şifreyi Gizle' });
        }
    });
    
    // Rastgele şifre oluştur
    const rastgeleSifre = document.getElementById('rastgeleSifre');
    rastgeleSifre.addEventListener('click', function() {
        const karakterler = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*';
        let sifre = '';
        for (let i = 0; i < 12; i++) {
            sifre += karakterler.charAt(Math.floor(Math.random() * karakterler.length));
        }
        
        sifreInput.type = 'text';
        sifreInput.value = sifre;
        sifreGoster.querySelector('i').className = 'bi bi-eye-slash-fill';
        
        // Tooltip'i güncelle
        const tooltip = bootstrap.Tooltip.getInstance(sifreGoster);
        if (tooltip) {
            tooltip.setContent({ '.tooltip-inner': 'Şifreyi Gizle' });
        }
    });
});
</script>
<?php
ob_end_flush(); // Çıktı tamponlamasını sonlandır
?>