<!-- Bootstrap Icons ve DataTables CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">


<?php
ob_start();
oturumKontrol();

$hata = '';
$basarili = '';

// Sunucu listesini getir
$sorgu = $db->query("SELECT * FROM sunucular ORDER BY sunucu_adi");
$sunucular = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Paket ekleme/güncelleme işlemi
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['paket_ekle'])) {
        $paket_adi = guvenlik($_POST['paket_adi']);
        $disk_alani = (int)$_POST['disk_alani'];
        $trafik = (int)$_POST['trafik'];
        $eposta_limit = (int)$_POST['eposta_limit'];
        $ftp_limit = (int)$_POST['ftp_limit'];
        $veritabani_limit = (int)$_POST['veritabani_limit'];
        $subdomain_limit = (int)$_POST['subdomain_limit'];
        $fiyat = (float)$_POST['fiyat'];
        
        if (empty($paket_adi)) {
            $hata = 'Paket adı boş bırakılamaz.';
        } else {
            try {
                // Paket adı kontrolü
                $sorgu = $db->prepare("SELECT id FROM hosting_paketleri WHERE paket_adi = ?");
                $sorgu->execute([$paket_adi]);
                
                if ($sorgu->rowCount() > 0) {
                    $hata = 'Bu paket adı zaten mevcut.';
                } else {
                    $sorgu = $db->prepare("INSERT INTO hosting_paketleri 
                        (paket_adi, disk_alani, trafik, eposta_limit, ftp_limit, veritabani_limit, subdomain_limit, fiyat) 
                        VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                    
                    $sonuc = $sorgu->execute([
                        $paket_adi,
                        $disk_alani,
                        $trafik,
                        $eposta_limit,
                        $ftp_limit,
                        $veritabani_limit,
                        $subdomain_limit,
                        $fiyat
                    ]);
                    
                    if ($sonuc) {
                        $basarili = 'Yeni paket başarıyla eklendi.';
                    }
                }
            } catch (PDOException $e) {
                $hata = 'Veritabanı hatası: ' . $e->getMessage();
            }
        }
    }
    
    // Paket güncelleme
    if (isset($_POST['paket_guncelle'])) {
        try {
            $db->beginTransaction();
            
            foreach ($_POST['paketler'] as $id => $paket) {
                $sorgu = $db->prepare("UPDATE hosting_paketleri SET 
                    disk_alani = ?,
                    trafik = ?,
                    eposta_limit = ?,
                    ftp_limit = ?,
                    veritabani_limit = ?,
                    subdomain_limit = ?,
                    fiyat = ?,
                    durum = ?
                    WHERE id = ?");
                
                $sorgu->execute([
                    (int)$paket['disk_alani'],
                    (int)$paket['trafik'],
                    (int)$paket['eposta_limit'],
                    (int)$paket['ftp_limit'],
                    (int)$paket['veritabani_limit'],
                    (int)$paket['subdomain_limit'],
                    (float)$paket['fiyat'],
                    isset($paket['durum']) ? 1 : 0,
                    $id
                ]);
            }
            
            $db->commit();
            $basarili = 'Paketler başarıyla güncellendi.';
            
        } catch (PDOException $e) {
            $db->rollBack();
            $hata = 'Veritabanı hatası: ' . $e->getMessage();
        }
    }
    
    // Sunucudan paketleri senkronize et
    if (isset($_POST['sync_paketler'])) {
        $sunucu_id = (int)$_POST['sunucu_id'];
        
        // Sunucu bilgilerini al
        $sorgu = $db->prepare("SELECT * FROM sunucular WHERE id = ?");
        $sorgu->execute([$sunucu_id]);
        $sunucu = $sorgu->fetch(PDO::FETCH_ASSOC);
        
        if ($sunucu) {
            // WHM API'yi çağır
            $url = "https://{$sunucu['ip_adresi']}:2087/json-api/listpkgs";
            
            $header = array(
                "Authorization: WHM {$sunucu['kullanici_adi']}:{$sunucu['token']}"
            );
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            
            $response = curl_exec($ch);
            $error = curl_error($ch);
            curl_close($ch);
            
            if ($error) {
                $hata = 'API hatası: ' . $error;
            } else {
                $result = json_decode($response, true);
                
                if (isset($result['package']) && is_array($result['package'])) {
                    try {
                        $db->beginTransaction();
                        
                        foreach ($result['package'] as $pkg) {
                            if (empty($pkg['name']) || $pkg['name'] == 'default') continue;
                            
                            // Paket var mı kontrol et
                            $sorgu = $db->prepare("SELECT id FROM hosting_paketleri WHERE paket_adi = ?");
                            $sorgu->execute([$pkg['name']]);
                            
                            if ($sorgu->rowCount() == 0) {
                                // Yeni paket ekle
                                $sorgu = $db->prepare("INSERT INTO hosting_paketleri 
                                    (paket_adi, disk_alani, trafik, eposta_limit, ftp_limit, veritabani_limit, subdomain_limit) 
                                    VALUES (?, ?, ?, ?, ?, ?, ?)");
                                
                                $sorgu->execute([
                                    $pkg['name'],
                                    isset($pkg['QUOTA']) ? $pkg['QUOTA'] : 1024,
                                    isset($pkg['BWLIMIT']) ? $pkg['BWLIMIT'] : 5120,
                                    isset($pkg['MAXPOP']) ? $pkg['MAXPOP'] : 5,
                                    isset($pkg['MAXFTP']) ? $pkg['MAXFTP'] : 1,
                                    isset($pkg['MAXSQL']) ? $pkg['MAXSQL'] : 1,
                                    isset($pkg['MAXSUB']) ? $pkg['MAXSUB'] : 1
                                ]);
                            }
                        }
                        
                        $db->commit();
                        $basarili = 'Paketler başarıyla senkronize edildi.';
                        
                    } catch (PDOException $e) {
                        $db->rollBack();
                        $hata = 'Veritabanı hatası: ' . $e->getMessage();
                    }
                } else {
                    $hata = 'Sunucudan paket listesi alınamadı.';
                }
            }
        } else {
            $hata = 'Sunucu bulunamadı.';
        }
    }
}

// Paket listesini getir
$sorgu = $db->query("SELECT * FROM hosting_paketleri ORDER BY paket_adi");
$paketler = $sorgu->fetchAll(PDO::FETCH_ASSOC);
?>

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item">Fiyatlar</li>
        <li class="breadcrumb-item active">Hosting Paketleri</li>
    </ol>
</nav>

<?php if ($hata): ?>
    <div class="alert alert-danger">
        <i class="bi bi-exclamation-triangle-fill me-2"></i>
        <?php echo $hata; ?>
    </div>
<?php endif; ?>

<?php if ($basarili): ?>
    <div class="alert alert-success">
        <i class="bi bi-check-circle-fill me-2"></i>
        <?php echo $basarili; ?>
    </div>
<?php endif; ?>

<div class="row">
    <!-- Yeni Paket Ekleme -->
    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-plus-circle me-2"></i>
                    Yeni Paket Ekle
                </h5>
            </div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="paket_ekle" value="1">
                    
                    <div class="mb-3">
                        <label for="paket_adi" class="form-label">Paket Adı *</label>
                        <input type="text" class="form-control" id="paket_adi" name="paket_adi" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="disk_alani" class="form-label">Disk Alanı (MB) *</label>
                        <input type="number" class="form-control" id="disk_alani" name="disk_alani" 
                               min="1" value="1024" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="trafik" class="form-label">Trafik (MB) *</label>
                        <input type="number" class="form-control" id="trafik" name="trafik" 
                               min="1" value="5120" required>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="eposta_limit" class="form-label">E-posta Limiti</label>
                                <input type="number" class="form-control" id="eposta_limit" name="eposta_limit" 
                                       min="0" value="5" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="ftp_limit" class="form-label">FTP Limiti</label>
                                <input type="number" class="form-control" id="ftp_limit" name="ftp_limit" 
                                       min="0" value="1" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="veritabani_limit" class="form-label">Veritabanı Limiti</label>
                                <input type="number" class="form-control" id="veritabani_limit" name="veritabani_limit" 
                                       min="0" value="1" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="subdomain_limit" class="form-label">Subdomain Limiti</label>
                                <input type="number" class="form-control" id="subdomain_limit" name="subdomain_limit" 
                                       min="0" value="1" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="fiyat" class="form-label">Fiyat *</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="fiyat" name="fiyat" 
                                   step="0.01" min="0" value="0.00" required>
                            <span class="input-group-text">₺</span>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-plus-circle me-2"></i>
                        Paket Ekle
                    </button>
                </form>
            </div>
        </div>
        
        <!-- Sunucudan Paket Senkronizasyonu -->
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-arrow-repeat me-2"></i>
                    Paket Senkronizasyonu
                </h5>
            </div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="sync_paketler" value="1">
                    
                    <div class="mb-3">
                        <label for="sunucu_id" class="form-label">Sunucu Seçin *</label>
                        <select class="form-select" id="sunucu_id" name="sunucu_id" required>
                            <option value="">Sunucu Seçin</option>
                            <?php foreach ($sunucular as $sunucu): ?>
                            <option value="<?php echo $sunucu['id']; ?>">
                                <?php echo htmlspecialchars($sunucu['sunucu_adi']); ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-arrow-repeat me-2"></i>
                        Paketleri Senkronize Et
                    </button>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Paket Listesi -->
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-box me-2"></i>
                    Paket Listesi
                </h5>
            </div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="paket_guncelle" value="1">
                    
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Paket Adı</th>
                                    <th>Disk</th>
                                    <th>Trafik</th>
                                    <th>Limitler</th>
                                    <th>Fiyat</th>
                                    <th>Durum</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($paketler as $paket): ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <i class="bi bi-box me-2"></i>
                                            <?php echo htmlspecialchars($paket['paket_adi']); ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input-group-sm">
                                            <input type="number" class="form-control" 
                                                   name="paketler[<?php echo $paket['id']; ?>][disk_alani]" 
                                                   value="<?php echo $paket['disk_alani']; ?>" 
                                                   min="1" required>
                                            <span class="input-group-text">MB</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input-group-sm">
                                            <input type="number" class="form-control" 
                                                   name="paketler[<?php echo $paket['id']; ?>][trafik] ```php
                                                   name="paketler[<?php echo $paket['id']; ?>][trafik]" 
                                                   value="<?php echo $paket['trafik']; ?>" 
                                                   min="1" required>
                                            <span class="input-group-text">MB</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input-group-sm">
                                            <input type="number" class="form-control" 
                                                   name="paketler[<?php echo $paket['id']; ?>][eposta_limit]" 
                                                   value="<?php echo $paket['eposta_limit']; ?>" 
                                                   min="0" required
                                                   title="E-posta Limiti">
                                            <input type="number" class="form-control" 
                                                   name="paketler[<?php echo $paket['id']; ?>][ftp_limit]" 
                                                   value="<?php echo $paket['ftp_limit']; ?>" 
                                                   min="0" required
                                                   title="FTP Limiti">
                                            <input type="number" class="form-control" 
                                                   name="paketler[<?php echo $paket['id']; ?>][veritabani_limit]" 
                                                   value="<?php echo $paket['veritabani_limit']; ?>" 
                                                   min="0" required
                                                   title="Veritabanı Limiti">
                                            <input type="number" class="form-control" 
                                                   name="paketler[<?php echo $paket['id']; ?>][subdomain_limit]" 
                                                   value="<?php echo $paket['subdomain_limit']; ?>" 
                                                   min="0" required
                                                   title="Subdomain Limiti">
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input-group-sm">
                                            <input type="number" class="form-control" 
                                                   name="paketler[<?php echo $paket['id']; ?>][fiyat]" 
                                                   value="<?php echo $paket['fiyat']; ?>" 
                                                   step="0.01" min="0" required>
                                            <span class="input-group-text">₺</span>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="form-check form-switch d-flex justify-content-center">
                                            <input class="form-check-input" type="checkbox" 
                                                   name="paketler[<?php echo $paket['id']; ?>][durum]" 
                                                   <?php echo $paket['durum'] ? 'checked' : ''; ?>>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>
                        Paketleri Güncelle
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
// Tooltips'i aktifleştir
const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));

// Disk ve trafik alanları için otomatik birim dönüşümü
function formatBoyut(input) {
    let value = parseInt(input.value);
    if (value >= 1024) {
        input.nextElementSibling.textContent = 'GB';
        input.title = (value / 1024).toFixed(2) + ' GB';
    } else {
        input.nextElementSibling.textContent = 'MB';
        input.title = value + ' MB';
    }
}

document.querySelectorAll('input[name*="disk_alani"], input[name*="trafik"]').forEach(input => {
    input.addEventListener('input', () => formatBoyut(input));
    formatBoyut(input);
});
</script>

<?php ob_end_flush(); ?>